#include <stdio.h>

#include "object.h"
#include "stack.h"
#include "mem.h"
#include "xlib.h"
#include "main.h"
#include "mem.h"
#include "symb.h"
#include "lambda.h"

/* data class */

void DOBINT(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOREAL(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOCPLX(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOZINT(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOARRY(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOCSTR(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOCHAR(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOLIST(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOSYMB(T_ATOM *ob) {
  DSTK_add(atom_link(ob));
}

void DOSYMBEVAL(T_ATOM *ob) {
  T_SYMB *symb = atom_get_symb(ob);
  T_ATOM *newob  = symb_rpn(symb);

  DOPROG(newob);
  atom_unlink(newob);
}

void DOIDNT(T_ATOM *ob) {
  T_WORD *L;
  char *id = atom_get_name(ob);

  /* first try lambda, in case it was compiled as a idnt */
  L = lambda_find(FOLDER_LAMBDA, id, 1);

  if(L == NULL)
    L = lambda_find(FOLDER_CWD, id, 1);

  if(L) {
    atom_eval(L->ob, NULL);
  } else
    DSTK_add(atom_link(ob));
}

void DOLAM(T_ATOM *ob) {
  T_WORD *L;
  char *id = atom_get_name(ob);

  L = lambda_find(FOLDER_LAMBDA, id, 1);
  if(L) {
    atom_eval(L->ob, NULL);
  } else
    Exception(ob, "Invalid Lam ID", 0);
}

void DOFUNC(T_ATOM *ob) {
  char *id = atom_get_name(ob);
  T_CODE code = code_find(id);

  if(code) {
    ((T_PROLOG *)code)(ob);
  } else {
    T_WORD *L = lambda_find(FOLDER_CWD, id, 1);
    if(L) {
      atom_eval(L->ob, NULL);
    } else
      DSTK_add(atom_link(ob));
  }
}

void DOCODE(T_ATOM *ob) {
  T_PROLOG *code = atom_get_code(ob);

  code(ob);
}

/* procedure class */

void DOPROG(T_ATOM *ob) {
  T_CONS *fst = atom_get_cons(ob);

  ISTK_add(cons_link(fst)); /* push runstream */
}
