#ifndef __MEM_H__
#define __MEM_H__

#include <sys/types.h>

#include "object.h"
#include "stack.h"

void xm_init(void);
void xm_end(void);
void xm_statz(int leak);

void *xm_alloc(size_t z);
void *xm_calloc(size_t n, size_t z);
void  xm_free(void *p);
char *xm_strdup(const char *s);

size_t mem_avail(void);

T_ATOM *atom_alloc(void);
T_ATOM *atom_link(T_ATOM *o);
void    atom_unlink(T_ATOM *o);
void    atom_kill(T_ATOM *o);
size_t  atom_ref(T_ATOM *o);

T_CONS *cons_alloc(void);
T_CONS *cons_link(T_CONS *R);
void    cons_unlink(T_CONS *R);
void    cons_kill(T_CONS *R);
size_t  cons_ref(T_CONS *R);

T_SYMB *symb_alloc(void);
T_SYMB *symb_link(T_SYMB *R);
void    symb_unlink(T_SYMB *R);
void    symb_kill(T_SYMB *R);
size_t  symb_ref(T_SYMB *R);

T_WORD *word_alloc(void);
T_WORD *word_link(T_WORD *R);
void    word_unlink(T_WORD *R);
void    word_kill(T_WORD *R);
size_t  word_ref(T_WORD *R);

T_FLDR *fldr_alloc(void);
T_FLDR *fldr_link(T_FLDR *R);
void    fldr_unlink(T_FLDR *R);
void    fldr_kill(T_FLDR *R);
size_t  fldr_ref(T_FLDR *R);

#endif
