#ifndef __MAIN_H__
#define __MAIN_H__

#include "object.h"

extern struct _flags_t {
  enum {
    M_OFF, M_RUN, M_DBG, M_TRC
  } mod_run;

  int video; 

  enum { MOD_DAL, MOD_LISP, MOD_RPN } mod_symb;
  enum { MOD_RAD, MOD_DEG } mod_angle;
  enum { MOD_HEX = 16, MOD_DEC = 10, MOD_OCT = 8, MOD_BIN = 2 } mod_bint;
  enum { MOD_POLAR, MOD_RECT } mod_cplx;
} FLAGS;

void Exception(T_ATOM *self, const char *msg, int fatal);

/* command completion */
const char *next_command(const char *text, int state);

const char *string_compile(T_CONS **tail, const char *stream);

char *file_read(char *file);
char *stream_read(FILE *stream);

const char *next_token(T_ATOM **ob, const char *stream);
void parse_string(const char *stream);
void eval_string(const char *stream);
void eval_runstream(void);

#endif
