#ifndef __LAMBDA_H__
#define __LAMBDA_H__

#include <sys/types.h>
#include "object.h"

extern T_FLDR *FOLDER_HOME, *FOLDER_CWD;
extern T_FLDR *FOLDER_LAMBDA;

void folder_initialize(void);

void lam_call(void);
void lam_kill(void);

T_WORD *lambda_findn(const T_FLDR *where, size_t ndx);

T_WORD *lambda_find(const T_FLDR *where,
		      const char *id,
		      int follow);

int lambda_set(T_FLDR *where, 
	       const char *id, T_ATOM *ob, 
	       int always);

int lambda_setn(T_FLDR *where, size_t ndx, T_ATOM *ob);

int lambda_purge(T_FLDR *where, char *id, int follow);

T_WORD *lambda_enum(const T_FLDR *where, const T_WORD *state);

#endif
