#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>
#include <assert.h>

#include "mem.h"
#include "lambda.h"
#include "xlib.h"

T_FLDR *FOLDER_HOME, *FOLDER_CWD;
T_FLDR *FOLDER_LAMBDA;

void folder_initialize(void) {
  FOLDER_HOME = fldr_alloc();

  FOLDER_HOME->fst = NULL;
  FOLDER_HOME->parent = NULL;
  FOLDER_HOME->id = xm_strdup("HOME");

  FOLDER_CWD = FOLDER_HOME;
}

void lam_call(void) {
  T_FLDR *folder;

  folder = fldr_alloc();

  folder->id = NULL;
  folder->fst = NULL;
  folder->parent = FOLDER_LAMBDA;

  FOLDER_LAMBDA = folder;
}

void lam_kill(void) {
  if(FOLDER_LAMBDA) {
    T_FLDR *parent;

    parent = FOLDER_LAMBDA->parent;
    fldr_unlink(FOLDER_LAMBDA);

    FOLDER_LAMBDA = parent;
  }
}

/* find word by id, optionally recursing down the path */
T_WORD *lambda_find(const T_FLDR *where,
			    const char *id,
			    int follow) {
  T_WORD *found = NULL;

  if(id) {
    while(where && !found) {
      T_WORD *L = where->fst;

      while(L && !found) {
	if(L->id && xstrcmp(id, L->id) == 0) {
	  found = L;
	} else
	  L = L->next;
      }

      if(follow) {
	where = where->parent;
      } else
	break;
    }
  }

  return found;
}

int lambda_purge(T_FLDR *where, char *id, int follow) {
  T_WORD *found = NULL;
  T_WORD *P = NULL;

  if(id) {
    while(where && !found) {
      T_WORD *L;

      for(P = NULL, L = where->fst; L && !found; ) {
	if(L->id && xstrcmp(id, L->id) == 0) {
	  found = L;
	} else {
	  P = L;
	  L = L->next;
	}
      }

      if(follow) {
	where = where->parent;
      } else
	break;
    }
  }

  if(found) {
    if(P) {
      P->next = found->next;
    } else {
      where->fst = found->next;
    }

    word_unlink(found);
    return 0;
  }

  return 1;
}

/* create/modify lambda in folder 'where' (always = unconditionally) */
int lambda_set(T_FLDR *where, 
	       const char *id, T_ATOM *ob, 
	       int always) {
  T_WORD *L = NULL;

  if(! always)
    L = lambda_find(where, id, 0 /* only CWD*/);

  if(L) { /* replace existing word */
    if(L->id)
      xm_free(L->id); /* release id */

    atom_unlink(L->ob); /* release stored object */

    L->id = xm_strdup(id);  /* set new id */
    L->ob = atom_link(ob);    /* set new object */

    return 0; /* replaced existing */
  } else { /* create in current folder */
    L = word_alloc();

    L->id = xm_strdup(id);
    L->ob = atom_link(ob);

    L->next = where->fst;
    where->fst = L;

    return 1; /* added new */
  }

  return -1;
}

/* create/modify lambda by number */
int lambda_setn(T_FLDR *where, size_t ndx, T_ATOM *ob) {
  T_WORD *L = NULL;

  L = lambda_findn(where, ndx);

  if(L) {
    atom_unlink(L->ob);       /* release stored object */
    L->ob = atom_link(ob);    /* set new object */

    return 0;
  }

  return -1;
}

T_WORD *lambda_enum(const T_FLDR *where, const T_WORD *state) {
  if(! state)
    return where->fst;

  if(state->next)
    return state->next;

  return NULL;
}

/* find word by index */
T_WORD *lambda_findn(const T_FLDR *where, size_t ndx) {
  T_WORD *L;

  for(L = where->fst; L && ndx > 0; ndx --)
    L = L->next;

  return L;
}
