#include "console.h"
#include "object.h"
#include "stack.h"
#include "main.h"

#include <string.h>
#include <stdlib.h>

#include <curses.h>

/* FIXME: no multi-line display */

void gstack(void) {
  if(FLAGS.video) {
    int y, max_y, max_x, max_len;
    size_t level;
    T_CONS *ptr;

    getmaxyx(win_stk, max_y, max_x);
    max_len = max_x - 6;
  
    for(ptr = DSTK, y = max_y - 1, level = 1;
	ptr && (y >= 0); ptr = ptr->cdr, y --) {
      char *atom;
      int len;
      int more = 0;

      mvwprintw(win_stk, y, 0, " %2zu: ", level ++);

      atom = atom_string(ptr->car, NULL);

      if(atom) {
	len = strlen(atom);
	if(len > max_len) {
	  atom[max_len] = '\0';
	  more = 1;
	}

	waddnstr(win_stk, atom, max_len);

	if(more)
	  waddch(win_stk, ACS_RARROW | A_STANDOUT);
	else
	  wclrtoeol(win_stk);

	free(atom);
      } else
	wclrtoeol(win_stk);
    }

    for(; y >= 0; y --) {
      mvwprintw(win_stk, y, 0, " %2zu: ", level ++);
      wclrtoeol(win_stk);
    }

    wrefresh(win_stk);
  }
}
