#include <stdio.h>
#include <stdlib.h>

#include "console.h"

#include "object.h"
#include "xlib.h"
#include "symb.h"
#include "dump.h"

void dump_arry(WINDOW *win,
	       unsigned long base,
	       unsigned long dims,
	       unsigned long *dim, 
	       T_ATOM **data,
	       unsigned long *atom_ndx) {
  unsigned long ndx;
  xprintf(win, "[");

  for(ndx = 0; ndx < dim[base]; ndx ++) {
    xprintf(win, " ");

    if(base + 1 < dims) {
      dump_arry(win, base + 1, dims, dim, data, atom_ndx);
    } else {
      atom_dump(win, data[(*atom_ndx) ++]);
    }
  }

  xprintf(win, " ]");
}

void atom_dump(WINDOW *stream, const T_ATOM *ob) {
  if(ob) {
    T_PROLOG *t = ob->prolog;

    if(t == DOBINT) {
      char *buf = bint_string(atom_get_bint(ob));

      xprintf(stream, "%s", buf);
      free(buf);
    }
    else if(t == DOREAL) {
      char *buf = real_string(atom_get_real(ob));

      xprintf(stream, "%s", buf);
      free(buf);
    }
    else if(t == DOCPLX) {
      char *buf = cplx_string(atom_get_cplx(ob));

      xprintf(stream, "%s", buf);
      free(buf);
    }
    else if(t == DOZINT) {
      char *buf = zint_string(atom_get_zint(ob));

      xprintf(stream, "%s", buf);
      free(buf);
    }
    else if(t == DOCHAR) {
      xprintf(stream, "CHR %c", atom_get_char(ob));
    }
    else if(t == DOARRY) {
      T_ARRY *arry;
      T_ATOM **data;
      unsigned long dims;
      unsigned long *dim;

      arry = atom_get_arry((T_ATOM *)ob);

      dims = arry->dims;
      dim = arry->dim;
      data = arry->data;

      if(dims > 0) {
	unsigned long atom_ndx = 0;
	dump_arry(stream, 0, dims, dim, data, &atom_ndx);
      } else
      xprintf(stream, "[ ]");
    }
    else if(t == DOCSTR) {
      xprintf(stream, "\"%s\"", atom_get_name(ob));
    }
    else if(t == DOIDNT) {
      xprintf(stream, "%s", atom_get_name(ob));
    }
    else if(t == DOFUNC) {
      xprintf(stream, "%s()", atom_get_name(ob));
    }
    else if(t == DOLAM) {
      xprintf(stream, "LAM %s", atom_get_name(ob));
    }
    else if(t == DOLIST) {
      T_CONS *el = atom_get_cons(ob);

      xprintf(stream, "{");

      for( ; el; el = el->cdr) {
	xprintf(stream, " ");
	atom_dump(stream, el->car);
      }

      xprintf(stream, " }");
    }
    else if(t == DOSYMB) {
      T_SYMB *symb = atom_get_symb(ob);
      char *expr;

      expr = symb_expr(symb);
      xprintf(stream, "SYMB %s", expr);
      free(expr);
    }
    else if(t == DOPROG) {
      T_CONS *el = atom_get_cons(ob);

      xprintf(stream, "::");

      for( ; el; el = el->cdr) {
	xprintf(stream, " ");
	atom_dump(stream, el->car);
      }

      xprintf(stream, " ;");
    }
    else if(t == DOCODE) {
      T_CODE code = atom_get_code(ob);

      xprintf(stream, "%s", code_getid(code));
    }
    else {
      xprintf(stream, "<External>");
    }
  }
}
