#ifndef __CONSOLE__
#define __CONSOLE__

#include <stdio.h>
#include <curses.h>

extern WINDOW *win_stk, *win_cmd;

void video_initialize(void);
void video_abandon(void);
void video_update(int force);

void set_header(const char *s);
void set_footer(const char *s);
void add_footer(const char *s);

int xprintf(WINDOW *win, const char *format, ...);
int dbg(const char *format, ...);

char *console_read(const char *prompt);

#endif
