#ifndef __CMD_H__
#define __CMD_H__

#include "object.h"

void micro_delay(unsigned long usec);
T_ATOM *stk_meta2ob(T_CONS **STK, size_t z, T_PROLOG *t);

#define declare(id)  void CMD_##id(T_ATOM *)

declare(NOP);
declare(DEPTH);
declare(DSTACK);
declare(DISPLAY);
declare(OFF);
declare(DBG);
declare(TRACE);
declare(CONT);
declare(MEM);
declare(SLOW);
declare(VERYSLOW);
declare(LOAD);
declare(EXEC);
declare(TYPE);
declare(DUPTYPE);
declare(CLOCK);
declare(TIME);
declare(ADDR);
declare(DEREF);
declare(CKREF);
declare(NEWOB);
declare(ROOM);
declare(NIL);
declare(SELF);
declare(RECURSE);
declare(SAME);
declare(EQ);

declare(MOD_DAL);
declare(MOD_LISP);
declare(MOD_RPN);
declare(MOD_DEG);
declare(MOD_RAD);
declare(MOD_HEX);
declare(MOD_DEC);
declare(MOD_OCT);
declare(MOD_BIN);
declare(MOD_POLAR);
declare(MOD_RECT);

declare(CK1);
declare(CK2);
declare(CK3);
declare(CKN);

declare(EVAL);
declare(COMPEVAL);
declare(EVAL_STR);
declare(PARSE_STR);
declare(NEXT_TOKEN);
declare(DO_STR);

declare(CATCH);
declare(THROW);
declare(THROW_MSG);

declare(QUOTE);
declare(SKIP);
declare(QUOTE_R);
declare(TIC_R);
declare(TO_R);
declare(TAIL_R);
declare(RCL_R);
declare(RDROP);
declare(COLA);
declare(IT);
declare(ITE);
declare(QSKIP);
declare(CASE);
declare(QSEMI);

declare(IDUP);
declare(BEGIN);
declare(WHILE);
declare(UNTIL);
declare(REPEAT);
declare(AGAIN);

declare(ZERO_DO);
declare(ONE_DO);
declare(DO);
declare(LOOP);
declare(INDEX_RCL);
declare(INDEX_STO);
declare(ISTOP_RCL);
declare(ISTOP_STO);

declare(FALSE);
declare(TRUE);
declare(NOT);
declare(AND);
declare(OR);
declare(XOR);

declare(EXIST);
declare(STO);
declare(RCL);
declare(PURGE);

declare(_BINT);
declare(_REAL);
declare(_CPLX);
declare(_CSTR);
declare(_ZINT);
declare(_CHAR);
declare(_IDNT);
declare(_LAM);
declare(_CODE);
declare(_XPTR);
declare(_ARRY);
declare(_SYMB);
declare(_LIST);
declare(_PROG);

declare(BINT_ZERO);
declare(BINT_ONE);
declare(BINT_TWO);
declare(BINT_THREE);
declare(BINT_FOUR);
declare(BINT_FIVE);

declare(BINT_PLUS);
declare(BINT_MINUS);
declare(BINT_TIMES);
declare(BINT_DIVIDE);

declare(BINT_OR);
declare(BINT_AND);
declare(BINT_XOR);
declare(BINT_NOT);

declare(BINT_LESS);
declare(BINT_LESS_EQ);
declare(BINT_MORE);
declare(BINT_MORE_EQ);
declare(BINT_EQUAL);
declare(BINT_Q_ZERO);
declare(BINT_NOT_EQUAL);
declare(BINT_Q_NOT_ZERO);
declare(BINT_MORE_ZERO);
declare(BINT_LESS_ZERO);
declare(BINT_MORE_EQ_ZERO);
declare(BINT_LESS_EQ_ZERO);

declare(ZINT_PLUS);
declare(ZINT_MINUS);
declare(ZINT_TIMES);
declare(ZINT_DIVIDE);
declare(ZINT_DIV_QR);
declare(ZINT_MOD);
declare(ZINT_GCD);
declare(ZINT_EGCD);
declare(ZINT_ABS);
declare(ZINT_NEG);
declare(ZINT_SGN);
declare(ZINT_FACTORIAL);

declare(ZINT_LESS);
declare(ZINT_LESS_EQ);
declare(ZINT_MORE);
declare(ZINT_MORE_EQ);
declare(ZINT_EQUAL);
declare(ZINT_Q_ZERO);
declare(ZINT_NOT_EQUAL);
declare(ZINT_Q_NOT_ZERO);
declare(ZINT_MORE_ZERO);
declare(ZINT_LESS_ZERO);
declare(ZINT_MORE_EQ_ZERO);
declare(ZINT_LESS_EQ_ZERO);

declare(REAL_ZERO);
declare(REAL_ONE);
declare(REAL_NEG_ONE);
declare(REAL_PI);
declare(REAL_E);
declare(REAL_G);

declare(REAL_PLUS);
declare(REAL_MINUS);
declare(REAL_TIMES);
declare(REAL_DIVIDE);
declare(REAL_ABS);
declare(REAL_SGN);
declare(REAL_NEG);
declare(REAL_INV);
declare(REAL_SQRT);
declare(REAL_POWER);
declare(REAL_NROOT);

declare(REAL_EXP);
declare(REAL_EXPM1);
declare(REAL_LN);
declare(REAL_LNP1);
declare(REAL_LOG);
declare(REAL_ALOG);

declare(REAL_COS);
declare(REAL_COSH);
declare(REAL_ACOS);
declare(REAL_ACOSH);

declare(REAL_SIN);
declare(REAL_SINH);
declare(REAL_ASIN);
declare(REAL_ASINH);

declare(REAL_TAN);
declare(REAL_TANH);
declare(REAL_ATAN);
declare(REAL_ATANH);

declare(REAL_SEC);
declare(REAL_SECH);
declare(REAL_ASEC);
declare(REAL_ASECH);

declare(REAL_CSC);
declare(REAL_CSCH);
declare(REAL_ACSC);
declare(REAL_ACSCH);

declare(REAL_COT);
declare(REAL_COTH);
declare(REAL_ACOT);
declare(REAL_ACOTH);

declare(REAL_IP);
declare(REAL_FP);
declare(REAL_FLOOR);
declare(REAL_CEIL);
declare(REAL_MOD);
declare(REAL_ANGLE);

declare(REAL_COMB);
declare(REAL_PERM);
declare(REAL_FACTORIAL);
declare(REAL_GAMMA);

declare(REAL_ERF);
declare(REAL_ERFC);
declare(REAL_IERFC);

declare(REAL_LESS);
declare(REAL_LESS_EQ);
declare(REAL_MORE);
declare(REAL_MORE_EQ);
declare(REAL_EQUAL);
declare(REAL_NOT_EQUAL);
declare(REAL_Q_ZERO);
declare(REAL_Q_NOT_ZERO);
declare(REAL_MORE_ZERO);
declare(REAL_MORE_EQ_ZERO);
declare(REAL_LESS_ZERO);
declare(REAL_LESS_EQ_ZERO);

declare(CPLX_ZERO);
declare(CPLX_ONE);
declare(CPLX_NEG_ONE);
declare(CPLX_J);

declare(CPLX_PLUS);
declare(CPLX_MINUS);
declare(CPLX_TIMES);
declare(CPLX_DIVIDE);
declare(CPLX_MOD);
declare(CPLX_POWER);

declare(CPLX_ANGLE);
declare(CPLX_ABS);
declare(CPLX_NEG);
declare(CPLX_SGN);
declare(CPLX_REAL);
declare(CPLX_IMAG);
declare(CPLX_CONJ);

declare(CPLX_INV);
declare(CPLX_SQRT);
declare(CPLX_NROOT);

declare(CPLX_EXP);
declare(CPLX_LN);
declare(CPLX_LOG);
declare(CPLX_ALOG);

declare(CPLX_SIN);
declare(CPLX_SINH);
declare(CPLX_ASIN);
declare(CPLX_ASINH);

declare(CPLX_COS);
declare(CPLX_COSH);
declare(CPLX_ACOS);
declare(CPLX_ACOSH);

declare(CPLX_TAN);
declare(CPLX_ATAN);
declare(CPLX_TANH);
declare(CPLX_ATANH);

declare(CPLX_SEC);
declare(CPLX_SECH);
declare(CPLX_ASEC);
declare(CPLX_ASECH);

declare(CPLX_CSC);
declare(CPLX_CSCH);
declare(CPLX_ACSC);
declare(CPLX_ACSCH);

declare(CPLX_COT);
declare(CPLX_ACOT);
declare(CPLX_COTH);
declare(CPLX_ACOTH);

declare(CPLX_FACTORIAL);
declare(CPLX_GAMMA);

declare(CPLX_EQUAL);
declare(CPLX_Q_ZERO);
declare(CPLX_NOT_EQUAL);
declare(CPLX_Q_NOT_ZERO);

declare(DUP);
declare(DROP);
declare(SWAP);
declare(OVER);
declare(ROT);
declare(UNROT);
declare(PICK);
declare(ROLL);
declare(UNROLL);

declare(INNER);
declare(CAR);
declare(CDR);
declare(NEXT);
declare(META_PROG);
declare(META_LIST);

declare(BIND);
declare(ABND);
declare(CACHE);
declare(DUMP);
declare(VARS);

declare(MAKEARRY);
declare(ARRY1);
declare(ARSIZE);
declare(ALEN);
declare(RANK);
declare(AREF);
declare(GETATELN);

declare(SYMBN);
declare(SYMB1);
declare(SIMPLIFY);

declare(COERCE1);
declare(COERCE2);

declare(BINT2ZINT);
declare(BINT2REAL);
declare(ZINT2BINT);
declare(ZINT2REAL);
declare(REAL2BINT);
declare(REAL2ZINT);

declare(xNEGATIVE);
declare(xOPAREN);
declare(xCPAREN);
declare(xTIMES);
declare(xDIVIDE);
declare(xMOD);
declare(xPLUS);
declare(xMINUS);
declare(xASSIGN);
declare(xCOMMA);
declare(xEQUAL);
declare(xPOW);

declare(xABS);
declare(xSGN);
declare(xINV);
declare(xSQRT);
declare(xNROOT);
declare(xEXP);
declare(xLN);
declare(xLOG);
declare(xALOG);
declare(xSIN);
declare(xCOS);
declare(xSINH);
declare(xCOSH);
declare(xASIN);
declare(xACOS);
declare(xASINH);
declare(xACOSH);
declare(xTAN);
declare(xATAN);
declare(xTANH);
declare(xATANH);
declare(xMOD);
declare(xANGLE);
declare(xCOMB);
declare(xPERM);
declare(xFACTORIAL);
declare(xGAMMA);        

#endif
