#include "symfonievolumedialog.h"
#include "ui_symfonievolumedialog.h"

SymfonieVolumeDialog::SymfonieVolumeDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SymfonieVolumeDialog)
{
    ui->setupUi(this);
    this->setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);


    this->connect(
            this->ui->speedSlider,
            SIGNAL(valueChanged(double)),
            this,
            SLOT(speedSliderChangedSlot(double))
            );

}

SymfonieVolumeDialog::~SymfonieVolumeDialog()
{
    delete ui;
}

void SymfonieVolumeDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SymfonieVolumeDialog::speedSliderChangedSlot(double oldValue){
    emit speedChangedSignal(oldValue);
}


QPushButton* SymfonieVolumeDialog::getShowSeekbarButton(){
    return this->ui->btnShowSeekbar;
}
