#ifndef SYMFONIETIMERWINDOW_H
#define SYMFONIETIMERWINDOW_H

#include <QMainWindow>



class QListWidgetItem;

namespace Ui {
    class SymfonieTimerWindow;
}

class SymfonieTimerWindow : public QMainWindow {
    Q_OBJECT
public:
    SymfonieTimerWindow(QWidget *parent = 0);
    ~SymfonieTimerWindow();
    static QString getNoTimerDescription();
    static QString getTimerDescription(int time); //msec
    static QString getTimerDescription(int hour, int minute);
    static int hourMinuteToMsec(int hour, int minute);
    void setTimerStateEnabled(bool);

    void updateStateInfo();
    void updateStateInfo(int time);


public Q_SLOTS:
    void setTimerSlot();
    void clearTimerSlot();


Q_SIGNALS:
            void setTimerSignal(int time);
            void clearTimerSignal();


protected:
    void changeEvent(QEvent *e);

private:
    Ui::SymfonieTimerWindow *ui;
    bool isEnabledState;
    static const int ROLE_VALUE = 999;




};

#endif // SYMFONIETIMERWINDOW_H
