#ifndef SYMFONIEPLAYLIST_H
#define SYMFONIEPLAYLIST_H

#include <QObject>
#include <QDebug>
#include <QHash>
#include <QFileSystemModel>
#include "symfonieplaylistitem.h"
#include "symfonieplaylistitemfile.h"
#include "symfonieplaylistitemfolder.h"

//class SymfoniePlayListItem;

class SymfoniePlayList : public QObject
{
    Q_OBJECT
public:
    SymfoniePlayList(QString curDir = QString());
    ~SymfoniePlayList();


    void addFile(SymfoniePlayListItemFile *);
    void addFolder(SymfoniePlayListItemFolder *);
    void addDotDot(SymfoniePlayListItemFolder *);

    int getFirstPlaybackIndex();
    int getNextPlaybackIndex(int currentPlaybackIndex);
    int getPreviousPlaybackIndex(int currentPlaybackIndex);

    int getSize();
    void setCurrentDirectory(QString);
    QString getCurrentDirectory();
    QList<SymfoniePlayListItem*> *getItemList();
    QList<QVariant> *getFileIndexList();

    SymfoniePlayListItem *get(int itemIndex);
    void clear();

    bool isIndexLast(int indexToTest);

    void enableShuffle();
    void disableShuffle();
    bool getIsShuffleEnabled();

    void enableRepeat();
    void disableRepeat();
    bool getIsRepeatEnabled();

private:
    QString curDir;
    QList<SymfoniePlayListItem*> *itemList;
    QList<QVariant> *fileIndexList;
    QList<QVariant> *fileIndexListBackup; //when shuffle is enabled, used for backup
    int firstFileIndex; //-1 means no file in current directory

    bool isShuffleEnabled;

    bool isRepeatEnabled;

   void shuffleList(QList<QVariant> *  list);



};

#endif // SYMFONIEPLAYLIST_H
