#include <QTime>
#include <QHashIterator>
#include "symfonieplaylist.h"

SymfoniePlayList::SymfoniePlayList(QString curDir):
        itemList(new QList<SymfoniePlayListItem*>()),
        fileIndexListBackup(NULL),
        fileIndexList(new QList<QVariant>()),
        curDir(curDir),
        firstFileIndex(-1),
        isShuffleEnabled(false)
{

}


SymfoniePlayList::~SymfoniePlayList()
{
    while (!itemList->isEmpty()){
        delete itemList->takeFirst();
    }
    delete this->itemList;
    delete this->fileIndexList;

    if(this->fileIndexListBackup != NULL){
        delete this->fileIndexListBackup;
    }
}


void SymfoniePlayList::setCurrentDirectory(QString dir){
    this->curDir = dir;
}


void SymfoniePlayList::addFile(SymfoniePlayListItemFile *file){
  this->itemList->append(file);
  //qDebug() <<"this->itemList->indexOf(file): " << this->itemList->indexOf(file);
  this->fileIndexList->append(QVariant(this->itemList->indexOf(file)));
}

void SymfoniePlayList::addFolder(SymfoniePlayListItemFolder *folder){
    this->itemList->append(folder);
}

void SymfoniePlayList::addDotDot(SymfoniePlayListItemFolder *folderDotDot){
    this->itemList->append(folderDotDot);
}

int SymfoniePlayList::getSize(){
    return this->itemList->size();
}

 QList<SymfoniePlayListItem*> *SymfoniePlayList::getItemList(){
    return this->itemList;
}

 QList<QVariant> *SymfoniePlayList::getFileIndexList(){
     return this->fileIndexList;
 }

 void SymfoniePlayList::clear(){
     this->itemList->clear();
 }

 SymfoniePlayListItem *SymfoniePlayList::get(int itemIndex){
     if(itemIndex < 0 || itemIndex >= this->itemList->size()){
         return NULL;
     }
     return this->itemList->value(itemIndex);
 }


 int SymfoniePlayList::getFirstPlaybackIndex(){
     if(this->fileIndexList->size() > 0){
       return this->fileIndexList->at(0).toInt();
     }else{
         return -1;
      }
 }

 int SymfoniePlayList::getNextPlaybackIndex(int currentPlaybackIndex){
     if(this->isRepeatEnabled){
         return currentPlaybackIndex;
     }


     int nextIndex = this->fileIndexList->indexOf(QVariant(currentPlaybackIndex)) + 1;
     int size = this->fileIndexList->size();
     if(nextIndex >= size){
         nextIndex = 0;
     }


     int ret = this->fileIndexList->at(nextIndex).toInt();

     qDebug() << "Next index: "<<ret;


     return ret;
 }

 bool SymfoniePlayList::isIndexLast(int indexToTest){
     return indexToTest >= this->fileIndexList->size();
 }

 QString SymfoniePlayList::getCurrentDirectory(){
     return this->curDir;
 }

 int SymfoniePlayList::getPreviousPlaybackIndex(int currentPlaybackIndex){
     int prevIndex = this->fileIndexList->indexOf(QVariant(currentPlaybackIndex)) - 1;
     if(prevIndex < 0){
         prevIndex = this->fileIndexList->size() - 1;
     }

     int ret = this->fileIndexList->at(prevIndex).toInt();

     return ret;
 }



 void SymfoniePlayList::shuffleList(QList<QVariant> *  list){

     qsrand( QTime(0,0,0).secsTo(QTime::currentTime()) );

     for( int i = list->count() - 1 ; i > 0 ; --i ){
         int rand = qrand() % list->count();
         QVariant value = list->value(i);
         list->replace(i, list->value(rand));
         list->replace(rand, value);
     }
 }

 void SymfoniePlayList::enableShuffle(){
     this->isShuffleEnabled = true;

     if(this->fileIndexListBackup == NULL){//only do this once
         this->fileIndexListBackup = new QList<QVariant>();
         for(int i = 0; i<this->fileIndexList->size(); i++){
             this->fileIndexListBackup->append(this->fileIndexList->value(i));
         }
     }


     this->shuffleList(this->fileIndexList);

 }


 void SymfoniePlayList::disableShuffle(){
     if(this->isShuffleEnabled){
        delete this->fileIndexList;
        this->fileIndexList = this->fileIndexListBackup;
        this->fileIndexListBackup = NULL;
     }

     this->isShuffleEnabled = false;
 }

  bool SymfoniePlayList::getIsShuffleEnabled(){
      return this->isShuffleEnabled;
  }



  void SymfoniePlayList::enableRepeat(){
      this->isRepeatEnabled = true;
  }

  void SymfoniePlayList::disableRepeat(){
      this->isRepeatEnabled = false;
  }

  bool SymfoniePlayList::getIsRepeatEnabled(){
      return this->isRepeatEnabled;
  }
