#ifndef SYMFONIEMEDIAPLAYER_H
#define SYMFONIEMEDIAPLAYER_H

#include <QMainWindow>
#include <phonon/audiooutput.h>
#include <phonon/seekslider.h>
#include <phonon/mediaobject.h>
#include <phonon/volumeslider.h>
#include <phonon/backendcapabilities.h>
#include <QList>
#include <QtConcurrentRun>
#include "symfonieplaylist.h"





class QStringList;
class QTimer;

class SymfonieMediaPlayer : public QObject
{
    Q_OBJECT
public:
    explicit SymfonieMediaPlayer(QObject *parent = 0);
    ~SymfonieMediaPlayer();



    QString getCurrentDirectory();
    SymfoniePlayList* scanDir(QString path);//, bool isUpdatePlayList = false);

    int getCurrentPlaybackIndex();
    int getNextPlaybackIndex();
    int getPreviousPlaybackIndex();
    Phonon::Path getPath();
    Phonon::Effect *getEqualizerEffect();

    Phonon::MediaObject *getMediaObject();
    SymfoniePlayList *getPlayList();
    void setPlayList(SymfoniePlayList*);
    Phonon::AudioOutput* getAudioOutput();

    bool insertEqualizerEffect();
    void removeEqualizerEffect();

    bool insertSpeedEffect();
    void setSpeed(float speed);

    bool isCanPlay();
    QString getFilePathAt(int index);
    void fetchSongInfo(QString path);

    //playback functions
    void play(qint64 = 0);
    qint64 seekToBuffer;
    void playOrPause();
    void playPrevious();
    void playNext();
    void pause();
    void enqueue(int index);
    void stop();

    void doTimer(int time);
    void stopTimer();
    int getTimerRemain();
    void setFileFilter(QStringList filterList);

    void startGraduateVolumeResuming(qreal value);

    void setIsContinuouslyPlay(bool flag);
    bool getIsContinuouslyPlay();

    void enableShuffle();
    void disableShuffle();
    bool getIsShuffleEnabled();

    void enableRepeat();
    void disableRepeat();
    bool getIsRepeatEnabled();

    SymfoniePlayList* scanDirRecursive(QString path);


Q_SIGNALS:
    void directoryChangedSignal(QString);
    void scanDirCompletedSignal(SymfoniePlayList*, QString);
    void mediaStateChangedSignal( Phonon::State newstate, Phonon::State oldstate);
    void playListUpdatedSignal(SymfoniePlayList* playList);
    void timerStoppedSignal();
    void timerRemainTimeChangedSignal(int);

    void equalizerEffectInsertedSignal();
    void equalizerEffectRemovedSignal();


public Q_SLOTS:
    void mediaStateChangedSlot( Phonon::State newstate, Phonon::State oldstate);
    void aboutToFinishSlot();
    void currentSourceChangedSlot ( const Phonon::MediaSource & newSource );
    void playListUpdatedSlot(SymfoniePlayList* playList);
    void oneCompletedSlot();
    void timerEndSlot();
    void doGraduateVolumeResuming();




private Q_SLOTS:
    void updateTimerValueSlot();


protected:
    void setCurrentDirectory(QString dir);


private:
    Phonon::MediaObject *player;
    Phonon::AudioOutput *audioOutput;
    Phonon::Path path;
    Phonon::Effect *equalizerEffect;
    Phonon::Effect *speedEffect;
    bool hasEqualizerEffect;
    bool isEqualizerEnabled;

    void initPlayer();

    QString currentDirectory;
    SymfoniePlayList *playList;
    int currentPlaybackIndex;
    int queuedIndex;
    QTimer *timer;
    QTimer *timerUpdater; //update remaining time of the timer

    void saveState();

    int timerRemainCounter; //why do I need to implement this?

    static const int TIMER_VALUE_UPDATE_RATE = 3000; //msec


    QStringList fileFilterList;

    static const qreal GRADUATE_VOLUME_INCREMENT = .02; //1 sec
    QTimer *graduateVolumeTimer;
    qreal graduateVolumeResumeTo;

    Phonon::Effect* getEffectDescriptionByName(QString effectName);


    bool isContinuouslyPlay;


    void scanDirRecursiveBase(SymfoniePlayList *playList, QString path);
    QStringList getDirectoryListByPath(QString path);
    QStringList getFileListByPath(QString path);
    void doScanDirCompleted(SymfoniePlayList *playList, QString path);
    void addInitialDir(SymfoniePlayList *playList, QString path);



};

#endif // SYMFONIEMEDIAPLAYER_H
