#include <QDebug>
#include <QStringList>
#include <QCheckBox>
#include "symfoniefiletypesdialog.h"
#include "ui_symfoniefiletypesdialog.h"
#include "symfoniedb.h"



SymfonieFileTypesDialog::SymfonieFileTypesDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::SymfonieFileTypesDialog)
{


    this->fileTypeList
            << "*.mp3"
            << "*.wma"
            << "*.m4a"
            << "*.mp4"
            << "*.ogg"
            << "*.wav"
            << "*.flac"
            << "*.acc"
            << "*.m4p"
            << "*.ape"
            << "*.3pg"
            << "*.ra"
            << "*.gsm"
            << "*.dct"
            << "*.vox"
            << "*.mmf"
            << "*.au"
            << "*.mpc"
            << "*.aiff"
            << "*.raw"
            << "*.dss"
            << "*.iklax"
            << "*.dvf"
            << "*.ivs"
            << "*.mxp4"
            << "*.amr"
            << "*.awb"
            ;


    ui->setupUi(this);
    this->setWindowTitle(tr("File Types"));


    for(int i=0; i<this->fileTypeList.size(); i++){
        QCheckBox* cb = new QCheckBox(this->fileTypeList.at(i));
        this->fileTypeCbList.append(cb);
        this->ui->cbLayout->addWidget(cb);
    }



   this->updateCheckedFileTypes();

    connect(this, SIGNAL(finished(int)), this, SLOT(finishedSlot(int)));
}

SymfonieFileTypesDialog::~SymfonieFileTypesDialog(){
    delete ui;
}

void SymfonieFileTypesDialog::changeEvent(QEvent *e){
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void SymfonieFileTypesDialog::updateCheckedFileTypes(){
    QStringList typeList = SymfonieFileTypesDialog::getSavedFilterList();
    for(int i=0; i < typeList.size(); i++){
        for(int cbIndex=0; cbIndex<this->fileTypeList.size(); cbIndex++){
            QCheckBox* cb = this->fileTypeCbList.at(cbIndex);
            if(QString::compare(typeList.at(i), cb->text()) == 0){
                cb->setChecked(true);

            }
        }

    }
}

void SymfonieFileTypesDialog::finishedSlot(int){
    QString buff;

     for(int cbIndex=0; cbIndex<this->fileTypeList.size(); cbIndex++){
         if(this->fileTypeCbList.at(cbIndex)->isChecked()){
             buff +=  this->fileTypeCbList.at(cbIndex)->text() + "|";

         }

     }

    SymfonieDb::getInstance()->saveSetting("file_filter", QVariant(buff));

    this->updateCheckedFileTypes();


    qDebug() << "emit fileTypesChanged(buff);" << buff << SymfonieFileTypesDialog::serializePattern(buff) << "__|";
    emit fileTypesChanged(SymfonieFileTypesDialog::serializePattern(buff));
}

QStringList SymfonieFileTypesDialog::serializePattern(QString str){
    QStringList list = str.split("|");
    QStringList ret;

    for (int i = 0; i < list.size(); ++i){
        if(list.at(i).length() > 0){
            ret.append(list.at(i));
        }
    }
    return ret;
}

QStringList SymfonieFileTypesDialog::getSavedFilterList(){
    QString pattern = SymfonieDb::getInstance()->getSetting("file_filter", QVariant()).toString();
    if(pattern.length() == 0){
        pattern = "*.mp3|*.m4a|*.mp4|*.wav|*.ogg|*.wma|*.flac";
    }

    return SymfonieFileTypesDialog::serializePattern(pattern);


}
