#ifndef SYMFONIEEQUALIZERWINDOW_H
#define SYMFONIEEQUALIZERWINDOW_H

#include <QMainWindow>
#include <phonon>

class QStringList;
class SymfonieQSlider;

namespace Ui {
    class SymfonieEqualizerWindow;
}

class SymfonieEqualizerWindow : public QMainWindow {
    Q_OBJECT
public:
    SymfonieEqualizerWindow(QWidget *parent = 0);
    ~SymfonieEqualizerWindow();
    void saveBandValue(int band, int value);
    int getBandValue(int band);
    void saveState();

    bool getIsEnabled();
    void setEqualizerEffect(Phonon::Effect *effect);
    void syncSlidersValues();


Q_SIGNALS:
    void enabledStateChanged(bool);


public Q_SLOTS:
    void slideValueChangedSlot(int index, int value);
    void setWindowEnabled(bool);

protected:
    void changeEvent(QEvent *e);
    void showEvent ( QShowEvent * event );

private:
    Ui::SymfonieEqualizerWindow *ui;
    Phonon::Effect *effect;
    static QString bandNames[];
   QList<SymfonieQSlider*> *sliderList;

   static const int EQ_BAR_MIN = 0; //0
   static const int EQ_BAR_MAX = 10; //10

   bool isEnabled;
};

#endif // SYMFONIEEQUALIZERWINDOW_H
