#include <QWidget>
#include <QLabel>
#include <phonon>
#include <QStringList>
#include "symfonieequalizerwindow.h"
#include "ui_symfonieequalizerwindow.h"
#include "symfonieqslider.h"
#include "symfoniedb.h"


QString SymfonieEqualizerWindow::bandNames[] = {
    "29Hz",
    "59Hz",
    "119Hz",
    "227Hz",
    "474Hz",
    "947Hz",
    "1889Hz",
    "3770Hz",
    "7523Hz",
    "15011Hz"
};

SymfonieEqualizerWindow::SymfonieEqualizerWindow(QWidget *parent) :
        effect(NULL),
        sliderList(new QList<SymfonieQSlider*>()),
        QMainWindow(parent),
        ui(new Ui::SymfonieEqualizerWindow)
{

    this->setWindowTitle(tr("Equalizer"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(this->windowFlags() | Qt::Window);

     ui->setupUi(this);

    connect(this->ui->actionToggle, SIGNAL(triggered(bool)), this, SLOT(setWindowEnabled(bool)));


    for(int i=0; i<SymfonieEqualizerWindow::EQ_BAR_MAX -  SymfonieEqualizerWindow::EQ_BAR_MIN; i++){

        int bandIndex = SymfonieEqualizerWindow::EQ_BAR_MIN + i;
        int bandValue;
        SymfonieQSlider *s = new SymfonieQSlider(bandIndex);


        s->getSlider()->setInvertedControls(true);
        s->getSlider()->setMinimum(-12);
        s->getSlider()->setMaximum(12);
        s->setName(SymfonieEqualizerWindow::bandNames[i]);


        connect(s, SIGNAL(valueChangedSignal(int, int)), this, SLOT(slideValueChangedSlot(int, int)));


        this->ui->mainLayout->addWidget(s);

        bandValue = this->getBandValue(bandIndex);
        s->setValue(bandValue);

        this->slideValueChangedSlot(i, bandValue);
        this->sliderList->insert(i, s);

    }

}

SymfonieEqualizerWindow::~SymfonieEqualizerWindow()
{
    delete ui;
    this->saveState();
    delete this->sliderList;
}

void SymfonieEqualizerWindow::setEqualizerEffect(Phonon::Effect *effect){
    this->effect = effect;
    this->syncSlidersValues();
}

void SymfonieEqualizerWindow::setWindowEnabled(bool value){
    this->ui->centralwidget->setEnabled(value);
    this->ui->actionToggle->setChecked(value);
    if(value == true){       
        this->ui->actionToggle->setText(tr("Disable Equalizer"));

    }else{
        this->ui->actionToggle->setText(tr("Enable Equalizer"));
    }

    this->isEnabled = value;

    emit enabledStateChanged(value);
}


bool SymfonieEqualizerWindow::getIsEnabled(){
    return this->isEnabled;
}

void SymfonieEqualizerWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void SymfonieEqualizerWindow::slideValueChangedSlot(int index, int value){
    if(this->effect == NULL){
        return;
    }

    QList<Phonon::EffectParameter> parameters = this->effect->parameters();

    foreach(Phonon::EffectParameter parameter, parameters) {
        if(QString::compare(parameter.name(), ("band" + QVariant(index).toString())) == 0){
            // qDebug() << "Band Value set to: " << value << " index: "<<index;
            this->effect->setParameterValue(parameter, value);
        }
    }

}

void SymfonieEqualizerWindow::syncSlidersValues(){
    for(int i=0; i<SymfonieEqualizerWindow::EQ_BAR_MAX - SymfonieEqualizerWindow::EQ_BAR_MIN; i++){
        this->slideValueChangedSlot(
                this->sliderList->at(i)->getGroupIndex(),
                this->sliderList->at(i)->getValue()
                );
    }
}



void SymfonieEqualizerWindow::saveBandValue(int band, int value){
    SymfonieDb::getInstance()->saveSetting("band-value-" + QVariant(band).toString(), QVariant(value));
}

int SymfonieEqualizerWindow::getBandValue(int band){
    return SymfonieDb::getInstance()->getSetting("band-value-" + QVariant(band).toString()).toInt();
}


void SymfonieEqualizerWindow::saveState(){

    for(int i=0; i<SymfonieEqualizerWindow::EQ_BAR_MAX - SymfonieEqualizerWindow::EQ_BAR_MIN; i++){
        this->saveBandValue(this->sliderList->at(i)->getGroupIndex(), this->sliderList->at(i)->getValue());
    }
}
