#include "symfoniesong.h"
#include "symfoniedb.h"


SymfonieSong::SymfonieSong(QObject *parent) :
         QObject(parent)

{
    file_size = 0;
    length = 0;
    is_info_fetched = false;
    isSongNew = true;
}

void SymfonieSong::setId(int id){
    this->id = id;
}

int SymfonieSong::getId(){
    return this->id;
}

void SymfonieSong::setTitle(QString title){
  this->title = title;
}

QString SymfonieSong::getTitle(){
  return this->title;
}

void SymfonieSong::setLength(qint64 length){
  this->length = length;
}

qint64 SymfonieSong::getLength(){
  return this->length;
}

void SymfonieSong::setFileSize(qint64 size){
  this->file_size = size;
}

qint64 SymfonieSong::getFileSize(){
  return this->file_size;
}

void SymfonieSong::setFilePath(QString path){
  this->file_path = path;
}

QString SymfonieSong::getFilePath(){
  return this->file_path;
}

QString SymfonieSong::getFileDir(){
    QFileInfo fi = QFileInfo(this->getFilePath());
    return fi.path();
}

QString SymfonieSong::getFileName(){
    QFileInfo fi = QFileInfo(this->getFilePath());
    return fi.fileName();
}

QString SymfonieSong::getNameForDisplay(){
    QString name;
    if(this->getTitle().length() > 0){
        name = this->getTitle();
    }else{
        name = this->getFileName();
    }
    return name;
}

void SymfonieSong::setArtistName(QString name){
  this->artist_name = name;
}

QString SymfonieSong::getArtistName(){
  return this->artist_name;
}

void SymfonieSong::setAlbumName(QString name){
  this->album_name = name;
}

QString SymfonieSong::getAlbumName(){
  return this->album_name;
}

void SymfonieSong::setIsInfoFetched(bool state){
    this->is_info_fetched = state;
}

bool SymfonieSong::getIsInfoFetched(){
   return this->is_info_fetched;
}


void SymfonieSong::save(){
  SymfonieDb *db = SymfonieDb::getInstance();
  QSqlQuery query;
  QString sql;
  if(this->isNew()){
  sql =
          "INSERT INTO " + SymfonieSong::getTableName()  + " "
          "( artist_name, album_name, title, length, file_size, file_path, is_info_fetched ) "
          "VALUES(:artist_name, :album_name, :title, :length, :file_size, :file_path, :is_info_fetched )";
}else{
    sql = "UPDATE " + SymfonieSong::getTableName()  + " "
          "SET artist_name=:artist_name, "
          "album_name=:album_name, "
          "title=:title, "
          "length=:length, "
          "file_size=:file_size, "
          "file_path=:file_path, "
          "is_info_fetched=:is_info_fetched "
          "WHERE id=:id";

}

  query.prepare(sql);
  if(!this->isNew()){
      query.bindValue(":id", this->getId());
  }
  query.bindValue(":artist_name", this->getArtistName());
  query.bindValue(":album_name", this->getAlbumName());
  query.bindValue(":title", this->getTitle());
  query.bindValue(":length", this->getLength());
  query.bindValue(":file_size", this->getFileSize());
  query.bindValue(":file_path", this->getFilePath());
  query.bindValue(":is_info_fetched", this->getIsInfoFetched() ? 1:0);
  db->executeQuery(query);
  this->isSongNew = false;
}

bool SymfonieSong::isNew(){
  return this->isSongNew;
}

void SymfonieSong::setIsNew(bool isSongNew){
    this->isSongNew = isSongNew;
}

SymfonieSong *SymfonieSong::findById(int id){
    QSqlQuery query;
    QString sql =
            "SELECT * FROM " + SymfonieSong::getTableName()  + " "
            "WHERE id=:id "
            "LIMIT 1";
    query.prepare(sql);
    query.bindValue(":id", id);
    return SymfonieSong::findByQuery(query);
}

SymfonieSong *SymfonieSong::findByFilePath(QString &path){
    QSqlQuery query;
    QString sql =
            "SELECT * FROM " + SymfonieSong::getTableName()  + " "
            "WHERE file_path=:file_path "
            "LIMIT 1";
    query.prepare(sql);
    query.bindValue(":file_path", path);

    return SymfonieSong::findByQuery(query);
}


SymfonieSong *SymfonieSong::findByQuery(QSqlQuery &query){
    bool r = SymfonieDb::getInstance()->executeQuery(query);


    if(r && query.first() == true){
        return SymfonieSong::hydrateInfoByQuery(query);
    }else{
        return 0;
    }
}

SymfonieSong *SymfonieSong::hydrateInfoByQuery(QSqlQuery &query){
    SymfonieSong* song = new SymfonieSong();
    song->setIsNew(false);
    song->setId(query.value(query.record().indexOf("id")).toInt());
    song->setArtistName(query.value(query.record().indexOf("artist_name")).toString());
    song->setAlbumName(query.value(query.record().indexOf("album_name")).toString());
    song->setTitle(query.value(query.record().indexOf("title")).toString());
    song->setLength(query.value(query.record().indexOf("length")).toInt());
    song->setFileSize(query.value(query.record().indexOf("file_size")).toInt());
    song->setFilePath(query.value(query.record().indexOf("file_path")).toString());
    song->setIsInfoFetched(query.value(query.record().indexOf("is_info_fetched")).toInt() == 1 ? true: false);
    return song;
}

QString SymfonieSong::getTableName(){
  return "song";
}

QString SymfonieSong::toString(){
    return QString("id: " + QVariant(this->getId()).toString() + ", length: " + this->getLength());
}


SymfonieSong* SymfonieSong::getNextUnIndexedSong(){
    QList<SymfonieSong*> *list = new QList<SymfonieSong*>();
    QSqlQuery query;
    QString sql =
            "SELECT * FROM " + SymfonieSong::getTableName()  + " "
            "WHERE is_info_fetched = 0 ";
    query.prepare(sql);

    return SymfonieSong::findByQuery(query);
}

QList<SymfonieSong*> *SymfonieSong::getUnIndexedSongList(){
    QList<SymfonieSong*> *list = new QList<SymfonieSong*>();
    QSqlQuery query;
    QString sql =
            "SELECT * FROM " + SymfonieSong::getTableName()  + " "
            "WHERE is_info_fetched = 0 ";
    query.prepare(sql);

    bool r = SymfonieDb::getInstance()->executeQuery(query);


    if(r){
        while(query.next()){
         SymfonieSong *song = SymfonieSong::hydrateInfoByQuery(query);
         list->append(song);
        }
    }

    qDebug() << "getUnIndexedSongList: " << list->size();


    return list;
}



