#include "symfonieplaylist.h"

SymfoniePlayList::SymfoniePlayList(QString curDir):
        itemList(new QList<SymfoniePlayListItem*>()),
        fileIndexList(new QList<QVariant>()),
        curDir(curDir),
        firstFileIndex(-1)
{

}


SymfoniePlayList::~SymfoniePlayList()
{
    while (!itemList->isEmpty()){
        delete itemList->takeFirst();
    }
    delete this->itemList;
    delete this->fileIndexList;
}


void SymfoniePlayList::setCurrentDirectory(QString dir){
    this->curDir = dir;
}


void SymfoniePlayList::addFile(SymfoniePlayListItemFile *file){
  this->itemList->append(file);
  //qDebug() <<"this->itemList->indexOf(file): " << this->itemList->indexOf(file);
  this->fileIndexList->append(QVariant(this->itemList->indexOf(file)));
}

void SymfoniePlayList::addFolder(SymfoniePlayListItemFolder *folder){
    this->itemList->append(folder);
}

void SymfoniePlayList::addDotDot(SymfoniePlayListItemFolder *folderDotDot){
    this->itemList->append(folderDotDot);
}

int SymfoniePlayList::getSize(){
    return this->itemList->size();
}

 QList<SymfoniePlayListItem*> *SymfoniePlayList::getItemList(){
    return this->itemList;
}

 QList<QVariant> *SymfoniePlayList::getFileIndexList(){
     return this->fileIndexList;
 }

 void SymfoniePlayList::clear(){
     this->itemList->clear();
 }

 SymfoniePlayListItem *SymfoniePlayList::get(int itemIndex){
     if(itemIndex < 0 || itemIndex >= this->itemList->size()){
         return NULL;
     }
     return this->itemList->value(itemIndex);
 }


 int SymfoniePlayList::getFirstPlaybackIndex(){
     if(this->fileIndexList->size() > 0){
       return this->fileIndexList->at(0).toInt();
     }else{
         return -1;
      }
 }

 int SymfoniePlayList::getNextPlaybackIndex(int currentPlaybackIndex){
     int nextIndex = this->fileIndexList->indexOf(QVariant(currentPlaybackIndex)) + 1;
     int size = this->fileIndexList->size();
     if(nextIndex >= size){
         nextIndex = 0;
     }


     int ret = this->fileIndexList->at(nextIndex).toInt();

     qDebug() << "Next index: "<<ret;


     return ret;
 }

 QString SymfoniePlayList::getCurrentDirectory(){
     return this->curDir;
 }

 int SymfoniePlayList::getPreviousPlaybackIndex(int currentPlaybackIndex){
     int prevIndex = this->fileIndexList->indexOf(QVariant(currentPlaybackIndex)) - 1;
     if(prevIndex < 0){
         prevIndex = this->fileIndexList->size() - 1;
     }

     int ret = this->fileIndexList->at(prevIndex).toInt();

     return ret;
 }
