#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QModelIndex>
#include <QPushButton>
#include <QAction>
#include <phonon>
#include <QListWidgetItem>


class SymfonieMediaPlayer;
class SymfonieInfoWindow;
class SymfoniePlayList;
class QLabel;
class QTimer;
class QApplication;
class SymfonieTimerWindow;
class SymfonieEqualizerWindow;
class SymfonieFileTypesDialog;
class SymfonieOptionsDialog;
class SymfonieVolumeDialog;
class SymfonieFullScreenExitButton;
class SymfonieVolumeSlider;
class SymfonieSeekSlider;
class SymfonieSpeedDialog;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(const QApplication *app, SymfonieMediaPlayer* player, QWidget *parent = 0);
    ~MainWindow();
    void setPlayer(SymfonieMediaPlayer *player);

    QString getCurrentDiretory();
    void setCurrentDirectory(QString);

    SymfonieMediaPlayer * getPlayer();
    void setPO();
    void setHO();

    Ui::MainWindow* getUi();
    int getCurrentOrientation();


protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    SymfonieMediaPlayer *player;
    QString curentDirectory;
    SymfoniePlayList* currentPlayList;
    void insertItem(SymfoniePlayList* );
    QTimer *timer;
    SymfonieTimerWindow *timerWindow;
    SymfonieEqualizerWindow *equalizerWindow;
    const QApplication *app;
    SymfonieFileTypesDialog *fileTypesDialog;
    SymfonieOptionsDialog *optionsDialog;
    SymfonieVolumeDialog *volumeDialog;
    SymfonieSpeedDialog *speedDialog;


    QAction *playAction;
    QAction *stopAction;
    QAction *prevAction;
    QAction *nextAction;
    QAction *switchOrientationAction;
    QAction *showInfoWindowAction;
    QAction *showToolBar2Action;
    QAction *goUpAction;
    QAction *goHomeAction;
    QAction *goToCurDir;
    QAction *toggleFullScreenAction;
    QAction *showSpeedDialogAction;

    QActionGroup *orientationGroup;
    QAction *orientationLandscape;
    QAction *orientationPortrait;
    QAction *orientationAuto;

    QWidget *ww;
    bool isInPortait;

    SymfonieInfoWindow* infoWindow;
    SymfonieSeekSlider *seekSlider;
    SymfonieVolumeSlider *volumeSlider;

    void setActionToggleState();

    SymfoniePlayList* createHomePlayList();
    void saveState();
    bool saveLastDir();
    bool isResumePlayback;
   // void notifyInfo(QString);

    void setMenuActionTimerText(int time);

   void setupToolBarButtonsLandscape();
   void setupToolBarButtonsPortrait();
   void setOrientationMode(int mode);
   int currentOrientationMode;

   SymfonieFullScreenExitButton *fullScreenExitButton;

   bool isMainToolbarVisible;
   void setToolbarVisibility(bool isShow);
   QString fileListWidgetItemFileToDelete;


public Q_SLOTS:
      void showSpeedDialogSliderChangedSlot(float);

private Q_SLOTS:
    void itemActivatedSlot(QModelIndex);
    void mediaStateChangedSlot(Phonon::State newState, Phonon::State oldState);
    void stopSlot();
    void playSlot();
    void playNextSlot();
    void playPrevSlot();
    void playerDirectoryChangedSlot(QString);
    void playerScanDirCompletedSlot(SymfoniePlayList*, QString);
    void switchOrientationSlot();
    void showInfoWindowSlot();
    void showToolBar2Slot();
    void goHomeSlot();
    void goUpSlot();
    void playerTickSlot(qint64 time);
    void goToCurDirSlot();
    void showAboutWindowSlot();
    void showTimerWindowSlot();
    void showVolumeDialogSlot();
    void showSpeedDialogSlot();
    void volumeDialogClosedSlot();
    void updateTimerSlot(int time);
    void showEqualizerWindowSlot();
    void toggleFullScreen();
    void toggleFullScreen(bool b);
    void toggleFullScreenOn();
    void toggleFullScreenOff();
    void orientationChanged(QAction *action);
    void playerTimerStoppedSlot();
    void clearTimerSlot();
    void playerTimerRemainTimeChangedSlot(int);
    void equalizerWindowEnabledStateChangedSlot(bool value);
    void showFileTypesWindowSlot();
    void fileTypesChangedSlot(QStringList list);
    void showOptionsWindowSlot();
    void optionsChangedSlot(int);

    void fileListItemContextMenu(const QPoint &pos);
    void deleteFileSlot();



};

#endif // MAINWINDOW_H

