#include "symfonieseekslider.h"
#include "MediaObject"
#include <QPainter>
#include <QStyleOptionSlider>
#include <QLayout>
#include "symfonielabelignoreevent.h"


SymfonieSeekSlider::SymfonieSeekSlider(QWidget *parent) :
        Phonon::SeekSlider(parent),
        displayer(new SymfonieLabelIgnoreEvent(this))

{
    displayer->setText("");

    //this->layout()->addWidget(displayer);
    displayer->setAlignment(Qt::AlignCenter);
    displayer->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);
    displayer->setMinimumWidth(150);

    displayer->setAttribute(Qt::WA_TransparentForMouseEvents);
    displayer->setFocusPolicy( Qt::NoFocus );

    this->centerText();

}


void SymfonieSeekSlider::setText(const QString & text ){
    this->displayer->clear();
    this->displayer->setText(text);

}

void SymfonieSeekSlider::centerText(){
    this->displayer->move(this->width() / 2 - this->displayer->width() / 2,  22);
}


void SymfonieSeekSlider::resizeEvent ( QResizeEvent * e) {
    Phonon::SeekSlider::resizeEvent(e);
    this->centerText();
}
