#include <QDebug>
#include <QStringList>
#include "symfoniefiletypesdialog.h"
#include "ui_symfoniefiletypesdialog.h"
#include "symfoniedb.h"

SymfonieFileTypesDialog::SymfonieFileTypesDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::SymfonieFileTypesDialog)
{
    ui->setupUi(this);
    this->setWindowTitle(tr("File Types"));

   this->updateCheckedFileTypes();

    connect(this, SIGNAL(finished(int)), this, SLOT(finishedSlot(int)));
}

SymfonieFileTypesDialog::~SymfonieFileTypesDialog()
{
    delete ui;
}

void SymfonieFileTypesDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void SymfonieFileTypesDialog::updateCheckedFileTypes(){
    QStringList typeList = SymfonieFileTypesDialog::getSavedFilterList();
    for(int i=0; i < typeList.size(); i++){
        if(QString::compare(typeList.at(i), "*.mp3") == 0){
            this->ui->cbTypeMp3->setChecked(true);
        }else if(QString::compare(typeList.at(i), "*.mp4") == 0){
            this->ui->cbTypeMp4->setChecked(true);
        }else if(QString::compare(typeList.at(i), "*.ogg") == 0){
            this->ui->cbTypeOgg->setChecked(true);
        }else if(QString::compare(typeList.at(i), "*.m4a") == 0){
            this->ui->cbTypeM4a->setChecked(true);
        }else if(QString::compare(typeList.at(i), "*.wav") == 0){
            this->ui->cbTypeWav->setChecked(true);
        }
    }
}

void SymfonieFileTypesDialog::finishedSlot(int){
    QString buff;
    if(this->ui->cbTypeMp3->isChecked()){
        buff += "*.mp3|";
    }

    if(this->ui->cbTypeM4a->isChecked()){
        buff += "*.m4a|";
    }

    if(this->ui->cbTypeMp4->isChecked()){
        buff += "*.mp4|";
    }

    if(this->ui->cbTypeOgg->isChecked()){
        buff += "*.ogg|";
    }

    if(this->ui->cbTypeWav->isChecked()){
        buff += "*.wav|";
    }

    SymfonieDb::getInstance()->saveSetting("file_filter", QVariant(buff));

    this->updateCheckedFileTypes();


    qDebug() << "emit fileTypesChanged(buff);" << buff << SymfonieFileTypesDialog::serializePattern(buff) << "__|";
    emit fileTypesChanged(SymfonieFileTypesDialog::serializePattern(buff));
}

QStringList SymfonieFileTypesDialog::serializePattern(QString str){
    QStringList list = str.split("|");
    QStringList ret;

    for (int i = 0; i < list.size(); ++i){
        if(list.at(i).length() > 0){
            ret.append(list.at(i));
        }
    }
    return ret;
}

QStringList SymfonieFileTypesDialog::getSavedFilterList(){
    QString pattern = SymfonieDb::getInstance()->getSetting("file_filter", QVariant()).toString();
    if(pattern.length() == 0){
        pattern = "*.mp3|*.m4a|*.mp4|*.wav|*.ogg";
    }

    return SymfonieFileTypesDialog::serializePattern(pattern);


}
