#include <QDir>
#include <QScrollArea>
#include <QDesktopServices>
#include <Phonon>
#include "symfoniemediaplayer.h"
#include "symfonieplaylist.h"
#include "symfonieplaylistitem.h"
#include "symfonieplaylistitemfolder.h"
#include "symfoniesong.h"
#include "symfoniedb.h"

SymfonieMediaPlayer::SymfonieMediaPlayer(QObject *parent) :
        QObject(parent),
        playList(NULL),
        timer(new QTimer()),
        timerUpdater(new QTimer()),
        currentPlaybackIndex(-1),
        queuedIndex(-1),
        seekToBuffer(-1),
        timerRemainCounter(0){


    this->timer->setSingleShot(true);
    connect(timer, SIGNAL(timeout()), this, SLOT(timerEndSlot()));




    this->player = new Phonon::MediaObject;
    this->player->setTickInterval(1000);


    this->audioOutput = new Phonon::AudioOutput;
    this->path = Phonon::createPath(player, audioOutput);

    connect(this->player, SIGNAL(stateChanged(Phonon::State,Phonon::State)),
            this, SLOT(mediaStateChangedSlot(Phonon::State,Phonon::State)));

    connect(this->player, SIGNAL(aboutToFinish()), this, SLOT(aboutToFinishSlot()));
    connect(this->player, SIGNAL(currentSourceChanged(const Phonon::MediaSource &)),
            this, SLOT(currentSourceChangedSlot(const Phonon::MediaSource &)));

    connect(this, SIGNAL(playListUpdatedSignal(SymfoniePlayList*)),
            this, SLOT(playListUpdatedSlot(SymfoniePlayList*)));

    QList<Phonon::EffectDescription> effectDescriptions =
            Phonon::BackendCapabilities::availableAudioEffects();

    qDebug() << effectDescriptions.size() << " effect size";
    for(int i = 0; i < effectDescriptions.size(); i++){
        Phonon::EffectDescription ef = effectDescriptions.at(i);
        if(QString::compare(ef.name(), "equalizer-10bands") == 0){
            this->equalizerEffect = new Phonon::Effect(ef);
            path.insertEffect(this->equalizerEffect );
            qDebug() << "Effect inserted: " << ef.name();
        }
        qDebug() << ef.name();
    }


    this->timerUpdater->setInterval(SymfonieMediaPlayer::TIMER_VALUE_UPDATE_RATE);
    connect(this->timerUpdater, SIGNAL(timeout()), this, SLOT(updateTimerValueSlot()));

}

SymfonieMediaPlayer::~SymfonieMediaPlayer()
{
    this->saveState();
    delete player;
    delete audioOutput;
    delete this->timer;
    delete this->timerUpdater;

}

void SymfonieMediaPlayer::doTimer(int time){
    if(time < 0){
        time = 0;
    }


    this->timerRemainCounter = time;
    this->timerUpdater->start();
    this->timer->start(time);

}

void SymfonieMediaPlayer::updateTimerValueSlot(){
    qDebug() << "updateTimerValueSlot: " << this->timerRemainCounter;
    if(this->timer->isActive()){
        if(this->timerRemainCounter > 0){
            this->timerRemainCounter = this->timerRemainCounter - SymfonieMediaPlayer::TIMER_VALUE_UPDATE_RATE;
        }
    }else{
        this->timerRemainCounter = 0;
        this->timerUpdater->stop();
    }
    emit timerRemainTimeChangedSignal(this->timerRemainCounter);
}

int SymfonieMediaPlayer::getTimerRemain(){
    return this->timerRemainCounter;
}

void SymfonieMediaPlayer::stopTimer(){
    this->timer->stop();
    this->timerUpdater->stop();
    this->timerRemainCounter = 0;
    emit timerStoppedSignal();
}

void SymfonieMediaPlayer::timerEndSlot(){
    this->pause();
    emit timerStoppedSignal();
}

Phonon::AudioOutput* SymfonieMediaPlayer::getAudioOutput(){
    return this->audioOutput;
}

void SymfonieMediaPlayer::init(){
    //this->setCurrentDirectory(QDir::homePath ());// + "/MyDocs/.sounds";
    
    //this->scanDir(QDir::homePath () + "/MyDocs/m", true);
    // this->scanDir(QDir::homePath () + "/MyDocs/.sounds", true);
    // qDebug() << "Music location: " << QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    //this->setCurrentDirectory(QDesktopServices::storageLocation(QDesktopServices::MusicLocation));

}

void SymfonieMediaPlayer::saveState(){
    int index = this->getCurrentPlaybackIndex();

    qDebug() << "trying to save current played file index: " << index << " path:" << this->getFilePathAt(index);

    SymfonieDb::getInstance()->saveSetting(
            "last_played_file",
            (index != -1) ? this->getFilePathAt(index) : QVariant("")
            );

    SymfonieDb::getInstance()->saveSetting(
            "last_played_index",
            index);
}



Phonon::Path SymfonieMediaPlayer::getPath(){
    return this->path;
}

Phonon::Effect *SymfonieMediaPlayer::getEqualizerEffect(){
    return this->equalizerEffect;
}


void SymfonieMediaPlayer::setCurrentDirectory(QString dir){
    this->currentDirectory = dir;
    emit directoryChangedSignal(dir);
    qDebug() <<  "directoryChangedSignal emitted: dir: " << dir;
}

QString SymfonieMediaPlayer::getCurrentDirectory(){
    return this->currentDirectory;
}

Phonon::MediaObject *SymfonieMediaPlayer::getMediaObject(){
    return player;
}


//remove any entry in the list
SymfoniePlayList* SymfonieMediaPlayer::scanDir(QString path){//bool isUpdatePlayList){
    QDir directory(path);

    SymfoniePlayList *playList = new SymfoniePlayList(path);

    QStringList filters;
    filters << "*.mp3";

    QStringList fileList = directory.entryList(filters);
    QStringList dirList = directory.entryList(
            QStringList(),
            QDir::Dirs|QDir::NoDotAndDotDot|QDir::Drives|QDir::AllDirs
            );


    // playList->clear();

    SymfoniePlayListItemFolder *folder =  new SymfoniePlayListItemFolder(path, SymfoniePlayListItem::DotDot);
    QFileInfo fileInfo(path + "/..");
    folder->setDisplayName(path);
    folder->setName(fileInfo.canonicalFilePath());
    playList->addFolder(folder);

    qDebug() << "first dir = "  << folder->getName() << " | " << path + "/.." << " can name: " + fileInfo.canonicalFilePath();

    for (int i = 0; i < dirList.size(); i++) {
        QFileInfo fileInfo(path + "/" +dirList.at(i));
        if(!fileInfo.isDir()){
            continue;
        }

        SymfoniePlayListItemFolder *folder =  new SymfoniePlayListItemFolder(fileInfo.canonicalFilePath());
        folder->setDisplayName(fileInfo.fileName());
        playList->addFolder(folder);

    }


    for (int i = 0; i < fileList.size(); i++) {
        QFileInfo fileInfo(path + "/" +fileList.at(i));
        QString filePath = fileInfo.canonicalFilePath();

        SymfoniePlayListItemFile *file =  new SymfoniePlayListItemFile(filePath);

/*
        SymfonieSong *song = SymfonieSong::findByFilePath(filePath);
        if(song != NULL){

        }else{
            SymfonieSong songToSave;
            songToSave.setFilePath(file->getName());
            songToSave.setFileSize(fileInfo.size());
            songToSave.setLength(-1);
            songToSave.save();
            song = &songToSave;
            qDebug() << "Inserted to db: " << songToSave.getFileDir() << " + " << songToSave.getFileName();

        }
        file->setSong(song);
*/

        playList->addFile(file);
    }

    qDebug() << playList->getSize() << "size";

    /** @todo temporary disabled until this is optimized */
    /*
    qDebug() << "is update playList: " << isUpdatePlayList;
    if(isUpdatePlayList){
        this->setPlayList(playList);
        qDebug() << "Set currentPlayback dir: " << this->getCurrentDirectory();
    }
    */

    emit scanDirCompletedSignal(playList, path);

    return playList;
}

SymfoniePlayList *SymfonieMediaPlayer::getPlayList(){
    return this->playList;
}

void SymfonieMediaPlayer::setPlayList(SymfoniePlayList* playList){
    if(this->playList != NULL){
        delete this->playList;
    }
    this->playList = playList;
    this->setCurrentDirectory(playList->getCurrentDirectory());
    emit playListUpdatedSignal(playList);
}

void SymfonieMediaPlayer::playListUpdatedSlot(SymfoniePlayList* playList){
    this->queuedIndex = playList->getFirstPlaybackIndex();
}

bool SymfonieMediaPlayer::isCanPlay(){
    this->getPlayList()->getFileIndexList();

    if(this->getPlayList()->getFileIndexList()->size() > 0){
        return TRUE;
    }else{
        return FALSE;
    }
}


void SymfonieMediaPlayer::mediaStateChangedSlot(Phonon::State newState, Phonon::State oldState)
{

    if(
            (newState == Phonon::PlayingState ||
             newState == Phonon::BufferingState ||
             newState == Phonon::PausedState)
            ){

        if(this->seekToBuffer > 0){
            qDebug() <<"state: " << newState << "player seek to " << this->seekToBuffer << " this->player->isSeekable(): " <<  this->player->isSeekable();
            this->player->seek(this->seekToBuffer);
            this->seekToBuffer = -1;

        }
    }
    emit this->mediaStateChangedSignal(newState, oldState);
}

void SymfonieMediaPlayer::oneCompletedSlot(){
    qDebug() << "reading completed";
}


void SymfonieMediaPlayer::fetchSongInfo(QString path){
    SymfonieSong *song = SymfonieSong::findByFilePath(path);
    if(song != NULL){
        qDebug() << "in db";
        return;
    }else{
        qDebug() << "not in db";
        delete song;
    }
}



QString SymfonieMediaPlayer::getFilePathAt(int index){
    SymfoniePlayListItem *item = this->getPlayList()->get(index);
    if(item == NULL){
        qWarning() << "Invalid playback index.";
        return QString();
    }

    if(item->getItemType() != SymfoniePlayListItem::File){
        qWarning() << "invalid file type: " << item->getName();
        return QString();
    }

    return item->getName();
}

void SymfonieMediaPlayer::play(qint64 seekTo){
    
    if(this->isCanPlay() != TRUE){
        qWarning() << "Playlist is empty.";
        return;
    }

    if(this->queuedIndex == -1){
        qWarning() << "Empty queue, nothing to play.";
        return;
    }

    QString path = this->getFilePathAt(this->queuedIndex);


    if(path.length() > 0){
        this->seekToBuffer = seekTo;
        this->player->stop();
        this->player->clearQueue();
        this->player->setCurrentSource(Phonon::MediaSource(path));
        this->currentPlaybackIndex = this->queuedIndex;
        this->player->play();
        this->queuedIndex = -1;
    }

}

void SymfonieMediaPlayer::playOrPause(){
    if(this->player->state() == Phonon::PlayingState){
        this->player->pause();
    }else{
        this->player->play();
    }
}

void SymfonieMediaPlayer::pause(){
    if(this->player->state() == Phonon::PlayingState){
        this->player->pause();
    }
}

void SymfonieMediaPlayer::enqueue(int index){
    this->queuedIndex = index;
}

void SymfonieMediaPlayer::playPrevious(){
    this->enqueue(this->getPreviousPlaybackIndex());
    this->play();
}

void SymfonieMediaPlayer::playNext(){
    this->enqueue(this->getNextPlaybackIndex());
    this->play();
}


int SymfonieMediaPlayer::getCurrentPlaybackIndex(){
    return this->currentPlaybackIndex;
}

int SymfonieMediaPlayer::getNextPlaybackIndex(){
    return this->getPlayList()->getNextPlaybackIndex(this->currentPlaybackIndex);
}

int SymfonieMediaPlayer::getPreviousPlaybackIndex(){
    return this->getPlayList()->getPreviousPlaybackIndex(this->currentPlaybackIndex);
}

void SymfonieMediaPlayer::aboutToFinishSlot(){
    this->queuedIndex = this->getNextPlaybackIndex();
    this->player->clearQueue();
    this->player->enqueue(Phonon::MediaSource(this->getFilePathAt(this->queuedIndex)));
}


void SymfonieMediaPlayer::currentSourceChangedSlot ( const Phonon::MediaSource &newSource ) {
    this->currentPlaybackIndex = this->queuedIndex;
}


