#include "swipecounter.h"
#include <QDebug>
#include <QPushButton>
SwipeCounter::SwipeCounter(){

    this->setFixedSize(200,100);
    swipes = set.value("swipes",0).toInt();
    dist = swipes*7.6;
    QVBoxLayout *lay  = new QVBoxLayout;
    conf = new GConfItem("/apps/osso/hildon-desktop/views/current");
    connect(conf,SIGNAL(valueChanged()),this,SLOT(desktopChanged()));
    count = new QLabel(this);
    count->setText("Swipes: " +QString::number(swipes));
    distance = new QLabel(this);

    if(dist < 100){
        distance->setText(QString::number(dist)+ " cm");
    }else{
        QString meters;
        distance->setText(meters.sprintf("%.2f",dist/100)+ " m");
    }
    lay->addWidget(count);
    lay->addWidget(distance);
    lay->setAlignment(Qt::AlignCenter);
    setLayout(lay);
    setAttribute(Qt::WA_TranslucentBackground);
}
void SwipeCounter::showSettingsDialog(){

    QDialog *dialog = new QDialog();
    dialog->setWindowTitle("SwipeCounter");
    QLabel *label = new QLabel(dialog);
    label->setText("SwipeCounter v0.2  Sampo Savola 2010" );
    reset = new QPushButton(dialog);
    reset->setText("Reset Counter");
    connect(reset,SIGNAL(clicked()),this,SLOT(resetCounter()));

    QVBoxLayout *lay = new QVBoxLayout(dialog);
    lay->addWidget(label);
    lay->addWidget(reset);
    lay->setAlignment(Qt::AlignCenter);
    dialog->show();
}

void SwipeCounter::desktopChanged(){
    swipes = swipes+1;
    count->setText("Swipes: " + QString::number(swipes));
    dist = swipes*7.6;
    if(dist < 100){
        distance->setText(QString::number(dist) + " cm");
    }else
    {
        QString meters;
        distance->setText(meters.sprintf("%.2f",dist/100) + " m");
    }
    set.setValue("swipes",swipes);
}
void SwipeCounter::resetCounter(){

    set.setValue("swipes",0);
    swipes = 0;
    count->setText("Swipes: 0");
    distance->setText("0 cm");
    reset->setDisabled(true);
}
