#include "swipecounter.h"
#include <QDebug>

SwipeCounter::SwipeCounter(){
    swipes = set.value("swipes",0).toInt();
    dist = swipes*7.6;
    QVBoxLayout *lay  = new QVBoxLayout;
    conf = new GConfItem("/apps/osso/hildon-desktop/views/current",this);
    connect(conf,SIGNAL(valueChanged()),this,SLOT(desktopChanged()));
    count = new QLabel(this);
    count->setText("Swipes: " +QString::number(swipes));
    distance = new QLabel(this);

    if(dist < 100){
        distance->setText(QString::number(dist)+ " cm");
    }else{
        QString meters;
        distance->setText(meters.sprintf("%.2f",dist/100)+ " m");
    }
    lay->addWidget(count);
    lay->addWidget(distance);
    lay->setAlignment(Qt::AlignCenter);
    this->setLayout(lay);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setFixedSize(200,100);
    show();
}
void SwipeCounter::showSettingsDialog(){
}

void SwipeCounter::desktopChanged(){
    swipes = swipes+1;
    count->setText("Swipes: " + QString::number(swipes));
    dist = swipes*7.6;
    if(dist < 100){
        distance->setText(QString::number(dist) + " cm");
    }else
    {
        QString meters;
        distance->setText(meters.sprintf("%.2f",dist/100) + " m");
    }
    set.setValue("swipes",swipes);
}
