/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of StultitiaSimplex.
 *
 *  StultitiaSimplex is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  StultitiaSimplex is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with StultitiaSimplex.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QFileDialog>

#include "recorddialog.h"
#include "ui_recorddialog.h"
#include "src/constants.h"

#ifndef WIN32
#include "src/io/audio/pulseaudio/pa_utils.h"
#include "src/io/audio/pulseaudio/pulseaudiorecordbackend.h"
#endif

#ifndef Q_WS_MAEMO_5
#include "src/io/audio/portaudio/portaudiorecordbackend.h"
#endif

RecordDialog::RecordDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RecordDialog)
{
    ui->setupUi(this);

    ui->fileEdit->setText(tr("Select File"));

    recording = false;
    ui->recordPushButton->setEnabled(false);;

    ui->vuMeter->setValue(0);

#ifdef WIN32
    backend = new PortAudioRecordBackend();
#endif

#if defined(Q_WS_X11) && !defined(Q_WS_MAEMO_5)
    if(pa_available()){
        backend = new PulseAudioRecordBackend();
    }else{
        backend = new PortAudioRecordBackend();
    }
#endif

#ifdef Q_WS_MAEMO_5
    backend = new PulseAudioRecordBackend();
#endif

    connect(backend, SIGNAL(updateVuMeterSignal(int)), ui->vuMeter, SLOT(setValue(int)), Qt::QueuedConnection);
}

RecordDialog::~RecordDialog()
{
    delete backend;

    delete ui;
}

void RecordDialog::fileDialog(){
    qDebug("Entering RecordDialog::fileDialog()...");

    QString selectedFile = ui->fileEdit->text();
    if(selectedFile == NULL || selectedFile.compare(tr("Select File")) == 0){
        selectedFile = Constants::SOUNDS_DIR;
    }

    QString newFile = QFileDialog::getSaveFileName(
            this,
            tr("Select audio file."),
            selectedFile,
            tr("Audio files (*.wav)"));

    if(newFile != NULL){
        fileSelected(newFile);
    }
}

void RecordDialog::fileSelected(QString fileName){
    if(fileName != NULL && fileName.compare(tr("Select File")) != 0){
        if(! fileName.endsWith(".wav")){
            fileName += ".wav";
        }

        ui->fileEdit->setText(fileName);
        ui->recordPushButton->setEnabled(true);
    }else{
        ui->recordPushButton->setEnabled(false);
    }
}

void RecordDialog::recordPushed(){
    qDebug("Entering RecordDialog::recordPushed()...");

    if(recording){
        recording = false;
        ui->recordPushButton->setText("Record");
        ui->buttonBox->setEnabled(true);

        backend->stopRecording();
    }else{
        recording = true;
        ui->recordPushButton->setText("Stop");
        ui->buttonBox->setEnabled(false);

        backend->startRecording(ui->fileEdit->text());
    }
}

