/* Object identifiers (OIDs) used by strongSwan
 * Copyright (C) 2003-2008 Andreas Steffen, Hochschule fuer Technik Rapperswil
 * 
 * This file has been automatically generated by the script oid.pl
 * Do not edit manually!
 */

#include <sys/types.h>

#ifndef OID_H_
#define OID_H_

typedef struct {
    u_char octet;
    u_int  next;
    u_int  down;
    u_int  level;
    const u_char *name;
} oid_t;

extern const oid_t oid_names[];

#define OID_UNKNOWN							-1
#define OID_NAME_DISTINGUISHER				6
#define OID_PILOT_USERID					16
#define OID_PILOT_DOMAIN_COMPONENT			17
#define OID_COMMON_NAME						20
#define OID_SURNAME							21
#define OID_SERIAL_NUMBER					22
#define OID_COUNTRY							23
#define OID_LOCALITY						24
#define OID_STATE_OR_PROVINCE				25
#define OID_ORGANIZATION					26
#define OID_ORGANIZATION_UNIT				27
#define OID_TITLE							28
#define OID_DESCRIPTION						29
#define OID_USER_CERTIFICATE				30
#define OID_NAME							31
#define OID_GIVEN_NAME						32
#define OID_INITIALS						33
#define OID_UNIQUE_IDENTIFIER				34
#define OID_ROLE							35
#define OID_SUBJECT_KEY_ID					38
#define OID_KEY_USAGE						39
#define OID_SUBJECT_ALT_NAME				41
#define OID_BASIC_CONSTRAINTS				43
#define OID_CRL_NUMBER						44
#define OID_CRL_REASON_CODE					45
#define OID_DELTA_CRL_INDICATOR				48
#define OID_NAME_CONSTRAINTS				51
#define OID_CRL_DISTRIBUTION_POINTS			52
#define OID_CERTIFICATE_POLICIES			53
#define OID_ANY_POLICY						54
#define OID_POLICY_MAPPINGS					55
#define OID_AUTHORITY_KEY_ID				56
#define OID_POLICY_CONSTRAINTS				57
#define OID_EXTENDED_KEY_USAGE				58
#define OID_FRESHEST_CRL					60
#define OID_INHIBIT_ANY_POLICY				61
#define OID_TARGET_INFORMATION				62
#define OID_NO_REV_AVAIL					63
#define OID_CAMELLIA128_CBC					74
#define OID_CAMELLIA192_CBC					75
#define OID_CAMELLIA256_CBC					76
#define OID_RSA_ENCRYPTION					89
#define OID_MD2_WITH_RSA					90
#define OID_MD5_WITH_RSA					91
#define OID_SHA1_WITH_RSA					92
#define OID_RSAES_OAEP						93
#define OID_SHA256_WITH_RSA					95
#define OID_SHA384_WITH_RSA					96
#define OID_SHA512_WITH_RSA					97
#define OID_SHA224_WITH_RSA					98
#define OID_PBE_MD5_DES_CBC					100
#define OID_PBE_SHA1_DES_CBC				101
#define OID_PBKDF2							102
#define OID_PBES2							103
#define OID_PKCS7_DATA						105
#define OID_PKCS7_SIGNED_DATA				106
#define OID_PKCS7_ENVELOPED_DATA			107
#define OID_PKCS7_SIGNED_ENVELOPED_DATA		108
#define OID_PKCS7_DIGESTED_DATA				109
#define OID_PKCS7_ENCRYPTED_DATA			110
#define OID_EMAIL_ADDRESS					112
#define OID_UNSTRUCTURED_NAME				113
#define OID_PKCS9_CONTENT_TYPE				114
#define OID_PKCS9_MESSAGE_DIGEST			115
#define OID_PKCS9_SIGNING_TIME				116
#define OID_CHALLENGE_PASSWORD				118
#define OID_UNSTRUCTURED_ADDRESS			119
#define OID_EXTENSION_REQUEST				120
#define OID_MD2								123
#define OID_MD5								124
#define OID_3DES_EDE_CBC					126
#define OID_EC_PUBLICKEY					130
#define OID_C2PNB163V1						133
#define OID_C2PNB163V2						134
#define OID_C2PNB163V3						135
#define OID_C2PNB176W1						136
#define OID_C2PNB191V1						137
#define OID_C2PNB191V2						138
#define OID_C2PNB191V3						139
#define OID_C2PNB191V4						140
#define OID_C2PNB191V5						141
#define OID_C2PNB208W1						142
#define OID_C2PNB239V1						143
#define OID_C2PNB239V2						144
#define OID_C2PNB239V3						145
#define OID_C2PNB239V4						146
#define OID_C2PNB239V5						147
#define OID_C2PNB272W1						148
#define OID_C2PNB304W1						149
#define OID_C2PNB359V1						150
#define OID_C2PNB368W1						151
#define OID_C2PNB431R1						152
#define OID_PRIME192V1						154
#define OID_PRIME192V2						155
#define OID_PRIME192V3						156
#define OID_PRIME239V1						157
#define OID_PRIME239V2						158
#define OID_PRIME239V3						159
#define OID_PRIME256V1						160
#define OID_ECDSA_WITH_SHA1					162
#define OID_ECDSA_WITH_SHA224				164
#define OID_ECDSA_WITH_SHA256				165
#define OID_ECDSA_WITH_SHA384				166
#define OID_ECDSA_WITH_SHA512				167
#define OID_USER_PRINCIPAL_NAME				182
#define OID_STRONGSWAN						185
#define OID_TCGID							192
#define OID_AUTHORITY_INFO_ACCESS			197
#define OID_IP_ADDR_BLOCKS					199
#define OID_POLICY_QUALIFIER_CPS			201
#define OID_POLICY_QUALIFIER_UNOTICE		202
#define OID_SERVER_AUTH						204
#define OID_CLIENT_AUTH						205
#define OID_OCSP_SIGNING					212
#define OID_XMPP_ADDR						214
#define OID_AUTHENTICATION_INFO				216
#define OID_ACCESS_IDENTITY					217
#define OID_CHARGING_IDENTITY				218
#define OID_GROUP							219
#define OID_OCSP							222
#define OID_BASIC							223
#define OID_NONCE							224
#define OID_CRL								225
#define OID_RESPONSE						226
#define OID_NO_CHECK						227
#define OID_ARCHIVE_CUTOFF					228
#define OID_SERVICE_LOCATOR					229
#define OID_CA_ISSUERS						230
#define OID_DES_CBC							236
#define OID_SHA1							237
#define OID_SHA1_WITH_RSA_OIW				238
#define OID_ECGDSA_PUBKEY					257
#define OID_ECGDSA_SIG_WITH_RIPEMD160		260
#define OID_ECGDSA_SIG_WITH_SHA1			261
#define OID_ECGDSA_SIG_WITH_SHA224			262
#define OID_ECGDSA_SIG_WITH_SHA256			263
#define OID_ECGDSA_SIG_WITH_SHA384			264
#define OID_ECGDSA_SIG_WITH_SHA512			265
#define OID_SECT163K1						288
#define OID_SECT163R1						289
#define OID_SECT239K1						290
#define OID_SECT113R1						291
#define OID_SECT113R2						292
#define OID_SECT112R1						293
#define OID_SECT112R2						294
#define OID_SECT160R1						295
#define OID_SECT160K1						296
#define OID_SECT256K1						297
#define OID_SECT163R2						298
#define OID_SECT283K1						299
#define OID_SECT283R1						300
#define OID_SECT131R1						301
#define OID_SECT131R2						302
#define OID_SECT193R1						303
#define OID_SECT193R2						304
#define OID_SECT233K1						305
#define OID_SECT233R1						306
#define OID_SECT128R1						307
#define OID_SECT128R2						308
#define OID_SECT160R2						309
#define OID_SECT192K1						310
#define OID_SECT224K1						311
#define OID_SECT224R1						312
#define OID_SECT384R1						313
#define OID_SECT521R1						314
#define OID_SECT409K1						315
#define OID_SECT409R1						316
#define OID_SECT571K1						317
#define OID_SECT571R1						318
#define OID_AES128_CBC						327
#define OID_AES128_GCM						328
#define OID_AES128_CCM						329
#define OID_AES192_CBC						330
#define OID_AES192_GCM						331
#define OID_AES192_CCM						332
#define OID_AES256_CBC						333
#define OID_AES256_GCM						334
#define OID_AES256_CCM						335
#define OID_SHA256							337
#define OID_SHA384							338
#define OID_SHA512							339
#define OID_SHA224							340
#define OID_NS_REVOCATION_URL				346
#define OID_NS_CA_REVOCATION_URL			347
#define OID_NS_CA_POLICY_URL				348
#define OID_NS_COMMENT						349
#define OID_EMPLOYEE_NUMBER					352
#define OID_PKI_MESSAGE_TYPE				358
#define OID_PKI_STATUS						359
#define OID_PKI_FAIL_INFO					360
#define OID_PKI_SENDER_NONCE				361
#define OID_PKI_RECIPIENT_NONCE				362
#define OID_PKI_TRANS_ID					363
#define OID_TPM_MANUFACTURER				369
#define OID_TPM_MODEL						370
#define OID_TPM_VERSION						371
#define OID_TPM_ID_LABEL					372

#define OID_MAX								373

#endif /* OID_H_ */
