#!/usr/bin/env python
#coding=utf-8

import osso
import sys
import gtk
import hildon
from key import key

class vKeyboard():		
	# Initialize keys
	aKey = None
	bKey = None
	cKey = None
	dKey = None
	eKey = None
	fKey = None
	gKey = None
	hKey = None
	iKey = None
	jKey = None
	kKey = None
	lKey = None
	mKey = None
	nKey = None
	oKey = None
	pKey = None
	qKey = None
	rKey = None
	sKey = None
	tKey = None
	uKey = None
	vKey = None
	wKey = None
	xKey = None
	yKey = None
	zKey = None
	spaceKey = None
	spaceKey2 = None
	capsLockButton = None	
	widthSwitchButton = None
	widthSwitchButton2 = None
	
	vQWERTYBox = gtk.VBox()		
	vQWERTYBox.padding = 0
	vQWERTYBox.set_spacing(0)

	vQWERTYBox.fill = True
	vQWERTYBox.expand = True
	vNumpadBox = gtk.VBox()
	vNumpadBox.padding = 0	
	vNumpadBox.set_spacing(0)
	
	def __init__(self, textArea=None):		
		# Create object instances of all keys
		self.aKey = key("a", textArea)
		self.bKey = key("b", textArea)
		self.cKey = key("c", textArea)
		self.dKey = key("d", textArea)
		self.eKey = key("e", textArea)
		self.fKey = key("f", textArea)
		self.gKey = key("g", textArea)
		self.hKey = key("h", textArea)
		self.iKey = key("i", textArea)
		self.jKey = key("j", textArea)
		self.kKey = key("k", textArea)
		self.lKey = key("l", textArea)
		self.mKey = key("m", textArea)
		self.nKey = key("n", textArea)
		self.oKey = key("o", textArea)
		self.pKey = key("p", textArea)
		self.qKey = key("q", textArea)
		self.rKey = key("r", textArea)
		self.sKey = key("s", textArea)
		self.tKey = key("t", textArea)
		self.uKey = key("u", textArea)
		self.vKey = key("v", textArea)
		self.wKey = key("w", textArea)
		self.xKey = key("x", textArea)
		self.yKey = key("y", textArea)
		self.zKey = key("z", textArea)
		
		self.zeroKey = key("0", textArea)
		self.oneKey = key("1", textArea)
		self.twoKey = key("2", textArea)
		self.threeKey = key("3", textArea)
		self.fourKey = key("4", textArea)
		self.fiveKey = key("5", textArea)
		self.sixKey = key("6", textArea)
		self.sevenKey = key("7", textArea)
		self.eightKey = key("8", textArea)
		self.nineKey = key("9", textArea)
		
		self.commaKey = key(",", textArea)		
		self.commaKey2 = key(",", textArea)		
		self.dotKey = key(".", textArea)		
		self.dotKey2 = key(".", textArea)		
		self.apostropheKey = key("'", textArea)
		self.apostropheKey2 = key("'", textArea)
		self.exclamationKey = key("!", textArea)
		self.exclamationKey2 = key("!", textArea)
		self.andKey = key("&", textArea)
		self.andKey2 = key("&", textArea)
		self.questionKey = key("?", textArea)
		self.questionKey2 = key("?", textArea)
		
		self.plusKey = key("+", textArea)		
		self.minusKey = key("-", textArea)
		self.asteriskKey = key("*", textArea)
		self.divideKey = key("/", textArea)				
		self.divideKey2 = key("/", textArea)				
		self.dollarKey = key("$", textArea)
		self.dollarKey2 = key("$", textArea)
		self.colonKey = key(":", textArea)
		self.colonKey2 = key(":", textArea)
		
		self.atKey = key("@", textArea)
		self.atKey2 = key("@", textArea)
		self.openBracketKey = key("(", textArea)
		self.closeBracketKey = key(")", textArea)
		self.equalKey = key("=", textArea)		
		self.semicolonKey = key(";", textArea)		
		self.semicolonKey2 = key(";", textArea)		
		self.sharpKey = key("#", textArea)		
		
		self.hatKey = key("^", textArea)		
		self.underlineKey = key("_", textArea)		
		self.quoteKey = key("\"", textArea)		
		self.quoteKey2 = key("\"", textArea)		
		self.greaterKey = key(">", textArea)
		self.smallerKey = key("<", textArea)
		
		self.spaceKey = key(" ", textArea)		
		self.spaceKey2 = key(" ", textArea)		
		
		self.backslashKey = key("\\", textArea)
		self.pipeKey = key("|", textArea)
		self.opensquarebracketKey = key("[", textArea)
		self.closesquarebracketKey = key("]", textArea)	
		self.snakeKey = key("~", textArea)		
		self.enterKey = key("\n", textArea)
		self.enterKey2 = key("\n", textArea)
		
		self.capsLockButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_THUMB_HEIGHT)
		self.widthSwitchButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_THUMB_HEIGHT)
		self.widthSwitchButton2 = hildon.GtkToggleButton(gtk.HILDON_SIZE_THUMB_HEIGHT)
		
		self.createCapsLockButton()		
		self.createBackSpaceButton(textArea)
		self.createWidthSwitchButton()
		self.drawKeyboard()
		self.drawNumpad()
	
	def createCapsLockButton(self):
		# Create the Caps Lock button for the QWERTY keyboard
		self.capsLockButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_THUMB_HEIGHT)
		self.capsLockButton.set_label("△")
		self.capsLockButton.set_active(False)
		self.capsLockButton.connect("clicked", self.swapKeysCase)

	def createWidthSwitchButton(self):
		# Create the Full/Half Width Toggle Switch buttons (one for the QWERTY keyboard, another one for the symbolic/numeric keyboard)
		self.widthSwitchButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_THUMB_HEIGHT)
		self.widthSwitchButton.set_label("半")		
		self.widthSwitchButton.set_active(False);
		self.widthSwitchButton.connect("clicked", self.swapKeysWidth)
		
		self.widthSwitchButton2 = hildon.GtkToggleButton(gtk.HILDON_SIZE_THUMB_HEIGHT)
		self.widthSwitchButton2.set_label("半")		
		self.widthSwitchButton2.set_active(False);
		self.widthSwitchButton2.connect("clicked", self.swapKeysWidth2)	
		
	def createBackSpaceButton(self, textArea):
		# Create the BackSpace button
		self.backSpaceButton = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.backSpaceButton.set_label("←")
		self.backSpaceButton.connect("clicked", self.backSpace, textArea)

	def backSpace(self, backSpaceButton, textArea):
		# The actual method for handling the backspace operation
		buffer = textArea.get_buffer()
		selectedText = buffer.get_selection_bounds()		
		if selectedText==():	# If there is no selected text, issue a Backspace keystroke
			offset = buffer.get_iter_at_mark(buffer.get_insert())
			buffer.backspace(offset,True,True)
		else:	# If there is selected text, delete the selected text
			buffer.delete_selection(True,True)	
			
	def swapKeysCase(self, capsLockButton):
		# Swap the letter case of the keys, including the label of the keys and the character being outputted by the key
		if self.aKey == None:
			self.__init__()
			
		CapsLockActive = self.capsLockButton.get_active()
		FullWidthActive = self.widthSwitchButton.get_active()
			
		self.aKey.swapCase(CapsLockActive,FullWidthActive)
		self.bKey.swapCase(CapsLockActive,FullWidthActive)
		self.cKey.swapCase(CapsLockActive,FullWidthActive)
		self.dKey.swapCase(CapsLockActive,FullWidthActive)
		self.eKey.swapCase(CapsLockActive,FullWidthActive)
		self.fKey.swapCase(CapsLockActive,FullWidthActive)
		self.gKey.swapCase(CapsLockActive,FullWidthActive)
		self.hKey.swapCase(CapsLockActive,FullWidthActive)
		self.iKey.swapCase(CapsLockActive,FullWidthActive)
		self.jKey.swapCase(CapsLockActive,FullWidthActive)
		self.kKey.swapCase(CapsLockActive,FullWidthActive)
		self.lKey.swapCase(CapsLockActive,FullWidthActive)
		self.mKey.swapCase(CapsLockActive,FullWidthActive)
		self.nKey.swapCase(CapsLockActive,FullWidthActive)
		self.oKey.swapCase(CapsLockActive,FullWidthActive)
		self.pKey.swapCase(CapsLockActive,FullWidthActive)
		self.qKey.swapCase(CapsLockActive,FullWidthActive)
		self.rKey.swapCase(CapsLockActive,FullWidthActive)
		self.sKey.swapCase(CapsLockActive,FullWidthActive)
		self.tKey.swapCase(CapsLockActive,FullWidthActive)
		self.uKey.swapCase(CapsLockActive,FullWidthActive)
		self.vKey.swapCase(CapsLockActive,FullWidthActive)
		self.wKey.swapCase(CapsLockActive,FullWidthActive)
		self.xKey.swapCase(CapsLockActive,FullWidthActive)
		self.yKey.swapCase(CapsLockActive,FullWidthActive)
		self.zKey.swapCase(CapsLockActive,FullWidthActive)
		self.exclamationKey.swapCase(CapsLockActive,FullWidthActive)
		self.atKey.swapCase(CapsLockActive,FullWidthActive)
		self.dollarKey.swapCase(CapsLockActive,FullWidthActive)
		self.andKey.swapCase(CapsLockActive,FullWidthActive)
		self.apostropheKey.swapCase(CapsLockActive,FullWidthActive)
		self.quoteKey.swapCase(CapsLockActive,FullWidthActive)
		self.colonKey.swapCase(CapsLockActive,FullWidthActive)
		self.semicolonKey.swapCase(CapsLockActive,FullWidthActive)
		self.divideKey.swapCase(CapsLockActive,FullWidthActive)
		self.questionKey.swapCase(CapsLockActive,FullWidthActive)
		self.commaKey.swapCase(CapsLockActive,FullWidthActive)
		self.dotKey.swapCase(CapsLockActive,FullWidthActive)
		
	def swapKeysWidth(self,widthSwitchButton):
		# Swap the width of the keys (full width / half width) in the QWERTY keyboard, including the label of the keys and the character being outputted by the key
		if self.aKey == None:
			self.__init__()
		if self.widthSwitchButton.get_label() == "半":
			self.widthSwitchButton.set_label("全")
			self.widthSwitchButton.set_active(True);
		else:	# F2H
			self.widthSwitchButton.set_label("半")
			self.widthSwitchButton.set_active(False);

		CapsLockActive = self.capsLockButton.get_active()
		FullWidthActive = self.widthSwitchButton.get_active()
		
		self.aKey.swapWidth(CapsLockActive, FullWidthActive)
		self.bKey.swapWidth(CapsLockActive, FullWidthActive)
		self.cKey.swapWidth(CapsLockActive, FullWidthActive)
		self.dKey.swapWidth(CapsLockActive, FullWidthActive)
		self.eKey.swapWidth(CapsLockActive, FullWidthActive)
		self.fKey.swapWidth(CapsLockActive, FullWidthActive)
		self.gKey.swapWidth(CapsLockActive, FullWidthActive)
		self.hKey.swapWidth(CapsLockActive, FullWidthActive)
		self.iKey.swapWidth(CapsLockActive, FullWidthActive)
		self.jKey.swapWidth(CapsLockActive, FullWidthActive)
		self.kKey.swapWidth(CapsLockActive, FullWidthActive)
		self.lKey.swapWidth(CapsLockActive, FullWidthActive)
		self.mKey.swapWidth(CapsLockActive, FullWidthActive)
		self.nKey.swapWidth(CapsLockActive, FullWidthActive)
		self.oKey.swapWidth(CapsLockActive, FullWidthActive)
		self.pKey.swapWidth(CapsLockActive, FullWidthActive)
		self.qKey.swapWidth(CapsLockActive, FullWidthActive)
		self.rKey.swapWidth(CapsLockActive, FullWidthActive)
		self.sKey.swapWidth(CapsLockActive, FullWidthActive)
		self.tKey.swapWidth(CapsLockActive, FullWidthActive)
		self.uKey.swapWidth(CapsLockActive, FullWidthActive)
		self.vKey.swapWidth(CapsLockActive, FullWidthActive)
		self.wKey.swapWidth(CapsLockActive, FullWidthActive)
		self.xKey.swapWidth(CapsLockActive, FullWidthActive)
		self.yKey.swapWidth(CapsLockActive, FullWidthActive)
		self.zKey.swapWidth(CapsLockActive, FullWidthActive)
		self.exclamationKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.atKey.swapWidth(CapsLockActive, FullWidthActive)			
		self.dollarKey.swapWidth(CapsLockActive, FullWidthActive)
		self.andKey.swapWidth(CapsLockActive, FullWidthActive)				
		self.apostropheKey.swapWidth(CapsLockActive, FullWidthActive)
		self.quoteKey.swapWidth(CapsLockActive, FullWidthActive)
		self.colonKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.semicolonKey.swapWidth(CapsLockActive, FullWidthActive)				
		self.divideKey.swapWidth(CapsLockActive, FullWidthActive)	
		self.questionKey.swapWidth(CapsLockActive, FullWidthActive)	
		self.commaKey.swapWidth(CapsLockActive, FullWidthActive)
		self.dotKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.spaceKey.swapWidth(CapsLockActive, FullWidthActive)				
		self.enterKey.swapWidth(CapsLockActive, FullWidthActive)
		
	def swapKeysWidth2(self, widthSwitchButton):
		# Swap the width of the keys (full width / half width) in the symbolic / numeric keyboard, including the label of the keys and the character being outputted by the key
		if self.aKey == None:
			self.__init__()
		if self.widthSwitchButton2.get_label() == "半":
			self.widthSwitchButton2.set_label("全")
			self.widthSwitchButton2.set_active(True);
		else:	# F2H
			self.widthSwitchButton2.set_label("半")
			self.widthSwitchButton2.set_active(False);
			
		CapsLockActive = self.capsLockButton.get_active()
		FullWidthActive = self.widthSwitchButton2.get_active()
		
		self.oneKey.swapWidth(CapsLockActive, FullWidthActive)
		self.twoKey.swapWidth(CapsLockActive, FullWidthActive)
		self.threeKey.swapWidth(CapsLockActive, FullWidthActive)
		self.backslashKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.opensquarebracketKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.closesquarebracketKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.exclamationKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.andKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.questionKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.dollarKey2.swapWidth(CapsLockActive, FullWidthActive)		
				
		self.fourKey.swapWidth(CapsLockActive, FullWidthActive)
		self.fiveKey.swapWidth(CapsLockActive, FullWidthActive)
		self.sixKey.swapWidth(CapsLockActive, FullWidthActive)
		self.atKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.plusKey.swapWidth(CapsLockActive, FullWidthActive)
		self.minusKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.asteriskKey.swapWidth(CapsLockActive, FullWidthActive)
		self.divideKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.equalKey.swapWidth(CapsLockActive, FullWidthActive)
		self.colonKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.semicolonKey2.swapWidth(CapsLockActive, FullWidthActive)
			
		self.sevenKey.swapWidth(CapsLockActive, FullWidthActive)
		self.eightKey.swapWidth(CapsLockActive, FullWidthActive)
		self.nineKey.swapWidth(CapsLockActive, FullWidthActive)
		self.quoteKey2.swapWidth(CapsLockActive, FullWidthActive)				
		self.underlineKey.swapWidth(CapsLockActive, FullWidthActive)
		self.openBracketKey.swapWidth(CapsLockActive, FullWidthActive)
		self.closeBracketKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.snakeKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.sharpKey.swapWidth(CapsLockActive, FullWidthActive)
		self.pipeKey.swapWidth(CapsLockActive, FullWidthActive)		
				
		self.zeroKey.swapWidth(CapsLockActive, FullWidthActive)
		self.spaceKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.hatKey.swapWidth(CapsLockActive, FullWidthActive)				
		self.smallerKey.swapWidth(CapsLockActive, FullWidthActive)		
		self.greaterKey.swapWidth(CapsLockActive, FullWidthActive)
		self.apostropheKey2.swapWidth(CapsLockActive, FullWidthActive)		
		self.commaKey2.swapWidth(CapsLockActive, FullWidthActive)
		self.dotKey2.swapWidth(CapsLockActive, FullWidthActive)		
		self.enterKey2.swapWidth(CapsLockActive, FullWidthActive)
	
	def drawNumpad(self):
		# Draw the symbolic / numeric keyboard
		
		npRow1HBox = gtk.HBox()
		npRow1HBox.spacing = 0
		npRow1HBox.padding = 0

		npRow2HBox = gtk.HBox()
		npRow2HBox.spacing = 0
		npRow2HBox.padding = 0

		npRow3HBox = gtk.HBox()
		npRow3HBox.spacing = 0
		npRow3HBox.padding = 0

		npRow4HBox = gtk.HBox()
		npRow4HBox.spacing = 0
		npRow4HBox.padding = 0
		
		npRow1HBox.pack_start(self.oneKey.getButton(),True,True,0)
		npRow1HBox.pack_start(self.twoKey.getButton(),True,True,0)
		npRow1HBox.pack_start(self.threeKey.getButton(),True,True,0)
		npRow1HBox.pack_start(self.backslashKey.getButton(),True,True,0)		
		npRow1HBox.pack_start(self.opensquarebracketKey.getButton(),True,True,0)		
		npRow1HBox.pack_start(self.closesquarebracketKey.getButton(),True,True,0)		
		npRow1HBox.pack_start(self.exclamationKey2.getButton(),True,True,0)
		npRow1HBox.pack_start(self.andKey2.getButton(),True,True,0)
		npRow1HBox.pack_start(self.questionKey2.getButton(),True,True,0)
		npRow1HBox.pack_start(self.dollarKey2.getButton(),True,True,0)		
		
		npRow2HBox.pack_start(self.fourKey.getButton(),True,True,0)
		npRow2HBox.pack_start(self.fiveKey.getButton(),True,True,0)
		npRow2HBox.pack_start(self.sixKey.getButton(),True,True,0)
		# npRow2HBox.pack_start(self.atKey2.getButton(),True,True,0)
		npRow2HBox.pack_start(self.plusKey.getButton(),True,True,0)
		npRow2HBox.pack_start(self.minusKey.getButton(),True,True,0)		
		npRow2HBox.pack_start(self.asteriskKey.getButton(),True,True,0)
		npRow2HBox.pack_start(self.divideKey2.getButton(),True,True,0)
		npRow2HBox.pack_start(self.equalKey.getButton(),True,True,0)
		npRow2HBox.pack_start(self.colonKey2.getButton(),True,True,0)
		npRow2HBox.pack_start(self.semicolonKey2.getButton(),True,True,0)
	
		npRow3HBox.pack_start(self.sevenKey.getButton(),True,True,0)
		npRow3HBox.pack_start(self.eightKey.getButton(),True,True,0)
		npRow3HBox.pack_start(self.nineKey.getButton(),True,True,0)
		npRow3HBox.pack_start(self.quoteKey2.getButton(),True,True,0)				
		npRow3HBox.pack_start(self.underlineKey.getButton(),True,True,0)
		npRow3HBox.pack_start(self.openBracketKey.getButton(),True,True,0)
		npRow3HBox.pack_start(self.closeBracketKey.getButton(),True,True,0)		
		npRow3HBox.pack_start(self.snakeKey.getButton(),True,True,0)		
		npRow3HBox.pack_start(self.sharpKey.getButton(),True,True,0)
		npRow3HBox.pack_start(self.pipeKey.getButton(),True,True,0)		
		
		npRow4HBox.pack_start(self.zeroKey.getButton(),True,True,0)
		npRow4HBox.pack_start(self.spaceKey2.getButton(),True,True,0)
		npRow4HBox.pack_start(self.hatKey.getButton(),True,True,0)				
		npRow4HBox.pack_start(self.smallerKey.getButton(),True,True,0)		
		npRow4HBox.pack_start(self.greaterKey.getButton(),True,True,0)
		npRow4HBox.pack_start(self.apostropheKey2.getButton(),True,True,0)		
		npRow4HBox.pack_start(self.commaKey2.getButton(),True,True,0)
		npRow4HBox.pack_start(self.dotKey2.getButton(),True,True,0)
		npRow4HBox.pack_start(self.enterKey2.getButton(),True,True,0)
		npRow4HBox.pack_start(self.widthSwitchButton2,True,True,0)
		
		self.vNumpadBox = gtk.VBox()

		self.vNumpadBox.pack_start(npRow1HBox,True,True)
		self.vNumpadBox.pack_start(npRow2HBox,True,True)
		self.vNumpadBox.pack_start(npRow3HBox,True,True)
		self.vNumpadBox.pack_start(npRow4HBox,True,True)
		
	def drawKeyboard(self):
		# Draw the QWERTY keyboard
		qwertyRow1HBox = gtk.HBox()
		qwertyRow2HBox = gtk.HBox()
		qwertyRow3HBox = gtk.HBox()		
		qwertyRow4HBox = gtk.HBox()

		qwertyRow1HBox.pack_start(self.qKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.wKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.eKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.rKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.tKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.yKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.uKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.iKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.oKey.getButton(),True,True,0)
		qwertyRow1HBox.pack_start(self.pKey.getButton(),True,True,0)		
#		qwertyRow1HBox.pack_start(self.backSpaceButton,True,True,0)		

		qwertyRow2HBox.pack_start(self.divideKey.getButton(),True,True,0)	
		qwertyRow2HBox.pack_start(self.aKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.sKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.dKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.fKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.gKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.hKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.jKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.kKey.getButton(),True,True,0)
		qwertyRow2HBox.pack_start(self.lKey.getButton(),True,True,0)		
		qwertyRow2HBox.pack_start(self.enterKey.getButton(),False,True,0)
		
		qwertyRow3HBox.pack_start(self.exclamationKey.getButton(),True,True,0)					
		qwertyRow3HBox.pack_start(self.zKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.xKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.cKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.vKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.bKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.nKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.mKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.commaKey.getButton(),True,True,0)
		qwertyRow3HBox.pack_start(self.dotKey.getButton(),True,True,0)	
		
		qwertyRow4HBox.pack_start(self.capsLockButton,True,True,0)					
		qwertyRow4HBox.pack_start(self.atKey.getButton(),True,True,0)	
#		qwertyRow4HBox.pack_start(self.dollarKey.getButton(),False,True,0)
		qwertyRow4HBox.pack_start(self.andKey.getButton(),True,True,0)				
		qwertyRow4HBox.pack_start(self.apostropheKey.getButton(),True,True,0)		
		qwertyRow4HBox.pack_start(self.quoteKey.getButton(),True,True,0)			
		qwertyRow4HBox.pack_start(self.spaceKey.getButton(),True,True,0)
		qwertyRow4HBox.pack_start(self.colonKey.getButton(),True,True,0)
		qwertyRow4HBox.pack_start(self.semicolonKey.getButton(),True,True,0)				
		qwertyRow4HBox.pack_start(self.questionKey.getButton(),True,True,0)	
		qwertyRow4HBox.pack_start(self.widthSwitchButton,True,True,0)
		
		self.vQWERTYBox = gtk.VBox()
		self.vQWERTYBox.pack_start(qwertyRow1HBox,True,True)
		self.vQWERTYBox.pack_start(qwertyRow2HBox,True,True)
		self.vQWERTYBox.pack_start(qwertyRow3HBox,True,True)
		self.vQWERTYBox.pack_start(qwertyRow4HBox,True,True)
		
	def getKeyboard(self):
		# Return the QWERTY keyboard
		return self.vQWERTYBox
	
	def getNumpad(self):
		# return the symbolic / numeric keyboard
		return self.vNumpadBox