#!/usr/bin/env python
#coding=utf-8

import osso
import sys
import gtk
import hildon
import unicodedata
import pango
import gobject

class key():
		
	def __init__(self, character="", textArea=None):		
		self.character = character
		self.button = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.keyDown = False
		self.keyUp = False
		# Special handling for label display of the Space and Enter keys
		
		if character==" ":
			self.button.set_label("└─┘")
		elif character=="\n":
			self.button.set_label("◢─┘")
		else:
			self.button.set_label(character)
			
		self.textArea = textArea		

		# self.handler_id = self.button.connect("clicked", self.buttonClicked, self.character, self.textArea)		
		self.handler_id = self.button.connect("button-press-event", self.buttonPressed, self.character, self.textArea)		
		self.release_handler_id = self.button.connect("button-release-event", self.buttonReleased)
		self.button.set_events(gtk.gdk.EXPOSURE_MASK |                        
                        gtk.gdk.BUTTON_PRESS_MASK |
                        gtk.gdk.BUTTON_RELEASE_MASK )

	def replacePunc(self):		
		# Replace some symbols to other common ones upon Caps Lock
				
		if self.character == ",":
			self.character = "、"
						
		elif self.character == "、":
			self.character = ","
						
		elif self.character == ".":
			self.character = "。"
			
		elif self.character == "。":
			self.character = "."
			
			
		elif self.character == "\'":
			self.character = "「"
			
		elif self.character == "「":
			self.character = "\'"			
						
		elif self.character == "\"":
			self.character = "」"
			
		elif self.character == "」":
			self.character = "\""						
			
		elif self.character == "!":
			self.character = "#"
			
		elif self.character == "#":
			self.character = "!"
					
		elif self.character == "@":
			self.character = "%"
						
		elif self.character == "%":
			self.character = "@"
			
		elif self.character == "$":
			self.character = "^"
						
		elif self.character == "^":
			self.character = "$"			
			
		elif self.character == "&":
			self.character = "*"
						
		elif self.character == "*":
			self.character = "&"
			
		elif self.character == ":":
			self.character = "("
						
		elif self.character == "(":
			self.character = ":"
			
		elif self.character == ";":
			self.character = ")"
			
		elif self.character == ")":
			self.character = ";"						
			
	def swapCase(self,CapsLockActive,FullWidthActive):
		# Swap the letter case of the key
		self.button.disconnect(self.handler_id)
		self.button.disconnect(self.release_handler_id)
		# print "Caps Lock: " + str(CapsLockActive) + ", Full Width: " + str(FullWidthActive) + ", Character: " + self.character
		
		# unicodedata.east_asian_width(unicode(self.character,"utf-8"))!="Na"
		if CapsLockActive==False and FullWidthActive==True and unicodedata.east_asian_width(unicode(self.character,"utf-8"))!="Na":
		# if full-width button is active and caps lock button becomes inactive
			self.character = self.toggleWidth(self.character, not FullWidthActive)
			self.replacePunc()
			self.character = self.character.swapcase()					
			self.character = self.toggleWidth(self.character, FullWidthActive)
		elif CapsLockActive==True and FullWidthActive==True and unicodedata.east_asian_width(unicode(self.character,"utf-8"))!="Na":
		# if full-width button is active and caps lock button becomes active
			self.character = self.toggleWidth(self.character,not FullWidthActive)
			self.replacePunc()
			self.character = self.character.swapcase()					
			self.character = self.toggleWidth(self.character, FullWidthActive)
		elif CapsLockActive==False and FullWidthActive==False:
		# if full-width button is inactive and caps lock button becomes inactive
			self.replacePunc()
			self.character = self.character.swapcase()							
		else:	# if full-width button is inactive and caps lock button becomes active
			self.replacePunc()
			self.character = self.character.swapcase()
		self.button.set_label(self.character)		
		# self.handler_id = self.button.connect("clicked", self.insertText, self.character, self.textArea)		
		self.handler_id = self.button.connect("button-press-event", self.buttonPressed, self.character, self.textArea)		
		self.release_handler_id = self.button.connect("button-release-event", self.buttonReleased)
		self.button.set_events(gtk.gdk.EXPOSURE_MASK |                        
                        gtk.gdk.BUTTON_PRESS_MASK |
                        gtk.gdk.BUTTON_RELEASE_MASK )
							
	def toggleWidth(self,text,FullWidthActive):
		# Swap the width (full width / half width) of the given text
		halfwidth_chars = u'0123456789!@#$%^&*()ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-=[]\;\',./_+{}|:"<>?~`¥£ '
		fullwidth_chars = u'０１２３４５６７８９！＠＃＄％︿＆＊（）ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ－＝〔〕＼；’，．／＿＋｛｝｜：”＜＞？～‘￥￡　'
		h2f = dict(zip(map(ord,halfwidth_chars),map(ord,fullwidth_chars)))
		f2h = dict(zip(map(ord,fullwidth_chars),map(ord,halfwidth_chars)))
		if FullWidthActive==True:	# if full-width...			
			result = str(unicode(text,"utf-8").translate(h2f))
			# print "H2F"
		else:
			result = str(unicode(text,"utf-8").translate(f2h))						
			# print "F2H"
		
		return result
	
	def swapWidth(self,CapsLockActive,FullWidthActive):
		# Swap the width (full width / half width) of the key		
		self.button.disconnect(self.handler_id)						
		self.button.disconnect(self.release_handler_id)
		# print "Caps Lock: " + str(CapsLockActive) + ", Full Width: " + str(FullWidthActive) + ", Character: " + self.character
		
		if self.character == "\n":
			if self.button.get_label()=="◢┘":	# since \n is never a full-width character, we need to handle this separately
				self.button.set_label("◢─┘")
			else:
				self.button.set_label("◢┘")
		else:		
			self.character = self.toggleWidth(self.character,FullWidthActive)
			
			if FullWidthActive==True:	# if full-width...
				# self.character = unicodedata.normalize('NFKC', unicode(self.character,"utf-8"))
				if self.character=="　":
					self.button.set_label("└─┘")			
				else:
					self.button.set_label(self.character)
			else:			
				if self.character==" ":
					self.button.set_label("└─┘")			
				else:
					self.button.set_label(self.character)				
			
		# self.handler_id = self.button.connect("clicked", self.insertText, self.character, self.textArea)		
		self.handler_id = self.button.connect("button-press-event", self.buttonPressed, self.character, self.textArea)		
		self.release_handler_id = self.button.connect("button-release-event", self.buttonReleased)
		self.button.set_events(gtk.gdk.EXPOSURE_MASK |                        
                        gtk.gdk.BUTTON_PRESS_MASK |
                        gtk.gdk.BUTTON_RELEASE_MASK )
							
	def buttonPressed(self, button, event, character, textArea):
		# Insert appropriate character when user clicks the key
		if not (self.keyDown==True and self.keyUp==False):
			self.insertText(character, textArea)
				
		gobject.timeout_add(300, self.checkKeyPress, self.character, self.textArea)
			
		self.keyDown = True
		self.keyUp = False		
		
	def buttonReleased(self, button, event):		
		self.keyDown = False
		self.keyUp = True

	def checkKeyPress(self, character, textArea):		
		if self.keyDown==True and self.keyUp==False:
			self.insertText(character,textArea)
			return True
		else:
			return False

	def insertText(self, character, textArea):
		buffer = textArea.get_buffer()
		buffer.insert(buffer.get_iter_at_mark(buffer.get_insert()), character)
		textArea.grab_focus()
		
	def getButton(self):
		# Return the key itself
		return self.button