﻿#!/usr/bin/env python
#coding=utf-8

# Stroke Order Chinese Input Method 筆劃輸入法 v0.6
# Author: Amanda Lam
# E-mail: amanda.hoic@gmail.com

import osso
import sqlite3
import sys
import gtk
import hildon
import os
import gettext
import i18n
import gobject
import string
import ctypes
import time
import pygobject
import sendSMS
import locale
import dbus
import pango
import webbrowser
import xml.dom.minidom
import xml.parsers.expat
from IOConnection import IOConnection
from portrait import FremantleRotation
from virtualKeyboard import vKeyboard
from threading import Thread

# By using apt-cache search, the following packages are required:
# python2.5-gtk2, python2.5-hildon, python-gobject

_ = i18n.language.gettext	# Internationization support

class StrokeOrder():
	_PORTRAIT, _LANDSCAPE = ('portrait', 'landscape')
    # sysfs device name for the keyboard slider switch
	KBD_SLIDER = '/sys/devices/platform/gpio-switch/slide/state'
	_KBD_OPEN = 'open'
	_KBD_CLOSED = 'closed'	
					
	strokesInputted = gtk.Label()	# Define label for displaying strokes
	strokesInputted.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#002090"))	# Modify label font color
	strokesCodeInputted = ""	# Define variable for stroke codes being inputted
	statusBar = gtk.EventBox()
	statusBar.add(strokesInputted)
	statusBar.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#AADDFF"))	# Modify label background color
	statusBar.set_size_request(672,50)

	delKeyDown = False
	delKeyUp = False
	
	candidateChars = hildon.TouchSelector(text = True)	# Define TouchSelector control for displaying candidate characters	
	smsTextLabel = gtk.Label()	
	pannableArea = hildon.PannableArea()
	pannableArea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
	
	textArea = hildon.TextView()	# Define the text area for input
	textArea.set_placeholder(_("StrokeOrder_textAreaPlaceHolder"))	# Set the info text for display when text area is empty
	textArea.set_wrap_mode(gtk.WRAP_CHAR)		
	textArea.set_cursor_visible(True)	
	
	vkb = vKeyboard(textArea)
	vkbVBox = vkb.getKeyboard()
	vnpVBox = vkb.getNumpad()
	
	charLeft = gtk.Label()	# Define label for displaying number of characters left and number of messages being sent
	charLeft.set_text("70(1)")
	textAreaBuffer = textArea.get_buffer()	
	sendTo = hildon.TextView()	# Define the text field for phone number(s)
	sendToBuffer = sendTo.get_buffer()
	sendTo.set_placeholder(_("StrokeOrder_sendToPlaceHolder"))	# Set the info text for display when phone number text field is empty
	textboxInFocus = "textArea"	# Set input focus to the text area initially

	sendToNumbers = ""	# Variable for remembering the contact numbers when user switches back and forth the pages

	# Check if espeak and espeak's Mandarin & Cantonese data files are installed
	if os.path.exists("/usr/bin/espeak") == True and os.path.exists("/opt/espeak/data/zh_dict") == True and os.path.exists("/opt/espeak/data/zhy_dict") == True:
		espeakInstalled = True
	else:
		espeakInstalled = False
	
	osso_ctx = osso.Context("test_abook", "0.one")	# Define variable for Address Book
	capi = pygobject.PyGObjectCPAI()
	
	vKB = False
	vNP = False
	orientation = ""
	isNowFullScreen = False
	
	def __init__(self):	
		self.main()

	def _get_keyboard_state(self):
        # For sbox, if the device does not exist assume that it's closed
		try:
			return open(self.KBD_SLIDER).read().strip()
		except IOError:
			return self._KBD_CLOSED
			
	def _on_orientation_signal(self, orientation, stand, face, x, y, z):
		self.AppWidth, self.AppHeight = self.currentwindow.get_size()		
		self.orientation = orientation
		# print "Orientation: " + orientation
		# print "Width: " + str(self.AppWidth) + ", Height: " + str(self.AppHeight)		
		# print "Stand: " + str(stand) + ", Face: " + str(face)
		# print "X: " + str(x) + ", Y: " + str(y) + ", Z: " + str(z)
		# print "Keyboard State: " + self._get_keyboard_state()
		
		self.handleResizeControls();	
			
	def handleResizeControls(self):
		if self.AutoOrientation == True:
			if ("portrait" in self.orientation) and (not "inverted" in self.orientation) and (self._get_keyboard_state()==self._KBD_CLOSED):
				self.resizeControls(480,744)
			elif ("portrait" in self.orientation) and (self._get_keyboard_state()==self._KBD_OPEN):
				self.resizeControls(800,424)
			elif ("landscape" in self.orientation):
				self.resizeControls(800,424)
			elif self.orientation == "":				
				self.resizeControls(800,424)				
			elif self.orientation == "unknown":		
				if self.AppWidth==800:
					self.resizeControls(800,424)
				elif self.AppWidth==480:
					self.resizeControls(480,744)				
		else:
			if self.ForcePortraitLandscape == True: # Portrait
				self.resizeControls(480,744)
			else:
				self.resizeControls(800,424)

	def _on_keyboard_signal(self, condition, button_name):
		self.AppWidth, self.AppHeight = self.currentwindow.get_size()				
		# print "Orientation: " + self.orientation
		# print "Width: " + str(self.AppWidth) + ", Height: " + str(self.AppHeight)		
		# print "Condition: " + str(condition) + ", Button Name: " + str(button_name)		
		# print "Keyboard State: " + self._get_keyboard_state()
		
		if condition == 'ButtonPressed' and button_name == 'cover':
			if ("portrait" in self.orientation) and (self._get_keyboard_state()==self._KBD_CLOSED):
				self.resizeControls(480,744)
			elif ("portrait" in self.orientation) and (self._get_keyboard_state()==self._KBD_OPEN):
				self.resizeControls(800,424)
			elif ("landscape" in self.orientation):
				self.resizeControls(800,424)			
					
	def resizeControls(self, AppWidth, AppHeight):
		if self.vKB == False and self.vNP == False:
			self.statusBar.set_size_request(AppWidth-128,50)
			self.StrokeOrderImage.set_size_request(48,48)
			self.StrokeOrderLogo.set_size_request(48,48)			
			self.FullScreenButton.set_size_request(80,48)			
			self.FullScreenImage.set_size_request(42,35)			
			self.RestoreImage.set_size_request(42,35)			
			self.buttonHBox1.set_size_request(AppWidth,int(AppHeight*0.165))
			self.buttonHBox2.set_size_request(AppWidth,int(AppHeight*0.165))		
			self.EngButton.set_size_request(int(AppWidth/3),int(AppHeight*0.165))
			self.SymButton.set_size_request(int(AppWidth/3),int(AppHeight*0.165))
			# self.SMSPageButton.set_size_request(int(AppWidth/3),int(AppHeight*0.165))			
			self.EngSymButtonsHBox.set_size_request(AppWidth,int(AppHeight*0.165))
		elif self.vKB == True and self.vNP == False:
			self.statusBar.set_size_request(0,0)			
			self.StrokeOrderImage.set_size_request(0,0)
			self.StrokeOrderLogo.set_size_request(0,0)
			self.FullScreenButton.set_size_request(0,0)			
			self.FullScreenImage.set_size_request(0,0)			
			self.RestoreImage.set_size_request(0,0)						
			self.EngButton.set_size_request(int(AppWidth/3),int(AppHeight*0.1))
			self.SymButton.set_size_request(int(AppWidth/3),int(AppHeight*0.1))
			# self.SMSPageButton.set_size_request(int(AppWidth/3),int(AppHeight*0.1))
			self.EngSymButtonsHBox.set_size_request(AppWidth,int(AppHeight*0.1))
			self.vkbVBox.set_size_request(AppWidth,int(AppHeight*0.45))
		elif self.vKB == False and self.vNP == True:
			self.statusBar.set_size_request(0,0)
			self.StrokeOrderImage.set_size_request(0,0)
			self.StrokeOrderLogo.set_size_request(0,0)			
			self.FullScreenButton.set_size_request(0,0)			
			self.FullScreenImage.set_size_request(0,0)			
			self.RestoreImage.set_size_request(0,0)									
			self.EngButton.set_size_request(int(AppWidth/3),int(AppHeight*0.1))
			self.SymButton.set_size_request(int(AppWidth/3),int(AppHeight*0.1))
			# self.SMSPageButton.set_size_request(int(AppWidth/3),int(AppHeight*0.1))
			self.EngSymButtonsHBox.set_size_request(AppWidth,int(AppHeight*0.1))
			self.vnpVBox.set_size_request(AppWidth,int(AppHeight*0.45))
		
		self.candidateChars.set_size_request(130,int(AppHeight*0.2830))
		self.candidateCharsAndtextAreaHBox.set_size_request(int(AppWidth),int(AppHeight*0.2830))			
	
	def getCurrentLocale(self):
		# Return the current system locale
		lc, encoding = locale.getdefaultlocale()
		CurrentLocale = lc
		return CurrentLocale
		
	def queryString(self, stroke):
		conObj = IOConnection()
		conObj.start()
		con = conObj.connectIMDB()
		cur = con.cursor()
		
		# Takes in the inputted stroke sequence and display the candidate characters for selection
		if stroke!="":
			if (len(self.strokesCodeInputted)<=4 and "6" not in self.strokesCodeInputted and "7" not in self.strokesCodeInputted) or ("%" in self.strokesCodeInputted):	
				if ("%" in self.strokesCodeInputted):
					# For strokes with wildcard character, limit the number of candidate characters to 75 for the sake of performance				
					cur.execute("SELECT DISTINCT Character FROM StrokeOrder WHERE Strokes LIKE '" + stroke + "%' ORDER BY Frequency DESC, Strokes ASC LIMIT 75")
				else:
					cur.execute("SELECT Character FROM StrokeOrder WHERE (Strokes='" + stroke + "') OR (SUBSTR(Strokes,1," + str(len(stroke)) + ")='" + stroke + "' AND Frequency>100) ORDER BY Frequency DESC, Strokes ASC")
			else:
				if ("%" in self.strokesCodeInputted):
					cur.execute("SELECT DISTINCT Character FROM StrokeOrder WHERE Strokes LIKE '" + stroke + "%' ORDER BY Frequency DESC, Strokes ASC")	# For >4 strokes, display all candidate characters
				else:
					cur.execute("SELECT Character FROM StrokeOrder WHERE SUBSTR(Strokes,1," + str(len(stroke)) + ")='" + stroke + "' ORDER BY Frequency DESC, Strokes ASC")

			# con.commit()
		
		tm = gtk.ListStore(gobject.TYPE_STRING)
		self.candidateChars.set_model(0,tm)	# Clear the TouchSelector
		if stroke!="":
			# print stroke
			candidateChars = ""
			for row in cur.fetchall():										
				self.candidateChars.append_text(row[0])	# Generate candidate character selection list													
		con.close()
		
	def queryStrokes(self, queryStr):
		conObj = IOConnection()
		conObj.start()
		con = conObj.connectIMDB()
		cur = con.cursor()
		
		# Takes in a Chinese character and returns its stroke orders
		querychar = queryStr[0:1]
		# print querychar
		sQuery = "SELECT DISTINCT Strokes FROM StrokeOrder WHERE Character='" + querychar + "' LIMIT 1"
		# print sQuery
		cur.execute(sQuery)
		# con.commit()
		result=""
		for row in cur.fetchall():
			result = row[0]
		return result
		con.close()
	
	def queryAssoc(self, charKey):		
		conObj = IOConnection()
		conObj.start()
		con = conObj.connectIMDB()
		cur = con.cursor()
				
		# Takes in a Chinese character and display its associated phrases for selection
		if charKey!="":
			if self.getCurrentLocale() == "zh_HK" or self.getCurrentLocale() == "zh_Yue" or self.getCurrentLocale() == "zh_TW":
			# Display Traditional Chinese associated phrases if system locale is Chinese (Hong Kong), Cantonese or Chinese (Taiwan)
				sSQL = "SELECT Phrase FROM Assoc WHERE CharKey='" + charKey + "' AND TradSim='T' ORDER BY Frequency DESC, Phrase ASC"				
				cur.execute(sSQL)
			else: # Display Simplifeid Chinese associated phrases if system locale is Chinese (PRC), Chinese, or English
				sSQL = "SELECT Phrase FROM Assoc WHERE CharKey='" + charKey + "' AND TradSim='S' ORDER BY Frequency DESC, Phrase ASC"				
				cur.execute(sSQL)
			# con.commit()	
			# print sSQL
			
		tm = gtk.ListStore(gobject.TYPE_STRING)
		self.candidateChars.set_model(0,tm)	# Clear the TouchSelector
		
		if charKey!="":
			rowcount = 0
			for row in cur.fetchall():		
				self.candidateChars.append_text(row[0])	# Generate associated phrases selection list
				rowcount = rowcount + 1
				
		# print "rowcount = " + str(rowcount)
		# print "locale = " + self.getCurrentLocale()
		
		if rowcount == 0:	# Lookup also the Simplified Chinese verson if Traditional Chinese lookup returns nothing
			if self.getCurrentLocale() == "zh_HK" or self.getCurrentLocale() == "zh_Yue" or self.getCurrentLocale() == "zh_TW":
			# Display Simplified Chinese associated phrases if system locale is Chinese (Hong Kong), Cantonese or Chinese (Taiwan)
				sSQL = "SELECT Phrase FROM Assoc WHERE CharKey='" + charKey + "' AND TradSim='S' ORDER BY Frequency DESC, Phrase ASC"				
				cur.execute(sSQL)
				# print sSQL
			else: # Display Traditional Chinese associated phrases if system locale is Chinese (PRC), Chinese, or English
				# if cur.rowcount == 0:	# Lookup also the Traditional Chinese verson if Simplified Chinese lookup returns nothing
				sSQL = "SELECT Phrase FROM Assoc WHERE CharKey='" + charKey + "' AND TradSim='T' ORDER BY Frequency DESC, Phrase ASC"
				cur.execute(sSQL)
				# print sSQL
					
			if charKey!="":
				for row in cur.fetchall():							
					self.candidateChars.append_text(row[0])	# Generate associated phrases selection list					
		con.close()
		
	def main(self):							
		system_bus = dbus.Bus.get_system()
		system_bus.add_signal_receiver(self._on_orientation_signal, \
			signal_name='sig_device_orientation_ind', \
			dbus_interface='com.nokia.mce.signal', \
			path='/com/nokia/mce/signal')
	
		system_bus.add_signal_receiver(self._on_keyboard_signal, \
			signal_name='Condition', \
			dbus_interface='org.freedesktop.Hal.Device', \
			path='/org/freedesktop/Hal/devices/platform_slide')
		
		program = hildon.Program.get_instance()
		window = hildon.StackableWindow()	
		
		self.currentwindow = window		

		self.AppWidth, self.AppHeight = self.currentwindow.get_size()
		# scrolledWindow = gtk.ScrolledWindow(hadjustment=None, vadjustment=None)
		# scrolledWindow.show()
		# scrolledWindow.set_policy('automatic','automatic')
		
		main_window = window
		app_name = _("StrokeOrder_AppName")
		app_version = "0.6"	
		
		conObj = IOConnection()
		conObj.start()
		con = conObj.connectIMDB()
		
		# Support Portrait Mode, adopting gPodder's code
		if conObj.getKeyValue(conObj.settingsDOM,"AutoOrientation") == "True":
			initial_mode = FremantleRotation.AUTOMATIC
			self.AutoOrientation = True
		else:
			self.AutoOrientation = False
			if conObj.getKeyValue(conObj.settingsDOM,"ForcePortraitLandscape") == "True":
				self.ForcePortraitLandscape = True
				initial_mode = FremantleRotation.ALWAYS				
			else:
				self.ForcePortraitLandscape = False
				initial_mode = FremantleRotation.NEVER
		
		self.rotation_object = FremantleRotation(app_name, main_window, app_version, initial_mode) 
	 
		program.add_window(window)		
		self.candidateChars.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
		
		# Creating user interface
		self.statusBarHBox = gtk.HBox(False, 0)
		self.buttonHBox1 = gtk.HBox(False, 0)
		self.buttonHBox2 = gtk.HBox(False, 0)
		self.SymButtonVBox = gtk.VBox(False, 0)
		self.textAreaAndStrokeButtonsVBox = gtk.VBox(False, 0)		
		self.candidateCharsAndtextAreaHBox = gtk.HBox(False, 0)		
		
		self.textAreaButtonsVBox = gtk.VBox(False, 0)	
		self.EngSymButtonsHBox = gtk.HBox(False, 0)	
		 
		self.mainVBox = gtk.VBox(False, 0)
		
		OneButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		OneButton.set_label("一")   
		OneButton.connect("clicked", self.StrokeClicked, 1)   

		TwoButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		TwoButton.set_label("丨")   
		TwoButton.connect("clicked", self.StrokeClicked, 2)   

		ThreeButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		ThreeButton.set_label("丿")   
		ThreeButton.connect("clicked", self.StrokeClicked, 3)

		FourButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		FourButton.set_label("丶")   
		FourButton.connect("clicked", self.StrokeClicked, 4)

		FiveButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		FiveButton.set_label("乛")   
		FiveButton.connect("clicked", self.StrokeClicked, 5)
		
		cur = con.cursor()
		if conObj.getKeyValue(conObj.settingsDOM,"UseVirtualKB") == "True":
			self.EngButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_AUTO)
			self.EngButton.set_label(_("StrokeOrder_EngMode"))
			# self.EngButton = gtk.ToggleButton(_("StrokeOrder_EngMode"))
			self.EngButton.connect("clicked", self.showHideVirtualKeyboard, window)
			
			# self.SymButton = gtk.ToggleButton(_("StrokeOrder_SymMode"))
			self.SymButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_AUTO)
			self.SymButton.set_label(_("StrokeOrder_SymMode"))
			self.SymButton.connect("clicked", self.showHideVirtualNumpad, window)
		else:
			self.EngButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			self.EngButton.set_label(_("StrokeOrder_EngMode"))   
			self.EngButton.connect("clicked", self.StrokeClicked, 6)
			
			self.SymButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			self.SymButton.set_label(_("StrokeOrder_SymMode"))   
			self.SymButton.connect("clicked", self.StrokeClicked, 7)	
		con.close()
	
		WildcardButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		WildcardButton.set_label("？")   
		WildcardButton.connect("clicked", self.StrokeClicked, 8)		

		CopyButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		CopyButton.set_label(_("StrokeOrder_Copy"))   
		CopyButton.connect("clicked", self.CopyClicked, window)

		DelButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		DelButton.set_label("←")   
		# DelButton.connect("clicked", self.DelClicked, window)
		DelButton.connect("button-press-event", self.delButtonPressed, window)
		DelButton.connect("button-release-event", self.delButtonReleased, window)
		DelButton.set_events(gtk.gdk.EXPOSURE_MASK |                        
                        gtk.gdk.BUTTON_PRESS_MASK |
                        gtk.gdk.BUTTON_RELEASE_MASK )

		
		self.FullScreenButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_AUTO)
		self.FullScreenImage = gtk.Image()
		self.FullScreenImage.set_from_file("/opt/StrokeOrder/FullScreen.png")
		self.FullScreenImage.show()
		self.RestoreImage = gtk.Image()
		self.FullScreenButton.set_image(self.FullScreenImage)
		self.FullScreenButton.show_all()		
		self.FullScreenButton.connect("clicked", self.FullScreen, window)

		self.SMSPageButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.SMSPageButton.set_label(_("StrokeOrder_SMS"))   
		self.SMSPageButton.connect("clicked", self.SMSPageClicked)
		
		NewButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		NewButton.set_label(_("StrokeOrder_New"))   
		NewButton.connect("clicked", self.NewClicked)

		self.StrokeOrderImage = gtk.Image()
		self.StrokeOrderImage.set_from_file("/opt/StrokeOrder/AppIcon.png")
		self.StrokeOrderImage.show()		
		self.StrokeOrderLogo = gtk.EventBox()
		self.StrokeOrderLogo.add(self.StrokeOrderImage)
		self.StrokeOrderLogo.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#AADDFF"))	# Modify background color
		
		self.statusBarHBox.pack_start(self.StrokeOrderLogo, False, True, 0)
		self.statusBarHBox.pack_start(self.statusBar, False, True, 0)
		self.statusBarHBox.pack_start(self.FullScreenButton, False, True, 0)
		
		self.buttonHBox1.pack_start(OneButton, True, True, 0)
		self.buttonHBox1.pack_start(TwoButton, True, True, 0)
		self.buttonHBox1.pack_start(ThreeButton, True, True, 0)

		self.buttonHBox2.pack_start(FourButton, True, True, 0)
		self.buttonHBox2.pack_start(FiveButton, True, True, 0)
		self.buttonHBox2.pack_start(WildcardButton, True, True, 0)				
		
		# print "Width: " + str(self.AppWidth) + ", Height: " + str(self.AppHeight)
	
		self.textArea.connect("grab-focus", self.setCurrentTextboxInFocus, "textArea")
		self.textAreaBuffer.connect("changed", self.refreshCharLeft)

		self.EngSymButtonsHBox.pack_start(self.EngButton, True, True, 0)	
		self.EngSymButtonsHBox.pack_start(self.SymButton, True, True, 0)			
		
		self.pannableArea.add_with_viewport(self.textArea)				
		
		self.textAreaAndStrokeButtonsVBox.pack_start(self.pannableArea, True, True, 0)
		self.textAreaAndStrokeButtonsVBox.pack_start(self.buttonHBox1, False, True ,0)
		self.textAreaAndStrokeButtonsVBox.pack_start(self.buttonHBox2, False, True ,0)		
		self.textAreaAndStrokeButtonsVBox.pack_start(self.EngSymButtonsHBox, False, True, 0)						
		
		self.candidateCharsAndtextAreaHBox.pack_start(self.textAreaAndStrokeButtonsVBox, True, True, 0)
		self.candidateCharsAndtextAreaHBox.pack_start(self.candidateChars, False, True, 0)		

		self.textAreaButtonsVBox.pack_start(self.charLeft, False, False, 0)
		self.textAreaButtonsVBox.pack_start(CopyButton, True, True, 0)
		self.textAreaButtonsVBox.pack_start(self.SMSPageButton, True, True, 0)
		self.textAreaButtonsVBox.pack_start(DelButton, True, True, 0)			

		self.candidateCharsAndtextAreaHBox.pack_start(self.textAreaButtonsVBox, False, False, 0)	

		self.candidateChars.connect("changed", self.CharSelected)
		self.strokesCodeInputted = "6"
		self.queryString(self.strokesCodeInputted)		
		
		self.strokesInputted.set_text( self.ConvertCodeToChar(self.strokesCodeInputted) )	# Display the inputted strokes
		
		self.mainVBox.pack_start(self.statusBarHBox, False, False ,0)				
		self.mainVBox.pack_start(self.candidateCharsAndtextAreaHBox, True, True, 0)		

		self.handleResizeControls()
		if self.AutoOrientation==True:
			self.resizeControls(800,424)
		else:
			if self.ForcePortraitLandscape==True:
				self.resizeControls(480,744)
			else:
				self.resizeControls(800,424)

		window.set_title(_("StrokeOrder_AppName")) 
		window.connect("delete_event",self.app_preclose)
		menu = self.create_menu(window, "MainPage") 
		window.set_app_menu(menu)	
		window.add(self.mainVBox)	
		window.show_all()		
		self.textArea.grab_focus()
		self.DBVerCheck(window)
		gtk.main()		

	def DBVerCheck(self,window):
		conObj = IOConnection()
		conObj.start()
		con = conObj.connectIMDB()
		cur = con.cursor()
		currentVer = 0
		
		try:
			cur.execute("SELECT Version FROM StrokeOrderVersion ORDER BY Version DESC LIMIT 1")
		except:
			currentVer = -1

		if currentVer==0:
			for row in cur.fetchall():
				try:
					currentVer = float(row[0])
				except:
					currentVer = 0
					
		if currentVer < 0.6:
			dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_DBUpgradeRequired")) 	
			response = dialog.run()
			dialog.destroy()			
			
			success=True
			try:
				if conObj.makedir('/home/user/MyDocs/.StrokeOrder') == True:
					copycmd = "cp /opt/StrokeOrder/IM.db /home/user/MyDocs/.StrokeOrder/"
					os.system(copycmd)						
			except IOError: # displays error message in case of file I/O error
				dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_ResetIMDBFailed")) 
				response = dialog.run()
				dialog.destroy()
				success=False
				
			if success==True:
				dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_ResetIMDBSuccess")) 
				response = dialog.run()
				dialog.destroy()	
			
	def showHideVirtualKeyboard(self, EngButton, window):
		# Show / hide the QWERTY virtual keyboard
		if self.EngButton.get_active() == False:
			self.vKB = False			
			self.mainVBox.remove(self.vkbVBox)
			tm = gtk.ListStore(gobject.TYPE_STRING)
			self.candidateChars.set_model(0,tm)
		else: 
			if self.SymButton.get_active() == True:
				self.SymButton.set_active(False)
				self.showHideVirtualNumpad(self.SymButton,window)
				
			self.statusBar.set_size_request(0,0)
			self.buttonHBox1.set_size_request(0,0)
			self.buttonHBox2.set_size_request(0,0)
			self.mainVBox.pack_start(self.vkbVBox,False,True,0)
			self.vKB = True
			self.StrokeClicked(self.EngButton,6)
			window.show_all()	

		self.handleResizeControls()
		# if self.orientation == "portrait":
		#	self.resizeControls(480,744)
		# else:
		#	self.resizeControls(800,424)			
			
	def showHideVirtualNumpad(self, SymButton, window):			
		# Show / hide the symbolic / numeric virtual keyboard
		if self.SymButton.get_active() == False:
			self.vNP = False
			self.mainVBox.remove(self.vnpVBox)
		else: 
			if self.EngButton.get_active() == True:
				self.EngButton.set_active(False)
				self.showHideVirtualKeyboard(self.EngButton,window)
				
			self.statusBar.set_size_request(0,0)
			self.buttonHBox1.set_size_request(0,0)
			self.buttonHBox2.set_size_request(0,0)
			self.mainVBox.pack_start(self.vnpVBox,False,True,0)
			self.vNP = True
			self.StrokeClicked(self.SymButton,7)
			window.show_all()				

		self.handleResizeControls()
		# if self.orientation == "portrait":
		#	self.resizeControls(480,744)
		# else:
		#	self.resizeControls(800,424)			
	
	def FullScreen(self, FullScreenButton, window):	
		# The method that toggles between full screen mode and window mode, by setting a class variable value 
		if self.isNowFullScreen == False:
			window.fullscreen()   
			self.isNowFullScreen = True
			self.RestoreImage = gtk.Image()
			self.RestoreImage.set_from_file("/opt/StrokeOrder/Restore.png")
			self.RestoreImage.show()
			FullScreenButton.set_active(True)
			FullScreenButton.set_image(self.RestoreImage)
			FullScreenButton.show_all()   
		elif self.isNowFullScreen == True:
			window.unfullscreen()		
			self.isNowFullScreen = False
			self.FullScreenImage = gtk.Image()
			self.FullScreenImage.set_from_file("/opt/StrokeOrder/FullScreen.png")
			self.FullScreenImage.show()
			FullScreenButton.set_active(False)
			FullScreenButton.set_image(self.FullScreenImage)
			FullScreenButton.show_all()
		
	def aboutProduct(self, AboutProductButton, window):
		# Show the About this Product dialog box
		
		text = _("StrokeOrder_AboutProductText")
		dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window,text) 
		response = dialog.run()
		dialog.destroy()

	def speakMandarinClicked(self, SpeakMandarinButton, window):
		textToSpeak = self.textAreaBuffer.get_text(self.textAreaBuffer.get_start_iter(), self.textAreaBuffer.get_end_iter(), False)
		textToSpeak = textToSpeak.replace("\"","").replace("'","").replace("\\","")
		speakCMD = "espeak -v zh \"" + textToSpeak + "\" &"
		os.system(speakCMD)
	
	def speakCantoneseClicked(self, SpeakCantoneseButton, window):	
		textToSpeak = self.textAreaBuffer.get_text(self.textAreaBuffer.get_start_iter(), self.textAreaBuffer.get_end_iter(), False)
		textToSpeak = textToSpeak.replace("\"","").replace("'","").replace("\\","")
		speakCMD = "espeak -v zhy \"" + textToSpeak + "\" &"
		os.system(speakCMD)
	
	def stopSpeakingClicked(self, StopSpeakingButton, window):		
		stopSpeakingCMD = "pkill espeak &"
		os.system(stopSpeakingCMD)	
	
	def donateClicked(self, DonateButton, window):
		if self.getCurrentLocale() == "zh_HK" or self.getCurrentLocale() == "zh_Yue" or self.getCurrentLocale() == "zh_TW":
			webbrowser.open_new("http://maemo.dadablog.net/donation_zhhk.html")
		elif self.getCurrentLocale() == "zh_CN" or self.getCurrentLocale() == "zh":
			webbrowser.open_new("http://maemo.dadablog.net/donation_zhcn.html")
		else:	
			webbrowser.open_new("http://maemo.dadablog.net/donation.html")
			
	def settingsClicked(self, QueryStrokesButton, window):
		# Create the UI for the Settings page
		settingsPage = hildon.StackableWindow()
		settingsPage.set_title(_("StrokeOrder_AppName") + " - " + _("StrokeOrder_Settings"))
		conObj = IOConnection()		
		conObj.start()
		try:
			if conObj.makedir('/home/user/MyDocs/.StrokeOrder') == True:
				conObj.settingsDOM = xml.dom.minidom.parse('/home/user/MyDocs/.StrokeOrder/settings.xml') # parse the settings XML and returns the XML DOM object	
		except xml.parsers.expat.ExpatError: # displays error message in case of parse error				
				self.writeDefaultSettingsXML()
				conObj.settingsDOM = xml.dom.minidom.parseString(self.getDefaultSettingsXML())
		except IOError: # displays error message in case of file I/O error				
				self.writeDefaultSettingsXML()
				conObj.settingsDOM = xml.dom.minidom.parseString(self.getDefaultSettingsXML())

		DisplayStatusIconLabel = gtk.Label()
		DisplayStatusIconLabel.set_text(_("StrokeOrder_DisplayStatusIconLabel"))
		DisplayStatusIconLabel.set_size_request(320,50)
		DisplayStatusIconLabel.set_line_wrap(True)		
		DisplayStatusIconLabel.set_alignment(0.1,0.5)
		
		if os.path.exists("/usr/share/icons/hicolor/48x48/apps/StrokeOrder_status_menu.png") and os.path.exists("/usr/share/applications/hildon-status-menu/StrokeOrder_status_menu.desktop"):
			self.DisplayStatusIconButton = gtk.ToggleButton(_("StrokeOrder_DisplayStatusIcon_On"))
			self.DisplayStatusIconButton.set_active(True)
		else:
			self.DisplayStatusIconButton = gtk.ToggleButton(_("StrokeOrder_DisplayStatusIcon_Off"))
			self.DisplayStatusIconButton.set_active(False)
		
		self.DisplayStatusIconButton.set_size_request(140,50)
		self.DisplayStatusIconButton.connect("clicked",self.DisplayStatusIconButtonClicked,window)
		
		DisplayStatusIconHBox = gtk.HBox()
		DisplayStatusIconHBox.pack_start(DisplayStatusIconLabel,True,True,0)
		DisplayStatusIconHBox.pack_start(self.DisplayStatusIconButton,False,True,0)
		
		UseVirtualKBLabel = gtk.Label()
		UseVirtualKBLabel.set_text(_("StrokeOrder_UseVirtualKBLabel"))
		UseVirtualKBLabel.set_size_request(320,50)
		UseVirtualKBLabel.set_line_wrap(True)				
		UseVirtualKBLabel.set_alignment(0.1,0.5)
		
		if conObj.getKeyValue(conObj.settingsDOM,"UseVirtualKB") == "True":
			self.UseVirtualKBButton = gtk.ToggleButton(_("StrokeOrder_UseVirtualKB_On"))
			self.UseVirtualKBButton.set_active(True)
		else:
			self.UseVirtualKBButton = gtk.ToggleButton(_("StrokeOrder_UseVirtualKB_Off"))
			self.UseVirtualKBButton.set_active(False)

		self.UseVirtualKBButton.set_size_request(140,50)			
		self.UseVirtualKBButton.connect("clicked",self.UseVirtualKBButtonClicked, window)		

		UseVirtualKBHBox = gtk.HBox()		
		UseVirtualKBHBox.pack_start(UseVirtualKBLabel,True,True,0)
		UseVirtualKBHBox.pack_start(self.UseVirtualKBButton,False,True,0)
		
		ForcePortraitLandscapeLabel = gtk.Label()
		ForcePortraitLandscapeLabel.set_text(_("StrokeOrder_ForcePortraitLandscapeLabel"))
		ForcePortraitLandscapeLabel.set_size_request(320,50)
		ForcePortraitLandscapeLabel.set_line_wrap(True)						
		ForcePortraitLandscapeLabel.set_alignment(0.1,0.5)
		
		if conObj.getKeyValue(conObj.settingsDOM,"ForcePortraitLandscape") == "True":
			self.ForcePortraitLandscapeButton = gtk.ToggleButton(_("StrokeOrder_ForcePortraitLandscape_Portrait"))
			self.ForcePortraitLandscapeButton.set_active(True)
		else:
			self.ForcePortraitLandscapeButton = gtk.ToggleButton(_("StrokeOrder_ForcePortraitLandscape_Landscape"))
			self.ForcePortraitLandscapeButton.set_active(False)
			
		self.ForcePortraitLandscapeButton.set_size_request(140,50)			
		self.ForcePortraitLandscapeButton.connect("clicked",self.ForcePortraitLandscapeButtonClicked,window)
		
		ForcePortraitLandscapeHBox = gtk.HBox()
		ForcePortraitLandscapeHBox.pack_start(ForcePortraitLandscapeLabel,True,True,0)
		ForcePortraitLandscapeHBox.pack_start(self.ForcePortraitLandscapeButton,False,True,0)

		AutoOrientationLabel = gtk.Label()
		AutoOrientationLabel.set_text(_("StrokeOrder_AutoOrientationLabel"))
		AutoOrientationLabel.set_size_request(320,50)
		AutoOrientationLabel.set_line_wrap(True)		
		AutoOrientationLabel.set_alignment(0.1,0.5)
		
		if conObj.getKeyValue(conObj.settingsDOM,"AutoOrientation") == "True" or conObj.getKeyValue(conObj.settingsDOM,"AutoOrientation") == "":
			self.AutoOrientationButton = gtk.ToggleButton(_("StrokeOrder_AutoOrientation_On"))
			self.AutoOrientationButton.set_active(True)
			self.ForcePortraitLandscapeButton.set_sensitive(False)
		else:
			self.AutoOrientationButton = gtk.ToggleButton(_("StrokeOrder_AutoOrientation_Off"))
			self.AutoOrientationButton.set_active(False)
			self.ForcePortraitLandscapeButton.set_sensitive(True)
		
		self.AutoOrientationButton.set_size_request(140,50)			
		self.AutoOrientationButton.connect("clicked",self.AutoOrientationButtonClicked,window)
		
		AutoOrientationHBox = gtk.HBox()
		AutoOrientationHBox.pack_start(AutoOrientationLabel,True,True,0)
		AutoOrientationHBox.pack_start(self.AutoOrientationButton,False,True,0)
		
		CandCustOrderLabel = gtk.Label()
		CandCustOrderLabel.set_text(_("StrokeOrder_CandCustOrderLabel"))
		CandCustOrderLabel.set_size_request(320,50)
		CandCustOrderLabel.set_line_wrap(True)				
		CandCustOrderLabel.set_alignment(0.1,0.5)
		
		if conObj.getKeyValue(conObj.settingsDOM,"CandCustOrder") == "True":
			self.CandCustOrderButton = gtk.ToggleButton(_("StrokeOrder_CandCustOrder_On"))
			self.CandCustOrderButton.set_active(True)
		else:
			self.CandCustOrderButton = gtk.ToggleButton(_("StrokeOrder_CandCustOrder_Off"))
			self.CandCustOrderButton.set_active(False)
		
		self.CandCustOrderButton.set_size_request(140,50)			
		self.CandCustOrderButton.connect("clicked",self.CandCustOrderButtonClicked)		

		CandCustOrderHBox = gtk.HBox()		
		CandCustOrderHBox.pack_start(CandCustOrderLabel,True,True,0)
		CandCustOrderHBox.pack_start(self.CandCustOrderButton,False,True,0)
		
		AssocCustOrderLabel = gtk.Label()
		AssocCustOrderLabel.set_text(_("StrokeOrder_AssocCustOrderLabel"))
		AssocCustOrderLabel.set_size_request(320,50)
		AssocCustOrderLabel.set_line_wrap(True)						
		AssocCustOrderLabel.set_alignment(0.1,0.5)
		
		if conObj.getKeyValue(conObj.settingsDOM,"AssocCustOrder") == "True":
			self.AssocCustOrderButton = gtk.ToggleButton(_("StrokeOrder_AssocCustOrder_On"))
			self.AssocCustOrderButton.set_active(True)
		else:
			self.AssocCustOrderButton = gtk.ToggleButton(_("StrokeOrder_AssocCustOrder_Off"))
			self.AssocCustOrderButton.set_active(False)

		self.AssocCustOrderButton.set_size_request(140,50)						
		self.AssocCustOrderButton.connect("clicked",self.AssocCustOrderButtonClicked)		
		
		AssocCustOrderHBox = gtk.HBox()		
		AssocCustOrderHBox.pack_start(AssocCustOrderLabel,True,True,0)
		AssocCustOrderHBox.pack_start(self.AssocCustOrderButton,False,True,0)

		UseCustIMDBLabel = gtk.Label()
		UseCustIMDBLabel.set_text(_("StrokeOrder_UseCustIMDBLabel"))
		UseCustIMDBLabel.set_size_request(320,50)
		UseCustIMDBLabel.set_line_wrap(True)		
		UseCustIMDBLabel.set_alignment(0.1,0.5)
		
		if conObj.getKeyValue(conObj.settingsDOM,"UseCustIMDB") == "True":
			self.UseCustIMDBButton = gtk.ToggleButton(_("StrokeOrder_UseCustIMDB_On"))
			self.UseCustIMDBButton.set_active(True)			
			self.CandCustOrderButton.set_sensitive(True)
			self.AssocCustOrderButton.set_sensitive(True)			
		else:
			self.UseCustIMDBButton = gtk.ToggleButton(_("StrokeOrder_UseCustIMDB_Off"))
			self.UseCustIMDBButton.set_active(False)
			self.CandCustOrderButton.set_sensitive(False)
			self.AssocCustOrderButton.set_sensitive(False)			
		
		self.UseCustIMDBButton.set_size_request(140,50)						
		self.UseCustIMDBButton.connect("clicked",self.UseCustIMDBButtonClicked)		
		
		UseCustIMDBHBox = gtk.HBox()		
		UseCustIMDBHBox.pack_start(UseCustIMDBLabel,True,True,0)
		UseCustIMDBHBox.pack_start(self.UseCustIMDBButton,False,True,0)
		
		self.OptimizeIMDBButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.OptimizeIMDBButton.set_label(_("StrokeOrder_OptimizeIMDB"))   		
		self.OptimizeIMDBButton.connect("clicked", self.OptimizeIMDBButtonClicked, window)		
		
		self.ResetIMDBButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.ResetIMDBButton.set_label(_("StrokeOrder_ResetIMDB"))   
		self.ResetIMDBButton.connect("clicked", self.ResetIMDBButtonClicked, window)

		vbox = gtk.VBox()
		vbox.pack_start(DisplayStatusIconHBox, True, True, 0)
		vbox.pack_start(UseVirtualKBHBox, True, True, 0)								
		vbox.pack_start(AutoOrientationHBox, True, True, 0)								
		vbox.pack_start(ForcePortraitLandscapeHBox, True, True, 0)										
		vbox.pack_start(UseCustIMDBHBox, True, True, 0)								
		vbox.pack_start(CandCustOrderHBox, True, True, 0)								
		vbox.pack_start(AssocCustOrderHBox, True, True, 0)								
		vbox.pack_start(self.OptimizeIMDBButton, True, True, 0)		
		vbox.pack_start(self.ResetIMDBButton, True, True, 0)
		vbox.set_size_request(460,900)
		settingsVBoxPannableArea = hildon.PannableArea()
		settingsVBoxPannableArea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
		settingsVBoxPannableArea.add_with_viewport(vbox)
		
		settingsPage.connect("delete_event",self.settingsPageClosed)
		settingsPage.add(settingsVBoxPannableArea)
		settingsPage.show_all()					

	def DisplayStatusIconButtonClicked(self, DisplayStatusIconButton, window):
		if self.DisplayStatusIconButton.get_active() == True:
			self.DisplayStatusIconButton.set_label(_("StrokeOrder_DisplayStatusIcon_On"))
			InstallStatusIconCMD = "sudo cp /opt/StrokeOrder/StrokeOrder_status_menu.png /usr/share/icons/hicolor/48x48/apps/; sudo cp /opt/StrokeOrder/StrokeOrder_status_menu.desktop /usr/share/applications/hildon-status-menu/; sudo cp /opt/StrokeOrder/StrokeOrder_status_menu.py /usr/lib/hildon-desktop/; pkill -f hildon-status" 
			os.system(InstallStatusIconCMD)					
		else:
			self.DisplayStatusIconButton.set_label(_("StrokeOrder_DisplayStatusIcon_Off"))
			RemoveStatusIconCMD = "sudo rm -f /usr/share/icons/hicolor/48x48/apps/StrokeOrder_status_menu.png; sudo rm -f  /usr/share/applications/hildon-status-menu/StrokeOrder_status_menu.desktop; sudo rm -f /usr/lib/hildon-desktop/StrokeOrder_status_menu.py; pkill -f hildon-status" 
			os.system(RemoveStatusIconCMD)
			
	def UseVirtualKBButtonClicked(self, UseVirtualKBButton, window):
		# Set button label when Use Virtual Keyboard option is enabled / disabled
		if self.UseVirtualKBButton.get_active() == True:		
			self.UseVirtualKBButton.set_label(_("StrokeOrder_UseVirtualKB_On"))
		else:
			self.UseVirtualKBButton.set_label(_("StrokeOrder_UseVirtualKB_Off"))
		dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_UseVirtualKBChange")) 
		response = dialog.run()
		dialog.destroy()					

	def AutoOrientationButtonClicked(self, AutoOrientationButton, window):
		if self.AutoOrientationButton.get_active() == True:		
			self.AutoOrientationButton.set_label(_("StrokeOrder_AutoOrientation_On"))
			self.ForcePortraitLandscapeButton.set_sensitive(False)
			self.AutoOrientation = True
			self.rotation_object.set_mode(FremantleRotation.AUTOMATIC)
			if ("portrait" in self.orientation) and (self._get_keyboard_state()==self._KBD_CLOSED):
				self.resizeControls(480,744)
			elif ("portrait" in self.orientation) and (self._get_keyboard_state()==self._KBD_OPEN):
				self.resizeControls(800,424)
			elif ("landscape" in self.orientation):
				self.resizeControls(800,424)
			else:
				self.resizeControls(800,424)			
		else:
			self.AutoOrientationButton.set_label(_("StrokeOrder_AutoOrientation_Off"))
			self.ForcePortraitLandscapeButton.set_sensitive(True)
			self.AutoOrientation = False
			if self.ForcePortraitLandscapeButton.get_active() == True:
				self.rotation_object.set_mode(FremantleRotation.ALWAYS)
				self.resizeControls(480,744)
			else:
				self.rotation_object.set_mode(FremantleRotation.NEVER)
				self.resizeControls(800,424)

	def ForcePortraitLandscapeButtonClicked(self, ForcePortraitLandscapeButton, window):
		if self.ForcePortraitLandscapeButton.get_active() == True:		
			self.ForcePortraitLandscapeButton.set_label(_("StrokeOrder_ForcePortraitLandscape_Portrait"))			
			self.ForcePortraitLandscape = True
			self.rotation_object.set_mode(FremantleRotation.ALWAYS)
			self.resizeControls(480,744)
		else:
			self.ForcePortraitLandscapeButton.set_label(_("StrokeOrder_ForcePortraitLandscape_Landscape"))			
			self.ForcePortraitLandscape = False
			self.rotation_object.set_mode(FremantleRotation.NEVER)
			self.resizeControls(800,424)						
	
	def UseCustIMDBButtonClicked(self, UseCustIMDBButton):
		# Set button label when Use customized frequency database option is enabled / disabled
		if self.UseCustIMDBButton.get_active() == True:
			self.UseCustIMDBButton.set_label(_("StrokeOrder_UseCustIMDB_On"))
			self.CandCustOrderButton.set_sensitive(True)
			self.AssocCustOrderButton.set_sensitive(True)
		else:
			self.UseCustIMDBButton.set_label(_("StrokeOrder_UseCustIMDB_Off"))
			self.CandCustOrderButton.set_sensitive(False)
			self.AssocCustOrderButton.set_sensitive(False)
			
	def CandCustOrderButtonClicked(self, CandCustOrderButton):
		# Set button label when Use customized frequency display order of stroke orders is enabled / disabled
		if self.CandCustOrderButton.get_active() == True:
			self.CandCustOrderButton.set_label(_("StrokeOrder_CandCustOrder_On"))
		else:
			self.CandCustOrderButton.set_label(_("StrokeOrder_CandCustOrder_Off"))

	def AssocCustOrderButtonClicked(self, AssocCustOrderButton):
		# Set button label when Use customized frequency display order of associated phrases is enabled / disabled
		if self.AssocCustOrderButton.get_active() == True:
			self.AssocCustOrderButton.set_label(_("StrokeOrder_AssocCustOrder_On"))
		else:
			self.AssocCustOrderButton.set_label(_("StrokeOrder_AssocCustOrder_Off"))

	def OptimizeIMDBButtonClicked(self, OptimizeIMDBButton, window):
		confirm = hildon.hildon_note_new_confirmation(window, _("StrokeOrder_OptimizingIMDB")) 
		response = gtk.Dialog.run(confirm)
		gtk.Dialog.hide(confirm)
		if response == gtk.RESPONSE_DELETE_EVENT:
			dialog.destroy()					
		elif response == gtk.RESPONSE_OK:
			success = True	
			try:		
				optimizeCMD = "echo 'REINDEX StrokeOrder; REINDEX Assoc; VACUUM;' | sqlite3 /home/user/MyDocs/.StrokeOrder/IM.db"
				os.system(optimizeCMD)			
			except IOError:
				dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_OptimizeIMDBFailed")) 
				response = dialog.run()
				dialog.destroy()
				success = False
		
			if success==True:	
				dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_OptimizeIMDBSuccess")) 
				response = dialog.run()
				dialog.destroy()				
					
		
	def ResetIMDBButtonClicked(self, ResetIMDBButton, window):
		# Defines the operations when the Reset frequency database button is clicked
		conObj = IOConnection()
		conObj.start()
		confirm = hildon.hildon_note_new_confirmation(window, _("StrokeOrder_Confirm_ResetIMDB"))
		response = gtk.Dialog.run(confirm)
		gtk.Dialog.hide(confirm)
		if response == gtk.RESPONSE_DELETE_EVENT:
			print "Reset IM.db cancelled"
		elif response == gtk.RESPONSE_OK:	
			success = True
			try:
				if conObj.makedir('/home/user/MyDocs/.StrokeOrder') == True:
					copycmd = "cp /opt/StrokeOrder/IM.db /home/user/MyDocs/.StrokeOrder/"
					os.system(copycmd)
			except IOError: # displays error message in case of file I/O error
				dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_ResetIMDBFailed")) 
				response = dialog.run()
				dialog.destroy()
				success = False
				
			if success==True:
				dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_ResetIMDBSuccess")) 
				response = dialog.run()
				dialog.destroy()			
		
	def settingsPageClosed(self, window, widget):
		# Write settings to settings file when Settings page is closed
		conObj = IOConnection()
		conObj.start()
		conObj.writeSettingsXML(self.UseVirtualKBButton.get_active(),self.AutoOrientationButton.get_active(),self.ForcePortraitLandscapeButton.get_active(),self.UseCustIMDBButton.get_active(),self.CandCustOrderButton.get_active(),self.AssocCustOrderButton.get_active())
		con = conObj.connectIMDB()
		cur = con.cursor()
		# Set the input focus back to the text area once the Settings page is closed		
		self.textArea.grab_focus()
		
	def queryStrokesClicked(self, QueryStrokesButton, window):
		# Create the UI for the stroke query module
		
		notebook = gtk.Notebook()
		queryCharLabel = gtk.Label()
		queryCharLabel.set_justify(gtk.JUSTIFY_LEFT)
		queryCharLabel.set_width_chars(25)
		queryCharLabel.set_line_wrap(True)		
		queryCharLabel.set_text(_("StrokeOrder_QueryStrokesInstruction"))
		
		self.queryCharEntry = hildon.Entry(gtk.HILDON_SIZE_AUTO)				
		self.queryCharEntry.set_max_length(1)
		
		queryCharEntryFont=pango.FontDescription('normal 60')
		self.queryCharEntry.modify_font(queryCharEntryFont)
		self.queryCharEntry.set_size_request(120,120)
		
		PasteButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		PasteButton.set_label(_("StrokeOrder_Paste"))
		PasteButton.connect("clicked", self.queryStrokesPasteClicked)
		
		queryCharHBox = gtk.HBox()
		queryCharHBox.pack_start(queryCharLabel, True, True, 0)		
		queryCharHBox.pack_start(self.queryCharEntry, False, True, 0)		
		
		queryCharVBox = gtk.VBox()
		queryCharVBox.pack_start(queryCharHBox, False, True, 0)		
		queryCharVBox.pack_start(PasteButton, True, True, 0)		
			
		self.queryStrokesResultLabel = gtk.Label()		
		self.queryStrokesResultExplainLabel = gtk.Label()		

		self.queryStrokesCopyButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.queryStrokesCopyButton.set_label(_("StrokeOrder_Copy"))
		self.queryStrokesCopyButton.connect("clicked", self.queryStrokesCopyClicked, window)
		resultVBox = gtk.VBox()
		resultVBox.pack_start(self.queryStrokesResultExplainLabel, True, True, 0)
		
		queryStrokesPannableArea = hildon.PannableArea()
		queryStrokesPannableArea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
		queryStrokesPannableArea.add_with_viewport(self.queryStrokesResultLabel)
		
		resultVBox.pack_start(queryStrokesPannableArea, True, True, 0)
		resultVBox.pack_start(self.queryStrokesCopyButton, True, True, 0)
						
		notebook.append_page(queryCharVBox, None)
		notebook.append_page(resultVBox, None)
		dialog = hildon.WizardDialog(None, _("StrokeOrder_QueryStrokes"), notebook)
		notebook.connect("switch-page", self.queryStrokesStartQuery, dialog)
		dialog.set_forward_page_func(self.queryStrokesWizardNextFunc)
		dialog.show_all()
		response = dialog.run()
		if response == hildon.WIZARD_DIALOG_FINISH: dialog.destroy()

	def queryStrokesWizardNextFunc(self, page, num, dialog):
		# Define the criteria for proceeding to the next step
		
		if self.queryCharEntry.get_text() == "": 
			return False
		else:
			return True

	def queryStrokesCopyClicked(self, CopyButton, window):
		# Copy the strokes to the clipboard
		
		textToBeCopied = self.queryStrokesResultLabel.get_text()
		if textToBeCopied != _("StrokeOrder_QueryStrokesResultNotFound") and textToBeCopied != _("StrokeOrder_SymMode") and textToBeCopied != _("StrokeOrder_EngMode"):			
			clip = gtk.Clipboard()
			clip.set_text( textToBeCopied )
			clip.store()		

	def queryStrokesPasteClicked(self, window):
		# Triggered when user clicks the Paste button from the menu
		clip = gtk.Clipboard()
		data = clip.wait_for_contents('UTF8_STRING')
		if data.get_text() != None:
			text = unicode( str(data.get_text()), "utf-8")
			text = text[0:1]			
			if text != "" and text != None:
				self.queryCharEntry.set_text(text)			
			# print text
			
	def queryStrokesStartQuery(self, notebook, page, num, dialog):
		# Performed the stroke query operation
		
		result = self.queryStrokes( unicode(self.queryCharEntry.get_text(),"utf-8") )
		# print result;
		if result != "":
			if result=="6" or result=="7":
				self.queryStrokesCopyButton.set_sensitive(False)
			else:
				self.queryStrokesCopyButton.set_sensitive(True)
			self.queryStrokesResultExplainLabel.set_text("「" + self.queryCharEntry.get_text() + _("StrokeOrder_QueryStrokesResultExplain"))				
			self.queryStrokesResultLabel.set_text( self.ConvertCodeToChar(result) )
		else:
			self.queryStrokesResultLabel.set_text( _("StrokeOrder_QueryStrokesResultNotFound") )
			self.queryStrokesCopyButton.set_sensitive(False)
		return True
	
	def SMSPageClicked(self, window):
		# Proceed to the SMS Preview page
		
		smsText = self.textAreaBuffer.get_text(self.textAreaBuffer.get_start_iter(), self.textAreaBuffer.get_end_iter(), False)
		
		if (smsText!=""):
			sendSMSPage = hildon.StackableWindow()
			sendSMSPage.set_title(_("StrokeOrder_Send"))
			
			vbox = gtk.VBox(False, 0)		
			
			smsText = unicode(smsText,"utf-8")
			msglength = len(smsText)
			textToBeSent = ""
			for i in range(1, msglength/70+2 ):
				textToBeSent = textToBeSent + "＊＊＊ " + _("StrokeOrder_MessageCount") + str(i) + " ＊＊＊\n" + smsText[(i*70-70):(i*70)] + "\n\n"
			
			self.smsTextLabel.set_text(_("StrokeOrder_MessagePreview") + "\n\n" + textToBeSent)
			self.smsTextLabel.set_alignment(0,0)						
			# self.smsTextLabel.set_line_wrap(True)
		
			self.smsTextLabel.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#000000"))	# Modify label font color	
			evtb = gtk.EventBox()
			evtb.add(self.smsTextLabel)
			evtb.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#999999"))	# Modify label background color		

			pannableAreaForSMSText = hildon.PannableArea()
			pannableAreaForSMSText.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
			pannableAreaForSMSText.add_with_viewport(evtb)
			pannableAreaForSMSText.set_size_request(800,100)
			
			sendToAndSelectContactButtonHBox = gtk.HBox(False, 0)
						
			self.sendToBuffer.set_text(self.sendToNumbers)			# Retrieve remembered contact numbers, if user switches pages back and forth
			self.sendToBuffer.connect("changed",self.rememberContactNumbers)	# In case sendTo text box content has been changed, call the rememberContactNumbers function
			self.sendTo.set_buffer(self.sendToBuffer)			
			self.sendTo.connect("grab-focus", self.setCurrentTextboxInFocus, "sendTo")

			sendSMSButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			sendSMSButton.set_label(_("StrokeOrder_Send"))
			sendSMSButton.connect("clicked", self.sendSMSPreCheck, self.currentwindow)		
		
			selectContactButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			selectContactButton.set_label(_("StrokeOrder_SelectContact"))
			selectContactButton.connect("clicked", self.selectContactClicked)
			
			OneButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			OneButton.set_label("１")
			OneButton.connect("clicked", self.numpadButtonClicked, 1)
			
			TwoButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			TwoButton.set_label("２")
			TwoButton.connect("clicked", self.numpadButtonClicked, 2)
			
			ThreeButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			ThreeButton.set_label("３")
			ThreeButton.connect("clicked", self.numpadButtonClicked, 3)		
			
			FourButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			FourButton.set_label("４")
			FourButton.connect("clicked", self.numpadButtonClicked, 4)		
			
			FiveButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			FiveButton.set_label("５")
			FiveButton.connect("clicked", self.numpadButtonClicked, 5)

			SixButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			SixButton.set_label("６")
			SixButton.connect("clicked", self.numpadButtonClicked, 6)

			SevenButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			SevenButton.set_label("７")
			SevenButton.connect("clicked", self.numpadButtonClicked, 7)
			
			EightButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			EightButton.set_label("８")
			EightButton.connect("clicked", self.numpadButtonClicked, 8)

			NineButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			NineButton.set_label("９")
			NineButton.connect("clicked", self.numpadButtonClicked, 9)
			
			PlusButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			PlusButton.set_label("＋")
			PlusButton.connect("clicked", self.numpadButtonClicked, "+")
			
			ZeroButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			ZeroButton.set_label("０")
			ZeroButton.connect("clicked", self.numpadButtonClicked, "0")
			
			SemicolonButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			SemicolonButton.set_label("；")
			SemicolonButton.connect("clicked", self.numpadButtonClicked, ";")

			DelButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
			DelButton.set_label("←")   
			# DelButton.connect("clicked", self.DelClicked, window)
			DelButton.connect("button-press-event", self.delButtonPressed, window)
			DelButton.connect("button-release-event", self.delButtonReleased, window)
			DelButton.set_events(gtk.gdk.EXPOSURE_MASK |                        
   	                     gtk.gdk.BUTTON_PRESS_MASK |
   	                     gtk.gdk.BUTTON_RELEASE_MASK )
			
			sendToAndSelectContactButtonHBox.pack_start(self.sendTo, True, True, 0)						
			sendToAndSelectContactButtonHBox.pack_start(selectContactButton, False, False ,0)
			
			numpadHBox1 = gtk.HBox(False, 0)
			numpadHBox1.pack_start(OneButton,True,True,0)
			numpadHBox1.pack_start(TwoButton,True,True,0)
			numpadHBox1.pack_start(ThreeButton,True,True,0)
					
			numpadHBox2 = gtk.HBox(False, 0)
			numpadHBox2.pack_start(FourButton,True,True,0)
			numpadHBox2.pack_start(FiveButton,True,True,0)
			numpadHBox2.pack_start(SixButton,True,True,0)
			
			numpadHBox3 = gtk.HBox(False, 0)
			numpadHBox3.pack_start(SevenButton,True,True,0)
			numpadHBox3.pack_start(EightButton,True,True,0)
			numpadHBox3.pack_start(NineButton,True,True,0)
			
			numpadHBox4 = gtk.HBox(False, 0)
			numpadHBox4.pack_start(PlusButton,True,True,0)
			numpadHBox4.pack_start(ZeroButton,True,True,0)
			numpadHBox4.pack_start(DelButton,True,True,0)		
			
			numpadHBox5 = gtk.HBox(False, 0)
			numpadHBox5.pack_start(SemicolonButton,True,True,0)
			numpadHBox5.pack_start(sendSMSButton,True,True,0)
			
			numpad = gtk.VBox(False, 0)
			numpad.pack_start(numpadHBox1,True,True,0)
			numpad.pack_start(numpadHBox2,True,True,0)
			numpad.pack_start(numpadHBox3,True,True,0)
			numpad.pack_start(numpadHBox4,True,True,0)
			numpad.pack_start(numpadHBox5,True,True,0)
			
			textAndnumpadVBox = gtk.VBox(False, 0)
			textAndnumpadVBox.pack_start(pannableAreaForSMSText, True, True, 0)
			textAndnumpadVBox.pack_start(numpad, True, True, 0)				
			
			vbox.pack_start(sendToAndSelectContactButtonHBox, False, False, 0)						
			vbox.pack_start(textAndnumpadVBox, True, True, 0)		

			sendSMSPage.connect("delete_event",self.sendSMSPageClosed)
			sendSMSPage.add(vbox)
			menu = self.create_menu(sendSMSPage, "SMSPage") 
			sendSMSPage.set_app_menu(menu)				
			sendSMSPage.show_all()
		else:					
			banner = hildon.hildon_banner_show_information(window,"" , _("StrokeOrder_Error_BlankMessage"))
			
	def sendSMSPageClosed(self, widnow, widget):
		# Set the input focus back to the text area once the SMS Preview page is closed
		self.textArea.grab_focus()
	
	def rememberContactNumbers(self, widget):
		# For remembering the contact numbers when user switches back and forth the pages
		self.sendToNumbers = self.sendToBuffer.get_text(self.sendToBuffer.get_start_iter(), self.sendToBuffer.get_end_iter())	# For remembering the contact numbers when user switches back and forth the pages
	
	def numpadButtonClicked(self, window, number):
		buffer = self.sendTo.get_buffer() 
		buffer.set_text(buffer.get_text(buffer.get_start_iter(), buffer.get_iter_at_mark(buffer.get_insert()), False) + str(number) + buffer.get_text(buffer.get_iter_at_mark(buffer.get_insert()), buffer.get_end_iter(), False))
		self.sendTo.set_buffer(buffer)			
			
	def create_menu(self, window, page):
		# Create the application menu
		
		menu = hildon.AppMenu()   
		
		CopyButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		CopyButton.set_label(_("StrokeOrder_Copy"))   
		CopyButton.connect("clicked", self.CopyClicked, window)
		
		PasteButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		PasteButton.set_label(_("StrokeOrder_Paste"))   
		PasteButton.connect("clicked", self.pasteClicked, window)    
		
		AboutButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		AboutButton.set_label(_("StrokeOrder_AboutProduct"))   
		AboutButton.connect("clicked", self.aboutProduct, window)    
		
		NewButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		NewButton.set_label(_("StrokeOrder_New"))   
		NewButton.connect("clicked", self.NewClicked)			

		QueryStrokesButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		QueryStrokesButton.set_label(_("StrokeOrder_QueryStrokes"))   
		QueryStrokesButton.connect("clicked", self.queryStrokesClicked, window)			

		SpeakMandarinButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		SpeakMandarinButton.set_label(_("StrokeOrder_SpeakMandarin"))
		SpeakMandarinButton.connect("clicked", self.speakMandarinClicked, window)
		
		SpeakCantoneseButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		SpeakCantoneseButton.set_label(_("StrokeOrder_SpeakCantonese"))
		SpeakCantoneseButton.connect("clicked", self.speakCantoneseClicked, window)
		
		StopSpeakingButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		StopSpeakingButton.set_label(_("StrokeOrder_StopSpeaking"))
		StopSpeakingButton.connect("clicked", self.stopSpeakingClicked, window)
		
		SettingsButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		SettingsButton.set_label(_("StrokeOrder_Settings"))
		SettingsButton.connect("clicked", self.settingsClicked, window)			

		DonateButton = hildon.Button(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
		DonateButton.set_label(_("StrokeOrder_Donate"))
		DonateButton.connect("clicked", self.donateClicked, window)
		
		if page == "MainPage":
			NewButton.set_sensitive(True)
		elif page == "SMSPage":
			NewButton.set_sensitive(False)	# Disable button if user is using SMS page
		menu.append(NewButton)							
		menu.append(QueryStrokesButton)
		menu.append(CopyButton)
		menu.append(PasteButton)
		if self.espeakInstalled==True:
			menu.append(SpeakMandarinButton)
			menu.append(SpeakCantoneseButton)
			menu.append(StopSpeakingButton)
		menu.append(SettingsButton)
		menu.append(DonateButton)  
		menu.append(AboutButton)   		 		

		menu.show_all()
		return menu

		
	def ConvertCodeToChar(self, strokes):
		# Convert stroke input code into actual strokes for display
		s = strokes
		s = s.replace("1","一")
		s = s.replace("2","丨")
		s = s.replace("3","丿")
		s = s.replace("4","丶")
		s = s.replace("5","乛")
		s = s.replace("6",_("StrokeOrder_EngModeFull"))
		s = s.replace("7",_("StrokeOrder_SymModeFull"))
		s = s.replace("%","？")
		return s

	def ConvertCharToCode(self, strokesInChar):
		# Convert actual strokes to stroke input code in numbers
		s = strokesInChar
		s = s.replace("一","1")
		s = s.replace("丨","2")
		s = s.replace("丿","3")
		s = s.replace("丶","4")
		s = s.replace("乛","5")
		s = s.replace(_("StrokeOrder_EngModeFull"),"6")
		s = s.replace(_("StrokeOrder_SymModeFull"),"7")
		s = s.replace("？","%")
		return s
		
	def setCurrentTextboxInFocus(self, widget, textbox):
		# Set the input focus to the given text field
		self.textboxInFocus = textbox
		
	def StrokeClicked(self, StrokeButton, stroke):
		# Triggered once a stroke (1 to 5, and ? ) button is pressed.
		# Build up the stroke sequence string and submit it to queryString() to lookup the candidate characters
		
		if stroke==6 or stroke==7:	# Do not build up stroke sequence if English or Symbol button is pressed
			self.strokesCodeInputted = str(stroke)			
		elif ("6" in self.strokesCodeInputted or "7" in self.strokesCodeInputted) and stroke!=8:
			self.strokesCodeInputted = str(stroke)
		elif stroke==8:
			if ("6" in self.strokesCodeInputted or "7" in self.strokesCodeInputted):
				self.strokesCodeInputted = "%"
			else:
				self.strokesCodeInputted = self.strokesCodeInputted + "%"
		else:
			self.strokesCodeInputted = self.strokesCodeInputted + str(stroke)
		
		self.strokesInputted.set_text( self.ConvertCodeToChar(self.strokesCodeInputted) )	# Display the inputted strokes	
		self.queryString(self.strokesCodeInputted)
		
	def pasteClicked(self, PasteButton, window):
		# Triggered when user clicks the Paste button from the menu
		clip = gtk.Clipboard()
		data = clip.wait_for_contents('UTF8_STRING')
		text = str(data.get_text())
		if text != "" and text != None and text != "None":
			if self.textboxInFocus == "textArea":
				buffer = self.textArea.get_buffer()
			elif self.textboxInFocus == "sendTo":
				buffer = self.sendTo.get_buffer() 
				
			selectedText = buffer.get_selection_bounds()
			if selectedText!=(): # If there is selected text, delete the selected text
				buffer.delete_selection(True,True)
			buffer.insert(buffer.get_iter_at_mark(buffer.get_insert()), text)		
	 
			if self.textboxInFocus == "textArea":
				self.textArea.set_buffer(buffer)
				self.textArea.grab_focus()
			elif self.textboxInFocus == "sendTo":
				self.sendTo.set_buffer(buffer)
				self.sendTo.grab_focus()
	
	def CharSelected(self, Selector, column):
		# Triggered once a candidate / English / Numeric / Symbol character is selected from the TouchSelector control.
		# Send the selected text to the text area.
		conObj = IOConnection()		
		conObj.start()
		con = conObj.connectIMDB()		
		cur = con.cursor()
		text = Selector.get_current_text()
		
		if (self.vKB == True) or (self.vNP == True):	# Handle English Case
			offset = self.textAreaBuffer.get_iter_at_mark(self.textAreaBuffer.get_insert())
			OriginalCharKey = unicode(self.textAreaBuffer.get_text(self.textAreaBuffer.get_start_iter(), offset),"utf-8")[-1]
		
		buffer = self.textArea.get_buffer()
		buffer.insert(buffer.get_iter_at_mark(buffer.get_insert()), text)
		self.textArea.grab_focus()				
				
		if (not "6" in self.strokesCodeInputted and not "7" in self.strokesCodeInputted) or (self.vKB == True) or (self.vNP == True):
			text = unicode(text, "utf-8")		

			if (self.vKB == True) or (self.vNP == True):	# Handle English Case				
				cur.execute("UPDATE Assoc SET Frequency=(SELECT Frequency FROM Assoc WHERE CharKey='" + OriginalCharKey + "' AND Phrase='" + text + "' LIMIT 1)+1 WHERE CharKey='" + OriginalCharKey + "' AND Phrase='" + text + "';")	# Increment the frequency by 1 so that next time the same phrase can be shown earlier
				# print "Frequency of Associated Phrase CharKey=" + OriginalCharKey + " and text = " + text + " is incremented by 1."
				
			elif self.strokesInputted.get_text().find(_("StrokeOrder_SelectAssoc1")) > -1 and self.strokesInputted.get_text().find(_("StrokeOrder_SelectAssoc2")) > -1: # For Chinese case, if selected phrase was from an associated phrase...
				if conObj.getKeyValue(conObj.settingsDOM,"UseCustIMDB") == "True" and conObj.getKeyValue(conObj.settingsDOM,"AssocCustOrder") == "True":	
					OriginalCharKey = self.strokesInputted.get_text().replace(_("StrokeOrder_SelectAssoc1"),"").replace(_("StrokeOrder_SelectAssoc2"),"") # Obtain the original Character Key
					cur.execute("UPDATE Assoc SET Frequency=(SELECT Frequency FROM Assoc WHERE CharKey='" + OriginalCharKey + "' AND Phrase='" + text + "' LIMIT 1)+1 WHERE CharKey='" + OriginalCharKey + "' AND Phrase='" + text + "';")	# Increment the frequency by 1 so that next time the same phrase can be shown earlier
					# con.commit()
					# print "Frequency of Associated Phrase CharKey=" + OriginalCharKey + " and text = " + text + " is incremented by 1."
			else:	# type strokes and then select single character
				if conObj.getKeyValue(conObj.settingsDOM,"UseCustIMDB") == "True" and conObj.getKeyValue(conObj.settingsDOM,"CandCustOrder") == "True":
					OriginalStrokes = self.ConvertCharToCode(self.strokesInputted.get_text())
					cur.execute("UPDATE StrokeOrder SET Frequency=(SELECT Frequency FROM StrokeOrder WHERE Strokes LIKE '" + OriginalStrokes + "%' AND Character='" + text + "' LIMIT 1)+1 WHERE Strokes LIKE '" + OriginalStrokes + "%' AND Character='" + text + "';")	# Increment the frequency by 1 so that next time the same character can be shown earlier
					# con.commit()					
					# print "Frequency of character " + text + " with Strokes beginning with " + OriginalStrokes + " is incremented by 1."
			if len(text)>1:	# Use the last character of the phrase if the length of the selected phrase is > 1
				text = text[-1]

			con.close()				
			if (self.vKB == False) and (self.vNP == False):
				self.strokesInputted.set_text(_("StrokeOrder_SelectAssoc1") + text + _("StrokeOrder_SelectAssoc2"))	# Clear the stroke display area once the text is inserted
			self.strokesCodeInputted = ""
			self.queryString("")
			self.queryAssoc(text)
	
	def CopyClicked(self, CopyButton, window):
		# Copy the text area content to the clipboard
		clipboard = gtk.Clipboard()
		if self.textboxInFocus == "textArea":
			buffer = self.textArea.get_buffer()
		elif self.textboxInFocus == "sendTo":
			buffer = self.sendTo.get_buffer()
			
		selectedText = buffer.get_selection_bounds()
		if selectedText==():	# If some text is selected, copy the selected text to clipboard only
			textToBeCopied = buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter(), False)
		else:	# If no text is selected, copy all the contents in the text area
			textToBeCopied = buffer.get_text(selectedText[0], selectedText[1], False)
		clipboard.set_text(textToBeCopied)
		clipboard.store()
		dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, "「" + textToBeCopied + "」 " + _("StrokeOrder_HasBeenCopied")) 
		response = dialog.run()
		dialog.destroy()	

	def delButtonPressed(self, button, event, window):
		# Insert appropriate character when user clicks the key
		if not (self.delKeyDown==True and self.delKeyUp==False):
			self.DelText(button, window)
			
		self.delKeyDown = True
		self.delKeyUp = False
		
		gobject.timeout_add(300, self.checkDelKeyPress, button, window)
		
	def delButtonReleased(self, button, event, window):		
		self.delKeyDown = False
		self.delKeyUp = True

	def checkDelKeyPress(self, LeftButton, window):
		if self.delKeyDown==True and self.delKeyUp==False:
			self.DelText(LeftButton, window)
			return True
		else:
			return False

	def DelText(self, LeftButton, window):	
		# Delete the previous character when Del button is clicked
		if self.textboxInFocus == "sendTo":		# Set buffer according to current input focus
			buffer = self.sendTo.get_buffer()			
		elif self.textboxInFocus == "textArea":
			buffer = self.textArea.get_buffer()
			
		if len(self.strokesCodeInputted) > 0:	# If strokes sequence is not blank, delete stroke from the sequence first
			self.strokesCodeInputted = self.strokesCodeInputted[0:len(self.strokesCodeInputted)-1]
			self.queryString(self.strokesCodeInputted)
			self.strokesInputted.set_text( self.ConvertCodeToChar(self.strokesCodeInputted) )
		else:						
			selectedText = buffer.get_selection_bounds()
			if selectedText==():	# If there is no selected text, issue a Backspace keystroke
				offset = buffer.get_iter_at_mark(buffer.get_insert())
				buffer.backspace(offset,True,True)
			else:	# If there is selected text, delete the selected text
				buffer.delete_selection(True,True)

	def refreshCharLeft(self, widget):
		# Recalculates the number of characters left in the current message, and the number of messages to be sent out
		msg = unicode(self.textAreaBuffer.get_text(self.textAreaBuffer.get_start_iter(), self.textAreaBuffer.get_end_iter(), False),"utf-8")
		charactersLeft = ( 70 * ( len(msg) / 70 + 1 ) ) - len(msg)
		msgCount = len(msg) / 70 + 1
		self.charLeft.set_text( str( charactersLeft ) + "(" + str(msgCount) + ")" )

		if self.vKB==True or self.vNP==True:
			offset = self.textAreaBuffer.get_iter_at_mark(self.textAreaBuffer.get_insert())
			msgForAssoc = unicode(self.textAreaBuffer.get_text(self.textAreaBuffer.get_start_iter(), offset),"utf-8")[-1]
			# print "msgForAssoc=" + msgForAssoc
			self.queryAssoc(msgForAssoc)
							
	def NewClicked(self, widget): 
		# Reset everything back to the very beginning
		text = ""
		buffer = self.textArea.get_buffer()
		buffer.set_text(text)
		self.textArea.set_buffer(buffer)
		
		buffer = self.sendTo.get_buffer()
		buffer.set_text("")
		
		self.smsTextLabel.set_text("")
		
		self.strokesCodeInputted = "6"
		self.queryString(self.strokesCodeInputted)
		
		self.strokesInputted.set_text( self.ConvertCodeToChar(self.strokesCodeInputted) )	# Display the inputted strokes
				
	def selectContactClicked(self, widget):
		# Pops up the Address Book, select a contact and phone number will be inserted to the phone number text field
		start, end = self.sendToBuffer.get_bounds()
		oldbuffer = self.sendToBuffer.get_text(start, end)
		osso_abook = ctypes.CDLL('libosso-abook-1.0.so.0')
		argv_type = ctypes.c_char_p * len(sys.argv)
		argv = argv_type(*sys.argv)
		argc = ctypes.c_int(len(sys.argv))
		osso_abook.osso_abook_init(ctypes.byref(argc), ctypes.byref(argv),
								   hash(self.osso_ctx))
		c_chooser = osso_abook.osso_abook_contact_chooser_new(None, _("StrokeOrder_SelectContact"))
		chooser = self.capi.pygobject_new(c_chooser)
		hildon.hildon_gtk_window_set_portrait_flags(chooser, hildon.PORTRAIT_MODE_SUPPORT)

		chooser.run()
		chooser.hide()

		contacts = osso_abook.osso_abook_contact_chooser_get_selection(c_chooser)
		glib = ctypes.CDLL('libglib-2.0.so.0')

		def glist(addr):
			class _GList(ctypes.Structure):
				_fields_ = [('data', ctypes.c_void_p),
							('next', ctypes.c_void_p)]
			l = addr
			while l:
				l = _GList.from_address(l)
				yield l.data
				l = l.next

		for i in glist(contacts):
			c_selector = osso_abook.osso_abook_contact_detail_selector_new_for_contact(c_chooser, i, 2) 	

			selector = self.capi.pygobject_new(c_selector)
			hildon.hildon_gtk_window_set_portrait_flags(selector, hildon.PORTRAIT_MODE_SUPPORT)
			selector.run()
			selector.hide()

			c_field = osso_abook.osso_abook_contact_detail_selector_get_selected_field(c_selector)
			get_display_value = osso_abook.osso_abook_contact_field_get_display_value
			get_display_value.restype = ctypes.c_char_p
			finalval = osso_abook.osso_abook_contact_field_get_display_value(c_field)
			# print oldbuffer
			if oldbuffer == "":
				if finalval != None:
					self.sendToBuffer.set_text(str(finalval))
			else:
				if finalval != None:
					newbuffer = oldbuffer +";" + str(finalval)
					self.sendToBuffer.set_text(newbuffer)
		
	def sendSMSPreCheck(self, widget, window):
		# Before sending out SMS, detect long message and break it down into multiple ones.
		start, end = self.textAreaBuffer.get_bounds()
		text = unicode(self.textAreaBuffer.get_text(start,end), "utf-8")
		start, end = self.sendToBuffer.get_bounds()
		number = self.sendToBuffer.get_text(start,end)
		
		if text=="":			  
			banner = hildon.hildon_banner_show_information(window,"" , _("StrokeOrder_Error_BlankMessage"))
		elif number == "":	# If phone number is not specified...
			banner = hildon.hildon_banner_show_information(window,"" , _("StrokeOrder_Error_NoContact"))
			# print "Error, no number specified!"
		else:
			msglength = len(text)
			for i in range(1, msglength/70+2 ):
				textToBeSent = text[(i*70-70):(i*70)]
				self.sendSMS(widget, window, textToBeSent )
				# print "Loop: " + str(i)
				# print "Message length: " + str(msglength)
				# print "Total no. of messages to be sent: " + str(msglength/70+1)
				# print "Text to be sent:\n" + textToBeSent
			os.system("sudo pkill -f rtcom-messaging-ui")

	def sendSMS(self, widget, window, text):
		# Send SMS to the specified recipient(s)
		
		start2, end2 = self.sendToBuffer.get_bounds()
		fullnumber = self.sendToBuffer.get_text(start2,end2)
		number = fullnumber.replace("+","").replace(" ","") 		
		if number == "":	# If phone number is not specified...
			  note2 = _("StrokeOrder_Error_NoContact")
			  banner = hildon.hildon_banner_show_information(window,"" , note2)
			  # print "error, no number specified!"
		elif text == "":	# If text area is blank...
			  note3 = _("StrokeOrder_Error_BlankMessage")
			  banner = hildon.hildon_banner_show_information(window,"" , note3)
			  # print "error, message is empty!"
		else:	# If message is valid....
			confirm = hildon.hildon_note_new_confirmation(window, _("StrokeOrder_Confirm_SendMessage") + "「" + text + "」？")
			response = gtk.Dialog.run(confirm)
			gtk.Dialog.hide(confirm)
			# print "response was: " +str(response)

			if response == gtk.RESPONSE_DELETE_EVENT:
				print "Sending cancelled"
			elif response == gtk.RESPONSE_OK:
				
				if number.isdigit():                
					note = _("StrokeOrder_SendingSMSTo") + number
					banner = hildon.hildon_banner_show_information(window,"" , note)
					sendSMScmd = "python /opt/StrokeOrder/sendSMS.py " + str(number) + " \"" + text.replace("\"","”").replace("'","’").replace("\\","＼").replace("`","‘") + "\""
					# print sendSMScmd
					os.system(sendSMScmd)
				else:	# If there are more than one recipients, loop through the recipient list and send the message to all of them.
					numb = number.split(";")
					i=0
					while i < len(numb):
						note = _("StrokeOrder_SendingSMSTo") + numb[i]
						banner = hildon.hildon_banner_show_information(window,"" , note)
						sendSMScmd = "python /opt/StrokeOrder/sendSMS.py " + str(numb[i]).replace("+","").replace(" ","") + " \"" + text.replace("\"","”").replace("'","’").replace("\\","＼").replace("`","‘") + "\""
						# print sendSMScmd
						os.system(sendSMScmd)						
						i = i+1
						time.sleep(5)
	
	def app_preclose(self, widnow, widget):
		# Close database connection before closing the application.
		# self.con.close()
		gtk.main_quit(None)
		
if __name__ == "__main__":	
#	checkInstanceCMD = "ps | grep \"python /opt/StrokeOrder/StrokeOrder.py\" | wc -l"
#	fin,fout = os.popen4(checkInstanceCMD)
#	checkInstanceResult = str(fout.read().replace("\n",""))	
#	if checkInstanceResult=="2":	# If only two matches found, i.e. one for the grep command and another one the program itself, continue program execution
#		StrokeOrder()
	StrokeOrder()