#!/usr/bin/env python
#coding=utf-8

import osso
import sys
import gtk
import hildon
import sqlite3
import os
import xml.dom.minidom
import xml.parsers.expat
from threading import Thread

class IOConnection(Thread):
# This class contains the settings file I/O methods as well as SQLite database connection related methods. Ready for multi-threading.

	settingsDOM = xml.dom.minidom.parseString("<?xml version=\"1.0\"?><Settings><UseVirtualKB>" + str(True) + "</UseVirtualKB><UseCustIMDB>" + str(True) + "</UseCustIMDB><CandCustOrder>" + str(True) +"</CandCustOrder><AssocCustOrder>" + str(True) + "</AssocCustOrder></Settings>" )
	
	# This method creates a directory for the settings file under MyDocs/ , or returns true if it is already created
	def makedir(self,dirname):
		if os.path.isdir(dirname):
			return True
		elif os.path.isfile(dirname):
			return False
		else:
			head, tail = os.path.split(dirname)
			if head and not os.path.isdir(head):
				self.makedir(head)
			if tail:
				os.mkdir(dirname)
		return True

	# This method returns a default setting XML string
	def getDefaultSettingsXML(self):
		defaultSettingsXML = "<?xml version=\"1.0\"?><Settings><UseVirtualKB>" + str(True) + "</UseVirtualKB><UseCustIMDB>" + str(True) + "</UseCustIMDB><CandCustOrder>" + str(True) +"</CandCustOrder><AssocCustOrder>" + str(True) + "</AssocCustOrder></Settings>" 
		return defaultSettingsXML
		
	# This method writes the default settings to the actual XML file
	def writeDefaultSettingsXML(self):
		self.settingsDOM = xml.dom.minidom.parseString(self.getDefaultSettingsXML())
		self.settingsFile = open("/home/user/MyDocs/.StrokeOrder/settings.xml", "w")
		self.settingsFile.write(self.settingsDOM.toxml("UTF-8"))
		self.settingsFile.close()

	# This method writes the currently selected settings to the actual XML file 
	def writeSettingsXML(self,UseVirtualKB,UseCustIMDB,CandCustOrder,AssocCustOrder):
		self.SettingsXML = "<?xml version=\"1.0\"?><Settings><UseVirtualKB>" + str(UseVirtualKB) + "</UseVirtualKB><UseCustIMDB>" + str(UseCustIMDB) + "</UseCustIMDB><CandCustOrder>" + str(CandCustOrder) +"</CandCustOrder><AssocCustOrder>" + str(AssocCustOrder) + "</AssocCustOrder></Settings>" 
		self.settingsFile = open("/home/user/MyDocs/.StrokeOrder/settings.xml", "w")
		self.settingsFile.write(self.SettingsXML)
		self.settingsFile.close() 

	# This method takes in the setting XML DOM object and the name of a node, and then returns the value of that node.
	def getKeyValue(self, settingsDOM, key):
		returnValue = ""
		for node in self.settingsDOM.getElementsByTagName(key)[0].childNodes:
			if node.nodeType == node.TEXT_NODE:
				returnValue = returnValue + node.data
		return returnValue
		
	def connectIMDB(self): # Connect to user's customized database or system's default database, based on the value stored in the settings file			
		try:
			if self.makedir('/home/user/MyDocs/.StrokeOrder') == True:
				self.settingsDOM = xml.dom.minidom.parse('/home/user/MyDocs/.StrokeOrder/settings.xml') # parse the settings XML and returns the XML DOM object	
		except xml.parsers.expat.ExpatError: # displays error message in case of parse error
				self.writeDefaultSettingsXML()
				self.settingsDOM = xml.dom.minidom.parseString(self.getDefaultSettingsXML())
		except IOError: # displays error message in case of file I/O error
				self.writeDefaultSettingsXML()
				self.settingsDOM = xml.dom.minidom.parseString(self.getDefaultSettingsXML())
				
		if self.getKeyValue(self.settingsDOM,"UseCustIMDB") == "True":
			if os.path.exists("/home/user/MyDocs/.StrokeOrder/IM.db") == False:
				try:
					if self.makedir('/home/user/MyDocs/.StrokeOrder') == True:	# Copy default IM.db to user's folder if it doesn't exist
						copycmd = "cp /opt/StrokeOrder/IM.db /home/user/MyDocs/.StrokeOrder/"
						os.system(copycmd)
						print "IM.db copied to /home/user/MyDocs/.StrokeOrder/"
				except IOError: # displays error message in case of file I/O error
					dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("StrokeOrder_ResetIMDBFailed")) 
					response = dialog.run()
					dialog.destroy()										
			con=sqlite3.connect("/home/user/MyDocs/.StrokeOrder/IM.db",5,0,None)	# Connect to the customized stroke lookup database			
			print "User's customized IM.db is being used."
		else:
			con=sqlite3.connect("/opt/StrokeOrder/IM.db",5,0,None)	# Connect to default stroke lookup database	
			print "System's default IM.db is being used."

		con.text_factory=str
		# cur = con.cursor()
		return con