#!/usr/bin/env python
#coding=utf-8

import osso
import sys
import gtk
import hildon

class key():
		
	def __init__(self, character="", textArea=None):		
		self.character = character
		self.button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		if character==" ":
			self.button.set_label("└┘")
		elif character=="\n":
			self.button.set_label("<┘")
		else:
			self.button.set_label(character)
			
		self.textArea = textArea		
		self.handler_id = self.button.connect("clicked", self.buttonClicked, self.character, self.textArea)		
	
	def swapCase(self):
		self.button.disconnect(self.handler_id)
		self.character = self.character.swapcase()
		self.button.set_label(self.character)		
		self.handler_id = self.button.connect("clicked", self.buttonClicked, self.character, self.textArea)		
	
	def buttonClicked(self, button, character, textArea):
		buffer = textArea.get_buffer()
		buffer.insert(buffer.get_iter_at_mark(buffer.get_insert()), character)
		textArea.grab_focus()
		
	def getButton(self):
		return self.button