CREATE TABLE StrokeOrder(Strokes TEXT,Character TEXT,Frequency NUMERIC);
CREATE INDEX StrokeOrder_FrequencyDESC_Idx ON StrokeOrder(Frequency DESC);
CREATE INDEX StrokeOrder_StrokesASC_Idx ON StrokeOrder(Strokes ASC);

INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1','一',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11','二',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111','三',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1111','亖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111154','弎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111154','弐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112','丰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11121112511','彗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111211125114334','熭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111211125114544','慧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111213251','砉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11121325122','剨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112145','匤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111215','匡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11121535','劻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11121552','邼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111221112521251431','豐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112211125212514311215425221','豔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111221112521251431134425221','豓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111221112521251431355215','艷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112211125212514314351523','豒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11122111252125143152','酆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234','耒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123411212511134','耫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112341122125121','耩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112341132','耕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112341154','耘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123412','耓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123412212511','耤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112341223241112154','耯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112341224535','耢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112341311534124','耨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234132511134','頛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234132511454544354','耰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112341515','耟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112342343','耖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123424325251','耥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123425111','耝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112342511135','耡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123425112512531','耬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234251125214','耦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123425151','耜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112342522112154','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234252215425113535','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112343115','耗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234341251','耠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123434125122','耣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123435251','耞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112344125221241343534','耲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112344131234123413251','耱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112344143454135','耪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234431234531','耧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234433443344535','耮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234521','耔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112345215','耙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123453254','耚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11123454251','耛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111234554554134543','耭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112355215','艳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111251113454','貳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112531234','栔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111253134','契',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111253212134341343452','齧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111253251214','蛪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112532534','洯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112533112','挈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112533535112','觢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111253454','贰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1112534544','恝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111253554234','絜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1113124','寿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11131244444','焘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11132515215','邫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11134','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11134112','奉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111341134','奏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1113424134','泰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111342511','春',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111342511251214251214','蠢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1113425114544','惷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1113431234','秦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11134321511','舂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111343215114544','憃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111352','邦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('111352252','帮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11135232511252','幚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11154','弍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112','亍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112','于',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112','干',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121','王',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211112','玤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112111134112','琫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121111342511','瑃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211113431234','瑧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121112','玕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121112','玗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211121','玨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211121112145443','璱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112111211234','琹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112111211535','琵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112111212154','珷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121112134','珡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112111213445','琴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211121353134','璈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112111214','珏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121112145443','瑟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112111215215','琶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121112155144','瑇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211132454','琎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211134','玞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121113411342511134','瓉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211135','玩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211152','玮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112','玎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121121','玒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121121121','珪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211211254444','瑪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121121252212511134','瓄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112132511','琽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121121335','珯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112151211251124','璹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121121512112511244444','瓙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112154','珐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112211','玵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121122111','珥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112211134','琪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112211134121','璂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112211152','瑘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211221122112','璍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211221215425221','瓂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112212511121','瑾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112212512134','璜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112212523434','璊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121122134','珙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112215','玴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121122155125121','璢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112225125132411121','瓘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112225134','瑛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211223123453','璓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211223241112154','瓁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211223411234','瑹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121122352513134','璥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211224312511','瑨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211225111134','瑱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121122513511','瑚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112341234','琳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211234123452134','璴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112343434','琜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211241344','球',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211241352211535','麉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211251112454','璉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112511214124','瑼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121125112144544','璤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121125112441353134','璷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112511543','琙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112512','珂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211251234352511134','瓎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211251251','珸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112112512531425221','璼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211252211234','瑮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121125431234','瑓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121131251543','瑊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121131543','珬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121132','弄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211324','环',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121132511','珛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121132511134','頊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121132511454544354','瓇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121132521','珔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121132522134','瑌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121132534','顼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211331234312342121','瓑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112113412512','琦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121134432511234','璙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112113533434','琢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112113543','珑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121135543','珹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112114312','玶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112114524444132522','瓀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121151','玙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211512454','琏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211523','玡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121152352','琊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211535','玭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121153532511','瑎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112115431543','琖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11211554','珁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121112111','琲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121211212','鬥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121211212122134','鬨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212112121251431124','鬪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212112122151525151213312','鬭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121121232151135','鬩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121121232511255115115341','鬮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121211212351255151213312','鬬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121121241252','鬧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212112124412','鬦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121121251221113134','鬫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121123454','琡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121212135','玼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121251','玷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121251112','琸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212135454431234','璨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121451343425111','璿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121531512512543121344','瓛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212153151353334','璩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212153152512125221','瓐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112121531535','琥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212154','武',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121215421531535','虣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121215432511154444','鵡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121215435451','鹉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121224314311134','璞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121243135','珖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212432511','琑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212432511134','瑣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212432534','琐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212434525125121','璫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112124345251252','瑺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121243511','珰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511','青',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125111','珇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511121','珵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511121','理',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251112134','瑅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511134','珼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511134','責',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125111342511134531','瓔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251113435','勣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511135','現',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251113533','瑒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125111535','琨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125112','玾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125112','珅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511243135','靗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125112511','琩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251125111','瑁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125112511125431234','瓓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125112511135','靚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251125221','瑥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125112535','靓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251131121','瑆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125113115','靔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125113115431234','靝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251132511154444','鶄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251134435112','靜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251135451','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511355112','静',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212511355215','靘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251141251234','璟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125114134','琝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251144512134','靛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251152','郬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125121','珃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212512121354251','璐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251212511134','璝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251212512125121','瓃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212512134','珿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251213432','琾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125122134','琠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212512511','琄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212512512511234','璪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121251341','珚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212521','靑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121252132522','瑞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212522112513534','環',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212522125111345','匵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125232411121','璀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121252324111212534251','瓗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212523445','琌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212534','责',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112125342534531','璎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11212535','现',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213112','玝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112131121','珄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121311222214444','璑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121311234','珠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213112342511134','璳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121311252','珤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121312135','珗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213121353121352511134','瓚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213121353121352534','瓒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121312154','珽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213121543','珴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213123422','琍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121312343533424134','瓈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213123453','琇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213134','玫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213152134','琁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213155144','珻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121321113554','瑖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213211152511134','璵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132154','玳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121322','玔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132411121','琟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132411121454','璡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132511','珀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121325111121','瑝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213251113251','碧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132511134','頇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132511154444','鳿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121325112534','瑔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132511312','琕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121325113554','瑰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213251141353134','璬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213251154444','瑦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121325115545541234','瓅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121325125214','瑀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213251511252','瑡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121325251','珦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132534','顸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112132535414544','璁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121331233122511134','瓆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121332112','珩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112133234342134','瑽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121335144','珘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112134','兲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112134','玐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112134112431','琻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121341251','珨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121341251122','瑜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213412524312511','璯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121341534','珧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121343123425121','璠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213432','玠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112134333','珍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121344311354','瑗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213443311252','瑶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213443321511','瑫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213443451354','瑷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213443454544354','璦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213443521','琈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213445','玪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213445113251','瑲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213445251','琀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112134454','玲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213453','玢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213454','玜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213455','玱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135','玏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135','玑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213511','玥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135121251','琱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121351252','珮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121351354','珟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135152511','琘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135234','珎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135251','玽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135251','珈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121352511','珣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121352534134','瑍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135253425111354','瓊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134','敖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213531341211254444','驁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134122111','聱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213531341344','獒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134251','嗸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213531342511134','贅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213531342511251211511','鼇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134251214','螯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134252','嶅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213531342534','赘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135313432511154444','鷔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135313434112431','鏊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135313435251211','鳌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135313435251214444','鰲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213531344111251','謷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213531344444','熬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134454','遨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134531','嫯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353134551','骜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213534','表',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135351','珊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135352','珋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121353535','珕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121354','玓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121354','玖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121354','麦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213541','玬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213541112','琒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213541134','麸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121354132522111','麺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121354251','珞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135435431234','麹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213544311252','瑤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11213545325121','瑠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121355112','琤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112135515','玸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214','玉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214','玊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214111251','琂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214124','玣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141251234','琼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141251251112213534','瓖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214125221241343534','瓌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214125251125111','璮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214134','玟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141341121','斑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214134333','珳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121413434','珓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141343412','琗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214134522554','璃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214135112251','瑭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141353152134','璇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141431251','琣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141431251112','璋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141431251121515111','瓏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141431251135','璄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141432512251454','瓋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141432533543211','璾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214154325','琉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121415435','珫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112141554','玹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121431112','珜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121431113121','瑳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214311135','琷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121431121','班',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121431234354152','璘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121431251122','瑐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214313252','琋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121431353334454','璲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121432524312511','璔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112143344334','琰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214351523','珶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144112154','琺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144115151234','璖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121443531','珱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144511234','琮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214451135','琓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144512134','琔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144512332511134','璸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121445125111','瑄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144512512134','璌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144525151','琯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214453212134','瑸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121445341523','瑏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214453434251','瑢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112144535455','琬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11214511534','琅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112145115452','瑯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121451251112','琿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121451251112454','璭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121451512','珲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112145341234','琛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121454','迋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112145443','珌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11215','匞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11215','玌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121511112','珒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121511121251124','璕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112151121444425221','璶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11215112321155212','璛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112151124134','琭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11215113251','珺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121511534','珢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121512115154','瑕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112151312251','琚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11215134','玦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121515','玘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112151515','珉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121515152511','瑉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121521251152','瑋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112152131212511454','瓍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121521325111','瑂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112153251','玿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112153254','玻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121533','玚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11215331343112','摮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112154','丟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112154','式',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121541541','珝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112154154134333','璆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112154154141343412','璻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112154251','珆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121543341251431','璒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11215435','玧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121544251214','瑵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121545231234','瑈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121545232534251','璚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121551','玛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121551311341535','璏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121551353334','瑑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112155144','毒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112155212511112343554234','纛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112155212511134','瑻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121554234','素',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112155423421251112','繛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121554554134543','璣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112155525111234','璅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1121555325431','瑙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11221154','甙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1122125121','冓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1122125121132511134','顜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11221251212511135','覯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11221251212535','觏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11221251214412','斠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1122125121454','遘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1122132515','匿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11221325154544','慝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11222','刊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1122324111213215115','匶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11225221','盂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1123134','攼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11232511154444','鳱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11234','未',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11234','末',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11234','示',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1123411234','祘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11234135543253434','膥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1123425135','唜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1123431341312343434','斄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112343134132511121','釐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112343134132534','漦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112343134133112','犛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112343134133115','氂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11234313413521','孷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1123431341353','剺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11234313413531','嫠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112345','礼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11243342511135','覝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112454','迀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('112454','迂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11251112355','匭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11251113454','貮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11252','击',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11252','邗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11252','邘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113112','幵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1131121234','栞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11311252','郉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1132','亓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1132','井',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1132','开',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1132121','坓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113222','刑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113222121','型',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11322534','汬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113232411121','雃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113232511154444','鳽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1132333','形',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11324','丼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11324334','烎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1132454','进',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113251113251134','奭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113252','邢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11325344','刱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1132543','戒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1134','天',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1134','夫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113411341251112','輦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11341134125111252','鄻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113411341512','辇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113411342511','替',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113411342511134','賛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11341134251113452','鄼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113411342511251214251214','蠺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11341134251214','蝅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113424134','沗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11342444','忝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1134251','吞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11342511','昋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11342511135','規',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113425111351234','槼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113425111351251254312','鬹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11342511135531','嫢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113425113511','奣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1134251214','蚕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11342512512515','匲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11342535','规',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113425351234','椝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113425351251254312','鬶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113432511154444','鳺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113432511154444','鴌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113434345','匧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1134454','迗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113452','邞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1135','元',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1135','无',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1135121','坖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1135132511134','頑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1135132534','顽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113522','刓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11352511251211511','黿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113525125115','鼋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113543','戎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1135454','远',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113552','邧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('113554251','兘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('114544','忈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('115','亏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('115','亐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11512355','匦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1152','韦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('115213544','韨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1152251125221','韫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11523443321511','韬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1152454','违',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11525121251124','夀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1152534','韧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1154','专',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1154','云',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1154','弌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11543','戋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1154322','刬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1154325113554','魂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1154325221','盏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('11543443451354','叆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('115435','动',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1154454','运',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('115451124134454','叇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('115454','迃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12','丁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12','丅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12','十',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121','土',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121','士',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121','工',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121','扌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111112','拝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121111253134','揳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111134112','埲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111134112','捧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121111341134','揍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121111342511','堾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211113431234','搸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111134321511','摏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121111352','垹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121111352','挷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121112','圩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121112','扜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121112','扞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211121','抂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211121115','匪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211121132','挵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111212511','埥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111212511','掅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121112154','拭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211121554234','塐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211122125121','搆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111234','抹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111234','抺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121112343534','款',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211123451124134','隷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211134','扶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121113411341251112','攆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121113411341512','撵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121113411342511134','攅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111342444','掭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111342511135','摫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211135','坃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211135','抏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211135','抚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115','圬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115','扝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111534','長',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154','坛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154','抎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154','抟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154','镸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115413425243434343','镾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154134432511234','镽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111541554','瓺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115431134','镻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543134','镺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333','髟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333111342511','鬊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543331135','髨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333121251','髻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543331213352511','鬐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333122111','髶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433312212523434','鬗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333122134','髸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433312215','髰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543331222511134','鬕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543331225111134','鬒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333122513511','鬍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543331234','髤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433312343454','鬆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333125123422','鬎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543331255','髩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333131212511','鬌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433313241','髬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333132522','髵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333135','髡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543331354','髪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433313544','髮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333212135','髭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543332432511','髾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543332511','髥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333251125112511','鬝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333251125113511','鬜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433325112522154','鬘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433325113533','鬄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433325121','髯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333251221','髷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543332512211311534','鬞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543332522112513534','鬟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333115','髦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333312251','髺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333123422','鬁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333312344334','鬏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333212134','鬂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333321234','髹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333254315445445','鬛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333333132511134','鬚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333412524312511','鬠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333434121','髽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433335','髠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433335113511','鬅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333541112','髼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543333541112454','鬔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333355112','鬇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433335515','髱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433341251251112213534','鬤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543334135','髣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433343113455','鬈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333431251122','鬋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543334315112234','鬑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333432524312511','鬙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543334351523','鬀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333435234354','鬉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543334412343','髿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433344511234','鬃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433344512332511134','鬢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543334453212134','鬓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433344545442522112','鬡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12111543334535','髧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433351532','髴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333525','髢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433353251','髫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433353254','髲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433354523','髳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115433354545434333','鬖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154333555254315445445','鬣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154354','镹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211154511112','肆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121115451352252','镼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112','圢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112','打',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121','圭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121','扗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121','扛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112111534','掁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121','垚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121','壵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121','挂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121121135','墝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121121135','撓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121135','堯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121135132511134','顤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121135454','遶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121121135541541','翹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112112124','掛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121124','封',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121124','持',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121124121','堼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121124122125112','鞤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121124252','幇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211211243112','犎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112112432511252','幫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121154','奊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112121154444','墕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112122','刲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121222511134','墳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112124','卦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121251','拮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211212511134','摃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211212511251211511','鼃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121251132511134','擷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121251132534','撷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112125145154121','擡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211212515215','郌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121315','拷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211213234','捇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112132411121543','擮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112132511','堵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211213352511','搘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112134354','堎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112134354','掕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112135','劸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121431112454','墶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121431112454','撻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121121451251431','撎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211214544','恚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112151211251124','壔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112151211251124','擣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112152','邽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112154','抾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211215425221','搕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112155121','埡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112155121','掗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112211','坩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112211','拑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122111','挕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122111122111122111','攝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112211134','掑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122111343312','撕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122111345','堪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122111345','揕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112211134535','墈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211221114134','摂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112211152','揶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112211154','掫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211221115454','摄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112211155455453212','壣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211221122112','墷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211221122112','撶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112212132511','墸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112212132511','擆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211221215425221','壒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122122112','搑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122122151234','擛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112212511','措',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112212511121','墐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211221251113432411121','攤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122125111343534','擹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122125113134','撒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112212512134','墴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112212512134','撗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112213251','掿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122134','垬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122134','拱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211221342444','塨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122134515','塂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112215','抴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122151234','堞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122151234','揲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211222511134','塻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211222511134','摸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122251135345','擖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112225121','描',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112225125132411121','壦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211223235','埖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211223241112154','擭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122341234','搽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122341251','塔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122341251','搭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122352513134','擏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112235445411234','攃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122415325','塃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122431','垭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122431','挜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211224312511','搢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211224535','捞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112251111','埴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211225111134','填',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211225111134','搷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211225111134132511134','攧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122511121543','撠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112251112315','墘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211225111234112','擀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211225221413534','壊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121122543112','揇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211225431121344','擜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121123425111','揸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211234341252511','墻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211234543','栽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121124','圷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121124','寺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211241344','捄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112431252511','墙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121124454','挝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112452','邿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211245521','挬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125111','垣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251112','捙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251112112','搟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112511123312','摲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251112454','摙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251112543','載',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112511214124','塼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112511214124','摶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112511234','埬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251124','埔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251124','捕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251124124','搏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251134','埂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251134','挭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125115315','堰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125115315','揠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112511543','域',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112511543','掝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112512','坷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112512','抲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251211251211','壃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251234','捒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125123422','揦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251234352511134','攋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112512343534','摗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251245251251112213534','攮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125125','挋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251251','捂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125125121','堛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125125121','揊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112512512515','塸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112512512515','摳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112512531425221','壏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125125314252212511135','攬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251254312','塥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211251254312','搹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112512554121','摼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112522111234','墂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112522111234','摽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125221121','堙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211252211234','塛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211252211234','搮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125221251112','墰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125221251112','撢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125234','拺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112523434','掚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112534','抦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125351','拪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211253511543','酨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254','技',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254125441352211535','攦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125431234','堜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125431234','揀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444','馬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444111213251','騞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444112','馯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441132543','駴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444113543','駥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444121121121135','驍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441211254444','騳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412112544441211254444','驫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441212511121543','驖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412145132511234','驝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444122111','駬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412211134','騏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412211154323334','驟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441221122112','驊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412212511121','騹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412212511235431234','驧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441221251211354444','驠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444122155125121','驑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444122251112','騲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412225125132411121','驩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412343434','騋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441251234','駷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412512512515','驅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441252','馷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444412522111234','驃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444125221251112','驔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444125221531','騕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441254','馶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441254125441352211535','驪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444132','馵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441321551','駵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444413241','駓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441332511234','騵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444134','馱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444413412512','騎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441344','駄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444413443434343','騻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441345','駆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441353334','駹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441354','駀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444414312','駍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444414524444123425111','驦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544441515','駏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444154121','駤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444421112111','騑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442113525121122134','驥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444421531522431','驉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442153152512125221','驢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442243143111234','驜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444243135','駫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442511','馹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425111','駔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442511112','駻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444251112134','騠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442511122112','驆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425111234','騍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425111535','騉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444251135345','騔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442511445531','騴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442512','馽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425121','駎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442512115','騁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444251214544','騦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425121554234','騾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444251251','駧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442512511','駽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444251251251112','驒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425134','駚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425134','駛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444251341','駰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544442522112143112','驛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444252324111212534251','驨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425251','駉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425351','駟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444425525251','騧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444311234','駯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444431133112','騈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444312135','駪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443121543','騀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443122113534','騬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443134','駇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444313425125251','驕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444315','馲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444431525','駞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444432121','駈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444432124','駙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444321511254','騪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444321554','駳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444322','馴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444432411121','騅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444325111121','騜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444325112534','騡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444325113554','騩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444432535414544','驄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443312','馸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444341121','駩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444434112251','騇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443411234','駼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444341251122','騟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443412512513434','驗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444434125134','験',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444341534','駣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444434333','駗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443443554134','騱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444434454','駖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444434454544','騐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444435121251','騆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444435251','駒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444352511','駨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444435311252','騊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444353251214','颿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444353344544','騘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444435352','駠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444354','馰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444354251','駱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443545325121','騮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544443552335523','騶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444441121','駐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444441251251112213534','驤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444412515213134','驐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444125251125111','驙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444134','馼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444413434','駮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444441352211535','騼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444143112','騂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444441431251112','騿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444143454135','騯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444415334','駭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444431132','駢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444311341211254444','驣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444431234354152','驎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444431251122','騚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444325135','駾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444432524312511','驓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444434242','駲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444343','駁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444435234354','騣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444443251112','騨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444444511234','騌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444444512332511134','驞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444444535','駝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444511534','駺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444513','馿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444451325122','騙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444513541541','騸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544444535','馾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444454','遤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444445443','駜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444451111254','騝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445112321155122','驌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444451124134','騄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445114554','駸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444512115154','騢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445134','駃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445134','駅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444513521521521','驏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445135251','駶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444525','馳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444453251','駋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444453254','駊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444534','馺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444534353432','騛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444454','馭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444454154132511','騽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444454251','駘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444454251214','騒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445431134','騃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444543341134','騤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444543345153554','驋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445434354','駿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12112544445435','馻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444544251214','騷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444545231234','騥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211254444545232534251','驈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121125444454545434333','驂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211311534','振',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211311534124','搙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113121121','堐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113121121','捱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121131212511','堶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121131251543','堿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211312515434544','撼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211314334543','搣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121131531543','揻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113211234543','墄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113211234543','摵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113221545252','墆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113221545252','摕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211324','坏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211324','抔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113241','坯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113241','抷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113251','坧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113251','拓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121132511134','項',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113251125111344','擫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121132511454544354','擾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121132512534','揼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113252','抪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121132521','拵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121132522134','堧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121132534','项',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113254312114444121','壥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211331234312342121','壢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211331234312342121','攊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211332511234','塬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211335','坜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134','扙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113411234','捺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134115','垮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134115','挎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113411533544','摦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113412132','捹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113412132511','撦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113412512','埼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113412512','掎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113425115','埯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113425115','掩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113425243434343','擟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134315233534','撅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134334','拻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211343434','埉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211343434','挾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134432511234','撩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113443434343','塽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113443434343','摤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134454','垯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121134454','挞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211345','抠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121135','扤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113535','拋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211354','扰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211354','抜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121135422','挒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113543','垅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113543','拢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113544','坺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113544','拔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211355','扼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121135543','城',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12113554325221','墭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12114312','坪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12114312','抨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121143134','挟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211441324111215','擓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12114524444115','摴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121145244441154','墵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121145244441221251123511','壩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12114524444132522','壖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12114524444132522','擩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211452444425121','擂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211452444432411121','攉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12115','巧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12115112134','捷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12115112531','捿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211512543','载',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211515','拒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121151534','挗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121152352','捓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211525','坉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211525','扽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121153135','挠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211535','批',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121153515352511','撍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121153532511','堦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121153532511','揩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121154121','垤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121154121','挃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12115412122','捯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121154121543','臷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211543','找',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211551','坘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12115534','拣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211554','瓨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1211555121','挳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121','正',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121211','圵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121112','羋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121112111','排',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121211121111543','韯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212111212511','靕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121211124','垰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121211124','挊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121123454','埱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121123454','掓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121124','拤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121132511134','頙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121211352511','揹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121154444','焉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212115444452','鄢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212121','址',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212121','扯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212121233','埗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212121233','捗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121212511','掯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121251','坫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121251','拈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121251112','掉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121212511134','揁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121254344441','塷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213134','政',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212132511154444','鴊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134','走',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134112','赶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134121121121135','趬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134121251','趌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213412211154','趣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213412212511','趞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213412212512134','趪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121341251234','趚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213413425243434343','趰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134135422','趔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213415543','越',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213421251','趈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213421251112','趠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121342343','赻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213424','赴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121342432511','趙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213424325251','趟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213425111','趄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121342511112','趕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134251112134','趧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213425121122134','趩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121342512134','趗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121342512512511234','趮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134252','赸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134311234','趎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213431134','趃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343121353121352511134','趲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343121353121352534','趱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134312251','趏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134313425125251','趫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213432411121','趡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134324111214444','趭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343312','赾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213434112431','趛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134341534','趒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213434333','趁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343434121','趖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343445','赺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213434454544','趝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213435','赲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134351234','趓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343515','赿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213435154','趆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343523','趀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213435234','趂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343534','赼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343541','赹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213435431234','趜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134354354','趍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213435511','趋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121343552335523','趨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134413534','趑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134413534251','趦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213441431','趇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213443','赵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134431253511','趥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121344412','﨣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213444513251','趤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213451124134','趢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121345133115','趘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121345134','赽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134515','起',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213452','赳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213452252','趉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213453251','超',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212134541541','趐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121213454154132411121','趯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121513','垆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212153151353334','壉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212153151353334','據',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121531522431','墟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121531525111','摣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212153152512125221','壚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212153152512125221','攎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212153152512135','擄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121215315251214544','攄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121531534312','摢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12121531535','掳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212153154544','摅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121221','卋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212211234','枽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121221212514311254','鼖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121221234','桒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12122135','尭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121222511134','賁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212225111343534','歕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121222511134541541','翸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121222534','贲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121223142535','揽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212243143111234','擈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121224314311134','墣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121224314311134','撲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212343','抄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12123433115','毮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121234335','挘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12124','圤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12124','扑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212425221','盐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121243135','垙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121243135','挄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212432511','捎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12124325251','埫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12124345251121','摚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121243452511523','撐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212434525125121','壋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212434525125121','擋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12124345251254312114444','攩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121243452513112','撑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121243511','垱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121243511','挡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121244125111','堩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121244125111','搄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121244125441','揯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251','吉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251','扣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511','抇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111','坥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111','坦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111','抯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111','担',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511112','垾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511112','捍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111134','埧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511121','埋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511121','埕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511121','挰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511121','捏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511121','捚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511121124','塒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251112134','堤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251112134','提',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251112211154','撮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111234','堁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111234','捰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511124','埘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111251113241112154','攫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511134','垻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511134','貢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111342511134531','攖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111344544','慐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511135','垷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511135','挸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251113533','場',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251113533','揚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511145244441154','壜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111535','堒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125111535','掍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511154','捑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112','坤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112','抻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112','押',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251121251','喆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251121251121251','嚞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112141','掴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251122111','揖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251122111543','擑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251124124','博',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112511','捫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251125111121','撋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112511125431234','攔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251125112511','墹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251125113511','撊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511251135321511','壛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112511354251','擱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112512531','塿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112512531','摟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251125125313134','擻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251125214','堣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251125221','塭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251125221','揾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112522154','墁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125112522154','摱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511254','捜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251132511134','頡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251132534','颉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511351125221','擝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125113533','埸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125113533','掦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251135345','堨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251135345','揭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125113535','掲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251141251234','撔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251153','拽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511541541','塌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212511541541','搨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125121','抩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125121','抽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125121122134543','戴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251211534','揋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251212511134','墤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251212511134','撌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251212511134454','壝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251212512125121','攂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512134','捉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251213432','堺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125121354251','撂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251214543','蛓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251214544','揌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125121554234','摞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512211311534','擃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125122134','捵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125122511','堌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512341','捆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251251','坰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251251','垌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251251','挏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251251','捛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512511','埍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512511','捐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512511134','塤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512511134','損',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251251115','堮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512511351221113134','壧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125125115431','摑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251251251112','墠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251251251112','撣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512512511234','操',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512534','埙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512534','埚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212512534','损',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212513234454','遠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125132511154444','鴶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125134','坱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125134','抧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125134','抰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212513414544','摁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125135','劼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125135','拀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125135','拐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212513534','欯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212513534','袁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431','壴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431124','尌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514311254','鼓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431125412111534','鼚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431125424345251121','鼞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431125425111','瞽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514311254321155122','鼘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431125432511312','鼙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431125435424251','鼛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431125435444','鼕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514311254543341251431','鼟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514311254544251214','鼜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514311515','壾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514312154','鼔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431251','喜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431251121251431251','囍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125143125113241','噽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514312511324251','嚭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514312512154','敼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514312513534','歖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514312514444','熹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514312514544','憙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431333','彭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212514313331554','甏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251431333251214','蟚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125143135251','嘉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125143153254','皷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125145154121','臺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251454','迼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125152','郆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212515215','挹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212515322','捌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251541541','翓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121251543','哉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121252','圸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212521251431','塏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125213112','堓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121252132522','揣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522112121','堽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522112143112','墿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522112143112','擇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522112154','摆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522112513534','擐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121252212511134','賣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522125111342511135','覿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125221251113453254','皾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522125122511','夁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522135251214','擉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121252214135','塄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121252215425113535','擺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212522155444432411121','攞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125232411121','墔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125232411121','摧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121252324111212534251','攜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212523445','埁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125235113511','塴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125251','垇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121252515','垲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212525221125135341','攌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212534','坝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212534','抐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212534','汞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212534','贡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212534125221','搵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212534251','埛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125342534531','撄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121253434543','胾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1212543','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125431252','堈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125431252','掆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125525251','堝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12125525251454','撾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121255452511','搰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213','耂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121311153534','揿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213112','抙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131122121','埵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131122121','捶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121311222214444','墲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121311222214444','撫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131134','垁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131134','抶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121311531153115','撬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312','圲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312','扦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131211','拃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213121251','捁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213121353121352511134','攢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213121353121352534','攒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312154','挺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213122113534','塖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312251','括',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312321511','插',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312321511','揷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312344334','揪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131234531','捼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312511121','堹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121312511121','揰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131251113533','塲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131251113533','摥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213125112','挿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213125125221','塩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131254312114444','壎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213132','抍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213134','坆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213134','扷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213134','攻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121313425125251','墧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121313425125251','撟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121313432','挢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213143141343434','擌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131431425111134554234','攥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121314314341251','撘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121314314431251122','擶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213143145115452','擳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121315','圪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121315','圫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121315','托',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121315','扢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121315','扥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121315','考',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131521454','逰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12131525','拖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213154121','耊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213155144','挴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132','卉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121321113554','塅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213211152511134112','攑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132114343511452511135','攪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132121','坵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132121','拞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132121252','捳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213212134','捠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132124','坿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132124','拊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121321344','垘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213215','扸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121321511121','揑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121321511254','搜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132151135','堄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132151135','掜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121321554','埏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121321554','挻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121322','圳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121322511234','堢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121323121','拰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213234','赤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132341213234','赫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121323412132511','赭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213234132511134','頳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213234212511134','赬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213234212534','赪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213234251214','赨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132343134','赦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132343134251214','螫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132343534','赥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213234355215','赩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132344135112251','赯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213234512115154','赮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121323452','郝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132345254','赧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132411121','堆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132411121','推',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121324111212525','擕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121324111213241112154','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121324111214444','撨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213241112153','携',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132411121543','截',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132511','拍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132511','者',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325111','垍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325111121','堭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325111121','揘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251111344','搝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132511125121132','擤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251113124','塮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132511134','頂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251115252','搗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325112511135','覩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132511312','埤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132511312','捭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325113312','斱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325113554','塊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325113554','殾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251141353134','墽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251141353134','撽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325114334','煑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325114444','煮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325115','乽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251152','都',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132511541541','翥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251154444','塢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213251154444','摀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325115545541234','擽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325131134','堠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325151','垖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132515112','埠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325151454','塠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325151454','搥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325251','垧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132534','顶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213253431234134','擙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12132535414544','摠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121325431234134','墺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312','圻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312','折',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312121','埑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133121234','梊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121331213251','硩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312251','哲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133122511','晢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121331225111','揗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133122512134','踅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312251214','蜇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121331234112431','銴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133123534','掀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133124','坼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133124','拆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133124111251','誓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312413534','裚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133124334','烲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133124444','焎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312454','逝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133124544','悊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133125','乴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121331251','垢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213312531','娎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121332112','垳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213321531535','搋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133215315353534','擨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133234342134','摐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213324','抓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121333534','挀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121335','老',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213351443554','搬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121335154121','耋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121335251','耇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121335251','耉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213352511','耆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213353115','耄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133535251','耈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213354','坂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213354','扳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121335434112431','鋬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12133544','坬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134','圦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134','扒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134','扖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341121','拴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134112251','捨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213411234','捈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134112431','捦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341124313534','撳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134121','坴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213412132511154444','鵱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213412135','勎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134121354','埶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341213541211254444','驇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341213541234','槷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341213542511','暬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341213543112','摰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213412135435','勢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341213544444','熱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213412143344334','燅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134121454','逵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341251','垥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341251','拾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341251122','堬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341251122','揄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341251132','揜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134125122','埨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134125122','掄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134125125121','墖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213412512513434','撿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134125152','掵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213414431','捡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341534','垗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121341534','挑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121342511251211511','鼀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213425135','挩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134312','垀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121343123425121','墦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121343123425121','播',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213432','圿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213432','扴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134333','抮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213434121','挫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134341211121111543','攕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213434251','﨏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213435','抡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134354','夌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121344134522554','擒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134414312511','摿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121344311252','揺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121344311354','援',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134431234','埰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134431234','採',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443124','埒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443124','埓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443124','捋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443311252','摇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443321511','塪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443321511','搯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121344335554444','撝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134434554','授',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134435112','掙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443521','垺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443521','捊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213443531','挼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213444','扵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213445','坅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213445','扲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213445113251','搶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134454','坽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134454','拎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213445413534','搇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134454544','埝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134454544','捻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213453','坋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213453','扮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213454','抸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12134544544','捴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213454541541','塕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213455','抢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135','功',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135','圥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135','扏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135','扐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213511','抈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135112','拥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121351134','巬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121351134','巭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135113511','堋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135113511','掤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121351234','垛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121351234','挆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213513344111251','擔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121351355','垝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213515','坁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213515','扺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135152511','捪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135154','坻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135154','抵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213521','孝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135213134','教',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135251','坸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135251','拁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135251','拘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121352511','指',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213525111534','塡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135251153535251354','攙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121352512112511','撸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121352512144442511','擼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213525134','换',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213525135','挽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135251354','堍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121352513544','搀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121352534134','換',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135311252','掏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135311345452134','擬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135321511','埳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135321511','掐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121353251214','堸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213533','圽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121353344544','揔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213534','坎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213534','扻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213535','抛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213535112','埆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213535112','捔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121353535','拹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213535352511','搚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354','圴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354','巩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354','扚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354','执',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541','均',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541','坍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541','抣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541112','埄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541112','捀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541112454','塳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541112454','摓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354111251','揈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354121','垫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354122111','聓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354122125112','鞏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354134112431','鋆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213541521234','搩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354242511','揝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354251','垎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354251','挌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213542512134','跫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354251214','蛩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354251214','蛰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213542534','贽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213543112','挚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135431234','掬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135434112431','銎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135435','势',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135435','拠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354354','垑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354354','拸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135435451','鸷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354413444444','撚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213544311252','搖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213544444','热',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135445411234','摖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213544544','恐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213545252','捣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213545325121','塯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121354554234','絷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213551','坞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121355112','埩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121355112','挣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135515','垉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12135515','抱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213552','抑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213552335523','搊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213554','坄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213554','抅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1213554','投',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214','圡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214111251554444554444515','壪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141121','拄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121412234515','塆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214124','抃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141251234','掠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141251251112213534','壤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141251251112213534','攘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214125125251','塙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214125125251','搞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121412514512','揨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141251451353334','壕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141251521','埻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121412515213134','墩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121412515213134','撴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214125152152','墎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214125221241343534','壞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214125251125111','壇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214125251125111','擅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214125251131234','壈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413','圹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413','扩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141312212512134','壙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141312212512134','擴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141312214444','墌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141312214444','摭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214131234123421112111','攠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413123412343112','擵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141321251','掂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141323544','掖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141332124','捬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141335154','掋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214134','坟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214134','抆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214134112213534','壌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413432','挤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413434','挍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141343412','埣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141343412','捽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214134342511','塉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413452','垴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214134522554','摛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413452255432411121','攡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135','坊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135','坑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135','抗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135112251','塘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135112251','搪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141351125112','墉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141351134','掶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141352211535','塶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141352211535','摝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135221153525312341','攟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135221153531234','攈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141352211535431234','攗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413531525','揓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413534','挔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121413534543','裁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141354','拡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214135452','垿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431','垃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431','拉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214143112','垶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431251','培',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431251','掊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121414312511','堷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121414312511','揞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431251112','墇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121414312511121','墥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121414312511121','撞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431251121515111','壠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431251121515111','攏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431251135','境',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431251135','摬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431331121','摌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141431531','接',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141432512251','墑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141432512251','摘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141432512251454','擿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141432533543211','擠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141432534251','墒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121414345252','揥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214143454135','塝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214143454135','搒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214152513511531354','攍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121415334','垓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141542511','堉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121415425113134','撤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214155332411121','擁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214155425121','搐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141554413412','摔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12141554453112','撁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121425','扪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121425354251','搁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143111','拦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431112','垟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431112431251','墡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431112454','達',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431113121','搓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143111325111','撯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143111344511534','攁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112','坢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112','幸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112','拌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112313425221','盩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214311233544','瓡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112354','執',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112354121','墊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431123541211254444','騺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431123542511134','贄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112354251214','蟄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431123542534','漐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431123543112','摯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214311235432511154444','鷙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431123544111251','謺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112354413534','褺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431123544544','慹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112354554234','縶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143112454','逹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431125254','報',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431132','垪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431132','拼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431134121','堘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214311343112','搼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143113452','掷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143113455','埢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143113455','捲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143122431','掽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431234354152','撛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214312343554','摋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431234531','搂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214312345313134','擞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431251122','揃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431253511','揂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431253511124','墫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431253511124','壿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121431253511124','撙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143125351113452','擲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214313425221','塧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214313425221','搤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214315112234','搛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214315233511','搠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143251112','掸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143251212511','増',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214325135','捝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121432514544','搃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143252343134','撇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121432524312511','增',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214334','灻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143344334','埮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12143344334','掞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214334433445251251','攚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121433443344535','撈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214334543','烖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121434','赱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214351523','挮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121435234354','堫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144115','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214412','抖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214412343','挱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144153441234','墚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121443452511135','撹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121443452535','搅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214451112251','搳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214451112252214544','攇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144511221342512134','攓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214451122134413534','攐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214451135','垸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214451135','捖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144512','坾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144512','拧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144512134','埞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144512134','掟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144512332511134','擯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445124','垨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445125111','塇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445125111','揎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144525151','捾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445315','垞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445315','挓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214453212134','摈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144532131511','摍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144534','坹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144534121','埪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144534121','控',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445341344','堗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445341344','揬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445342512512','撺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214453431211','搾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445343215115445445','攛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214453433544','搲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144534335443354433544','攨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214453434251','塎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214453434251','搈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214453434354','摉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445345','挖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144535','坨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144535','抭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144535','拕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445354251','揢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144535445411234','擦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144535455','埦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144535455','捥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12144545442522112','擰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445531','垵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121445531','按',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145111213554','瑴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145112343554','榖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145112511123554','轂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214511353334','塜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145113533343554','豰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214511534','埌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214512155121','壼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145122431','壸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451251112','堚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451251112','揮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451251113554','瞉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214512513554','嗀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214512513554','嗀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451251431','壹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145125143132511154444','鷧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214512514314135344544','懿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214512514315','亄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145125143153254','皼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214513','护',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451312343554','穀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145131344','捩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145132511','掮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451325111544443554','鷇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145132511234','槖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451325122','揙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214513251251214251214','蠧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214513533434','塚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145135351123554','觳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451353554','殼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214513541541','搧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214513554251214','螜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145135544544','愨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214514312343554','糓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121451512','挥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214515123554','毂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214515153554','彀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214515542343554','縠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121452155121','壺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214522431','壶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214525114134','塓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145251221','壷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214532411121','搉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145341234','堔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145341234','探',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214535','坈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214535','壱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214535','売',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214535','壳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214535','抌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145353554','殻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121453535544544','慤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145354544','悫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214544','志',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1214544','抋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12145442511135','覟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215','丐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215','圠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215','扎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511','扫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511112','垏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151111254','揵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511121251124','撏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511124','挦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151121444425221','壗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151124134','埭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151124134','捸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215113251','捃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511352','挪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151145252','埽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151145252','掃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215114554','埐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511534','垠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511534','拫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121511541535','摡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215115452','揤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121512','扟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215121','扭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151211251124','壽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151211251124325113554','魗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121512112511244444','燾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151211251124541541','翿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151221113134','撖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151311234124','墛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215131221534','搌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151312251','据',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121513154121','握',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121513241343112','墀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121513241343112','摨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215132514143112','壀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215132514143112','擗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215133115','捤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151335','坭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151335','抳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215134','块',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215134','抉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215134','択',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215134143112','搱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121513431132','塀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121513431132','摒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151352252','堀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151352252','掘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215135251','挶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121515','圮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121515','圯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151515','垊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151515','抿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121515251251214','摾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151532','坲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12151532','拂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215154151541','搦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121515515122134','撰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152','凷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152','卭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152','壭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152','邛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152125221','掹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215213','声',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152131212511','撱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121521325111','堳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152133544124','摪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152133554','殸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152133554122111','聲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215213355413251','磬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121521335542534','漀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121521335543112','撀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152133554311252','罄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152133554312342511','馨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152133554313425125251','毊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215213355434112431','鏧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121521335544111251','謦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152133554414312511','韾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121521342511','壻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121521342511','揟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215213554234','搎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215215','把',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215221125125','臦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121522112512513432','臩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152211251254334','燛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12152252','拙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121525','地',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121525','扡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121525341','拯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215254','报',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121525454','逇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12153','扔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121531234','垜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121531234','挅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12153234454','逺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12153251','招',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12153254','坡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12153254','披',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121533','场',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121533','扬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121534','圾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121534','扨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121534','扱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12153544','拨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154','去',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154','払',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154112','择',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154132','弆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154132','拚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121541341251112','撪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154134333','掺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121541541','挧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154154132411121','擢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154154132511','摺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154154134333','摎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215422','刦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154251','坮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154251','抬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215425112','埇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215425112','捅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121542511251211511','鼁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154251135345','朅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154251214','掻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215425135','唟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215425221','盍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121543','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215431134','埃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215431134','挨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215432411121','摊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121543341134','揆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121543341251431','墱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121543341251431','撜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121543345153554','墢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121543345153554','撥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215434','拟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215434354','埈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215434354','捘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215435','劫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215435','抁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121544','扠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121544251214','搔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154454','迲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215452','却',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215452','抒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121545231234','揉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121545254','叝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215453','刧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154534','刼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215454','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215454541234','搡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121545454342444','撡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154545434333','墋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154545434333','摻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12154545454','掇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155121','亞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215512111214','琧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155121121','堊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155121251214','蝁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215512132511154444','鵶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121551214544','惡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121551353334','堟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121551353334','掾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121551353334251214251214','攭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155144','坶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155144','拇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155212511134','摜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155212534','掼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215531','毐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155435','坳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155435','拗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121554444355215','撧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215545','抝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12155525111234','摷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121555254315445445','擸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121555325431','堖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('121555354','拶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1215554234','紥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122','卄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122','艹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221','廿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211','甘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111','耳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221111121122522114544','聽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211111212511','聙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221111154','耺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211112','耵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211112121','聇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111121251','聐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111122111','聑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111122111122111','聶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111122111122111132511134','顳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211112252214544','聴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211112511543','聝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111132522','聏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221111343434','聗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221111354','耾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221111535','聀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211121112511','蔧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221112121','耻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211122','刵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111221112521251431','蘴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111234','某',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211123412212511','藉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111234251125214','藕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221112511','耼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221112511121','聖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211125121','聃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221112512115','聘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111251212511134','聵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111251212534','聩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211125134','职',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111253134','葜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211131134','聅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113115','毦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113121251','聕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111312251','聒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211132151135','聣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211132511154444','鵈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211132511312','聛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111325113554','聭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111325125214','聥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211132535414544','聰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134','其',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134112','菶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134121','基',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111341234','棊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113413251','碁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111341534','聎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113422','剘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111342511','朞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111342511','萶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134251214','蜝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113431234','蓁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111343312','斯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111343312251214','蟴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134333','聄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111343511','期',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111343534','欺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111344111251','諅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113445','耹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134454','聆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111344544','惎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111345','甚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134512','卙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113451543','戡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113452343','尠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113453','聁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134535','勘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113453534','歁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111345354354','夦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113454412','斟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134544544','聡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113454541541','聬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211134554234','綦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221113513344111251','聸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111353344544','聦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211135352','聊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111412514512','聤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111414312511543','職',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111431132','聠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111431134','联',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111432514544','聪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221114334','耿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221114334413534','褧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211144512','聍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211144512134','聢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211144534121','聜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211144535445411234','聺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211144545442522112','聹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221114535','耽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221114544','恥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221115','耴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211152','耶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211152252','聉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211154','取',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211154121','埾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111541234','棸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211154323334','聚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221115432333452','鄹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111543341134','聧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111544444','焣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221115452','郰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211154531','娶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221115454','聂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221115454132534','颞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211155435','聈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111554554132','聨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122111554554134','聫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221115545544444','聮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211155455453221','聯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122112','芉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122112','芋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211212511','菁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211212511134','蔶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221121353134','蔜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221122112','華',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122112211232511154444','鷨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211234','苿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211234','茉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221123411234','蒜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122112512134','黃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211312251','甛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221132','茾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122113222','荆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122113222','荊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221134','芙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12211342444','菾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221135','芜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221135','芫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122113543','茙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122115','芌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221152','苇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221152','邯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221154','芸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212','艼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121','芏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221211134','荴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212111534','萇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221211154122134','蕻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221211154511112','蕼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121121','茥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121121121135','蕘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121121124','葑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221211251124','蒱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212113544','菝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212115112134','蓵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212121154444','蔫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121222511134','蕡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221212343','莏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212125121','菗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221212513234454','薳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221212514311254','薣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212125145154121','薹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221212522112143112','蘀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121252212511134','藚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121312251','葀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212132411121','蓷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212132511','著',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121335','荖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221213352511','蓍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212134121354','蓺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121341213541154','藝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121341213544444','爇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212134354','菱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221213534','莰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121354','茿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221213541','荺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121354531','蒆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212135515','菢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221214125221241343534','蘾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212141431','菈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121431112454','薘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212143112354','蓻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122121431125254','蕔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212151211251124','薵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212153251','萔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212154112','萚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221215425221','蓋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212211','苷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122122111','茸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212211134','萁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122122111345','葚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212211134541542511','蘛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212211134554234','藄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122122111414312511543','蘵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212211154','菆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212211154323334','藂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212212511121','蓳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212212511235431234','蘜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212212512134121121','蘳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221221251213441121','蘣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122122151234','葉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212251','苦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221225111134','蒖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221225125','茝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221225125112512511','蘁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122122513511','葫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122122543112','萳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212341','苯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221234121','荰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221234121121','蓕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212341234','菻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122123412512512515','藲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221234251','莕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122123425111','葙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221234324111214444','藮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212343312','菥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221234341','莁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221234341252511','薔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212343434','萊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212343454','菘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212344454','蒁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212344535','萙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122124','芐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221241344','莍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212431252511','蔷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221245521','荸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122124552135','葧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511','昔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125111','荁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251112','莗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511121','堇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511121','菫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251112112','蓒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125111212511135','覲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125111212535','觐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125111213312','斳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251112135','勤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125111213534','歏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511121354544','懃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251112152','鄞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511123312','蔪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251112454','蓮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251112523554554234','蘻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511134121251431251','囏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251113432411121','難',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251113432411121253434','臡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511134324111214544','戁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125111343534','歎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511134511534','艱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112','革',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112112','靬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251121122125121','鞲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511211234','靺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511212','靪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112121','靯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112121121','鞋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112121251','鞊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112121252212511134','韇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511212141431','鞡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112121431112454','韃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251121221122112','鞾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251121221325112','鞴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112122132521','鞯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511212215','靾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112122151234','鞢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511212225112511125431234','韊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511212225221134543','韈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251121223241112154','韄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112122341251','鞳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251121224135221154444','韉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251121251134','鞕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251121251211251211','韁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112125221134515454','韆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511212534','鞆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112134454','鞑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112135','靰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511214124','蓴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112144544','蕙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251122','剒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112211124','鞐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251122432511','鞘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112243251122','鞩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511224325251','鞝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511224345251121','鞺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511225111','靻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511225111','靼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251122511121','鞓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112251112134','鞮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251122511122112','鞸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511225112512531','鞻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112251125221','鞰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112251135345','鞨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511225115545544444','韅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112251212511134','鞼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251122512511','鞙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511225134','鞅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112251341','鞇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251122534','靹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511225342511','鞜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511231234','鞂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112312344334','鞦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112313425125251','鞽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112313432','鞒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112321251134','鞭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123235','靴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511232511312','鞞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123312','靳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511234','菄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112341251','鞈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112341251132','鞥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112341534','鞉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123443321511','鞱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123443531','鞖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123443554134','鞵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123445','靲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511235','勒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123513344111251','韂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251123525135','鞔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112354','靮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112354111251','鞫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511235431234','鞠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511235515','鞄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251124','莆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251124124','蒪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511241251521','鞟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251124125152152','鞹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251124135221154444','韀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511241431251','鞛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511243112','靽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112431253511','鞧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511244534121','鞚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112445531','鞍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511251111254','鞬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112511534','鞎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251125121','靵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251125152','靷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511251554','鞃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251125215','靶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511253251','鞀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511253254','鞁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112534','靭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112534','靱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112534','靸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112544','靫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112545231234','鞣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511255435','靿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125112554554134543','鞿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125113134','散',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251132511154444','鵲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125113312','斮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251134','莄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251135451','鹊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212511454','逪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251153254','皵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512','苛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251211251211','薑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512113532511154444','鷰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251211354444','燕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125121135444452','酀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125121135531','嬊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512134','黄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512134121121','黊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251213421251','黇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251213432511154444','鷬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125121343445','黅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251213441121','黈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125121344412','斢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125121344535','黆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512212511','蓸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251234352511134','藾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512343534','蔌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512343534454','藗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125125','茞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125125121','葍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512512515','蓲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512531425221','藍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251254312','蒚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125125431232511154444','虉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212512554','菣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125125542511134','藖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221251431','荳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221252','芾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212522111234','蔈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221252211211554','薽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125221251112','蕈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125221531','葽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125234','茦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125234125234','蕀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212523422','莿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221252343134','蓛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212523434132511134','顢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12212534','苪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221253434132534','颟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125351','茜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221253511','莤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221253511324111214444','蘸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221253511515','蓜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221254','芰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122125431234','萰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213113453554541541','蘙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221311534','莀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221311543124','蓐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213125125543','蔵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122131251543','葴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122131531543','葳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132121','茬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221321251543','蒧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213221545252','蔕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221324','芣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213241','苤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213251','若',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132511134251251251251','虈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132511134543','蕆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132511212151534354','蘷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132511325113251','藞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213251251214251214','蠚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213251454','逽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132514544','惹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221325152','鄀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132521','荐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132522','荋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122132534543','蒇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221331234312342121','藶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221332511234','蒝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221335','苈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134','共',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134','芖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213411234','萘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134115','荂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213412132','莾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221341251112','輂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221342444','恭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213425115','菴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134251214','蛬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213425243434343','薾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221343112','拲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134315233534','蕨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221343434','莢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134343434112','蕐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221344132','莽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134425221','葢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134454','荙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134515','巷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122134543','荗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213513125125543','藏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122135333412132511','藸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122135333431121','蕤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221353334454','蓫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221354','苃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221354211121111','薤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122135422','茢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221354251113533','薚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213543','茂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213543','茏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221354344511534','薞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122135435121','塟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122135435132','葬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12213544','茇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221355','苉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221355','苊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122135543','荿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12214312','苹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221431234','莱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122143134','荚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12214334','炗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122145244441154','蕓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12214524444132522','薷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221452444425121','蕾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122145244442512121354251','虂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12214524444251251251','蘦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221452444432411121','藿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221452444434454','蕶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221452444435115215','蘎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215','世',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215112134','萐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215112531','萋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122151234','枼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221512454','莲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221515','苣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122151534','荑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221523','芽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122152332411121','蕥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221525','芚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122152511134','貰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215251113435','勩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215252511','萅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122152534','贳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215253435','勚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122153135','荛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221535','芘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122153512','荜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122153532511','蒈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122154','芅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122154121','荎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215412122','菿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215431543','菚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12215454','迣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122155125121','畱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221553','苆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1221555121','莖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122155512135','葝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221','丗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221112111','菲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122211121111','韮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122211121114544','蕜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122211234','茮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221123454','菽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221135','苝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222121','芷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222121131233543','薉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122212121212121','蕋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222121212121211234','蘃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222121233','荹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222121233132511134','蘋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122212135','茈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221251','苫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221254344441','蓾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222135454431234','薒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222145252','帯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222153151353334454','蘧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221531525111','蔖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222153152512125221','蘆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122215315251214544','藘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12221531535','萀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12222','卌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222231425221','蓝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12222431431121124','薱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122243135','茪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222432511','莦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122243251122','萷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222444125221241343534','蘹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122245252','带',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111','苜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111','苴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111132','萛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111134554234','繤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251112','草',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511121','荲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511121124','蒔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251112211154','蕞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511122112','蓽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111234','菋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111234','菒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111234','菓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511124','莳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511134','茣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511134','莫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511134121','墓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111341211254444','驀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251113422','萴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111342444','慕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111342511','暮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111342511134531','蘡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511134251214','蟇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511134252','幕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111343112','摹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251113435','募',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111344111251','謩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251113452','鄚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511134551','蓦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511135','莇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511135','莧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111354','萈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111431234','蔝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251115132125','薡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111535','菎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225111543341134','藈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251122111','葺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251122111543','蕺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112511','菖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112511','菛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125111','萺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112511125431234','蘭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112511251','蔄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125112511','蕌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125112511','蕳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511251132411121','藺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125113511','蕑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125114544','蕄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112511531','蔅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112512531','蔞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125125313134','藪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125214','萬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222511252142512134','躉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125214251214','蠆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112521435','勱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125214454','邁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251125221','蒀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225112522154','蔓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251131211','葃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251134','茰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225113511','萌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251135345','葛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225121','苒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225121','苖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225121','苗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251211534','葨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512121354251','蕗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251212511134','蕢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251212512125121','藟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251212512125121121','蘲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512125121251211234','蘽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251212512125121554234','虆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512125135341','薗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251212534','蒉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512132511154444','鶓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512134','莡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512135','莮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512135451','鹋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251214','茧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225121435441431331121','虄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251214544','葸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225121554234','蔂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512211311534','蕽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251251','茼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251251','莒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512511134','蒷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251251115','萼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225125115431','蔮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251251251112','蕇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512512511123312','蘄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225125125111252','鄿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251251251115','蕚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225125132411121','雚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225125132411121132511134','顴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225125132411121132534','颧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251251324111212511135','觀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512513241112132511154444','鸛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512513241112135','勸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225125132411121353251214','飌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251251324111213534','歡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512513241112135451','鹳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512513241112152','酄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222512534','莴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225132411121','蓶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225134','英',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122251341','茵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222513414544','蒽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222513432511154444','鶧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222513445','荶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222513522','莂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225151','苢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122252','芇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522112132511','薯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225221134334433422','蘮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225221134543','蔑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225221251','萜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122252212511134','蕒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522135251214','薥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225221354','萝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225221411125122','藅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522145135435','薨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225221451554','甍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122252214525111','瞢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522145321543','薎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522145325114554','蘉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522145354','夢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522145354132511134','顭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122252214535452','鄸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122252215425113535','藣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222522155444432411121','蘿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225251','苘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122252511','茴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122252554444251214','繭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225312341','菌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222534','芮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225341','苬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222534125221','蒕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225341535','萞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122253422','荝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222534251','莔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1222535','苋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225431134551','蔨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225431415','菵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225525251','萵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12225525251454','薖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122255452511','蓇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231121','苼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231122121','菙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122311222214444','蕪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122311234','茱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223112525134','蒛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231134','苵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223113432411121','薙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223115','芞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223115','芼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312','芊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231211','苲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312154','莛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223121543','莪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123412134354','薐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123422','莉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312342432511','蕱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231234251','萂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312342511','萫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123425111','蒩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231234251135345','藒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123432511312','薭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312343251253415511511','蘒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123435132511134','蘈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123435251125115','蘒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123435251214444','蘓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231234353','菞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312343531234','蔾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312343533424134','藜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231234354','萟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312344334','萩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312344351523','蕛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312344412','萪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231234451325122','藊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223123453','莠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231234531','萎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231234531325113554','蘶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122312511121','董',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223125111214444','薫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231254312114444','薰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223125431211444435','蘍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223134','芺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122313425125251','蕎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122313432','荞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223154','苌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223155144','莓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12231551443134554234','蘩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223211','芢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122321113554','葮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223211152511134','藇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223211212511','蒨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232112512515114512535113453','虋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232121','茊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232121','茌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122321234','茠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232124','苻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223212512','荷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122321344','茯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122321511254','蓃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232151134','萸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232151135','萖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122321511354444','蕮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122321543','茷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122321554','莚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223223134','莜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223223541234','蓧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223223542511','蓨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122322354333','蓚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122322511234','葆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122322511234413534','藵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122322512','茽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232252','苮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122323121','荏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223231211','莋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223235','花',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122323525135','蒊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232411121','萑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232411121321511','舊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122324111214444','蕉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223241112154','蒦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122324111215422','劐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223241431','莅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223241431251','蓓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232511','苩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325111121','葟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251114544','蒠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232511154444','蔦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325112534','葲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232511312','萆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325113251132511','藠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232511344335554444','蘤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232511354','菂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232511355135','蔸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325113554','蒐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251141341234','薬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251141353134','薂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325114554','葠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325115215','葩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325115545541234','藥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325125214','萭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325131134','葔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251354','莵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251511252','蒒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325151212151145252','蘬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251514143112','薛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232515141431121234','蘖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232515141431122512134','躠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251514143112431234','糵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223251514143112521','孽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223253','芿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12232535414544','蔥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223254311535','蓖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325431234134','薁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122325434354','葰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223312','芹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223312454','菦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122331251','茩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122332112','荇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223321212134','蓗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12233221212134','蓰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122332252111213134','藢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223322521353134','薇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122332311212152','蓹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12233231121215211234','蘌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122332312511354','蕧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223323411234','蒣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12233234342134','蓯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223323525121134112','蘅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122332441112','葕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122332511112','葎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122333132511134','蕦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223351153554','蒑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223351443554','蒰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12233544','苽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223354433544','蓏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234','艾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122341121','荃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223411234','荼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122341123432511154444','鷋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234112431','菳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122341154','荟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122341234','茶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122341251','荅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122341251122','萮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122341251132','葊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234125122','剳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234125125125125122','蘥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223412512513434','薟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234125125134343134','蘞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234125125134343534','蘝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223412524312511','薈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223414431','莶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234144313134','蔹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223422','苅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234234','苶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234312','苸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122343123425121','蕃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223432','芥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223432511154444','鴱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223434','苁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223434121','莝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223434121354','蓌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223434121454','遳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122343425111','葅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223435','芲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122344311354','萲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234431234','菜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234433112523554234','蘨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223443321511','蓞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122344335554444','蔿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122344345354152','蕣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223443454544354','薆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223443521','莩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223443531','荽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234435332511121','薶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234435333251135','藐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223443542554545','薍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223443554134','蒵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223445','芩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223445113251','蒼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223445251','莟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234454','苓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234454544','菍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223453','芬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12234531234','棻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122345325221','葐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223454541541','蓊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223455','苍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235','艻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235','艽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235','芁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235112','苚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223511234132511134','蘏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223511251135345','﨟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122351131211','葄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122351135','荕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235113511','萠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223511351122','蒯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122351135251','葋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235114311341211254444','虅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122351143113424134','藤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122351143113435','蕂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235115215','萉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235115254','菔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122351251124','葡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235125122','菕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235125125121','蔔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223513344111251','薝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223515','芪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235152','茚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235154','茋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235251','苟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235251','茄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122352511','荀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122352511134','萯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525121122','蓟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235251211431112','藓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525121444422','薊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525121444431234','蘇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235251214444431112','蘚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122352513134','敬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525131341211254444','驚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525131341234','檠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122352513134251214','蟼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525131343112','擎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525131344111251','警',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525131344544','憼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223525135','莬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122352513535','葂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235251354','菟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235253425111354','藑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235311252','萄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235311345452134','薿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235312132511','蕏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223531234132511134','蘔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235312511','萏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223531344','获',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223531354','莸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122353251214','葻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223533','芴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235334','茐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122353344544','葱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223534','芡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122353431253511','蕕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223534334','荻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122353511222','葪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235351124412','蔛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223535112533112','薢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223535121','莥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235352','茆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122353535','荔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354','芃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354','芄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354','芍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354','芕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223541112','莑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223541112454','蓬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354152','荈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354251','茖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354251','茗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235431234','菊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354344511534','蕵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354354','茤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223544','苏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235444','苳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235445411234','蔡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235451','茑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235452','茒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223545325121','蒥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354533411243122','藰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235455','苑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122354554544','葾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12235515','苞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223552335523','蒭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223554','芟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1223554','芶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122411125112132511','藷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224111251251135345','藹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224111251344311354','蘐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241112513554','蔎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241112515544445544441234','虊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224112134354','蓤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122412121','荘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122412354124','蒋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224124','苄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224125113534','蓑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241251251112213534','蘘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224125125251','蒿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241251252511234','藁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122412512525131234','藳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241251252513534','藃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122412514512','葶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224125145135435','薧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224131221252','蓆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241312214444','蔗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241312341234','蔴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224131234123413251','蘑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224131234123421112111','蘼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122413123412343112','藦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241313425115','蓭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224133434121','蓙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241335154','菧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224134','芠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224134131134','蒺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241341325113554','藱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241342513534','蔉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224134315112234','薕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122413432','荠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241343211','萕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122413434','茭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241343412','萃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224134522554','蓠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122413452255432411121','蘺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241345435','萒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224134543534','蓘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224135','芳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224135','苀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224135112251','蓎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241351134','菮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241352211535','蔍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241352211535121','薼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241352211535431234','蘪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122413522115354444','藨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224135221154444','薦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241353131134','蔟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241353152134','蔙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122413531525','葹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122413534','茨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224135342511134','薋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241353444','菸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241431','苙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143112','莘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143112342511135','藽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143112343312','薪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241431251','菩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122414312511','萻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241431251112','蔁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122414312511121','蕫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241431251121515111','蘢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143125114544','薏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143125152','蔀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143135251','蒟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122414313533343554','藙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241431531','菨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241432512251','蔐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241432512251454','藡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122414325335413211','薺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143253354211121111','虀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12241432534251','蔏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122414345252','蒂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224143454135','蒡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122415','芒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122415325','荒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122415334','荄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122415435','茺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224154544','莣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224155332411121','蕹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224155425121','蓄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12242532411121','蔺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431','亚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431113121','蒫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431121','垩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224311214444','蓔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431121531','葁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431132','荓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12243113455','菤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224312341344132511134','蘱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224312343554','蔱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431234454','蒾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431234531','蒌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224312345313134','薮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224312511','晋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12243125111543','戬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431251122','葥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431251152','鄑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224313','严',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122431325111212151534354','虁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224313252','莃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224314544','恶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224315112234','蒹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224315233511','蒴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122432511123312','蕲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224325135','莌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12243252343134','蔽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12243252343134251125511151','虌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224334','苂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224334132511134','薠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12243342511112','蔊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224334344311354','蕿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12243344334','菼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12243344334454334','藀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122435234354','葼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122435554444','蒍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244111212511','蔳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441121','茳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244112134354','蔆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441122134','葓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224411234','莯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224411251124','蒲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224411251124124','薄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244112512','菏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244112512531425221','蘫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244112522111234','薸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441125221251112','藫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244114312','萍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224411515','菃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244115151234','蕖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244121123454','蔋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224412343','莎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244125111','菹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441251113533','蕩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244125111353325221','蘯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441251125214','蕅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441251125221','蕰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224412512512511234','藻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224412534125221','薀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441312251','萿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224413241431','蒞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244132511','萡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441333534','蒎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224413411234','蒤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441341251122','蕍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441343123425121','藩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244134341211121111543','虃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441351234','蒅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441354251','落',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244135515','萢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224413554','莈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224414125125251','薃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441415','茫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224414154325','蓅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441431132','蓱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224414511534','蒗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224414535','莐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441511112','葏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224415114525254','薓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224415114554','蓡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244153251','菬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244153254','菠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244153254531','蔢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122441533','荡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244154251','菭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244155','范',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244155525111234','薻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224451','苎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224451112252214544','藼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445112','荢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244511221343112','藆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244511234','萗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224451135','莞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244511352154','蔻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244511353134','蔲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244512','苧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244512134','萣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244512332511134','薲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445125111','萱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244512512134','蔩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244513251','菪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445134432511234','藔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244525111','萓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244525151','菅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244532132511','蓿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445321511354444','藛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244534','茓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445341344','葖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445343251113515','藭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224453434251','蓉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224453435','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244535455','菀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244545442522112','薴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244545443251214','藌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12244545443252','蔤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445521','茡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122445531','荌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224511214','莹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451135124','蒄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224511353334','蒙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245113533343115','氋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451135333432511154444','鸏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451135333435451','鹲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224511534','莨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224511543511','蓢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245115452','蓈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245121','茔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451234','荣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451251112','葷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451253511','蒏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224513','芦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245132511','菺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451325122','萹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245132515215','蔰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122451512','荤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245251135345','蔼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224525114134','蓂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245251214','萤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245251251','营',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122452534','荥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122453112','荦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224532511121','蒮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224534112431','蓥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224535','劳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224535251354','蒬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224535451','莺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122454','芝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122454334','荧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224544','芯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245443','苾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122454445444544','蕊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1224544454445441234','蘂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245512','茕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12245554234','萦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225','艺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251','古',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251111','直',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511111225111112251111','矗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511112','茟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511112315','亁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111125135','嗭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111134','真',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111134132511134','顛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111134132534','颠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511113432511154444','鷏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511114544','惪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251112','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511121152','韩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511121251124','蕁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511121543','戟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251112315','乾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111234','倝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111234112','幹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251112341234','榦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111234251214','螒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511123432411121','雗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511123432511154444','鶾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251112344412','斡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225111234541541','翰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511123511','朝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511124','荨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511125','乹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251112521251152','韓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251121444425221','藎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225112321155212','蕭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251123234','萧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251124134','菉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225113','芛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225113251','莙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251132514444','蔒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251145252','菷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511534','茛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511541535','蔇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225115452','莭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122511554','瓳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122512115154','葭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122512115154454','蕸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225121354','畞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122512511212511134','賾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122512511212534','赜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225125112512511','噩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122512511534','喪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225125132511134','頤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225125132534','颐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251251452511134','賷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225125515','巸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251255154444','煕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251255154444','熙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225125515531','媐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251311234124','蔚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513112341244544','藯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513134','故',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225132511154444','鴣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225132514143112','薜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251325141431121234','蘗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225133115','荱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251335','苨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225134','芵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513444','荩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225135','克',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513511','胡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251351132511154444','鶘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251351132511154444','鶦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251351135451','鹕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513512','兙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251351225135','兢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225135124','尅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225135132511','兡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225135132511121','兣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513522','剋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251353115','兞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225135312','兛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251353453','兝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513535','勀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122513535','勊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225135451','鸪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122514143112','辜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122514544','怘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122515','芎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122515','芑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251512115154','嘏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122515122111','葞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251512225125132411121','虇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251515','苠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251523','苐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122515251251214','蔃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251532','茀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225154151541','蒻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12251554','苰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252','节',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122521','芓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122521214154325','蔬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122521234','荪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225212511234','蔯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122521251152','葦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225213121','莊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252131234341252511','蘠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122521325111','葿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252133544','菰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252133544124','蔣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225213554234','蓀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225215','芤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225215','芭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252251212511134','藬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252252','茁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122523134','荍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122523411234','蒢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225234431215114544','蘟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225234451154','蔭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122523511','荫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252354131121','蕯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252413452','菡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12252414313','萨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225241431331121','薩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225253414444','蒸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12253','艿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12253','芀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12253112251','菇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225311311534124','薅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122531251','茹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225312513112','蒘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122531251554234','蕠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122531531531','葌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12253251','苕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225325135','莻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122534','芨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225344544','荵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122535353','茘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122535425221','萾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12254121','茎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12254154132411121','藋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12254154134333','蓼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12254251','苔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122542511234','葈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225425112454','蓪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122543112','南',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225431121344','献',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122543112454','遖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122543341134','葵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122543345153554','蕟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225434','苡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225434354','荾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122544','芆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122544134','荬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225452','芧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225452132511134','蕷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225452132534','蓣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12254523','茅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122545231234','葇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225452332511154444','鶜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225452335453','蓩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12254545434333','蔘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122551121','荭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122551124','荮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225511525','莼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122551251125221','蕴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122551353334','蒃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122551354','药',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12255144','苺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122553','芗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12255345115452','薌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12255435','苭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554444121','葒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554444124','葤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225544441525','蒓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554444251125221','藴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12255444425112522154','蘰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225544442534','蒳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225544442534125221','蘊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554444344311354','藧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225544443453','蒶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554444354','葯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1225544443541112454','蘕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12255444435444','蔠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554444355215','蕝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554444554234','蕬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122554554','茲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('122555125121','葘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12255525121','菑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123','才',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123251115132125','鼒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234','木',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234','朩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341','本',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411121112511','槥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111211125114544','櫘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111215','框',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111251113454','樲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111253134','楔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341113124','梼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411134112','棒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111341134','楱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111342511','椿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341113431234','榛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411134321511','樁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111352','梆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234111543','桟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234112','杅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234112','杆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341121','枉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341121132','梇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411212511','棈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411212511134','樍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234112154','栻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341121554234','榡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341122125121','構',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411234','枺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411234','柰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411234','标',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234112343534','歀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341123451124134','隸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234112534','柡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341132','枅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341132543','械',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341134','枎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234113411342511134','櫕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411342511135','槻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341135','杬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234115','杇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341153512','桺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341154','枟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123411543','栈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412','朾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121','杜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121','杠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121','杢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341211121115','榧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412111534','棖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121121','桂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121121121135','橈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341211254444','榪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412121','柾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121213415543','樾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121222511134','橨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121251','桔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341212511121','榸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341212511134','槓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341212513534','榬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121251431124','樹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121251431251','橲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412125145154121','檯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121252212511134','櫝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121315','栲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412132','枿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412132511','楮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121335','栳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341213352511','榰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412134121354','槸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412134354','棱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234121431112454','橽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341214544','梽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412151211251124','檮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412152','桏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341215425221','榼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412155121','椏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412211','柑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122111','栮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122111122111122111','欇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122111234','楳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341221112511121','檉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412211134','棋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412211134121','樭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122111345','椹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412211134554234','櫀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412211152','椰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412211154','棷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341221122112','樺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122112512134','橫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122122111','榵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412212251','楛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412212511','棤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412212511121','槿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341221251112454','櫣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122125113134','橵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412212512134','横',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412212512512515','櫙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412212514334','樮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412212523434','樠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412213251','楉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122134','栱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341221341251112','檋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412213513125125543','欌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412215','枻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122151234','楪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122155125121','橊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341222511134','模',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412225112511125431234','欗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412225113511','橗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412225125132411121','權',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122251251324111212511135','欟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412225134','楧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412225221134543','櫗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412232124','﨓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341223235','椛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412232411121321511','欍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122324111214444','櫵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341223241112154','檴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122341251','榙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122352511','槆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122353344544','檧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341223541112','樥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412235445411234','櫒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122431','桠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341224312511','榗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341224411251124124','欂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341224511353334','檬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412251','枯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412251111','植',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341225111134','槙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122511121543','橶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341225111234112','檊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341225112321155212','櫹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341225125112512511','櫮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122513511','楜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122514143112','橭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412252','栉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234122543112','楠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123','材',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234','林',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123411234','禁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234121','埜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123412211154','樷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412341234','森',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234123452134','檚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234124','梺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412341311534','辳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123425111','楂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123425121','榃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234333','彬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234341252511','檣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412343434','棶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412343445','棽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412343453','棼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234353251214','檒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234354','梦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234354','梵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123441352211535','麓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412344334','焚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412344535','棾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234454','椘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123452','郴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234123452134','楚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341234531','婪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234124','村',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341241344','梂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412431252511','樯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341245521','桲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125111','桓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251112454','槤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412511214124','槫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125112144544','橞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412511234','棟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251124124','榑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251134','梗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125115315','椻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412511543','棫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412512','柯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251211251211','橿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412512125111345','櫃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412512212511','槽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251234','梀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125123422','楋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251234352511134','櫴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412512343534','樕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251245251251112213534','欜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125125','栕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251251','梧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125125121','楅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412512512515','樞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412512531425221','檻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125125314252212511135','欖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251254312','槅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412512554121','樫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341251431','梪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341252','杮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412522111234','標',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341252211123422','檦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125221134515454','櫏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125221251112','橝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341252212511134','檟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341252212534','槚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125221531','楆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125234','栜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412534','柄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125351','栖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341253511','梄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412535114444','槱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341254','枝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341254125441352211535','欐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234125431234','楝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123412544134','椟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341311534','桭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341311534124','槈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234131212511','楕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413121251431124','櫉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413122','枾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413122251125214','櫔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234131251431124','橱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234131251543','椷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234131531543','楲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413211234543','槭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341324','杯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413241','柸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341324251','桮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413251','柘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234132511','栢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234132511','栯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341325111354','榎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234132511454544354','櫌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341325125251','槗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413252','柨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234132521','栫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234132522','栭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341331234312342121','櫪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341332511234','榞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341335','枥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234134','杕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234134','杖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234134115','桍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413411533544','槬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234134121121','楏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413412512','椅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413412512512515','檶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413425243434343','檷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234134315233534','橛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341343434','梜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341344','枤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234134432511234','橑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413443434343','樉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341345','枢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234135','杌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234135','杤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413533434','椓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234135422','栵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413543','栊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413544','柭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123413545','柩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341355','枙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123414312','枰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341431234','梾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123414524444115','樗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234145244441154','橒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234145244441221251123511','欛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123414524444132522','檽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341452444425121','檑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123414524444251251251','櫺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234145244442512512511234341','欞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123414524444511','樰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123415','朽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123415112531','棲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341512454','梿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341515','柜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234151534','桋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341523','枒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123415234','栋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341525','杶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234153135','桡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341535','枇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341535121','梐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234153515352511','橬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234153532511','楷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234154','杙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234154121','桎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123415412122','椡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341541541','翉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123415431543','棧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341551','枑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12341555121','桱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421112111','棑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234211124','桛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421123454','椒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342121','杫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342121131233543','檅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234212135554234','橴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421251','枮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421251112','棹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342125111234','槕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234212511134','楨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234212534','桢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421254344441','樐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421513','栌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421531525111','樝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342153152512125221','櫨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234215315251214544','櫖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123421531535','椃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342153154134','榩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342231425221','槛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234223142535','榄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342243143111234','檏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234224314311134','樸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234224314311212211154','欉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342343','杪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123424','朴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234243135','桄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342432511','梢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123424345251121','樘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234243452511234','橖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234243452511523','橕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342434525125121','檔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123424345251254312114444','欓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234243511','档',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251','杏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511','杳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511','枏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111','柤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111','查',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111','柦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111','査',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111','相',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511112','桿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111124','棏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111134','椇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511121','桯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511121','梩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511121124','榯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251112211154','樶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111234','棵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251112511132411121','欋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111251113241112154','欔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511134','梖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111342511134531','櫻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511135','梘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251113533','楊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111353332511154444','鸉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251114544','想',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251115132125','檙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511153254','皶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425111535','棍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112','柙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112','柛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112141','椢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251122111','楫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251122111543','檝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511243135','榥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112511','椙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112511','椚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251125111121','橍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112511125431234','欄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251125112511','橸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251125112511','橺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112511251251','櫚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251125113511','橌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511251135321511','櫩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112511354251','櫊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112512531','樓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251125125313134','櫢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251125221','榅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425112522154','槾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251135345','楬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425115','枵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251153','栧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342511541541','榻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425121','柚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425121','柟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342512115','梬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251211534','椳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251212511134','樻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251212512125121','櫑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251212512125121554234','欙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251213432','楐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251214251214','螙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251214544','楒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425121554234','樏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342512211311534','檂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425122113115341234','欁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425122134','椣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425122511','棝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342512341','梱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251251','桐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251251','梠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342512511','梋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425125112141241','檲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342512511351221113134','欕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425125115431','槶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342512512','梙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425125124544','槵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251251251','楍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251251251','榀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251251251112','樿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342512512511234','橾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425134','枳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425134','柍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234251341','栶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425135','柷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425135','柺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425153','枴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234252','杣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342521251431','榿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234252132522','椯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425221','柵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342522112143112','檡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342522112513534','檈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342522121112111','檌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425221354','椤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234252214135','楞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342522155444432411121','欏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425232411121','槯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234252324111212534251','欈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342523445','梣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342523453','梤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234252515','桤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425312341','棞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342534','枘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342534125221','榲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425342534531','樱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342535','枧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425351','柶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12342543','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425431252','棡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425431415','棢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425525251','楇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123425525251454','檛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234255452511','榾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343112','杵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343112','杽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431121','栍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431122121','棰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234311222214444','橅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234311234','株',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343112521234453444445235333','鬱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431132411121','権',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431134','柣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431134251','椥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343115','枆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234311531153115','橇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234312','杄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431211','柞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343121251','梏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343121353121352511134','欑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234312154','梃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234312251','栝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431234','柇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343123422','梸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234312342511','楿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234312344334','楸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234312511354','椱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431254312114444','櫄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343132','枡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343134','枖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343134','枚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234313425125251','橋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234313432','桥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234313541','栴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431431412132511','櫡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431431412211134','檱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234314314352511','橁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431431441121','樦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234314314431251122','櫤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343143145115452','櫛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234315','杔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234315','杚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431511234','棅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123431525','柂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343154','枨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343155144','梅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234321113554','椴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343211152511134112','櫸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432111525111343112','欅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234321155212','棩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343212134','梹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432124','柎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234321251134','楩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234321344','栿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234321511','桕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343215111213554','檓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432151134','楰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432151135','棿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234321543','栰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234321554','梴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234322','杊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343223541234','樤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343223542511','樇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234322511234','椺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234323121','栣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343235','杹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234323512','桦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432411121','椎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343241112112','榫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234324111212525','檇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234324111213241112154','欆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234324111214444','樵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343241112153','槜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432511','柏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325111121','楻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251113124','榭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251113412','槔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325111413412','橰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325111445344135','櫋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251115','梍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251115252','槝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432511154444','樢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325112113535','橷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432511252','棉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325112534','楾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432511255115115341','櫷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432511312','椑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251135','梎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432511351535','槪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325113554','槐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251135544412','櫆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432511413412','槹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251141341234','檪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251141353134','檄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325115545541234','櫟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325125214','楀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325151','桘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325151454','槌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343251532','梻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234325221','桖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123432535414544','樬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343312','析',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433121234','椞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433122511','晳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234331225111','楯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343312251214','蜤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234331232511','皙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234331233122511134','櫍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433124','柝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433124544','惁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433135','栃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343315215','梔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433155','栀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234332112','桁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343321531535','榹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433234342134','樅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343324','枛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234332441112','椼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234333','杉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343354','板',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123433544','柧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434','朲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434','朳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434','杁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234341','巫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234341121','栓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343411234','梌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434112431511534','檭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234341154','桧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343412511135','覡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234341251122','榆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234341251155','楡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434125122','棆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343412512513434','檢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434125134','検',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434125152','椧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343412524312511','檜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234341252511','嗇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343412535','觋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434132511154444','鵐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434135451','鹀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343414431','检',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343415','枍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234341534','桃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343424134','桼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234342413452','厀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434251','柗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343425135','梲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343123425121','橎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434','來',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434','枞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434121','桽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434341211121111543','櫼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434132511134','顂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434341344','猌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343413444544','憖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434342511134','賚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343432511154444','鶆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343435','勑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434354','麥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434354111221112521251431','麷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434343541134','麩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434343541215','麫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343435412154','麮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343435412343434','麳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434343541251124','麱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434343541255','麪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434354132522111','麵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434343542343','麨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434343542511135','麲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434354251221','麯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434354315','麧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343435435431234','麴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343435435515','麭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434343544134522554','麶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343435453254','麬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434354543112','麰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434354544','愸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343434454','逨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234343452','郲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234344134522554','檎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234344311354','楥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434431215114544','檼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434431234','棌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343443311252','榣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434433112523554234','櫾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343443321511','槄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234344345354152','橓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343443521','桴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343443531','桵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343443554134','榽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343445','枔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343445113251','槍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343445251','梒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434452511134','賫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434452534','赍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434454','柃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434454544','棯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343453','枌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434531234','椕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343454','松',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343454','枩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343454','柉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123434544544','棇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343455','枪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435','朸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435','朹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435','机',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435','朼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343511','枂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435113511','棚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234351143113435','橳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435115254','棴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343512','枠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435121251','椆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343513344111251','檐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234351355','桅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343515251','桰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435152511','棔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435154','柢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343523','柹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435234','栎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435251','枷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435251','枸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234352511','栒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234352511','栺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343525111534','槇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435251153535251354','欃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234352512112511','橹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234352512144442511','櫓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343525121444431234','櫯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343525135','梚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435251353334','橡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234353251214','楓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234353344544','楤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343534','杴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343534334','梑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435351','栅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343535112','桷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435351124412','槲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343535112533112','檞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435352','柳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234353535','栛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354','杋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354','杓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354','杦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343541','枃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343541','枬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343541112','桻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343541112454','槰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354152','栙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354152','桝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343541521234','榤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354251','格',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343543','枫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435431234','椈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354354','栘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354413444444','橪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435444','柊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435452','栁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435452','桞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234354532511134','橮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343545325121','榴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234355112','棦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123435515','枹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343552','枊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234355215','栬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343554','杸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12343554','构',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344','术',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234411125112132511','櫧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441121','柱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125113534','榱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441251234','椋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441251251112213534','欀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125125251','槁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234412514512','楟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441251451353334','檺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125152','梈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441251521','椁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234412515213134','橔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125152152','槨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441252','柿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125221241343534','櫰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125251111234','檩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125251125111','檀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344125251131234','檁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234412534','栤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413121','桩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413121251431124','櫥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441312212512134','櫎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441312214444','樜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441323544','棭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413312154','榳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441332124','椨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344134131134','槉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413434','校',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441343412','椊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344134522554','樆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344135','杭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344135','枋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344135112251','榶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441351124134','槺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441351125112','槦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441351134','椩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344135121','堏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441352211535','樚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413522154544354','櫦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441353113412512','檹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413531525','椸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413534','栨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441353444','棜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413543345153554','櫠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234413543543534','橠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441431','柆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344143112','梓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234414311234','榇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344143112342511135','櫬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441431251','棓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441431251112','樟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234414312511121','橦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441431251121515111','櫳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441431251135','樈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344143125114544','檍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344143125115','槞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234414312511543','樴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234414313333','楌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441431531','椄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441432512251','樀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441432533543211','櫅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234414345252','楴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344143454135','榜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234415','杧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234415334','核',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123441542511','棛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344154325','梳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234415432525221','橀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344155425121','槒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234425251251','榈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443111','栏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431112','样',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431112431251','橏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431113121','槎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443112','柈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344311212534','様',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344311213121543','檥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431121413534','檨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344311214444','榚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443112145534','樣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431132','栟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431134','栚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443113453','椦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443113455','棬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443122431','椪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431234354152','橉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344312343554','榝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443123443554','樧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431234531','楼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431251122','椾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431253511','楢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431253511124','樽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431253511134','橂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431325111454','檤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344313252','桸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344313425221','榏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234431353334454','檖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344315112234','槏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443251112','椫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344325135','棁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234432524312511','橧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443344334','棪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344334433421251','檆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344334433445251251','櫿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234433443344535','橩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234433443344535','橯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234434242','栦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443431234','棥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443431234134','樊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344343123413413251','礬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443431234134251214','蠜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234434312341343112','攀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234434312342522151154124','欝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344343123434112431','鐢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234434312344334','燓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123443431234453444445235333','鬰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234434312344551154124','欎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344351523','梯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234435234354','椶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344412','枓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344412343','桫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444153441234','樑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234443134112','榉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344431343112','﨔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234443531','桜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344444','杰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344451112252214544','櫶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444511234','棕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344451135','梡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444512','柠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444512134','椗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444512332511134','檳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234445125111','楦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444513412512','槣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344451353334','榢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234445154121','榁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444525111','椬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444525151','棺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344453212134','槟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444532132511','樎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444534','柼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444534121','椌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344453431211','榨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344453434251','榕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444535','柁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234445354251','楁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444535445411234','檫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444535455','椀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344454','述',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344454143112','榟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234445432511154444','鶐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444544','怸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234445454425112','橣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444545442522112','檸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444545443251214','櫁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123444545443252','樒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234445531','桉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344511534','桹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344511543511','樃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123445115452','榔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344512132511','槠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234451251112','楎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344513','枦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123445131344','棙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234451325122','楄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123445132515215','槴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123445134135','椖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234452425112','榊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344525114134','榠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344532411121','榷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123445341234','棎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344535','枕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344544','杺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123445443','柲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12344544325221','榓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123445534','栐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345','札',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345','朰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451111254','楗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234511121251124','樳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234511124','桪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345112321155212','橚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451124134','棣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451124134','椂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345113251','桾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234511352','梛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345114334','棂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345114554','梫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234511511511','榋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234511534','根',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234511541535','概',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451154153525111','櫭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345115452','楖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345121','杻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234512115154','椵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234512151215121','橻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451221113134','橄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451251','柌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345131221534','榐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451312251','椐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234513154121','楃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234513241342522135251214','欘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234513241343112','樨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345132432511','榍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345132514143112','檘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345133115','梶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451335','柅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234513521521521','樼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345135251','梮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234515','杛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234515','杞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123451532','柫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345154151541','榒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345154544','梞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123452','朻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234521','杍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234521','李',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345212511234','樄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234521251152','椲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345213121','梉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123452131212511','橢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123452132511','椭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234521325111','楣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234521342511','楈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345213554234','槂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345215','杷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123452251541','極',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123452252','柮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234525','杝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345251214','蚻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123453','朷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234531234','桗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123453251','柖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123453254','柀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123453254132511134','櫇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234533','杨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234534','杒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234534','极',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234534353432','榌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345344544','梕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234535425221','楹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454','权',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454121','柽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454124','树',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345413412','桳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454134333','椮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234541541','栩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454154132411121','櫂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454154132511','槢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454154134333','樛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454251','枱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345425112','桶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345425112454','樋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234543112','桙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234543341134','楑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234543341251431','橙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454334125143135','櫈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234543345153554','橃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345434354','梭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234544','杈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345452','杼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454523','柕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234545231234','楙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234545231234','楺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234545231234121','壄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345452312344544','懋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234545232534251','橘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234545235251353334','櫲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345454541234','槡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454545434333','槮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123454545454','棳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234551','杩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234551353334','椽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234551353334251214251214','欚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123455144','栂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234551551353334','橼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123455212511134','樌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123455435','柪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123455444432511252','檰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234554444551353334','櫞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234554554134543','機',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123455455415545545','檵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123455525111234','樔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123455525121','椔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1234555354','桚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12345554234','紮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12353535','協',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12354','朮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123544','协',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('123544544','怷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124','下',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124','寸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1241344','求',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124134425221','盚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12413443134','救',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124134431344544','慦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1241344413534','裘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1241344454','逑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124134453254','皳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12422','刌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12431252511','啬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12431534','丧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124353251214','颪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124454','过',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1244544','忑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1245','乤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12452512152134','疐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12454','辻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1245521','孛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124552132511154444','鵓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124552135','勃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124552135451','鹁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1245521354544','愂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('124552152','郣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1245554234','索',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251','五',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111','亘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112','車',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111211121112511','轊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112111215','軭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112111341134','輳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121113431234','轃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112112','軒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121121','軖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112112121511','輤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112112154','軾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121154','転',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112121222511134','轒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121212513534','轅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212134354','輘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121221115','輒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212211154','輙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112122134','輁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121222511251132411121','轥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112122251135345','轕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212251','軲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121234341252511','轖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212511121251112','轟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121251112454','轋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212511214124','轉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121251124','輔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212512','軻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112125125121','輻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212512531425221','轞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111212523434','輛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112125252','輌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121253511','輏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112131251543','輱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121312515434544','轗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112132522','輀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112132522134','輭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121331234312342121','轣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112134','軑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111213412512','輢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121344','軚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112134432511234','轑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112135','軏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111213544','軷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121355','軛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111214312','軯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111214524444132522','轜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111214524444511','轌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121525','軘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112154121','輊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121543','戜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111215431543','輚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511121555121','輕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112155512134112431','鑋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122','刯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111221112111','輫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122153152512125221','轤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122154','軙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112224314311134','轐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111222431431121124','轛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112243135','輄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122432511','輎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112251','軎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111225111234','輠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112251113533','輰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111225111535','輥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112251122111','輯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112251125221','輼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112251135345','輵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111225121','軸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112251212512125121','轠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111225134','軮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111225134','軹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111225135','軦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122513554','毄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112252','軕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112252132522','輲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122522112513534','轘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122534','軜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511122534125221','轀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111225431415','輞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111231133112','輧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111231134','軼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123115','軞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123121','軠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112312511354','輹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112313425125251','轎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111232124','軵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111232151135','輗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112325115545541234','轢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123312','斬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123312121','塹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111233121234','槧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112331213251','磛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111233122511','暫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112331225111','輴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111233122511135','覱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111233122512134','蹔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112331234112431','鏨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111233124544','慙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112335144','輈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111233544','軱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112341121','輇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112341251122','輸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111234125122','輪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111234312','軤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112343123425121','轓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111234333','軫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123434251','輍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123443321511','轁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123445','軡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111234454','軨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235','軌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235113511','輣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235121251','輖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123515','軝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235154','軧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235251','軥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123525135','輓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235321511','輡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123534','軟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112354','軓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112354111251','輷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112354251','輅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235515','軳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123554','軗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111235543112','撃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511123554554234','繋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111241121','軴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111241251234','輬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511124134','軣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112413434','較',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111241352211535','轆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112415334','輆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112415425113134','轍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511124311213121543','轙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112431132','軿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112431234354152','轔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112431253511','輶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511124451112251','轄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511124451135','輐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111244525151','輨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111245135','軶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112454','連',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125','軋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125111324111215','匷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125113251','輑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112512','軐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125131221534','輾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112513521521521','轏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112523554121','墼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125235541234','檕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125235541251112','轚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111252355413251','礊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112523554251214','蟿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125235543112','擊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112523554311252','罊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112523554554234','繫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111253251','軺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112534','軔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111254121','軽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511125413425121','輽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111254154134333','轇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111254251','軩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112545231234','輮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111254545454','輟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111255453','軪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251112555125121','輺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111255525111234','轈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125111255525121','輜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112124','専',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511214124','專',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112141241554','甎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251121412422','剸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251121412432511154444','鷒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251121412452','鄟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112144544','惠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511234','東',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251123432511154444','鶇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251124','甫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251124124','尃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112425135','喸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112425221','盙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112432511154444','鵏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511244135','旉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112441353134','敷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251124413531344544','懯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251124454','逋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511245','乶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125112452','郙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251124544','恵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251125','匣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511254','叀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251134','更',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125113431121','甦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125113452','郠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125115315','匽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511531532511154444','鶠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511531552','郾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251153334','彧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12511543','或',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125115434544','惑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512','可',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125121','再',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251211251211','畺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251212511','曺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512125111345','匱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251212512','哥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512125121543','戨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512125123534','歌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512125345','匮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512152','画',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251221','亜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512212511','曹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512212511454','遭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512214544','悪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234','束',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234132511134','頼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125123422','剌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234223112','揧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512343134','敕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234313412121','整',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234313432511154444','鷘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512343134454','遫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125123431344544','慗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125123432511154444','鵣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125123435','勅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234352511134','賴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234352534','赖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512343532511154444','鶒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512343534','欶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512343534454','遬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512344143112','辢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125123444','栆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251234454','速',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251245132511234','橐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125124513251251214251214','蠹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251245251251112213524','囊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125124534112213534','嚢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251245354242511234','櫜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125124552252251214','蟗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125','臣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251251','吾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125121','畐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512512122','副',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512512132511154444','鶝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512512143125125121','疈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125121454','逼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512512511125','匰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512512515','區',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125125151554','甌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125125152154','敺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251251251522','剾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251251251532511154444','鷗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125125153534','歐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125125153554','毆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512513134','敔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125132511134','頣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251251454','逜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125152','郚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512524','卧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125251245442511134','贒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125311225125221','盬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125312125434444125221','鹽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512531251251251','臨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251253142511135','覧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512531425221','監',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125314252212511135','覽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125314252213112','擥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251253142522134112431','鑒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125314252214111251','譼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512531434112431','鍳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512534','臥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512535111121','朢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251254','叓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251254312','鬲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251254312122125112','鞷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512543121251124','鬴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251254312251214','融',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125431231251113533','鬺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125431232511154444','鷊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125431235451','鹝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512543123545325121','鬸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251254312435234354','鬷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251254312541541','翮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512554','臤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512554121','堅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125541251431','豎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251255413251','硻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125542511','腎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125542511134','賢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512554251214','蜸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125125543112','掔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251255434112431','鋻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251255441431','竪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512554521','孯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512554531','婜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12512554554234','緊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125134','吏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251431','豆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251431121','豇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12514311254','豉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251431132511134','頭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125143122','剅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12514313115','毭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125143132511312','豍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12514314315112234','豏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125143144535455','豌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251431454','逗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125143152','郖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12514544','忢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12515','叵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12515112','事',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251511222','剚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12515124','尀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1251543','戓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252','巿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252','帀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252','邒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221','襾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221','覀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522111234','票',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522111234132511134','顠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211123422','剽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522111234333','彯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211123433544','瓢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211123435','勡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522111234353251214','飄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221112343543','飘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522111234541541','翲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221121','垔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211211554','甄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211213534','歅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522112152','鄄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211221251121211254444','覊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522112212511213412512','覉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211221251123511','覇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252211234','栗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221123432511154444','鷅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221134515454','遷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221251112','覃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12522125111232511154444','鷣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252212511134','賈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252212534','贾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221321344','覄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252213251141353134','覈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221332312511354','覆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252213454','覂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221431234','粟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125221531','要',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252215313533','覅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125232511154444','鳾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125234','朿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125234125234','棗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125234125234','棘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12523412523434','僰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12523422','刺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252343134','敇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12523434','兩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12523444','枣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12524444','雨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1252454','迊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12525','匝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125252','両',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12534','丙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253434','两',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253452','邴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351','西',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511','酉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511112','酐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511112','酑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111134','酜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111135','酛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111154','酝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112','酊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112132511','醏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111213521','酵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112151211251124','醻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111215425221','醘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112211','酣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112212511','醋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111221251211354444','醼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511122341121','醛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111224313','酽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112251','酤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511122513511','醐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112341234','醂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511124','酎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111251124','酺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112512','酠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112512212511','醩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112512512515','醧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351112522111234','醥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511125221251112','醰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111254125441352211535','釃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111254254','酾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511131251543','醎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511132511','酭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111325125221','醢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351113425115','醃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535111344','酞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351114524444132522','醹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351114524444251251251','醽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351115431543','醆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351121251','酟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112153151353334','醵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511224314311134','醭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112511121','酲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511251112134','醍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351125111535','醌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511251125221','醖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511251131121','醒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112512211251431','醴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112512211311534','醲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511251251','酮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112512511351221113134','釅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112513425221','醠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112522112143112','醳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535112534125221','醞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113115','酕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351131211','酢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113121251','酷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511312135','酰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351131234','酥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351131254312114444','醺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113155144','酶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511321511254','醙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351132411121','醀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511324111214444','醮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511325113554','醜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511341121','酫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113411234','酴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113412512513434','醶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113443124','酹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351134432522151154124','釂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113443521','酻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113453','酚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113512','酔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511352511','酯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351135311252','醄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511354','酌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511354251','酩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511354251','酪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535113554','酘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511412512511','醕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351141251251112213534','釀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351141251521','醇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114131234123421112111','釄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351141312341234431234','醾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351141312341234554234','醿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114134112213534','醸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351141343412','醉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114134522554','醨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114135112251','醣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351141431251','醅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114143125114544','醷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114154325','酼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511415432525221','醯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511431113121','醝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511431234454','醚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351143344334','醈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511434242','酬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114352','酗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114412','酙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511445124','酧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114453431211','醡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351144535','酡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114511534','酿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535114535','酖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511453525221','醓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511454','逎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351151124134','醁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511515','配',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511521342511','醑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511525','酏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351153544','酦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351154154134333','醪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511543341135','醗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1253511543345153554','醱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535115434354','酸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351154545434333','醦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351154545454','醊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535115542511','酳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125351454','迺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12535154','廼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254','支',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254125441352211535','麗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125412544135221153532511154444','鸝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254125441352211535333','彲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254125441352211535454','邐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125412544135221153552','酈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12541254531','婯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254132511134','頍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254254','丽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254254333','彨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125425435451','鹂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254254454','逦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125425452','郦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125431234','柬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12543123432511154444','鶫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125432511154444','鳷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125435','攰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125441','亙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('12544134','卖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('125441342535','觌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254511121251124','攳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1254541541','翅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1255','丏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13','丆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13','厂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13112','厈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131121353134','厫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311345','医',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13113453554','殹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311345355411214','瑿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131134535541234341','毉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131134535541253511','醫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311345355425111','瞖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131134535542511134','贀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13113453554254312114444','黳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311345355432511154444','鷖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311345355435451','鹥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13113453554531','嫛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13113453554541541','翳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13113453554554234','繄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13113454544','悘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311534','辰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311534124','辱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131153412452','鄏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311534251','唇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13115342511','脣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1311534251214','蜃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13115343134','敐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312','厅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13121','圧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13121','左',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13121121','厓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312125113115','毻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131212511454','遀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131214','压',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13122111343312','厮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312212511','厝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312212511121','厪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13122251125214','厲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312225112521435','勵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131225111134','厧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13123412342121','歴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13123412342511','暦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312341234544','厯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13123425111','厢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131251112','厙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131251431124','厨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131251543','咸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131251543132511134','顑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312515433535112','觱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1312515434544','感',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131325111354','厦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131344','厌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131344132522111','靥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13134425112','厣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131344254312114444','黡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131344325113554','魇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131344344511534','餍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13135','厉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131353334','厖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1313535','励',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1313543','厐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1314314251111325','匴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1314334543','烕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131512','厍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131523','厊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1315251','丣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131531543','威',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13154121','厔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('131543','戌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132','丌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132','廾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1321112111','厞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13211234543','戚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13211234543132511134','顣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132112345432512134','蹙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132112345434544','慼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1321135','兏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132121','在',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1322','卅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13221545252','帶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13221545252454','遰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132215452524544','慸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1324','不',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13241','丕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132412121','歪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1324125221531','嫑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1324134','奀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1324152','邳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1324251','否',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13242511135','覔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132425221','盃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132432511154444','鴀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13243252513134','厰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132435112','甭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1324454','还',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1324531521','孬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325','冇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251','右',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251','石',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511','有',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511','百',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251111253134','碶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511113432','奡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251111543','戛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251112','矸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511121','厘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511121132','硦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111212151534354','夒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111212154','碔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111212511','碃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111212511134','磧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111212534','碛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511121353134','磝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111214','砡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251112155144','碡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111234','砞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251112511543','戫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251113112','硏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511132','研',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251113222','硎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111323112','揅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511132511','皕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511134','砆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511134','頁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511134132511134132','顨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251113422','厠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511135151134354','夓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325111354','夏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511154','砖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511154544','悳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112','矴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251121','矼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251121121','硅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251121121121135','磽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511211254444','碼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511211254444413434','礮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112112544444343','礟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251121251','硈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511212511134','碽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251121251431251','礂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511213234','硳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251121335','硓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112134354','碐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511213521','硣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112154','砝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511215425221','磕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251122111345','碪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112211134535','磡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511221215425221','礚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112212511','碏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511221251124124','礡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112212512134','磺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112212512531425221','礷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251122134','硔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251122151234','碟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251122251135345','礍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112225125132411121','礶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112225134','碤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112225221134543','礣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511223235','硴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112234','砹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112235445411234','礤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251122415','硭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511224411251124124','礴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511224511353334','礞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511225111134','磌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112341','砵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112341234','碄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511234123452134','礎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251123425111','碴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112343454','硹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511251112','硨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125111344','厭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125111344121','壓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511251113441234','檿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125111344132522111','靨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112511134425112','厴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125111344254312114444','黶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511251113443112','擪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125111344325113554','魘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125111344344511534','饜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511251113444544','懕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125111344531','嬮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112511214124','磚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511251124124','磗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511251134','硬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112512','砢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511251211251211','礓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112512531425221','礛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125125542511134','礥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112522111234','磦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125221251112','磹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325112525','砸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251125351','硒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113115342511','磭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113122251125214','礪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251131251543','碱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113153','砺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113211234543','磩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113251','砳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251132511134','碩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511325113251','磊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251132522134','碝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251132534','硕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511331234312342121','礰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113412512','碕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113425115','硽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511343434','硤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113443434343','磢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251135','矹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511353334','硥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325113533434','硺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251135424251','厬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511355','砈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251141431251121515111','龓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325114312','砰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251143134','硖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511451543','戞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325114524444123425111','礵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325114524444132522','礝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511452444425121','礌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511452444432411121','礭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511454','迶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511454544354','憂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251145454435452','鄾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511512','砗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251152','郁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511521','厚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511523','砑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511525','砘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251153135','硗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511535','砒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325115431543','碊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511553','砌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511554','砙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132511555121','硜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512121','砋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325121251','砧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251212511134','碵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512125431','硵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325121254344441','磠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325122','矵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512243143111234','礏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512343','砂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251243135','硄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512432511','硝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512434525125121','礑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251243452513112','礃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125111','砠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125111124','碍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251112134','碮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512511135','硯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251113533','碭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125112','砷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251125112511','磵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251125113511','礀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251135345','碣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125115545544444','礘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251211534','碨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251212512125121','礧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125121554234','磥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125122134','碘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512512341','硱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251251','硐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512512511134','磒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512512511351221113134','礹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251251251251112','磾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125212512','碋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512521251431','磑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125213112','硸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251252134334','碳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512522112143112','礋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125232411121','磪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125234125122','磮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512523445','硶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125235113511','磞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251252511','硘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251252515','硙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125312341','碅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512534','泵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512534','砅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132512535','砚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125431252','碙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325125525251','碢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251255452511','磆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325131122121','硾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251311234','硃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325131211','砟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513121251','硞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513121353121352511134','礸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513121543','硪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251313425125251','礄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251313432','硚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251315','矺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251315','矻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325131525','砤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251321113554','碫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513211152511134','礖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251321511354444','磶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251321554','硟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325132411121','碓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251324111211234','磼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251324111214444','礁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325132511','砶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325132511312','碑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251325113554','磈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513251141353134','礉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251325115545541234','礫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251325151454','磓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251325431','硇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513254311535','磇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251325431234134','礇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513312','厛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513312','斫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251331225111','碷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251331233122511134','礩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513321531535','磃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325133234342134','磫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513351153554','磤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251341121','硂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513411234','硢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325134112431','碒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325134121','砼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251341251','硆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325134125122','碖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513412512513434','礆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513414431','硷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251343123425121','磻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513432','砎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513434251','硲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513443311252','磘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513443554134','磎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513445','砛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325134454','砱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513453','砏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513454','砭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135','劯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135','厑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135','矶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135112','砽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135113511','硼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513512','砕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135121251','碉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251351355','硊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135152511','碈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135154','砥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135234','砾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135311345452134','礙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251353251214','碸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513534','砍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513535112','确',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251354','矽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251354','矾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251354','砐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513541','砃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513541521234','磔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251354251','硌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513543','砜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135445411234','磜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513545325121','磂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251355112','碀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325135515','砲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132513554','砓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325141121','砫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514125125251','碻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251412514512','碠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251412515213134','礅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251413','矿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325141312212512134','礦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514131234123413251','礳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251413234','硛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514134','砇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325141343412','碎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514134543534','磙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514135','砊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514135112251','磄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325141354','砿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325141431','砬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325141431251','碚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325141431251121515111','礲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251414345252','碲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514143454135','磅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251415334','硋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514154325','硫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325142534','砯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431112431251','磰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431113121','磋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325143111344511534','礢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514311213121543','礒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431132','硑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325143122431','碰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431234354152','磷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431253511134','磸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431353334454','礈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514315112234','磏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431523454','磀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251431554554','磁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514315545544544','礠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251432524312511','磳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251433443344535','磱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514334433445554234','礯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325144115151234','磲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514451112251','磍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325144511234','碂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325144512134','碇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325144512332511134','礗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251445125111','碹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514451354','硡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325144534121','硿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325144535','砣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251445354251','碦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325144535455','碗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514511534','硠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251451325122','碥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325145135','砨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132514532411121','確',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132515','乭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251511112','硉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325151124134','碌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251511534','硍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251512115154','碬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132515131221534','碾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132515132432511','碿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132515132514143112','礔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132515134','砄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325151532','砩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251521','矷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325152252','础',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325153254','破',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251533','砀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325154121','硁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325154134333','碜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325154154132511','磖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325154154134333','磟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325154251','唘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132515425112','硧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251543341251431','磴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132515454541234','磉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325154545434333','磣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251551','码',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325155144','砪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251554554134543','磯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13251555325431','碯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13252','布',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132521','存',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522','而',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522111','面',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325221112511135','靦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522111251212511134','靧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522111251214251214','蠠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13252211135','勔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13252211135515','靤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522124','耐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522134','耎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13252232511154444','鴯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522333','耏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13252235451','鸸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1325224544','恧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132522513','耍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13252511','靣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('132534','页',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13253422','厕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1331122121','厜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13311252','厒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1331211','厏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('133123431234','厤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13312343123413251','磿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1331234312342121','歷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1331234312342511','曆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('133125','匠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13315','厇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('133232411121','雁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1332324111212511134','贋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1332324111212534','赝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('133232511154444','鴈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1332325111544442511134','贗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1332511154444','鳫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1332511234','原',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1332511234132511134','願',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('133251123413325112341332511234','厵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13325112344544','愿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13325112534','厡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1334','仄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('133412512513434','厱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1335','历',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1335154','厎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134','丈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134','大',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13411','夳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13411234','奈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134115','夸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13411522','刳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13411532511154444','鴮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13411533544','瓠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13411535515','匏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341153554234','綔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341154','夽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13411552','郀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412','夲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134121','圶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341211154','套',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134121121','奎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412132','奔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412132454','逩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412132511','奢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412132511251251251112','奲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134122111','耷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134124','夺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412511225','匬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412512','奇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134125121254','攲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134125122154','敧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341251222','剞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341251232511154444','鵸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134125123534','欹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412512512515','奩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134125125134345','匳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13412515','匼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134132522111','奤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134134','夶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341345','奁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134143112','厗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341431251121515111','龎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1341515','奆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1342121131233543','奯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134234','夵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134251','夻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13425113511','奛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13425115','奄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1342511522','剦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1342511532511154444','鵪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1342511535451','鹌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13425121','奋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13425243434343','爾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1342524343434311214','璽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13425243434343121','壐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134252434343432511135','覼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13425243434343251214','蠒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1342524343434332511154444','鸍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13425243434343454','邇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134315233534','厥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1343152335341234','橜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13431523353422','劂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1343152335342512134','蹷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134315233534251214','蟨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13431523353432511154444','鷢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1343152335344544','憠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13432','夰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134322','夼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13432411121','奞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13432411121124','奪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1343241112125121','奮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134334','灰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13433425221','盔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1343434','夾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1343434132511134','頰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1343434231344544','憗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134343432511154444','鵊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134343452','郟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13435','夯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13435113511','奟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13435121251','奝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13435154','奃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13435352','奅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134354354','奓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1344','太',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1344','犬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134413441344','猋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134413441344353251214','飆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1344134413443543','飙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134415334','奒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134425221','盇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134431112','羍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134432511','昚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1344325111','眘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134432511234','尞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13443251123432511154444','鷯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13443251123435451','鹩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134432511234454','遼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13443434343','爽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1344343434332511154444','鷞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13444','冭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134441321155212','奫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1344454','迏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1344454','迖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13444544','态',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134453112','牵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134454','达',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1345','区',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13451554','瓯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1345215','夿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134532511154444','鴎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13453534','欧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134535451','鸥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13453554','殴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13454','厺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('134543','戍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135','万',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135','兀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135','尢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135','兀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1351121','尪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1351121','尫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13511541535','厩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13512512531425221','尶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13512512531425221','尷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13513125125543','臧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1351353334','豗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1352231425221','尴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135251212511134','尵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1352512134','趸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135251214','虺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135251214','虿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135255452511','尳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135312511121','尰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353325115','匫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334','尨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334','豕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334113112','豣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533341132','豜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334121222511134','豶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334121222534','豮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333412132511','豬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334121325111234','櫫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334121451251431','豷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533341251124','豧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533341332511234','豲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533341353334','豩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333413533344334','燹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533341525','豘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533342135333452','豳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333425111','豠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334251125221','豱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334251214251214','蟸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333431121','甤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333433234342134','豵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533343443554134','豯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333435251','豞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533343554','豛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333441432512251','豴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334415334','豥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533344313252','豨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135333445135','豟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334454','逐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334511534','豤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353334512115154','豭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533345215','豝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13533434','豖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353343422','剢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135335','匢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1353432','尬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13535','劢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135351355','卼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135351355','尯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135354','尥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354','厷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354','友',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354','尤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354','歹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13541113431234','殝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135411543','残',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354121211121111543','殱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354121252212511134','殰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354121451251431','殪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135412212511121','殣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354122151234','殜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135412251111','殖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13541225135','殑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13541241344','殏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13541251211251211','殭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13541251234','殐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135413221545252','殢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135413425115','殗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13541343434','殎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354135454431234','殩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135415431543','殘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13541555121','殌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135422','列',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542232511154444','鴷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542234112431','銐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542235','劽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542235251214444','鮤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542235451','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135422413534','裂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354224334','烮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354224444','烈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135422454','迾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135422531','姴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135425111','殂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354251125221','殟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354251212511134','殨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354251212534','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542512511134','殞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354251251251112','殫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542512534','殒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135425134','殃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13542522112143112','殬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543','戊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543','龙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135431121','殅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354311234','殊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135431134','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354312','歼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543121','垄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543122111','聋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543122134','龚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135431251113533','殤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354313251','砻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543134','殀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354315112234','尲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135431533','殇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135432411121','雄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543251111344','殠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135432511154444','殦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354325221','殈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543312','歽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135434111251','詟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543412512513434','殮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543413534','袭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543414431','殓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135434333','殄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135434333344511534','餮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135434341211121111543','殲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543443521','殍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135434451154','飱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135435','死',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135435152511','殙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354352511','殉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543533','歾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13543554','殁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13544','犮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354412512341354','殧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135441431251','殕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354425221','盋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135443251112','殚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135444512332511134','殯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135444512512134','殥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13544453212134','殡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13545','匛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354511112','肂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135451124134','殔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135452251541','殛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13545354','歿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135454','迈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1354541541','翃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135454251','殆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1355','匹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1355','厄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1355132511134','頋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1355132534','顾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135531234','尮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135532511154444','鴄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('135543','成',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13554325221','盛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('13554352','郕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('141355','匟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14312','平',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1431234','来',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('143123413444544','慭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14312342534','赉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('143134','夹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('143134132511134','頬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('143134132534','颊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14313422','刾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14313452','郏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14334','灭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1435112','亊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1441324111215','匯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14513251225','匾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444111221112521251431','靊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441122431','霊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444115','雩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441154','雲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444411541525','霕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444411543115431234','霼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444411543443454544354','靉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444411543445','霒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444115451124134','霴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444115451124134454','靆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441154515322511134','靅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444411552','鄠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444412211','雸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441221251123511','霸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444122125113134','霰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444412225134','霙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441224511353334','靀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441234','雬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444412341234','霖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444412341234333','霦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444123425111','霜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444412342511132511154444','鸘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444412342511135451','鹴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444124','雫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441311534','震',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444413251','雼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444132522','需',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444132522132511134','顬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444132522132534','颥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441331234312342121','靂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244441335','雳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444415112531','霋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444421112111','霏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244442432511','霄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444251122111543','霵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244442511251113533','霷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444425115','電',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444425121','雷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444425121122134','霬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244442512114524444251211452444425121','靐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244442512121354251','露',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444251212512125121','靁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244442512211251431','霻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244442512511134','霣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444251251251','霝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244442512512511234341','靈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444425125125141431251121515111','龗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444425125125152','酃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444251251251531','孁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444425134','雵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443115','雮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444312154','霆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443155144','霉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444432151135','霓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444432411121','霍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443241112132411121','靃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443241112132511154444','靍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443241112132511154444','鸖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443322521353134','霺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443411243132511154444','靎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444341534','雿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444434312','雽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444434435332511121','霾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444434454','零',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443453','雰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443511333534','霢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444351145534','霡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444435121251','霌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444435435','雾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244443545325121','霤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444435515','雹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444111251','霅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444111251251135345','靄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444125152152','霩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444134','雯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444413432','霁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444135','雱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444441431','雴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444143125111515111','靇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444414313445','霠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444441431531','霎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444441432533543211','霽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444441122111345','霮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444441122134','霟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444411234','霂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444411251','霈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444411331234312342121','靋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444444121251','霑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444441251251','霘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444444134433121','霪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444444134454','霗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444444141121','霔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444414143454135','霶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444414535','霃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444444151554','霐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444451121352342511134','靌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244444511353334','霥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444445251135345','霭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444453241112132511154444','靏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444511','雪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444512115154','霞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444451311234124','霨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244445132514143112','霹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444515515515','霛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444452354131121','霳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444534','雭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444454154132511','霫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444543341251431','霯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1452444454523','雺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444545232534251','霱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('14524444545233134','霚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244445452335425111','霿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('145244445452335435','霧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1454','辷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1454454','忒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15','丂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15','七',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15','匚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15','匸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151','与',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15112134','疌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15112531','妻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1511253132511154444','鶈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1511253152','郪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512','车',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512111341134','辏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512112','轩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512112154','轼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15121154','转',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15121212513534','辕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15121221115','辄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151212251','轱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15121251124','辅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151212512','轲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512125125121','辐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15121253434','辆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512134','轪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15121355','轭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512154121','轾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151221513','轳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151225111535','辊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512251122111','辑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512251125221','辒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151225121','轴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151225134','轵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151225431415','辋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151231134','轶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512313432','轿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15123312','斩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15123312121','堑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151233121234','椠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151233122511','暂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512331234112431','錾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512335144','辀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512341121','辁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512341251122','输',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151234312','轷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151234333','轸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15123435','轮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151235','轨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151235234','轹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15123534','软',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512354251','辂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151241251234','辌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512413434','较',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151241352211535','辘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512415425113134','辙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512431234354152','辚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15124451112251','辖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512454','连',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15125','轧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15125131221534','辗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151253251','轺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1512534','轫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151254121','轻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15125454','轰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151254545454','辍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151255525121','辎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1513','戸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15132511134','頃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15132534','顷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1513534','欤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1515','巨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1515251214251214','螶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('151534','夷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15153432511154444','鴺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15155','乬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15155','巪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('152131215','匨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('152211215','匩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1523','牙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('152332411121','雅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('152332511154444','鴉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('152335451','鸦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15234','东',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1523435451','鸫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1523454','迓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('152352','邪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15235451','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1525','屯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1525132511134','頓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1525132534','顿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15252511','旾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1525454','迍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15255','匜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('152552','邨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153134','攷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153135','尧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153135541541','翘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1535','兂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1535','旡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1535','比',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153512','毕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1535121','坒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15351234','枈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1535135435','毙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15351535','兓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153515351251254312','鬵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153515352511','朁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153515352511251214251214','蠶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15353115','毞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153532511','皆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15353251132511154444','鶛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15353251135','勓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1535431234','粊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15354444','炁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('153545443','毖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154','夨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154','弋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154121','至',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1541211113431234','臻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154121132521','臶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154121135543','臹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154121154121','臸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15412122','到',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1541213134','致',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15412132511154444','鵄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154121354251','臵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15412152','郅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1541325','匥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1542511134','貣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1543','戈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15431511154444','鳶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15431543','戔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1543154321531535','虦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1543154322','剗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1543154325221','盞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('154322','划',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15432411121','隿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15435451','鸢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1545412511','晉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15454125111543','戩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1551','互',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1553','切',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1553413534','袃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1554','瓦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('155412','瓧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1554132511','瓸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1554132511121','甅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15541525','瓲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15542511121','瓼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15543','戉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15543115','瓱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1554312','瓩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15543354','瓪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15543453','瓰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('155452','邷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1555121','坙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1555121','巠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1555121132511134','頸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('155512122','剄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('155512132511154444','鵛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('155512135','勁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('15551214154325','巰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('1555121454','逕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2','丨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2','亅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21','丄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211','上',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21112111','非',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121111','韭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121111234','棐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121111251112','輩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21112111134','奜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121111344','猆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121111512','辈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2111211122','剕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21112111251214','蜚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121113115','靟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21112111344511534','餥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121114134','斐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21112111413534','裴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211121114544','悲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21112111531','婓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21112111541541','翡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211234','尗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2112342154','敊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21123454','叔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2112345425111','督',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2112345434112431','錖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21123454413534','裻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211234544544','惄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21124','卡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21134','仧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21135','北',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211351','丠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211351251112','軰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('211352511','背',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21135251152','鄁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2113525121122134','冀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2113552','邶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2114544','忐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121','卝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121','止',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121112','芈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212111212511134','歵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121121124','歭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121121354','羐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21211254','歧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121131233543','歲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121131233543132511134','顪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212113123354322','劌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121131233543541541','翽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121131234543','歳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121132511134','頉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21211515','歫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212121212121','歮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21212134','歨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121233','步',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121233132511134','頻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212123313251113432511312','顰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121233132534','频',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212123313253432511312','颦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21212343','歩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21212511','肯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121312511121','歱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212132411121','雈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213251514143112','辪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121335144','歬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452','齒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345212211154','齱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345212212511','齰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345212215','齛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434521225111134','齻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434521234123411234','齽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434521234123452134','齼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434521251251','齬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345213412512','齮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434521523','齖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452212135','齜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345225111','齟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452251125214','齵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452251153','齥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434522512134','齪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434522512341','齫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452251251115','齶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345225134','齞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345231211','齚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452315','齕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452321511','齨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345232151135','齯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452325125214','齲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434523312','齗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345233513312','齭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434523432','齘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345234454','齡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345235','齔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345235251','齣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345235515','齙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434523552335523','齺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452413434','齩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452414313333','齴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434524313425221','齸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452451251112','齳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121343413434525','齓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452511534','齦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134341343452513154121','齷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345253251','齠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213434134345254251','齝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213452','齿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134521251251','龉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213452212135','龇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121345225111','龃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134522512134','龊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213452315','龁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213452325125214','龋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212134523312','龂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121345234454','龄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121345235','龀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121345235515','龅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213452511534','龈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213452513154121','龌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121345253251','龆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135','此',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213511','些',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213511234','祡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121351234','柴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213513251','砦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135251','呰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135251','茍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213525111','眥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121352511134','貲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135251125214','歶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135251251','啙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121352534','赀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135253434','胔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213532411121','雌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213532511154444','鴜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213534112431','鈭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135344511534','飺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21213535251214444','鮆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121353535112','觜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2121354111251','訾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135531','姕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212135554234','紫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212143123452','歯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21214312345234452','齢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251','凸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251','占',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251112','卓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125111232511154444','鵫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125111234','桌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251112454','逴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212511134','貞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212511134454','遉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251115132125','鼑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251132511134','頕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251134','奌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212511543','战',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212512154','敁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251223534','欳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212512511135','覘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125125132511134','頥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212512535','觇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212514444','点',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251454','迠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212515','乩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21251541234','梷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21253341','卥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212534','贞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125431','卤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21254312554','禼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125431431113121','鹾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21254344441','鹵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21254344441131251543','鹹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212543444413412512513434','鹼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125434444134125134','鹸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212543444413445','鹶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125434444134454','鹷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21254344441431113121','鹺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('212543444414315112234','鹻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125511','卣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125511454','逌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2125525251','卨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21354','歺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2135454211121111','韰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2135454344511534','餐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2135454431234','粲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21451343425111','睿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2145134342511154','叡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2145134342511154121','壡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21451343425154121','壑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21452511','肻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('214534312343134','敹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21513','卢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21513132534','颅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2151335451','鸬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315','虍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531512341234333','虨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153151251254312','鬳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531512512543121344','獻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531512512543121344212134341343452','齾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531512512543121554','甗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531512514311543','戲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531512514312511135','覻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153151353334','豦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315135333422','劇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315135333435','勮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153151353334454','遽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315151','虐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531522431','虚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315224311543','戯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315224312511135','覷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315224312535','觑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153152243134','虡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315224313534','歔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315225211','虛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153152252111543','戱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531525111','虘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315251112511135','覰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153152511134','虞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315251113432511154444','鸆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153152511153254','皻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315251212511','膚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153152512125221','盧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153152512125221132511134','顱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315251212522132511154444','鸕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153152512135','虜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315251214544','慮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531525121454435','勴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531532121','虗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531532411121','雐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531532411121115','虧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531534312','虖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315343123534','歑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531535','虎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531535','虏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153153512211','甝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153153515431543','虥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153153521531535','虤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531535215315352511134','贙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315352511135','覤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315352512113134','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315352512144443134','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531535322354254312114444','虪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531535333','彪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('215315353533','虝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531535435','處',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153154134','虔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2153154544','虑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('21531545443','虙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2154','攴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22','刂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('223142521','临',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2231425221','监',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('223142535','览',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2231434112431','鉴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22431','业',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2243143111234','業',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('224314311123432511154444','鸈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('224314311123452','鄴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('224314311134','菐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2243143112','丵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22431431121124','對',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('224314311211244544','懟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('224314311212211154','叢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2243143112321511355434112431','鑿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22431431123215113554431234','糳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('224314311252','凿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('224314325234','黹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2243143252341251124','黼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22431432523413544','黻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2243143252343453','黺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2243151531134','彂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2243152','邺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22511','旧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22511225112511125431234','囒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2251135','児',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2254121','坚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22542511','肾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('22542534','贤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('225441431','竖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2254554234','紧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('231252','师',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('23252','帅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234','小',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234121','尘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234134','尖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234134234','尜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234234234','尛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2342511135','覍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('23425251','尙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2343','少',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('23432411121','雀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234324111211543251214251214','蠽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234325111','省',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('23433115','毟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('234335','劣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2344','尐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2344','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('235','凣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('23511','归',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24','卜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24134','氺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2425221','盀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243135','光',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24313512212512134','兤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24313512212512134','黋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24313525111535','尡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243135451251112','輝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243135451512','辉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243135521251152','韑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24313554154132411121','耀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2432511','肖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2432511154444','鳪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243251122','削',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2432511223112','揱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243251123421531535','虩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2432511454','逍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243251513134252','幤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24325251','尚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243252513134','敞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2432525131343115','氅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2432534313432511255115115341','龞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24345','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243451154','尝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24345121','坣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24345251121','堂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2434525112211','甞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243452511234','棠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243452511523','牚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243452511554','瓽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243452512511134','賞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2434525125121','當',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243452512512122','劏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24345251252','常',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243452512534','赏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24345251254312114444','黨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243452513112','掌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2434525135','党',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24345251352511','嘗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24345251413534','裳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('243511','当',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244','忄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244111211125114544','懳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244111215','恇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244112','忓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441121','忹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24411212511','情',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441121353134','慠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244112154','恜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441121554234','愫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24411234','怽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441132543','悈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24411342444','悿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244113434345','愜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441135','忨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441135','怃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24411431345','惬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441154','忶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244115435','恸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412','忊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412111534','悵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121121121135','憢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121124','恃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412121','怔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121211121111543','懴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121222511134','憤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121222534','愤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121251','恄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441212511134','愩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121251431251','憘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121251431333','憉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412125145154121','懛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412132341213234','懗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244121335','恅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441213352511','愭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412143112','悻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412151211251124','懤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412154','怯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122111122111122111','懾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122111345','愖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441221115454','慑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412212511','惜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412212511121','慬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441221251112135','懄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122125112','愅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412212523434','慲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412215','怈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122151234','惵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122251112','愺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441222511134','慔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412225125132411121','懽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412225134','愥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412225221134543','懱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122252214525111','懵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441222522145354','懜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122312511121','懂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122353344544','憽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122415','恾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244122415325','慌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441224511353334','懞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412251','怙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441225111134','慎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412341234','惏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441234123452134','憷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441234341252511','懎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412344','怵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244124','忖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412452512152134','懥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441245521','悖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125111','恒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412511123312','慚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441251112454','慩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412511214124','慱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125112144544','憓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441251124','悑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441251124124','愽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125115315','愝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412511543','惐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412512212511','慒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441251234','悚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441251234352511134','懶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441251234352534','懒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441251251','悟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125125121','愊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412512512515','慪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412512531425221','懢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412512554121','慳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412522111234','慓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441252211234','慄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125221251112','憛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125221431234','憟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24412534','怲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125351','恓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441254','忮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244125441','恆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244131212511','惰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244131212511121','墯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441312515434544','憾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244131344','恹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24413211234543','慽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244132121','恠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441324','怀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24413241','怌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24413251125111344','懨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244132511454544354','懮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24413252','怖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244132522111','愐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244132522134','愞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244134','忕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244134115','恗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244134334','恢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441343434','悏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441344','忲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244134432511234','憭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24413443434343','慡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441345','怄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441354','忧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24414312','怦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24414524444132522','懦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24415112531','悽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441515','怇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244151534','恞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24415213312','惭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441525','忳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2441535121','悂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244153515352511','憯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244154121','恎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24415543','怴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24421112111','悱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442113525121122134','懻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24421251','怗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24421251112','悼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442153151353334','懅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24421531522431','憈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442254121','悭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244243135','恍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442432511','悄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24424325251','惝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24424345251121','憆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24424345251254312114444','戃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425111','怚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425111','怛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442511112','悍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425111134','惧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442511121','悜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442511121','悝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251112134','惿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251112213424134','懪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425111234','惈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251112511132411121','懼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425111251113241112154','戄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442511134','悮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251113422','惻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442511135','悓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251113533','愓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425111535','惃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442511243135','愰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251125113511','憪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251125114134','憫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442511251211511','憴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425112512531','慺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251125221','愠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425112522154','慢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251131121','惺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425113533','惕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251135345','愒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251141251234','憬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442512','忡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425121','怞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251211234','愄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251212511134','憒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251212534','愦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251214544','愢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442512211311534','憹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442512341','悃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251251','恫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442512511','悁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442512511134','愪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251251115','愕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425125115431','慖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244251251251112','憚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442512512511234','懆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425134','怏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425134','怾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425135','怳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442515134','悞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442515215','悒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442521251431','愷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244252132522','惴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442522112143112','懌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442522112513534','懁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244252214135','愣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425232411121','慛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244252511','恛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244252515','恺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2442534125221','慍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244253422','恻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425351','怬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24425431415','惘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244255452511','愲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443112','忤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24431121','性',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244311222214444','憮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24431134','怢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443115','忾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443115431234','愾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244312','忏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24431211','怍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443121251','悎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443121251454','慥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244312251','恬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443123422','悧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244312344334','愀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24431234521','悸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24431251112135','慟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24431251113533','慯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244312511354','愎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244313425125251','憍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244314314125234','憡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244315','忔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443154','怅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443155144','悔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443211152511134','懙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244321234','恘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24432411121','惟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244324111212525','懏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244324111214444','憔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443241112154','愯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24432511','怕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244325111121','惶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244325113554','愧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443251141353134','憿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244325221','恤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244325251','恦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24432535414544','憁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244325431234134','懊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443312','忻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244331233122511134','懫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24433123534','惞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244341121','恮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443411234','悇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24434112431','惍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244341251','恰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244341251122','愉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24434125122','惀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443412512513434','憸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443412524312511','懀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244341354','恡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244341534','恌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443425135','悅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244343123425121','憣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443432','忦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24434341211121111543','懺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244344311354','愋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24434431215114544','懚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443443311252','愮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443443321511','慆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443443454544354','懓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443443554134','慀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443445','忴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443445113251','愴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24434454','怜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24434454544','惗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443454','忪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244345435','恱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443454541541','慃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443455','怆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435','忇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443512','忰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435121251','惆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443513344111251','憺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244351355','恑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443515','忯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435152511','惛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435154','怟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435251','怐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244352511','恂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244352511','恉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443525111534','愼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443525135','悗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435251521','惸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244352534134','愌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435311345452134','懝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435321511','惂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244353344544','愡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435334544','惚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443534','忺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443535112533112','懈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244353535','恊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244354','忛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244354251','恪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244354352','恟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244354354','恀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435445411234','憏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244354533411243122','懰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435511','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24435515','怉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2443552335523','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444124','忭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441251234','惊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244412512341354','憱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441251251112213534','懹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444125152','悙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441251521','惇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244412515213134','憞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444125221241343534','懷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444125221413534','懐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444125251111234','懔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444125251125111','憻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444125251131234','懍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441312212512134','懭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444131234123421112111','戂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441312341234354','懡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441321251','惦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444134','忟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444134131134','愱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444134251','悋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244413434','恔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441343412','悴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244413452','恼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444135','忼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441351124134','慷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441351125112','慵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244414312511','愔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441431251112','慞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244414312511121','憧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444143125114544','憶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441432533543211','懠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244415','忙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24441554','怰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444155425121','慉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444254134','悯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24443111344511534','懩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24443112','怑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244431132','恲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24443113425111','慻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24443113455','惓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244431234354152','憐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444313252','悕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444315112234','慊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24443251112','惮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444325135','悦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244432524312511','憎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24443344334','惔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244433443344535','憦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444351523','悌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444352','忷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244435234354','惾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444434352','悩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24444511234','悰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244445125111','愃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24444525151','悺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24444534121','悾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444453434251','愹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244445354251','愘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24444535455','惋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24444545442522112','懧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444511534','悢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244451251112','惲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24445131344','悷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244451325122','惼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244451512','恽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444525114134','慏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2444535','忱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24445443','怭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24445534','怺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2445','忆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244511121251124','憳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244511534','恨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244511541535','慨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2445121','忸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24451335','怩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2445134','快',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244515','忋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244515','忚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24451515','怋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244515152511','惽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24451532','怫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2445154151541','愵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24451541554','惤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244521251152','愇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24452131212511','憜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24453','忉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24453154','怓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24453251','怊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24453254','怶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244534','忣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454112','怿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454121','怪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454134333','惨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454154132511','慴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454154134333','憀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244542451214','慅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454251','怡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2445425112','悀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244542511235','愑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244543112','恈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244543341251431','憕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2445434354','悛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2445452','忬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244545232534251','憰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454545434333','慘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24454545454','惙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24455212511134','慣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24455212534','惯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('24455435','怮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('244555325431','惱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25','冂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251','口',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251','囗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511','冃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511','冄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511','日',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511','曰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111','且',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111','旦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111','目',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111112','盽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111111215','眶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111111342511','睶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111112','盰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111112','盱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111121112511','暳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511111212511','睛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511111212511134','瞔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511111234','眎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511111234','眛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511111234','眜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511111342511','暙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511111342511135','瞡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111135','盶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111154','眃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112','旰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112','旱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112','旴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112','盯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111121','旺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111121112511','嘒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111211125114544','嚖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111121121','眭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112121','眐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111212511','晴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111121251431251','瞦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111121251543','睵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112132511','睹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112134121','睦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112134354','睖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111215','哐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111215425221','瞌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111122111','眲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111221122112','瞱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111122122151234','瞸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112212523434','瞞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111221253434','瞒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112213251','睰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111122132515','暱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111222511134','瞙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112225121','瞄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112225125132411121','矔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111122252214525111','矒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111223241112154','矆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111224511353334','矇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111225111134','瞋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111234','昧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111234','昩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112343434','睞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112343554234','縣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111123435542344544','懸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112512512515','瞘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112522111234','瞟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111125221251112','瞫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111253134','喫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111253212134341343452','囓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511112534','眪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111253554234','噄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111254125441352211535','矖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111255','眄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511113121121','睚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511113122251125214','矋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134','具',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134','昊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134112','唪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134121121','睳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511113431234','嗪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111344','狊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134432511154444','鶪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134432511234','瞭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134435451','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111134452','郹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111345','眍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511113543','眬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111431234','睐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111452444432411121','矐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511115112134','睫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111151534','眱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251111525','盹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111154','昙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111154121','眰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511115543','眓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112','吁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112','早',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112','旪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121','呈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121','圼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121','里',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112111213445','噖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121121','晆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121121121135','曉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121124','時',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121132','哢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112113444444','黙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112121','昰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121213134','晸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111212135','眦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112122135','暁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111212511','啨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111212511134','嘖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121251431251','暿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111212534','啧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112132511','暏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112132511','暑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111213312','晣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112134','是',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121341152','韪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112134132511134','題',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112134132534','题',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121342343','尟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111213432511154444','鶗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111213435','匙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112134454','遈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112134521251152','韙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112135','昮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121353134','嗷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111213531342511134','嚽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121354','唛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111214444','黒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121451251341','曀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121454','逞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112152','昻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112152','郢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112153152512125221','矑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111215452','野',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111215452121','墅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511121554234','嗉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511122','刞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112211135','朂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112211154','最',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511122112','畢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112211212112','曄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111221122112','曅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112211232511154444','鷝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112212511134','暵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111221251211354444','曣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112212512134','曂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112212523434','暪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511122134','晎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112213424134','暴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111221344111251','謈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111222511134','暯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112225134','暎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511122352513134','曔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111224314311134','瞨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111224511353334','曚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511122543112','暔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111234','呩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111234','味',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111234','杲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111234','果',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112341234','晽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111234132511134','顆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111234132534','颗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112342154','敤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112343','眇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112343312','晰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112343534','褁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111234354354','夥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511124','时',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112432511','睄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511124345251121','瞠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511124345251254312114444','矘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125111','晅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511112','睅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251111344','瞁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511121','睈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511121','量',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251112134','睼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511125111','瞐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511132411121','瞿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125111324111211543','戵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125111324111213115','氍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251113241112132511154444','鸜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251113241112154','矍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511135','睍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251114334','煛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511144534121','瞾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251114532511154444','鷪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251114544','愳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125112','眒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511214124','暷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251124','晡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251125111121','瞤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251125112511','瞷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251125113511','瞯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511251151221113134','矙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112511251211511','鼂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125112512531','瞜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251131121','睲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125113533','睗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125121132','睤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251212511134','瞶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251212534','瞆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125122134','睓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112512341','睏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251251','晤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251251','眮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112512511','睊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125125115','鼌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125125124544','瞣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112512512511234','矂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111251254312251214','曧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125134','眏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125135','眖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111252','昁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125221251112','曋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112534','昞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251112534','昺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125351','晒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111254125441352211535','曬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511125431234','暕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511131122121','睡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111311222214444','瞴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511131134','眣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113115','眊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111311534','晨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511131153432511154444','鷐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113121543','睋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113122251125214','曞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111312344334','瞅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113123443344544','矁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511131254312114444','矄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111315','盵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132','咞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111321511254','瞍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132151135','睨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132411121','睢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132411121','雎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111324111214444','瞧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132511134','暊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111325111445344135','矏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132511154444','瞗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132511154444','鴠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132511154444','鴡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132511312','睥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511132511445344135','矈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111325131134','睺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113312','盺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111331225111','瞃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113322521353134','矀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511133234342134','瞛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111333534','眽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111334','昃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113354','眅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134','吴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134','呋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134','旲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134','貝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134111342511','賰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134111543','賎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113411212154','賦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113411212511','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341122125121','購',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341135','貦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134113543','賊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134113543251214','蠈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134115','晇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113412111534','賬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134121251543','賳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134121252212511134','贖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113412132511','賭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113412213513125125543','贜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134122251125214','贎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134123','財',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341241344','賕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341251122','睮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341251124124','賻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134125122','睔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113412512513434','瞼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134125221251112','贉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113412524312511','瞺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341311534','賑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134132511','賄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134134413441344','贆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113413513125125543','贓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113414431','睑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113415','盻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341534','眺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111341543','戝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113415431543','賤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113421251','貼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113422','則',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134224314311134','贌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134243452512511134','贘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111342511134','賏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425111341554','甖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425111342511134','贔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111342511134311252','罌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425111343134','贁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134251113432511154444','鸎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134251113434112431','鑍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425111344111251','譻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111342511134531','嬰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134251113453132511154444','鸚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134251125111','賵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425113533','賜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425115','晻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425122134','賟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111342512512','賗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425125124544','贃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113425135','貺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113431121','貹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111343134','敗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113432','昦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113432511154444','鵙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134325221','賉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134333','眕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111343354','販',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111343411234','賒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111343411234','賖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113434121','睉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111343445113251','賶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111343454','貶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113435121251','賙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111343513344111251','贍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113435154','貾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134352511521','賯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134354251','賂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134413121','賍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111344131214','賘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134413434','賋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113441343412','賥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111344135','貥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113441431251','賠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113441431251121515111','贚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134415334','賅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134431132','賆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134431234','睬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111344313425221','賹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111344315112234','賺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134432511234','暸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134432524312511','贈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113443344334','賧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111344345354152','瞬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113443454544354','瞹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134435112','睜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113444511234','賩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113444512','貯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134451251112','賱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113445341234','賝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113451121444425221','贐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113452','郥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511134525','貤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113453','盼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113453254','貱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113454','眨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113454154134333','賿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113454251','貽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111345434354','賐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113454541541','瞈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113454545434333','贂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135','助',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135','呒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135','見',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113511','眀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135121251','睭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113513344111251','瞻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113515','眂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135152511','睧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135154','眡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135251','眗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111352511','眴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111352511135','覞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113525135','睌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135253425111354','矎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113533','昜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111353322521353134','覹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135333134','敭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113533454','逿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113541','盷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111354251','眳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251113543','昽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111354343','覐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111354354','眵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111355112','睁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135521','覎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135543','晟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511135543','晠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114111251322','瞓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511141312212512134','矌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114134','盿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511141343412','睟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114134522554','瞝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114135','眆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114135112251','瞊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511141431251112','瞕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111414312511121','瞳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511141431251121515111','矓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111415','盳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111415425113134','瞮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511141554','眩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111431112','眻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511143112','眫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111431134','眹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511143113455','睠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111431234','眯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111431234354152','瞵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111431234454','瞇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111431234531','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114313252','睎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511143344334','睒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114351523','睇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114451112251','瞎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114451135','睆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511144512','眝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511144512332511134','矉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111445125111','睻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511144512512134','瞚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511144535455','睕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511144545442522112','矃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111451251112','睴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511145131344','睙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511145244441154','曇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114524444132522','曘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111452444432411121','曤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114525114134','瞑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251114535','眈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511145534','眿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511151111254','睷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511151124134','睩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111511534','眼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111512115154','睱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511151221113134','瞰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251115132125','鼎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111513241342522135251214','矚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111513325125214','瞩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511151335','眤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111515','昛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511151515','眠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251115154334','煚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111521325111','睸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251115234','県',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111525','旽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511153135','晓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511153251','眧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111535','昆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511153532511154444','鵾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511153535451','鹍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511154','县',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511154','呍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511154121','晊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511154154132411121','矅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511154251','眙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111543112','眸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111543341134','睽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111543341251431','瞪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251115434354','睃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111544544','悬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111545232534251','瞲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511155435','眑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511155444432511252','矊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25111555552','郻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112','叮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112','叶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112','曱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112','甲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112','申',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121','叿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121','吐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511211','囯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121112111','暃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112112','咑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121121','哇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121121121135','嘵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112112124','啩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511211254444','嗎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112121154444','嘕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511212134','唗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121222511134','噴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121222534','喷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121251','咭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112125111','圊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121251112','晫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511212511134','嗊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121251431251','嘻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121251431333','嘭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511212534','唝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112125431234','朄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511213234','哧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112132341213234','嚇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112132511','啪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112132511','啫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511213251152','嘟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511213312','哳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121335','咾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511213352511','嗜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511213521','哮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112135213134','嘋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112141','国',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112141431','啦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121431112454','噠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112143112','啈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511214412','唞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121451251431','噎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112151211251124','嚋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121525','哋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112153152512125221','曥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112154','呿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511215425221','嗑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112155121','啞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251121551214544','噁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112211','咁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122111','咠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122111','咡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122111122111122111','囁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112211134','唭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122111343312','嘶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122111345','啿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122111543','戢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511221115454','嗫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511221122112','嘩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122121341213541154','囈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112212511','唶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112212511134','嘆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122125112121121','嚡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112212511235','嘞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511221251211354444','嚥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112213251','喏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122134','哄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112215','呭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122151234','喋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511222511134','嗼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122251125214','噧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122251125214251214','囆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122251135345','噶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112225121','喵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112225125132411121','嚾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511223212512','嗬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112232411121321511','嚿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511223241112154','嚄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112234','哎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122341234','嗏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122341251','嗒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511223525121444431234','囌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511224125125251','嚆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122431','哑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122431','显',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122431132511134','顕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112243143111234','曗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511224535','唠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511225','呓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112251','咕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511225111134','嗔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122511123511','嘲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112251113533','暢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112252511','啚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511225251152','鄙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251122543112','喃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511232511154444','鴨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511234','呆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112341','呠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251123412251','喖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112341234','啉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511234123411234','噤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251123425111','喳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112342511234','槑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112343312','唽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112343434','唻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112343434354','嘜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112354','畃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511235451','鸭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251124','吋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251124','吓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511243135','晃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511243135','晄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251124345251254312114444','曭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511244125111','暅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112452512152124','嚏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251124525121542134','嚔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112454','迧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511245521','哱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511245554234','嗦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511','冐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511','昌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511','昍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511','門',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111','冒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111','咺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111','閂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511111','閆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511112','晘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511112','閈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111121','閏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251111214','閠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111132','開',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251111342511135','闚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112','冔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112','唓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112','閅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511121121','閨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111211254444','闖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111212511214124','囀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111212513234454','闧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112132511','闍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511121431112454','闥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111215425221','闔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112155121','閸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511122111','聞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511122134','閧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112213424134','曝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511122134515','闀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111225111134','闐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511123','閉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111234','閑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511123432511154444','鷴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511124','閇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112454','嗹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111251112','閳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112511543','閾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251112512','閜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111251431124','闘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511125221121','闉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511125221531','闄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511125351','閪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511125431234','闌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251113115','毷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251113425115','閹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111344','猒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511135','勖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511135','勗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511135','晛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251113533','暘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111354','閎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251114312','閛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125111523','閕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251124','哺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251124345251121','闛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112434525125121','闣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251','問',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112511','晶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112511','晿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112511','間',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251111344','闃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251112154','闅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125111311534','曟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112511134','閴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125111343134','闝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125112','閘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125112511','閶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125112511','闁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125112511135','覸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251131121','曐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251132511154444','鷼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251134333','曑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125114134','閺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251125114525111','曡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112511541541','闒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251212511134','闠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251214','閩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112512211251431','闦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112512341','閫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251251','閭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251251251','闆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511251251251112','闡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511252','閊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112521251431','闓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112522112513534','闤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125112534','閖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125113','閁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251131121','暒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125113115','閐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511312154','閮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511321511','閰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511321543','閥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251132411121','閵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125113251111234','闑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511325112534','闎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251134','哽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251134','閃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251134','閄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511341251','閤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511341251541541','闟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125113425135','閱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511343434','閦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251134434554','閿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251134454','閝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125113511','閒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251135112511135','覵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511351132511154444','鷳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251135152511','閽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251135321511','閻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511353251214','闏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125113533','晹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251135345','暍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511354251','閣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114111251','誾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251141251234','暻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251141252','閙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114134','閔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114135','閌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114135','閍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251141353444','閼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251141431','閚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511414312511','闇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511415334','閡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511431134','関',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251143113455','闂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114315233534','闕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114325135','閲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114334','焛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114334','焸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114412','閗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114412343','閯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511441312251','闊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511445531','暥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114511534','閬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251145132513134','闙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125114544','悶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251145443','閟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251151221113134','闞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125115132514143112','闢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511521251152','闈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251154132','閞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112511543341134','闋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125115545544444','闗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251155455453212','關',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512','呵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251211511','黽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125121151152','鄳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251221','唖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512212511','嘈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125122134','晪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125123422','喇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512343534','嗽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251245251251112213534','囔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251251','唔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251251','晍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512511351221113134','曮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251251251112','暺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512512515','嘔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512531','婁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125125311554','甊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125125313115','氀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125125313134','數',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251253132511154444','鷜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512531425221','嚂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125125314252212511135','囕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112512531454','遱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251254312','嗝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125134','映',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511251431','哣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511252','旵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112521251431','暟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125214','禺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125214132511134','顒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125214132534','颙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125214454','遇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511252144544','愚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125221','昷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112522111234','嘌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112522112132511','曙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112522112143112','曎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125221251112','嘾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125221531','喓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112522154','曼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511252215452','鄤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112522155444432411121','曪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112523434','啢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112525','咂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112533','畅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511253434','唡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251125351','哂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511253511','唒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511254','吱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511254125441352211535','囇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25112541541','翈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113112','旿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251131121','星',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251131121','甠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511311211543','戥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251131134','昳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511311534124','嗕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113115431234','暣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113121','咗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251131211','昨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113121121','啀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113121251','晧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251131251543','喊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251131254312114444','曛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113132','昇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251131531543','喴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113155144','晦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511321','囲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113211234543','嘁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132151135','晲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511323512','晔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511324','吥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113241','呸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132411121454','暹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132511','咟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132511','哊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113251111234','暞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113251111543','嘎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132511121','喱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113251113412','暤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511325111354','嗄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511325111413412','曍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113251125111344','嚈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132511413412','暭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113251141353134','曒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132511451543','嘠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132511454544354','嚘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113251152','喐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113252','咘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251132522111','喕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511325251','晌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511325251','晑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113312','昕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511331234312342121','嚦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251133234342134','暰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251133241121','暀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511335','呖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113354','昄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134115','咵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134121121','喹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113412132','喯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511341534','晀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511341534','晁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113425115','唵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134315233534','噘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134333','昣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134334','咴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511343434','唊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511344','吠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511344','呔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511344311354','暖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134432511234','嘹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113443311252','暚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113443451354','暧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113443454544354','曖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113445','昑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113445251','晗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134454','哒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251134454','昤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511345','呕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113453','昐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113454','昖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113454541541','暡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135','旯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511351','园',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113511','明',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511351111214','琞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511351125221','盟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135114334','焽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511351144534121','曌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135121251','晭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113513344111251','曕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135251','昫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113525135','冕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113525135','晚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511352514444','煦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135252135','晩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113533','昒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113533','易',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135332154','敡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511353322','剔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511353332511154444','鶍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511353334','哤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113533434','啄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113533454','逷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135334544','惖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113534','欥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135345','曷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511353453115','毼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113534532511154444','鶡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511353453534','歇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113534535451','鹖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135345454','遏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135352','昴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511354','吰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511354','旳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113541','昀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511354152','曻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135422','咧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135424251','晷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113543','咙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135444','昸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251135445411234','暩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511355','呃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25113552','昂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141251234','景',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141251234','晾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141251234132511134','顥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141251234132534','颢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141251234333','影',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141251251112213534','曩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114125125251','暠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511412515213134','暾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511413','旷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141312212512134','曠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114134','旻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114134','旼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114134','昗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511413434','晈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141343412','晬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114135','昉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114135','昘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141353152134','暶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511413531525','暆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141354','昿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141431','昱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511414312511','暗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141431251112','暲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511414312511121','曈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141431251121515111','曨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511415334','晐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251141554','昡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511431113121','暛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114311213123415543','曦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511431134121','塍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114312','呯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511431234354152','暽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114313252','晞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114334','炅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114334','炚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251143344334','晱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114351523','晜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114451135','晥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511445125111','暄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511445134432511234','曢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251144535455','晼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511445531','晏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251144553132511154444','鷃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511451251112','暈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511451251112','暉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114513','昈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511451512','晕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511451512','晖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114524444132522','嚅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511452444432411121','嚯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25114525114134','暝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251145534','昹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115','号',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115','电',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115112134','啑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251151124134454','曃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115112531','啛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511512115154','暇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115121154','啭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511513241342522135251214','曯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251151335','昵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251151532','昲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511515322511134','曊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251151534','咦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511521','围',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511521251152','暐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511521531535','號',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511521531535344511534','饕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511522113344454','嚃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251152252','昢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115225213412341','曓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511523','呀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511525','吨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511525132511134','噸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251153','旫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251153','曳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511531','妟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251153135','哓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251153251','昭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511532511154444','鴞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511532514444','照',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511533','旸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511534','昅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115344511534','飸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511535','吡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251153512','哔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251153515352511','噆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251153532511','喈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511535451','鸮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511541','囩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251154121','咥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251154132','昪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115415413115','毾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251154154132411121','曜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511541541454','遢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511543','曵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511543341134','暌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115434354','晙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251155345115452','曏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2511554','咓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25115545544444132511134','顯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251155455444443534','歞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512','中',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121','冉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121','田',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121','由',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121','甴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211113124','畴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121112111','啡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211132','畊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211134','畉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512112','町',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512112','甼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121121121','畦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121121124','畤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512112151211251124','疇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121122134','異',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121124','咔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211251211251211','疅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121132','畀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121132','畁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121132511134','頔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512113412512','畸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211344','畎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121134425221','盢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512115','甹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211534','畏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211535','毗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251211535','毘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211','囸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211113124','踌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121111342511','踳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212111134321511','蹖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121112','哶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121112','趶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212111212511134','蹟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212111234','跊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211132','趼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211134','趺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212111543','践',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121121121','跬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121121121121135','蹺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121121124','跱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211212134','跿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112132511','踷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112134121','踛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112134354','踜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211213521','踍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121121431112454','躂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112151211251124','躊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211215452','踋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121122111122111122111','躡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112211123412212511','躤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112211134','踑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121122111345','踸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211221115','踂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112211154','踙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211221115454','蹑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112212132511','躇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112212511','踖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112212523434','蹣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211221253434','蹒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112213251','蹃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112215','跇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121122151234','蹀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211222511251132411121','躪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112242532411121','躏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112251','跍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211225111134','蹎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121123425111','蹅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211251112454','蹥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112512','跒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212112512212511','蹧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211251234','踈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121125125121','踾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121125221134515','蹮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121125221134515454','躚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121125351','跴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211254','跂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211254125441352211535','躧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121131233543','噦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121131251431124','蹰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212113221545252','蹛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211324251','踎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212113251','跖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121134115','跨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212113412512','踦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212113425243434343','躎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121134315233534','蹶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121134432511234','蹽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121134454','跶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212113544','跋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212115112134','踕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212115132511134','蹞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211515','距',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121151534','跠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121153135','跷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121153512','跸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121154121','跮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212115431543','踐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121211555121','踁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212121123454','踧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212121','趾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212121233','踄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121212135','跐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212121251','跕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212121251112','踔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212153151353334','躆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121224314311134','蹼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121233132511134','嚬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212432511','踃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212124345251121','蹚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212511','啃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125111','跙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121251112134','踶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212511122112','蹕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125111234','踝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121251112511132411121','躣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125111251113241112154','躩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121251113533','踼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125112511125431234','躝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121251125112511541541','躢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212511251132411121','躙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125113533','踢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121251153','跩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212511541541','蹋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121251212511134','蹪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212512134','踀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212512512511234','躁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121252132522','踹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121212522135251214','躅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125235113511','蹦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125342511','踏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212125525251','踻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212131122221354152','躌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121311234','跦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212131134','跌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212131134251','踟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121312135','跣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213121353121352511134','躦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213121353121352534','躜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121312344334','踿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212131234531','踒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121312454','跹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121312511121','踵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213134','跃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121313425125251','蹻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121315','趷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213155144','踇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212132124','跗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212132411121','踓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213251141353134','躈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121325115545541234','躒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121325125214','踽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121331225111','踲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212133122534','踬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121331233122511134','躓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212133124','跅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213321531535','蹏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212133221212134','蹝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212133234342134','蹤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134','趴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121341121','跧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121341251','跲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121341251122','踰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134125122','踚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121341251541541','蹹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121341534','跳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121343123425121','蹯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134333','跈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134341343452','嚙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134342134','踨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134431234','踩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213443321511','蹈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213443554134','蹊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213445','趻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213445113251','蹌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134454','跉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212134454544','踗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213452','啮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213455','跄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135','呲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213511','跀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121351234','喍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121351234','跺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121351355','跪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135234','跞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135251','跏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135251','跔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135351','跚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121353535112','嘴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121354','趵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121354152','跭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121354251','路',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135425132511154444','鷺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135425135451','鹭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135431234','踘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121354354','跢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121354413444444','蹨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121213545325121','蹓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121355112','踭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212135515','跑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141112514334433454','躞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141121','跓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121412512341354','蹴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141251251112213534','躟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121412515213134','蹾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121413121251431124','躕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141312214444','蹠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121413122154','踱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141321251','踮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121413234','跡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121413251112134121','躔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121214133442511','蹐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121413432','跻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121413434','跤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141343412','踤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121214135','趽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141352211535','蹗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141431251','踣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121414312511121','蹱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121214143125111515111','躘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141431531','踥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141432512251','蹢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212141432533543211','躋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121414345252','蹄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121431113121','蹉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212143112','跘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121431132','跰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212143113452','踯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212143113455','踡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212143122431','踫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121431234354152','蹸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212143123452','噛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121431253511124','蹲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212143125351113452','躑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121431325111212151534354','躨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121432524312511','蹭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212144511234','踪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212144532132511','蹜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121445342512512','蹿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121445343215115445445','躥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212144535','跎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212144535455','踠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121214511534','踉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121451325122','蹁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212151111254','踺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121511534','跟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121511534454','蹆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215131221534','蹍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212151312251','踞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215132514143112','躃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212151335','跜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215134','趹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215135251','跼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215154544','跽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212152133544124','蹡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215215','跁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121531234','跥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212153254','跛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121534','趿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212154154132411121','躍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212154154134333','蹘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212154251','跆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215425112','踊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121542511235','踴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121543341251431','蹬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121543345153554','蹳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121215434354','踆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121545231234','蹂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121545232534251','蹫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212155212511134','躀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121554554155455421','躖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512121555254315445445','躐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251','呫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212511','冑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212511','胃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212511','胄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251112','啅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212511134','貴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212511134454','遺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251113533','畼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512125121','畕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512125121','畘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212512125121','畾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212512125121121','壘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512125121251211234','櫐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251212512113251','礨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251212512125121121','壨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212512125121311252','罍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251212512132511154444','鸓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251212512144525413115','氎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512125121251214525111','疊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121251212512145551','疉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212512125121554234','纍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512125132541','園',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512125151454','遣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212534','贵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251212534454','遗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121312511121','畽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251213134','畋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251213155144','畮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121322','甽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512132511154444','鴫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251213354','畈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512133544','畖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512134','足',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251213411234','畭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251213432','界',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251213432','畍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512134333','畛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512134354','畟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512135','男',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121354','畂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251213541','畇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121354251','略',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121354251','畧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121355312512135','嬲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214','虫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141112','蚌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121411134112','蜯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214111342511','蝽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141113431234','螓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214112','虶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214112','虷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141121','蚟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121411212511','蜻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214112155144','蝳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141121554234','螦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141132','蚈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141134','蚨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141135','蚖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412','虰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121','虹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121121','蛙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121121121135','蟯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141211254444','螞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121222511134','蟦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121251','蛣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121251431251','蟢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121251431333','蟛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412132411121543','蠘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412132511','蝫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121335','蛯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141213352511','螧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214121431112454','蟽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141215435','蜐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412211','蚶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141221112511121','蟶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412211134','蜞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214122111343312','蟖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214122122151234','蠂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412212511','蜡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412212511121','螼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412212512134','蟥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412212523434','蟎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141221253434','螨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412213412132','蠎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141221344132','蟒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214122151234','蝶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141222511134','蟆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214122251125214','蠇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412225125132411121','蠸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412225134','蝧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141222522112132511','蠴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412225221134543','蠛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141222534','蜹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141223241112154','蠖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141224511353334','蠓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214122451234','蝾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412251','蛄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141225112321155122','蠨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412251123234','蟏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214122513511','蝴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214122543112','蝻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141234','蚞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412343312','蜥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412343454','蜙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214124','虾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141241344','蛷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141251112','蛼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412511123312','螹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214125112144544','蟪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412511234','蝀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141251124','蜅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214125115315','蝘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412511543','蜮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412512','蚵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412512212511','螬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214125123422','蝲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214125125121','蝠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141251254312','螎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412522111234','螵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214125221251112','蟫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412523434','蜽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121412534','蛃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141254','蚑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121413113453554541541','蠮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141311534','蜄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121413122251125214','蠣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214131251431124','蟵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121413135','蛎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214131531543','蝛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121413221545252','螮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121413241','蚽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214132511','蛕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214132511','蛨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214132511134','蝢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214132522111','蝒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214132522134','蝡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141332511234','螈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214134121','塁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214134121121','蝰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214134315233534','蟩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141343434','蛺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214134432511234','蟟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141344525111','疂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141353334','蛖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121413534','畩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141354','蚘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214135422','蛚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121413544','蛂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141355','蚅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121414312','蚲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121414312511121','疃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214143134','蛱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121414524444132522','蠕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121415','甿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121415112134','蜨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141515','蚷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214151534','蛦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141523','蚜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214153135','蛲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121415334','畡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141535','蚍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141535121','蜌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214153532511','蝔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214154121','蛭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512141555121','蛵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142121112','蝆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142121353535112','蟕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121421251','蛅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142153152512125221','蠦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214231252','蛳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121424','虲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142432511','蛸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121424345251121','螳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142434525125121','蟷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121424345251252','蟐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142511','蚎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142511','蚦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425111','蛆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251112134','蝭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425111234','蜾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251112511132411121','蠷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425111251113241112154','蠼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142511134','蛽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142511134','蜈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425111342511134531','蠳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142511135','蜆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251113533','蝪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425111535','蜫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425112141','蝈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251125111','蝐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251125115','蝿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142511251211511','蠅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425112512531','螻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251125221','蝹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425112522154','蟃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425113533','蜴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251135345','蝎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142511353453534','蠍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142512','蚛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425121','蚰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425121','蚺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251212511','蝟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251212512125121','蠝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251214251214','蟲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425121425121425221','蠱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425121554234','螺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251221','蛐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142512511','蜎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425125115','蝇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425125115431','蟈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214251251251121','蟬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142512534','蜗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142521251431','螘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425221','蛊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142522111','蜖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142522112143112','蠌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142522112513534','蠉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142522135251214','蠋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214252324111212534251','蠵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214252511','蛔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425312341','蜠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142534','蚋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512142535','蚬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214254312114444','蟔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425431415','蝄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214254343','蛧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121425525251','蝸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214255452511','螖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143112','畔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431121','圉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431121','﨡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214311222214444','蟱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214311234','蛛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431134','蛈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431134121','畻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431134251','蜘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143115','蚝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431211','蚱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214312154','蜓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143121543','蛾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214312251','蛞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143123422','蜊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431234221234','蟍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431234354152','疄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214312344412','蝌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143123453','蜏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121431234531','蜲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214312511121','蝩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214312511354','蝮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214313425125251','蟜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214315','虴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214315','虼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143152134','蜁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214321155212','蜵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432121','蚯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432124','蚹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214321511254','螋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432151135','蜺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432153354','蝂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432154','蚮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214321542511134','蟘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214321554','蜒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143223541234','螩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432411121','蜼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214324111214444','蟭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214325111121','蝗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143251111344','螑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143251114544','螅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432511151234','蟂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214325113','蛜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432511312','蜱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214325113554','螝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143251154444','螐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214325125214','蝺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143251511252','螄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121432535414544','蟌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143254311535','螕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143312','蚚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121433124','蚸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143321531535','螔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121433544','蛌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143411234','蜍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214341251','蛤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214341251122','蝓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121434125122','蜦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143425135','蛻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214343123425121','蟠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121434312344544','蟋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143432','蚧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143434','蚥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214344134522554','蠄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214344311354','蝯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143443124','蛶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214344335554444','蟡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143443521','蜉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143443554134','螇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143445','蚙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143445113251','螥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143445251','蛿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121434454','蛉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143453','蚡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143454','蚣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143454541541','螉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435','虮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143511','蚏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435121251','蜩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143513344111251','蟾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214351355','蛫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143515','蚔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435154','蚳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435251','蚼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214352511134','蝜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143525121','蜔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435251353334','蟓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435311252','蜪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435321511','蜭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143535112533112','蠏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214353535','蛠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214354','虳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143541','蚐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143541','蚒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512143541112','蜂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214354251','蛒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214354354','蛥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121435515','蚫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214411125112132511','蠩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441121','蛀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441251251112213534','蠰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214412514512','蝏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441251451353334','蠔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441251521','蜳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144125251125111','蟺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441312214444','蟅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144134','蚊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144134131134','螏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144134315112234','蠊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214413431523','蝷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214413432','蛴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214413434','蛟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441343412','蜶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144134522554','螭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144135','蚄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144135','蚢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144135112251','螗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441352211535','螰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214413531521','蝣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144135342511134','蠀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441431251112','蟑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441431251121515111','蠬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214414312511543','蟙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441432533543211','蠐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441432534251','螪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144143454135','螃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214415','虻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441542511','蜟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441554','蚿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121441554413412','蟀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214431112','蛘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214431112431251','蟮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144311135','蜣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144311213121543','蟻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214431132','蛢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121443113455','蜷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214431234531','蝼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214431253511','蝤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144313425221','螠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144315112234','螊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214431554554','螆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121443251112','蝉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144325135','蜕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121443344334451234','蠑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214433443344535','蟧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214434','蚁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214435234354','蝬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444115151234','蟝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144412','蚪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444335112','蝋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144451112251','螛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444512134','蝊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444512332511134','蠙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214445125111','蝖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444512512134','螾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444534154121','螲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444535','蛇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121444535455','蜿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144511534','蜋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121445115452','螂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121445131344','蜧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214451325122','蝙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144525114134','螟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512144535455','畹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145','虬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214511121251124','蟳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145112321155212','蟰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214511534','蛝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214511534454','螁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145115452','蝍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214512115154','蝦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121451312251','蜛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214513241342522135251214','蠾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121451335','蚭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145134','蚇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145134','蚗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145152','蚓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214515515122134','蟤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121452','虯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214521','虸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121452125221','蜢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214521325111','蝞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214521342511','蝑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145215','蚆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121452413452','蜬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214525','虵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214525111','畳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121453','虭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121453251','蛁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121453254','蚾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121454','迪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121454121','蛏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214541541','蛡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121454154132411121','蠗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121454154134333','蟉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512145425112','蛹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214543112','蛑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214544','思',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214544132511134','顋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214545231234','蝚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121454545454','蝃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214551','蚂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214551353334','蝝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121455435','蚴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214554554134543','蟣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251214555254315445445','蠟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512152','邮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121531512512543121344','囐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121531512514311523','嚱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512153151353334','噱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121531522431','嘘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251215315225211','噓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512153152511134','噳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512153152512125221','嚧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121531534312','嘑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121531535','唬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512154','廸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512154154134333','疁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512154252211','圔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251215434354','畯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512154545454','畷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25121554234','累',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251221','曲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512211251431','豊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512211251431355215','艶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25122112514314351523','豑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251221125143152','鄷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512211311534','農',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25122134','典',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251221342511135','覥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251221342535','觍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251221343134','敟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251224314311134','噗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25122431431121124','嚉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25122511','固',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251225221','盅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251231','团',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512341','困',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512343','吵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25124','卟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251241','団',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251243135','咣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512432511','哨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512432511134','嗩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512432534','唢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25124345251121','嘡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512434525125121','噹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25124345251352511','嚐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512454','迚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25124544','忠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251','吅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251','同',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251','吕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511','肙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111','呾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111','咀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511112','哻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511121','哩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111215452','嘢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251112211154','嘬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511122112','嗶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251112213424134','嚗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511125351','嗮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511134','員',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511134','唄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111342511134531','嚶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251113432511154444','鶰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251113435','勛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511134432524312511','囎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251113452','鄖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511135','哯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251113533','啺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251115','咢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251115132511134','顎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251115132534','颚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511152511135','覨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111532511154444','鶚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111535451','鹗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251115454','遌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111552','卾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111552','鄂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125111554','瓹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125112','呷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125112','呻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511211254444','駡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251121251251','噐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125112141','啯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125112141241','團',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251122','剈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511241','圃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511241241','圑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125112511','唱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511251135321511','嚪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511251151221113134','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251125125251251','嚚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125112512531','嘍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251125214','喁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251125221','嗢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251132511134251251','嚻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251132511134251251','囂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251132511154444','鵑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251132534251251','嚣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511344','哭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511344251251','器',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511351221113134','嚴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251135345','喝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251135451','鹃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251141431','喅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125115','呺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125115','黾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512511543','戙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125115431','國',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251154313324','爴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512','串',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125121','呥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251211534','喂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251212511','喟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251212511134','嘳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512134','哫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251214','虽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125121432411121','雖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512211311534','噥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125122134','唺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512251251','嗣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125122541541','翤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125124544','患',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251','品',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251','哃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512511','圄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251112','單',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512511121311534','辴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512511121543','戰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125125111232511154444','鷤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512511125131221534','囅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125125111252','鄲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512511234','喿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251123422','劋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125125112343115','氉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251123452','鄵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125125113251','碞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125125115431','嘓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251211251','嘼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512512112511251211511','鼉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512512112511344','獸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125125121125125115','鼍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251251112','嘽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512512511234','噪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251252','喦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251251252','嵒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512512534','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125132','丳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125134','呮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125134','咉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251341','咽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512513414544','嗯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125135','呪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125135','咒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512513522','哵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251431523454','遻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251434242','喌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251454','迵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251454412','斝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125152','郘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512515215','唈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125152251251','嘂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251251551','骂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251252','吊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125213121121','嘊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125213251','啱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251252132522','喘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512522112513534','噮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251252212511134','嘪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512522135251214','噣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125221354','啰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125221431353334454','嚺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512522155444432411121','囉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125232411121','嗺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125235113511','嘣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251252354','哕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512534','吶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512534','呐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512534','呗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512534','员',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2512534','呙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251253422','剐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125342534531','嘤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251253435','勋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251253452','郧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125351','呬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251254312114444','嘿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251254312114444121','嚜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125431211444421251','嚸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25125525251','喎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251255452511','嗗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513112','吘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513112','吽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251311212','哖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251311212152','啣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131122121','唾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251311222214444','嘸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251311234','咮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131125221531534312','嚹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131134','呹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251312','吀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131211','咋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513121251','哠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513121353121352511134','囋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513121543','哦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251312251','咶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251312321511','喢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131234','咊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513123422','唎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131234251','啝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251312343533424134','嚟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251312344334','啾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513123453','唀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131234531','唩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251312511121','喠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25131254312114444','嚑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513132','呏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513134','呚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251313425125251','嘺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513143141234341','噬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513143142522155444432411121','囖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251315','吃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251315','吒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251321234','咻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132124','咐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513212512','哬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251321511254','嗖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132151135','唲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251321554','唌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513225122511','嗰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513235','吪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251323512','哗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251323554234','喺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513241','囨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132411121','唯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513241112132511154444','鷕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251324111214444','噍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513251','呂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325111','咱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325111','囿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325111121','喤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513251111344','嗅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513251112','唕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132511125121132','嚊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513251113412','嗥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325111413412','嘷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513251115','唣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132511151234','嘄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132511154444','鳴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325113','咿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132511312','啤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132511354','啲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325113552','喞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132511413412','噑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513251141353134','噭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513251154444','嗚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325115545541234','嚛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325131134','喉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25132525','咃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325251','响',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251325431234134','噢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513312','听',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251332112','哘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513321531535','嗁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25133221212134','嘥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25133225111124','嘚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251333534','哌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25133544','呱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134','只',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134','叭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134','史',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134','叺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134','央',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341','因',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134112251','啥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513411234','唋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134112431','唫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341154','哙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341251','哈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341251122','喻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341251132','啽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341251155','喩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513412512513434','噞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513412513112','嗱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341251541541','噏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134125221531','嘦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513412524312511','噲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513413534','欭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513414544','恩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251341534','咷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513425221','盎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134312','呼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251343123425121','噃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513432','吤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513432511154444','鴦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513434121','唑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513434251','唂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513434354354','嗲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513435451','鸯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251344134522554','噙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251344311354','喛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134431234','啋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513443124','哷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134432522151154124','嚼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513443311252','嗂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251344335554444','噅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513443451354','嗳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513443454544354','噯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513443521','哹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134435215','啂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513443531','哸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513443554134','嗘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513445','吟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513445113251','嗆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251344511534','喰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513445251','唅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134452511134','嗿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134454','呤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25134454544','唸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513453','吩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513454541541','嗡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513455','呛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135','兄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135','另',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135','叱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135','叻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135','叽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135121251','啁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251351234','哚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513513344111251','噡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135154','呧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513522','別',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513522','别',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135251','呴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135251','咖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251352511','咰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135251153535251354','嚵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251352512112511','噜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251352512144442511','嚕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513525134','唤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251352514444','喣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251352534134','喚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135311252','啕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135321511','啗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513533','吻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513533341','圂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135333414544','慁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135334544','唿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513534','吹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513534334','唙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135344334','焁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251353453','哛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513535112','唃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135351124412','嘝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513535352511','嗋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513541','呁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251354242511','喒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251354251','咯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251354352','哅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251354354','哆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251354413444444','嘫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135444','咚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135451','鸣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251354533411243122','嚠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513551','呜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251355114544','喼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25135515','咆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2513554','吺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514111251','唁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251412512341354','噈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141251251112213534','嚷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514125125251','嗃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141251451353334','嚎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251412514535','喨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514125152','哼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141251521','啍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251412515213134','噋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141312212512134','嚝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141312214444','嗻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251413122154','喥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141312341234','嘛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514131234123413251','嚰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251413123412343112','嚤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141312341234554','嚒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514134','呅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251413432','哜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251413434','咬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141343412','啐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251413434123432411121','囃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514134454','唥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251413452255432411121','囄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514135','吭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141351125112','嘃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141353131134','嗾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141353444','唹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514143112342511135','嚫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514143112353312','噺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251414312511','喑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251414312511121','噇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141431251121515111','嚨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514143125113534','噷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514143125114544','噫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251414313333','喭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141431531','唼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141432512251','嘀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141432533543211','嚌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251414345252','啼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514143454135','嗙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251415334','咳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141542511','唷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514155332411121','噰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25141554','呟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25142551221113134','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431112','咩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431113121','嗟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514311135','唴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431113554','嗴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431134','咲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25143113455','啳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431234','咪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431234354152','噒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431234531','喽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431253511124','噂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514313252','唏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514313425221','嗌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514315112234','嗛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514315233511','嗍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251431554554','嗞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251432','吖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25143251112','啴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514325135','哾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251432524312511','噌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514334','吙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25143344334','啖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251433443344535','嘮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514412','呌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514412343','唦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514413155144','嗨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144153254','啵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144153254531','嘙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514451112251','嗐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514451122134121','噻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514451135','唍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144512','咛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144512134','啶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251445125111','喧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514453112','哰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251445315','咤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144534121','啌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144534414312511','噾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144535','咜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251445354251','喀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144535445411234','嚓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144535455','啘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144545442522112','嚀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25144545443252','嘧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251445531','咹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514511534','哴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25145115452','啷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251451251112','喗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25145131344','唳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25145135','呝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251453534','哝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2514544','吣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25145443','咇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25145534','咏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151','叼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251511121251124','噚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151121444425221','嚍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515112321155212','嘯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151123234','啸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151124313432','嘨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515113','吚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251511352','哪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515114554','唚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251511534','哏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251511541535','嘅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515115452','唧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515121','吜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151221113134','噉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151251','呞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151312251','啹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251513154121','喔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251513241342522135251214','囑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515132514143112','噼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151325222','唰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251513325125214','嘱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151335','呢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515134','吳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515134','吷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515134','呉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515134','呎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151352252','啒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151515','呡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515152','吲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25151532','咈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251515515122134','噀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25152','叩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25152','叫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251521','吇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251521251152','喡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515212512','啊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515215','吧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515215','吼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515215','邑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515221251214','嗤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515225111','唨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25152252','咄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251525','吔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515251','囤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25153','叧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25153','叨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25153154','呶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251534','吸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25154','叹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25154154132411121','嚁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25154154134333','嘐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25154154141343412','噿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25154251','咍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515425112454','嗵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251543112','哞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515431134','唉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251543341251431','噔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515434354','唆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515435','吮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251545232534251','噊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515454541234','嗓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25154545434333','嘇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25154545454','啜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251551','吗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251551353334','喙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251551354','哟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25155144','呣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251554','吆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25155435','呦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515544441251124124','嚩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251554444354','喲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251554444554234','噝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('251554554134543','嘰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2515552515215','嗈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25155551','咝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252','山',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252','巾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521','円',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25211','亗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521113124','帱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252112','屽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25211212511','崝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25211212511134','幘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25211212534','帻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521122112','崋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25211234','帓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521132','岍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521135','岏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521152','帏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212','帄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252121','屸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212111534','帳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252121121121135','嶢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252121121121135','嶤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252121121124','崶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252121124','峙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252121222511134','幩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521212511134','幊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212132411121','嶊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212132411121543','嶻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212132511','帾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212132511134','嵿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252121335','峔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212134354','崚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521213534','崁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212151211251124','嶹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212151211251124','幬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212211134','帺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252122111345','嵁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252122113534','嵌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212212511235431234','巈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252122151234','幉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521222511134','幙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252122251135345','嶱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212225125132411121','巏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212225221134543','幭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521224511353334','幪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252122451234','嵘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521224535','崂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212251','岵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521225111134','嵮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212251111341325111134','巔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521225111134132534','巅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212312','岼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212341234','崊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252123415431543','嶘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252123425111','嵖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212343434','崍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212343454','崧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252123441121','嵀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252125111','峘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212511123312','嶃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212511123312','嶄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212511234','崠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212511234','崬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521251124','峬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521251134','峺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212512','岢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212512212511','嶆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521251251','峿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252125125121','幅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212512512515','嶇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521251431','豈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521251431132511134','顗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212514311344','獃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212514312154','敱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252125143122','剴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212514312511135','覬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212514313134','敳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252125143135','凱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521251431353251214','颽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25212522111234','幖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252125221531','崾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521254','岐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213','屵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213112','岸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521311534','帪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213121121','崕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213121121','崖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213122251125214','巁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252131233543','嵗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252131251543','嵅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252131253511515','嶏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252131531543','崴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213221545252','嵽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213241','岯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213251','岩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132511','峟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132511','帞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521325111212151534354','巎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132511134','崸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132511134','幁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132522','峏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132522','耑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132522132511134','顓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132522132534','颛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213252222','剬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521325223534','歂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252132522454','遄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521332411121','嵟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252134121','峚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521341251112','輋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213412512','崎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213425115','崦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252134315233534','嶡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252134315233534','嶥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252134334','炭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521343434','峽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252134432511234','嶚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252134432511234','嶛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521345','岖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252135','屼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521353334121121','嶳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252135422','峛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252135422','峢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25213544','帗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252135543','峸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521431234','崃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252143134','峡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25214524444115','嶀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25214524444132522','嶿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252151','屿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25215112134','崨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25215123312','崭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521515','岠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252151534','峓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2521523','岈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25215234','岽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252152352','峫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252153135','峣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252153515352511','嶜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252154121','峌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25215431543','帴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221','冊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221','皿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221','罒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522111','囬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211124','峠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522111454','逥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211154','廽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221121121','罣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112112124','罫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211211254444','罵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112121','罡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211212513534','瞏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112132511','署',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112143112','睪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221121431123134','斁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211214311232511154444','鸅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221121431123534','歝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112154','罢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221121544444','罴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211221251121211254444','羈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112212511213412512','羇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221122125112551','羁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211222511134252','羃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112251','罟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112251111','置',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221122543112','罱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112341234','罧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112511543','罭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112513234454','還',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112513534','睘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211251353435451','鹮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522112513534541541','翾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252211324','罘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522113425115','罨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221134334433422','罽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522121112111','罪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522121251112','罩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522122','刪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522123344','眔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522123344454','遝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522124432411121','罹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221251','岾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221251','帖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522125111','罝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252212511122112','罼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252212511134','幀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252212511134','買',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221251113432511154444','鷶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221251214544','罳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252212512511','罥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252212522125221134','奰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252212534','帧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221323434','眾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522133544','罛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221344','罖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252213443521','罦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522135251214','蜀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221352512142154','斀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252213525121422','劅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252213525121432511154444','鸀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221352512143534','歜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221352512144412','斣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221354','罗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221354454','逻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252213545325121','罶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252214111251','詈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252214111251124','罸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221411125122','罰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252214111251554444554234','羉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522141121','罜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221414312511','罯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221414312511121','罿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221432524312511','罾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252214351523','罤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252214522','罚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522151311234124','罻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522151515','罠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221531512512543121344','巘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221531512512543121344','巚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25221531512514311543','巇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252215425113535','罷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522154251135354444','羆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522154523','罞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522154545454','罬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522155444421251112','羄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252215544442512511','羂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522155444432411121','羅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522155444432411121454','邏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522155525111234','罺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522243143111234','嶪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522243143111234','嶫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252224314311134','幞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252234324111211543','巀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25223511','岿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522432511','峭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522432511','帩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252243452513112','幥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225111','岨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522511121124','嵵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251112134','崼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251113422','崱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225111342511134531','巊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522511135','峴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251113533','崵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225111535','崐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225111535','崑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225112','岬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225112141','帼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251122111543','嶯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522511243135','幌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251125111','帽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225112512531','嶁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251125214','嵎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225112522154','幔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251135345','嵑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251135345','幆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251141251234','幜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225121','岫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225121','峀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251211534','嵔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251214544','崽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522512211311534','嶩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225122511','崓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225122511','崮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251251','峒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251251','峝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251251115','崿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522512511351221113134','巖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522512511351221113134','巗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225125115431','幗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251251251','嵓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252251251251112','幝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522512512511234','幧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225132411121','嶉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225134','岟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225134','帜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225135','岲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252252','屾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252252','岀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522521251431','嵦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522522112143112','嶧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522522121112111','嶵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522534','汖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522534121','埊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225342511','崉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522535','岘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2522543','岗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25225431252','崗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252311153534','嵚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25231122121','崜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252311222214444','幠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25231133112','帲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25231134','帙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25231211','岝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25231211','岞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523121251','峼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523121353121352511134','巑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523121543','峨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523121543','峩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523122113534','嵊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523123422','峲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252312344412','嵙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25231234531','崣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25231234531325113554','巍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523134','岆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252313425125251','嶠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252313432','峤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523143145115452','幯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252315','屹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523154','帐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523211152511134','嶼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232121','岴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523223134','峳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232411121','崔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232411121','帷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252324111212525','嶲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252324111212534251','巂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232411121253425152','酅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252324111214444','嶕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252324111214444','嶣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232511','岶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232511','帕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252325111121','崲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523251111234','嵲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232511154444','嶋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232511154444','嶌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232511312','崥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252325113554','嵬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523251154444','嵨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252325131134','帿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252325151212151145252','巋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523251514143112','嶭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25232535414544','幒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523312','岓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252332121124','崻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523322521353134','嶶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25233234342134','嵷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25233234342134','嵸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252332511112','嵂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523354','岅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341121','峑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234112431','崟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234112431','崯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341124313534','嶔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341251','峆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341251','峇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341251','帢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341251122','崳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341251122','嵛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234125122','崘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234125122','崙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523412512513434','嶮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252341251541541','嶖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234132511','崤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523414431','崄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252342121','峜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234251153434251354','巉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252343123425121','嶓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252343123425121','幡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523432','岕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523434251','峪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252344311354','嵈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234431215114544','嶾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523443321511','幍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234435112','崢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523443554134','嵠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523445','岑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523445','岒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523445113251','嵢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234454','岭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234454','岺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25234454132511134','嶺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523453','岎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523453','帉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523454541541','嵡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235','屴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523511','岄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235113511','崩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523511351122','剻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523513344111251','嶦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523513344111251','幨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252351355','峗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252351355','峞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235152511','崏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235154','岻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235251','岣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252352511','峋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523525111534132511134','巓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235251353334','嶑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235311345452134','嶷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252353251214','嵐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523533','岉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235341112511344','嶽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523535112','崅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523535112533112','嶰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235352','峁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252354','岁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252354','帆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523541112','峯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523541112','峰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523541521234','嵥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235422','刿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252354251','峈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252354251','峉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523543','岚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25235444','峂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523545325121','嵧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252354541541','翙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252355112','峥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2523552','岇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524111251','訔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252412511','峕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524125125251','嵩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524125125251','嵪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252412512525125113312','巐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252412514512','嵉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241251521','崞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252413121251431124','幮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252413434','峧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241343412','崒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241343412','崪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524134342511','嵴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524135112251','嵣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241351124134','嵻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252413531525','崺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241431','岦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524143112','峷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241431251112','嶂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241431251112','幛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252414312511121','幢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241431251121515111','巃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241431251121515111','巄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252414312511543','幟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252414312512','嵜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252414312512','﨑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241431331121','嵼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252414313333','嵃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25241431531','帹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252414345252','崹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524143454135','嵭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252415334','峐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431113121','嵯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431113121','嵳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431121134','嵄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524311213121543','嶬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431132','帡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431234354152','嶙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431234531','嵝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431253511','崷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431253511124','嶟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431325111212151534354','巙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524313251514143112531','巕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524315112234','嵰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252431554554','嵫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524325135','帨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252432524312511','嶒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25243344334451234','嶸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524334433445251251','巆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252433443344535','嶗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252435234354','嵏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252435234354','嵕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524431351221113134','巌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524451112252214544','幰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25244511234','崇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524451353334','幏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524451354','峵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25244534','岤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25244534121','崆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524453434251','嵱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25244535','岮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25244535455','帵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252445531','峖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524511534','崀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524525114134','幎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2524535','帎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252454','辿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525','乢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251','冋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251','凹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252511','回',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252511112','峍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525112151125431234','幱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251122525111','圖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525113251','峮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252511454','迴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252511534','峎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251154','廻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252512125111341','圚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525125111341','圓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525125341','圆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251311234124','嶎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251312251','崌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252513154121','幄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251342252','崫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252513431132','幈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525135','兕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251352252','崛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251454','迥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252515','屺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252515','岂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251515','岷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251522','剀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252515251251214','嵹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525152535','觊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251532','岪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25251535','凯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525154151541','嵶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25252','邖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252521251152','幃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252521325111','嵋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252521325221','圌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25252133544124','嶈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525215','岜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525215','帊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525221121431121','圛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525221125135341','圜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252522141351','圐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25252354131121','嶐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25252413452','崡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25253','屶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25253','屷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25253251','岧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25253251','岹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25253254','岥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25253254','帔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252534','屻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252534','岃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252534','岋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252534','岌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525341','囦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25254112','峄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25254132','峅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25254154132511','嶍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25254154134333','嵺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('252543341251431','嶝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2525434354','峻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25254545434333','嵾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25254545434333','幓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25255435','岰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25255525121','崰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25312341','囷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2532351','囮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534','內',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534','内',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534','水',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534','贝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25341','囚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253411212154','赋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253411212511','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534113543','贼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253411543','贱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534121','坔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25341211','囶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253412132511','赌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534123','财',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25341241344','赇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25341251124124','赙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25341251221','圇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253412544134','赎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25341311534','赈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534132132511134','頮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534132132534','颒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253413251','沯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534132511','贿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25341325221111','圙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253421251','贴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253422','则',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534251','冏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534251','呇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534251','囧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25342511','沓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534251125111','赗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253425113533','赐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253425121','畓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253425135','贶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25342513511','朙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253425221','泴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25342534','沝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253425342534','淼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253425342534','赑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25342534311252','罂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25342534531','婴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534253453135451','鹦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25343134','败',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25343154','账',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25343354','贩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253434','氼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253434','肉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25343411234','赊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25343454','贬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534351','囵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253435121251','赒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25343513344111251','赡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534354251','赂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25343554','购',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534413121','赃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253441351','圀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253441431251','赔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534415334','赅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25344315112234','赚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534432524312511','赠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253443344334','赕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253444112212523434','濷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25344451','贮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25344541','囹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2534513444','赆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253452','凼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('253454251','贻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25345452','沀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2535','见',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25351','四',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2535331','囫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25354441','图',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2535521','觃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2541112511','圁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2541112515544445544441','圝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25411125155444455444412341','圞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2541351','囥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543','冈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543','罓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254311345151','圏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431134551','圈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444','黑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444121','墨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444121251','黠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444121252212511134','黷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444412211','黚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444122111345','黮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144441225111134','黰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444125221121','黫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444412544134','黩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444131251543','黬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444413425115','黤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144441344','默',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144441525','黗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144441535','黖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444154','黓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444421251','點',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144442153152512125221','黸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144443155144','黣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444341251132','黭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144443445','黔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144443513344111251','黵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444354354','黟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444441251234','黥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254312114444414312511','黯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444444535455','黦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144444535','黕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444452252','黜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444454134333','黪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543121144445434354','黢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444454545434333','黲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431211444455435','黝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431252','岡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2543125222','剛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25431415','罔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254322','刚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254343','网',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('254343122155125121','羀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2544341','図',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25511','囙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2551112125111','圕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25515','囘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25515151','囻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255211','囝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255212511521','圍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25525','冎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25525251','咼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255252511535','旤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2552525122','剮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255252513534','歄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25525251454','過',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255311','囡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25532511','囼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554','禸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25541','囜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25541225221111','圗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255425111341','圎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511','骨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511112','骬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511112','骭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511121121121135','髐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511122135435132','髒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251112251','骷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251112341','骵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525111251124124','髆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525111251134','骾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511131212511454','髓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511132511134','顝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511132511454','髄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511134115','骻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511154','骮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511212135','骴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525112153152512125221','髗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251125111234','髁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251125112512531','髏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511251125214','髃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525112512211251431','體',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525112522135251214','髑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251132511154444','鶻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251132511312','髀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511331251','骺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525113432','骱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525113443531','骽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251135','骩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251135154','骶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511354','骪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511354','骫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511354251','骼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251135451','鹘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251135515','骲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525113554','骰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525114125125251','髇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251141312341234','髍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511413434','骹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525114135','骯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525114143454135','髈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511415334','骸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511431113121','髊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511431132','骿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511431234531','髅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251144512225111354','髖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525114451222535','髋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251144512332511134','髕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525114453212134','髌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255452511445354251','髂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('2554525114532411121','髉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251153254','骳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('25545251154154134333','髎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('255455452','幽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3','丿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115','钅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115111253134','锲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151113124','铸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111511212511','锖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111511214','钰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151132','钘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115113222','铏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111511543','钱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512','针',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512','钉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115121','钍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512121','钲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115121315','铐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512132511','锗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115121335','铑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151215','钙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512211','钳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115122111','铒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151221115454','镊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512212132511','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512212511','错',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512213251','锘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151222511134','镆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512225121','锚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512225134','锳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151223241112154','镬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115122415','铓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115122431','铔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151224535','铹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512251','钴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151225111134','镇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512341','钵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151251124','铺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151251124124','镈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512512','钶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151251251','铻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151251254312','镉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512515','钷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111512522111234','镖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115125221251112','镡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151324','钚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111513251','钸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115132511','铕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111513412132','锛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111513412512','锜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115134315233534','镢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151344','钛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115134432511234','镣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111513544','钹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115135543','铖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151431234','铼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115143134','铗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151452444425121','镭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151454454','铽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151512454','链',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151515','钜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151523','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115152352','铘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311151525','钝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115153135','铙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115153532511','锴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115154121','铚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111515543','钺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111521251','钻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111522','钊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115224314311134','镤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152254121','铿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152343','钞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111524','钋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152432511','销',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152432534','锁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111524345251121','镗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152434525135','镋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115243511','铛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525111','钼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525111','钽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525111124','锝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152511121','锂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152511121','锃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525111234','锞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525111251113241112154','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152511153','锄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525111535','锟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525112','钾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525112511','锠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525112522154','镘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525113533','锡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152512','钟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525121','钿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525121','铀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115251214544','锶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525121554234','镙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525122511','锢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115251251','铜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115251251','铝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115251251115','锷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115251252','铞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152512534','锅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115251341','铟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152522112513534','镮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152522135251214','镯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525221354','锣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111525235113511','镚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115252515','铠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152534','钠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152534','钡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115253422','铡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311152543','钢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111531122121','锤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115311234','铢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111531134','铁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312','钎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153121251','锆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312135','铣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312154','铤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312154','铥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153121543','锇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312251','铦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312321511','锸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312344334','锹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153123453','锈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115312511121','锺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115321113554','锻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115321511254','锼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115322','钏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115323512','铧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111532411121','锥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153241112153','镌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111532511','铂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115325111121','锽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153251111234','镍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111532511252','锦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111533122534','锧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111533123534','锨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115333','钐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153354','钣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115341121','铨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115341251','铪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153412513112','镎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115341534','铫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153434121','锉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115344311354','锾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153443124','锊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153445','钤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111534454','铃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153511','钥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111535234','铄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111535251','铅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111535251153535251354','镵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115352512112511','镥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111535334544','锪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153534','钦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111535351','铆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115354','钒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115354','钓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153541','钧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153541112','锋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115354251','铬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115354251','铭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153545325121','镏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153551','钨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115355112','铮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111535515','铇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115355215','铯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311153554','钩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115412354124','锵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541251251112213534','镶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154125125251','镐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115412513534','锿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115412515213134','镦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541252','铈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115413122154','镀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154134315112234','镰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115413434','铰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154135','钪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154135','钫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541351125112','镛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115413522115354444','镳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541353131134','镞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541353152134','镟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115413534','铱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154143112','锌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541431251','锫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541431251135','镜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154143125114544','镱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115414313','铲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541432512251','镝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154143454135','镑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154154325','锍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115415435','铳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111541554','铉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115425','钔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154251132','锎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115425125341234','镧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154252511','锏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115431112431251','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115431121134','镁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111543113455','锩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115431224312511','镨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115431234','铩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115431234531','镂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154313425221','镒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115431554554','镃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154325135','锐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154334','钬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111543344334','锬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154351523','锑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154412','钭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115441533','铴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111544512134','锭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154451353334','镓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154453212134','镔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115445342512512','镩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154453434251','镕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111544535','铊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111544535445411234','镲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115445531','铵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154511534','锒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311154513541541','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111545443','铋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311155','钆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311155','钇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111551111254','键',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311155114554','锓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115511534','银',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311155121','钮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111551312251','锯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111551335','铌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311155135251','锔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115515251251214','镪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115515322534','镄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111552','钌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311155212512','锕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111552125221','锰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115521325111','镅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311155215','钯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115531','钕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115531251','铷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111553254','铍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115533','钖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115534','钑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111553544','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111554112','铎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111554154134333','镠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115543341251431','镫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115544','钗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3111555525121','锱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31115555254315445445','镴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112','午',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112','手',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112','牛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112','牜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121','玍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121','生',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311212','年',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112121','牡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112121124','特',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112121252212511134','犢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311212152','卸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121221325112','犕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311212251','牯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311212251111','犆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121232511154444','鵇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112125111','眚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311212512','牱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311212512153','甥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121251251','啎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121251251','牾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112125351','牺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311212544134','犊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112131121','甡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121311212511','甧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311213122251125214','犡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311213412512','犄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121353334','牻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112153534','欫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121543','牫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31121555121','牼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31122121','垂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311221211554','甀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112212152','郵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311221234','乗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112222112341234','橆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31122221354152','舞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311222214444','無',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112222144441554','甒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31122221444432511154444','鷡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31122221444452','鄦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112251','吿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311225111134','犋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112251111344','犑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112251112213424134','犦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311225121','牰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112252215425113535','犤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311225351','牭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311225431252','犅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123112','牪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311231121','牲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311231123112','掱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311231123112','犇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123115','牦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123115431234','犔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123121251','牿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112312344412','犐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112312515213134','犜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123134','牧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112313425125251','犞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311234','朱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112341121','牷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123412513112','搿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112342511251211511','鼄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123432511154444','鴸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123452','邾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311235','劧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311235','牝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311235','牞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311235154','牴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123523','牬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123533','物',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311235334544','惣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123535112','觕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31123552335523','犓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31124125125251','犒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311241251521','犉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31124135','牥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31124135','牨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112413522115354444','犥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311241431251','犃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112414312511121','犝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112415','牤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31124311213121543','犠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31124311213123415543','犧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311243113455','犈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112431325111212151534354','犪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31124451112251','犗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112445521','牸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112451325122','犏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112454','迕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311251111254','犍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112512115154','犌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252','缶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252121','缸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125212225125132411121','罐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125212341','缽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252125221251112','罈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112522153152512125221','罏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125221531534312','罅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125222','制',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252223112','掣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125222413534','製',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252243452513112','罉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112522511145244441154','罎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125225431252','罁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252331251','缿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252341534','罀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112523534','缼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252431132','缾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311252431253411124','罇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112524444','缹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112525','牠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112525134','缺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125252','缷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31125255212511134','罆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112534','牣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311254545434444','犙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311255144','牳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3112555254315445445','犣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311311112','拜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311324111212511135','観',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113241112135','勧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311324111213534','歓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311325111','看',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31133112','幷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311331121554','甁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31133112454','逬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311334533112','掰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134','失',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134','矢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311341223241112154','矱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311341251431','短',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311341515','矩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113415151234','榘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134251','知',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134251122111','聟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311342512511','智',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113425125125115151','鼅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134252215425113535','矲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113431234531','矮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311343134','矨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134313425125251','矯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134313432','矫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113432411121','雉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113432511154444','鴙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113432511154444','鴩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134335144','矪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311343434121','矬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3113435','劮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134432524312511','矰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31134454','迭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311344544','怣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311345152','矧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115','毛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115','气',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311511212511','氰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115113543','毧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311512155121','氬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31151222511134','氁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115122431','氩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31151225135','氪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31151241344','毬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311512511234','氭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311512534','氞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115125351','毢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115125351','氥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31151555121','氫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311521112111','毴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311521251','毡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311522','刏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115234','毜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31152511','氜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31152511135','覒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115251113533','氱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311525112','氠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115251125221','氲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115251214544','毸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115251341','氤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115252','氙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31152534','氝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31152534125221','氳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31153','氕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311531153115','毳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115312135','毨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311532','氘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115322','氚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115333','毝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311534','気',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115341251122','毺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31153453','氛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115352511','毥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115352512112511','氇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115352512144442511','氌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311535431234','毱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311535444','氡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31154125251125111','氊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311541431251','毰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115415334','氦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115431112','氧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115431224312511','氆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115431234','毩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115431234','氣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311543344334','毯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311543344334','氮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115445531','氨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31154544','忥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311551111254','毽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311551124134','氯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311551532','氟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311553','氖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311554121','氢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('311554134333','毶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3115543112','毪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312','千',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121','壬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31211','乍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31211454','迮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312114544','怎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31212213422','剰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121251','告',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121251132511134','頶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312125121112111','靠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312125132511154444','鵠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312125135','勂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312125135451','鹄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121251454','造',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312125152','郜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312135','先',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312135312135','兟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121353121352511134','贊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312135312135251113422','劗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312135312135251113452','酇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121353121352534','赞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312135312135253452','酂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312135454','选',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312154','丢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312154','廷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312154132511134','頲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312154132534','颋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3121543','我',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312154332511154444','鵝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312154332511154444','鵞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312154335451','鹅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31221135','乖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122113511','埀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122113534','乘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312211353422','剩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312251','舌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225111342444','舔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225112211','甜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312251122114544','憇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312251132511134','頢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225122','刮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225125113533','舓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225125121','舑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312251312251312251','舙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122513134','敌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122513251114544','憩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225132511154444','鴰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122513513344111251','舚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122513515','舐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225135451','鸹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122514143112','辞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225143344334','舕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312251454','适',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3122515','乱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31225152','舏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312312','竹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312321511','臿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123215112154','敮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123215113534','歃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234','尓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234','禾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234111253134','稧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234112','秆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123411212511134','積',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123411234','秣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341154','秐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234121121121135','穘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234121124','秲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234121251','秸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412134121','稑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412134354','稜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412155121','稏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412211134','稘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234122122111','穁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412212511','稓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412212512134','穔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341223241112154','穫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412251','秙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412251111','稙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341225111134','稹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234122512511252511','穯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341234341252511','穡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412344','秫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412431252511','穑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234125112144544','穗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341251124','秿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341251124544','穂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341251134','稉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341251153334','稶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123412511543','稢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234125125121','稫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341254','秓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341254125441352211535','穲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123413241','秠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234132522134','稬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123413425243434343','穪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341354252','嵆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341354252','嵇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341354352511','稽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123413544','秡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123413544111251','諬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123414312','秤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123414524444132522','穤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341515','秬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312341535','秕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234153532511','稭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234154121','秷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342121131233543','穢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123421251','秥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123422','利',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234221234','梨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234223112','犁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342234112431','鋫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234224314311134','穙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234224544','悡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342343','秒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342432511','稍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251','和',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511','香',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425111','租',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511112','稈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511121','程',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511121222511134','馩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251112211154','穝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425111234','稞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425111245521','馞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251113425115','馣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251113544','馛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251115431543','馢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251121112111','馡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511251125221','馧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511251135345','馤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511312342511312342511','馫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342511312511354','馥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425113443521','馟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425113445251','馠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425113453','馚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425114315112234','馦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251144512332511134','馪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251145443','馝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251151335','馜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342512','种',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425121','秞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425121122134','穓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251212511','稩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342512134354','稷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342512211311534','穠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425122511','稒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342512341','稇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251251','秱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251251','稆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425134','秧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425134','积',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234251341','秵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312342514544','惒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234252','秈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425221','盉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234252354','秽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123425312341','稛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234311234','秼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123431134','秩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343115','秏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234312','秊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234312','秊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123431211','秨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343121353121352511134','穳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234312251','秳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123431234','秝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234312511121','種',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234312511354','稪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343134','秗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234313425125251','穚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234315','秅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343211152511134','穥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234323121','秹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123432411121','稚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234324111211234','穕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234324111214444','穛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123432511154444','穒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123432511234333','穆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123432511255115115341','龝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123432511312','稗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434','秂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343411234','稌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234341251','秴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434125122','稐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343424134','黍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234342413421251','黏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434241344134522554','黐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343425135','稅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434431215114544','穩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234344322511','稲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234344325121','稱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434432522151154124','穱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343443321511','稻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434435114544','穏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343443521','稃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434454','秢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123434454544','稔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343453','秎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435','禿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435','秃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435113511','稝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435121251','稠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435132511134','頹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435132511134','頽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435132534','颓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343515','秖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435154','秪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343523','秭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435234','称',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435251125115','穐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234352512112511','穞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435251212511134','穨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234352512144442511','穭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343531234','棃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435325111','睝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343532511154444','鵚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234353254312114444','黧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343533112','犂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435332511154444','鵹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435334112431','錅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343533424134','黎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312343533424134454','邌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435335251214444','鯬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435353','剓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234354','秇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234354354','移',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123435445411234','穄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234355114544','稳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441251234','稤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441251251112213534','穰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344125125251','稿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441251521','稕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441312212512134','穬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344134112213534','穣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441343412','稡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344135','秔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441351124134','穅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234413522115354444','穮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441431251','稖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234414312511121','穜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123441432533543211','穧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344155425121','稸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123443112','秚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344313252','稀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234431353334454','穟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344315112234','稴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234431554554','稵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344325135','税',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344334','秋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123443341253511','醔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123443341554','甃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344334251214','蝵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123443342534','湬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123443343112','揫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234433432511154444','鶖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234433434112431','鍫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234433435451','鹙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123443344544','愁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344334531','媝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344351523','稊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234435234354','稯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344412','科',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123444442511','稥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123444512332511134','穦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344451353334','稼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234445315','秺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344453434251','穃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312344511534','稂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234451325122','稨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234453534','秾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123445443','秘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234511541535','穊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234513241343112','穉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123451335','秜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312345134143112','稺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234521','季',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234521','秄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234521251152','稦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234521342511','稰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123453','秀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234531','委',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312345311554','瓾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312345312511135','覣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123453132511134','頺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234531325113554','魏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312345313251135543112','犩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234531454','逶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123453254','秛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123453454','透',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123454','私',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123454134333','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123454154134333','穋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123454251','秮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312345434354','稄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3123454545434333','穇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31234554554134543','穖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312454','迁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3124544','忎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312511121','重',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31251112125342511','濌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31251112135','動',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312511121354444','勲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312511121354544','憅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('312511354','复',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31251255154444','熈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31254312114444','熏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3125431211444435','勳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('313121','圱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3132','升',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31322','刋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3133434251','谸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3134','夭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3134','攵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3134251','呑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('313425125251','喬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3134251252512154','敽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3134251252513134','敿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31342512525132511154444','鷮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31342512525135','勪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3134252','岙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('313432','乔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('313432511154444','鴁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31354','叐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314','',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411','竺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411121112511','篲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141112145','筺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314111215','筐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314111234','筙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411123412212511','籍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141113124','筹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314111342511','箺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314112','竽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314112','竿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141121132','筭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411212511','箐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411212511134','簀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411212534','箦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141122125121','篝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314113112','筓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141132','笄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314113411342511','簮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314113434345','篋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141135','笎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411431345','箧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431411543','笺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121','笁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141211121115','篚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141211122125121','簼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121121','筀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121121124','篈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412112211','箝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412112212511','簎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121122155125121','籒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121124','等',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412112525','箍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141211254444','篤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121211121111543','籖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412121154444','篶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121251','筘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141212511134','篢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121251124124','簙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412125135','箉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412125145154121','籉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141212522112143112','籜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412132511','箸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412132511312','篺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141213412512513434','籡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314121354','筑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141213541','筠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141213541234','築',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141213543112','篫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141213545325121','籀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412151211251124','籌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412152','笻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412152','筇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141215215','筢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412154112','箨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141215425221','篕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412211134','箕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412211134121','簊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314122111343312','簛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141221113453254','簸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412211154','箃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314122113534','篏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412212511235','簕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412212512134','簧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412213251','箬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412215','笹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141223241112154','籆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141225111234112','簳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314122513511','箶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412341','笨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314123412211134','簯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412341234','箖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314123412525','篐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314123425111','箱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141234341','筮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314123434134251','簭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141234341454','遾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412343434','箂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412343545325121','籕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412511123534','簐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141251112354251','簵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314125111255','範',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412511214124','篿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314125112425221','簠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141251125','筪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141251134','筻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412512','笴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412512125111345','籄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141251234352511134','籟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141251234352534','籁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412512343534','簌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412512531425221','籃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412515','笸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412522111234','篻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141252211211554','籈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141252211234','篥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314125221251112','簟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314125234','策',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431412523422','箣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141254125441352211535','籭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314131251543','箴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431413425243434343','籋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141343434','筴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314134432511234','簝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141353334454','篴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431413543','笼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314135543','筬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141452444432411121','籗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314145244443241112132411121','籱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431415112134','箑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141523','笌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143141535','笓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314153512','筚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314153515352511','簪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431415412122','箌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431415431543','箋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431421251','笘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142153151353334454','籧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142153152243134','簴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142153152512125221','籚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431421531535','箎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142231425221','篮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314231252','筛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314234325111','箵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142432511','筲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314243251122','箾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142434525125121','簹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314243511','筜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142445134','筷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425111','笡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425111','笪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511112','筸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425111132','算',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425111134354','簒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251111344511534','籑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511113454','篡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511113455','篹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425111134554234','纂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511122112','篳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251112343','篎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425111251113241112154','籰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511134','筫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511134','筽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511135','筧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142511135','筯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425111535','箟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425112','笚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251122111','箿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425112511125431234','籣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251125112511','簡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251125114134','簢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425112512531','簍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251125125313134','籔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251131121','篂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425121','笛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425121132','箅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142512121354251','簬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251212511134','簣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251212534','篑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251221','筁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425122511','箇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251251','筒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251251','筥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142512511134','篔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425125115431','簂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251251251112','簞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142512534','筼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314251341','筃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314252132522','篅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425221','笽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314252211252543','簚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425221134543','篾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314252212511134','簤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425221354','箩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142522155444432411121','籮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425312341','箘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142534','笍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425341535','箆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143142535','笕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425525251454','簻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431425541','笝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143111511543','篯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431431121','笙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431431122121','箠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431431134','笶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143115','笔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431431211','笮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143121251','筶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143121251454','簉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314312135','筅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143121353121352511134','籫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314312154','筳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314312251','筈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143123422','筣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431431234354354','簃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314312344334','篍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314312511121','箽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143134','笑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314313425125251','簥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143211152511134','籅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143211212511','篟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431432124','符',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314321251134','箯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314321532511312','簰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431432154','笩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314321543','筏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314321554','筵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143223134','筱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143223541234','篠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314322512','筗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143231211','筰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143241112154','篗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314325111121','篁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314325111445344153454','籩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431432511312','箄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431432511355135','篼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314325131134','篌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143251511252','篩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143254311535','篦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314332112','筕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143321531535','篪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431433221212134','簁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314332311212152','篽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431433231121215211234','籞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431433234342134','篵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143324','笊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314332511112','箻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431433544','笟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314341121','筌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143411234','筡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143411243115431543','籛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434112431312511121','籦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143411243151124134','籙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314341251','答',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434125122','劄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434125122','箚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434125125125125122','籥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434125125125125122132511134','籲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143412512513434','簽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434125125134343134','籢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434125125134343534','籨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143414431','签',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314341534','筄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434341211121111543','籤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434435112','箏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143443521','筟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143445','笒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143445113251','篬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314344511534','篒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143445115431252','籂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143445251','筨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431434454','笭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435','竻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314351132511312','簲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314351135','筋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314351143113424134','籐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143511431134554234','籘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435115254','箙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435121251333','簓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143513344111251','簷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143523','笫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435251','笱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435251','笳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314352511','筍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314352511521','箰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435311345452134','籎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143533','笏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435351','笧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435352','笷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314354','竼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314354','笂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143541','笉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143541112454','篷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143541234','筿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314354251','笿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435444','笗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435454','笾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314355112','筝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431435515','笣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143143552335523','篘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441122113534','簔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144124','笇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144125113534','簑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144125125251','篙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441251451353334','籇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144134315112234','簾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314413434','筊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441343412','箤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144134522554','篱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314413452255432411121','籬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144135','笐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144135112251','篖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314413512211134','簱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441352211535','簏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441353112211134','籏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441353131134','簇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314413531525','箷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441353444','箊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441431','笠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441431251','箁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441431251121515111','籠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144143125115','篭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144143125152','篰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144143132511154444','鷑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441431331121','簅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144143454135','篣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314415','笀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431441525135112511134354','籯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144152513511531354','籝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144252511','简',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431443113455','箞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314431234531','篓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431443123453312','簖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314431251122','箭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431443251112','箪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314433443344535','簩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144343','笅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314441122134','篊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144411251124124','簿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144412511121','篞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314441251113533','簜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314441312135','箲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444132511','箔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314441343123425121','籓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314441525','筂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444153254','箥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444153441234','簗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444154251','箈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444155','笵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144451122134121','簺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144451135','筦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444511353134','簆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144451234','筞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314445125111','箮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444525151','管',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444534121','箜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431444535455','箢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144511534','筤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314451325122','篇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431445132515215','簄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314452451124134','簶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143144532411121','篧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314511112','筆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145112321155212','簫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451123234','箫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451124134','箓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451124313432','簘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145113','笋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451145252','箒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451153425221','簋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145115452','節',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145115452251214','蠞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451251','笥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314513154121','箼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451331133112','簈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314513431132','箳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451515','笢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451523','第',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431451532','笰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145154151541','篛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314515515122134','簨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314521325111','篃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431452133544','箛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145215','笆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431452252','笜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314523411234','篨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314525','竾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145253414444','篜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314531251','筎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431453154','笯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431453251','笤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314534','笈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431454132','笲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431454154132411121','籊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431454251','笞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145425112','筩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314543341251431','簦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3143145434','笖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31431454545434333','篸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314551','笃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314551353334','篆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314554444354','箹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('314314554554155455453312','籪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('315','乇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('315','乞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31511234','秉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31522','刉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31525454','迤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3154','长',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('315454','迄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3155144','每',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31551443134','敏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31551443134325112534','瀪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3155144313435251211','鳘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3155144313435251214444','鰵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('315514431344544','慜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31551443134554234','繁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('315514435','勄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31551443554234','緐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('31551444154325','毓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('315521','毎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32','亻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211','仁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111','仨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321112','仹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111251112511134','輿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111253134','偰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321113124','俦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211134112','俸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321113424134','傣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111342511','偆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321113554','段',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111512511134','舆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211152511134','與',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211152511134112','舉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111525111341251112','轝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321115251113413251','礜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111525111343112','擧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321115251113432511154444','鸒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111525111343534','歟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32111525111344111251','譽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32112','仠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321121','仼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211212154','倵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211212511','倩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211212511134','債',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32112125112511135','儬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211212534','债',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321121353134','傲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211213534','俵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32112154','侙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321121554234','傃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321122125121','傋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211234','佅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211251251511134','興',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32112512515111342511','臖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32112512515114511214','璺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321125125151145123412341344334','爨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32112512515114512535113453','釁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32112512515114525111','舋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211251251511454334','爂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211253451125221','盥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32113222','侀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321134','伕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32113411342511','僣',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32113411342511134','儧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211434351145121','壆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321143435114512212512134','黌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321143435114513251','礐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32114343511452511135','覺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211434351145252','嶨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32114343511452534','澩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32114343511453121251','嚳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321143435114532411121','雤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321143435114532511154444','鷽',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321143435114535251214444','鱟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32114343511453535112','觷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32114343511454334','燢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211434351145521','學',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32114343511455212154','斅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32114343511455213134','斆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321152','伟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3211531','佞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321154','伝',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321154','传',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212','什',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212','仃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121','丘',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121','仕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121','仜',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212111534','倀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121121','佳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121121121135','僥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121124','侍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321211251112543','儎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321211254444','傌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321211512543','傤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212121','佂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212121154444','傿',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121222511134','僨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121222534','偾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121251','佶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121251431251','僖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212125145154121','儓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121252','岳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121252212511134','儥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321213','乒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121315','侤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212132511','偖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121335','佬',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212134','兵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212134354','倰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321213521','侾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321214','乓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212143112','倖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321214544','俧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212151211251124','儔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212151335','屔',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212152','邱',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212154','佉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212155121','俹',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32121551214544','僫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212211','佄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122111','佴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212211134','倛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122111343534','僛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122111345','偡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212211152','倻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122122111','傇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122122151234','僷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212212511','借',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212212511121','僅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212212511134','傼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321221251113432411121','儺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212212512134','僙',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212213251','偌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321221325112','備',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212213251124544','憊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122134','供',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212215','伳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122151234','偞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212225134','偀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321222522145354','儚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122344335554444','儰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321223525112','僃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122352513134','儆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321224313','俨',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212251','估',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212251111','值',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321225111134','傎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212251115','値',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32122513134','做',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321234','休',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212341','体',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321234123411234','僸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321234123452134','儊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32123432511154444','鵂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212343434','倈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212343454','倯',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32123435451','鸺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212344444','烋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212344544','恷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32124','付',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321241344','俅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321244544','怤',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32124531','姇',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321245521','侼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251','伍',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251112','俥',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212511123134','僌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251112454','僆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212511214124','傳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125112144544','僡',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212511234','倲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251124','俌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251124124','傅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251134','便',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125115315','偃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212512','何',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125121','侢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251211251211','僵',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212512212511','傮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251245251251112213534','儾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251251','俉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125125121','偪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212512512515','傴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212512531425221','儖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125134','使',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321251431','侸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212515112','倳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321252','伂',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125221','価',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212522111234','僄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321252211234','傈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125221134515','僊',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321252212511134','價',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125221354152','僲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125221431234','僳',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32125221531','偠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3212523434','倆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321253434','俩',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321254','伎',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321254125441352211535','儷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321254254','俪',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321311534','侲',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321311534124','傉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213121','佐',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213211234543','傶',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213221545252','僀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321324','伓',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213241','伾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321324251','俖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213251','佑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213251','佦',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32132511','佰',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32132511','侑',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32132511454544354','優',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213252','佈',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32132521','侟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32132522','侕',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32132522111','偭',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32132522134','偄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321331234312342121','儮',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321332511234','傆',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32134','仗',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213411234','倷',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32134115','侉',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213412132','倴',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213412512','倚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213425115','俺',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213425243434343','儞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321343434','俠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32134354354','偧',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321344','伏',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321344325111','傄',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32134432511234','僚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3213443434343','傸',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321345','伛',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321354','伖',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321354','优',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32135422','例',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321355','伌',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3214312','伻',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321431234','俫',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32143134','侠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3214524444132522','儒',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3215','片',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321511','臼',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3215111213554','毀',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3215111213554','毁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321511132','舁',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321511154444','舃',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3215112134','倢',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('3215112512135','舅',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321511252','帠',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321511254','叟',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321511254454','遚',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32151125452','鄋',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('32151134','臾',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) VALUES ('321511344412','斞',500);
INSERT INTO StrokeOrder (Strokes,Character,Frequency) V