﻿#!/usr/bin/env python
#coding=utf-8

# Stroke Order Chinese Input Method 筆劃輸入法
# Author: Amanda Lam
# E-mail: amanda.hoic@gmail.com

import osso
import sqlite3
import sys
import gtk
import hildon
import os
import gettext
import i18n
import gobject
import string
import ctypes
import time
import pygobject
import sendSMS
import locale
from portrait import FremantleRotation

# By using apt-cache search, the following packages are required:
# python2.5-gtk2, python2.5-hildon, python-gobject

_ = i18n.language.gettext	# Internationization support

class StrokeOrder():
	strokesInputted = gtk.Label()	# Define label for displaying strokes
	strokesInputted.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#002090"))	# Modify label font color
	strokesCodeInputted = ""	# Define variable for stroke codes being inputted
	eb = gtk.EventBox()
	eb.add(strokesInputted)
	eb.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#AADDFF"))	# Modify label background color
	
	candidateChars = hildon.TouchSelector(text = True)	# Define TouchSelector control for displaying candidate characters
	
	pannableArea = hildon.PannableArea()
	pannableArea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
	
	textArea = hildon.TextView()	# Define the text area for input
	textArea.set_placeholder(_("StrokeOrder_textAreaPlaceHolder"))	# Set the info text for display when text area is empty
	textArea.set_wrap_mode(gtk.WRAP_CHAR)		
	textArea.set_cursor_visible(True)
	
	charLeft = gtk.Label()	# Define label for displaying number of characters left and number of messages being sent
	charLeft.set_text("70(1)")
	textAreaBuffer = textArea.get_buffer()	
	sendTo = hildon.TextView()	# Define the text field for phone number(s)
	sendToBuffer = sendTo.get_buffer()
	sendTo.set_placeholder(_("StrokeOrder_sendToPlaceHolder"))	# Set the info text for display when phone number text field is empty
	textboxInFocus = "textArea"	# Set input focus to the text area initially

	con=sqlite3.connect("/opt/StrokeOrder/IM.db")	# Connect to stroke lookup database
	con.text_factory=str
	cur = con.cursor()			
	
	osso_ctx = osso.Context("test_abook", "0.one")	# Define variable for Address Book
	capi = pygobject.PyGObjectCPAI()

	def __init__(self):	
		self.main()

	def getCurrentLocale(self):
		# Return the current system locale
		lc, encoding = locale.getdefaultlocale()
		CurrentLocale = lc
		return CurrentLocale
		
	def queryString(self, stroke):
		# Takes in the inputted stroke sequence and display the candidate characters for selection
		if stroke!="":
			if (len(self.strokesCodeInputted)<=4 and "6" not in self.strokesCodeInputted and "7" not in self.strokesCodeInputted) or ("%" in self.strokesCodeInputted):	# For <=4 strokes, since there would be a huge amount of characters having strokes beginning with the same stroke sequence, limit the number of candidate characters to 50 for the sake of performance
				self.cur.execute("SELECT DISTINCT Character FROM StrokeOrder WHERE Strokes LIKE '" + stroke + "%' ORDER BY Frequency DESC, Strokes ASC, Character ASC LIMIT 50")
			else:
				self.cur.execute("SELECT DISTINCT Character FROM StrokeOrder WHERE Strokes LIKE '" + stroke + "%' ORDER BY Frequency DESC, Strokes ASC, Character ASC")	# For >4 strokes, display all candidate characters
			self.con.commit()
		
		tm = gtk.ListStore(gobject.TYPE_STRING)
		self.candidateChars.set_model(0,tm)	# Clear the TouchSelector

		if stroke!="":
			for row in self.cur.fetchall():
					self.candidateChars.append_text(row[0])	# Generate candidate character selection list
	
	def queryAssoc(self, charKey):		
		# Takes in a Chinese character and display its associated phrases for selection
		if charKey!="":
			if self.getCurrentLocale() == "zh_HK" or self.getCurrentLocale() == "zh_Yue" or self.getCurrentLocale() == "zh_TW":	# Display Traditional Chinese associated phrases first if system locale is Chinese (Hong Kong), Cantonese or Chinese (Taiwan)
				self.cur.execute("SELECT DISTINCT Phrase FROM Assoc WHERE CharKey='" + charKey + "' ORDER BY TradSim DESC, Phrase ASC")		
			else: # Display Simplifeid Chinese associated phrases first if system locale is Chinese (PRC), Chinese, or English
				self.cur.execute("SELECT DISTINCT Phrase FROM Assoc WHERE CharKey='" + charKey + "' ORDER BY TradSim ASC, Phrase ASC")					
			self.con.commit()
		
		tm = gtk.ListStore(gobject.TYPE_STRING)
		self.candidateChars.set_model(0,tm)	# Clear the TouchSelector
		
		if charKey!="":
			for row in self.cur.fetchall():		
				self.candidateChars.append_text(row[0])	# Generate associated phrases selection list
		
	def main(self):	
		program = hildon.Program.get_instance()
		window = hildon.StackableWindow()
		# scrolledWindow = gtk.ScrolledWindow(hadjustment=None, vadjustment=None)
		# scrolledWindow.show()
		# scrolledWindow.set_policy('automatic','automatic')
		
		main_window = window
		app_name = _("StrokeOrder_AppName")
		app_version = "1.0"	
		# Support Portrait Mode, adopting gPodder's code
		initial_mode = FremantleRotation.AUTOMATIC
		rotation_object = FremantleRotation(app_name, main_window, app_version, initial_mode) 
	 
		program.add_window(window)		
		self.candidateChars.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
		
		# Creating user interface
		
		buttonHBox1 = gtk.HBox(False, 0)
		buttonHBox2 = gtk.HBox(False, 0)
		EngSymButtonVBox = gtk.VBox(False, 0)
		candidateCharsAndtextAreaHBox = gtk.HBox(False, 0)
		strokesInputtedAndEngSymButtonHBox = gtk.HBox(False, 0)	
		sendToAndSelectContactButtonHBox = gtk.HBox(False, 0)	
		self.textAreaButtonsVBox = gtk.VBox(False, 0)	
		 
		vbox = gtk.VBox(False, 0)
		
		OneButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		OneButton.set_label("一")   
		OneButton.connect("clicked", self.StrokeClicked, 1)   

		TwoButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		TwoButton.set_label("丨")   
		TwoButton.connect("clicked", self.StrokeClicked, 2)   

		ThreeButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		ThreeButton.set_label("丿")   
		ThreeButton.connect("clicked", self.StrokeClicked, 3)

		FourButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		FourButton.set_label("丶")   
		FourButton.connect("clicked", self.StrokeClicked, 4)

		FiveButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		FiveButton.set_label("乛")   
		FiveButton.connect("clicked", self.StrokeClicked, 5)

		EngButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		EngButton.set_label(_("StrokeOrder_EngMode"))   
		EngButton.connect("clicked", self.StrokeClicked, 6)

		SymButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		SymButton.set_label(_("StrokeOrder_SymMode"))   
		SymButton.connect("clicked", self.StrokeClicked, 7)
		
		WildcardButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		WildcardButton.set_label("？")   
		WildcardButton.connect("clicked", self.StrokeClicked, 8)		

		CopyButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		CopyButton.set_label(_("StrokeOrder_Copy"))   
		CopyButton.connect("clicked", self.CopyClicked, window)

		DelButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		DelButton.set_label("←")   
		DelButton.connect("clicked", self.DelClicked, window)

		ClearButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		ClearButton.set_label(_("StrokeOrder_Clear"))   
		ClearButton.connect("clicked", self.ClearClicked)
		
		sendSMSButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		sendSMSButton.set_label(_("StrokeOrder_Send"))
		sendSMSButton.connect("clicked", self.sendSMSPreCheck, window)
		
		selectContactButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		selectContactButton.set_label(_("StrokeOrder_SelectContact"))
		selectContactButton.connect("clicked", self.selectContactClicked)
		
		self.sendTo.connect("grab-focus", self.setCurrentTextboxInFocus, "sendTo")
		
		buttonHBox1.pack_start(OneButton, True, True, 0)
		buttonHBox1.pack_start(TwoButton, True, True, 0)
		buttonHBox1.pack_start(ThreeButton, True, True, 0)
		buttonHBox1.set_size_request(800,75)
		buttonHBox2.pack_start(FourButton, True, True, 0)
		buttonHBox2.pack_start(FiveButton, True, True, 0)
		buttonHBox2.pack_start(WildcardButton, True, True, 0)
		
		buttonHBox2.set_size_request(800,75)

		strokesInputtedAndEngSymButtonHBox.pack_start(EngButton, False, True, 0)		
		strokesInputtedAndEngSymButtonHBox.pack_start(self.eb, True, True, 0)
		strokesInputtedAndEngSymButtonHBox.pack_start(SymButton, False, True, 0)		
		
		self.textArea.connect("grab-focus", self.setCurrentTextboxInFocus, "textArea")
		self.textAreaBuffer.connect("changed", self.refreshCharLeft)
		
		self.pannableArea.add_with_viewport(self.textArea)
		self.candidateChars.set_size_request(150,200) 
		candidateCharsAndtextAreaHBox.pack_start(self.candidateChars, False, True, 0)
		candidateCharsAndtextAreaHBox.pack_start(self.pannableArea, True, True, 0)

		self.textAreaButtonsVBox.pack_start(self.charLeft, False, False, 0)
		self.textAreaButtonsVBox.pack_start(DelButton, True, True, 0)	
		self.textAreaButtonsVBox.pack_start(ClearButton, True, True, 0)	
		self.textAreaButtonsVBox.pack_start(CopyButton, True, True, 0)	
		self.textAreaButtonsVBox.set_size_request(120,200)
		candidateCharsAndtextAreaHBox.pack_start(self.textAreaButtonsVBox, False, False, 0)	
		
		sendToAndSelectContactButtonHBox.pack_start(self.sendTo, True, True, 0)		
		sendToAndSelectContactButtonHBox.pack_start(sendSMSButton, False, False, 0)		
		sendToAndSelectContactButtonHBox.pack_start(selectContactButton, False, False ,0)
		
		self.candidateChars.connect("changed", self.CharSelected)
		
		vbox.pack_start(buttonHBox1, False, True ,0)
		vbox.pack_start(buttonHBox2, False, True ,0)
		vbox.pack_start(strokesInputtedAndEngSymButtonHBox, False, False ,0)
		vbox.pack_start(sendToAndSelectContactButtonHBox, False, False, 0)		
		vbox.pack_start(candidateCharsAndtextAreaHBox, True, True, 0)
		
		window.set_title(_("StrokeOrder_AppName")) 
		window.connect("delete_event",self.app_preclose)
		menu = self.create_menu(window) 
		window.set_app_menu(menu)	
		window.add(vbox)	
		window.show_all() 	
		self.textArea.grab_focus()
		gtk.main()	
		
	def aboutProduct(self, AboutProductButton, window):
		# Show the About this Product dialog box
		
		text = _("StrokeOrder_AboutProductText")
		dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window,text) 
		response = dialog.run()
		dialog.destroy()

	def create_menu(self, window):
		# Create the application menu
		
		menu = hildon.AppMenu()   
		
		AboutButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		AboutButton.set_label(_("StrokeOrder_AboutProduct"))   
		AboutButton.connect("clicked", self.aboutProduct, window)    

		menu.append(AboutButton)   
		menu.show_all()
		return menu

		
	def ConvertCodeToChar(self, strokes):
		# Convert stroke input code into actual strokes for display
		s = strokes
		s = s.replace("1","一")
		s = s.replace("2","丨")
		s = s.replace("3","丿")
		s = s.replace("4","丶")
		s = s.replace("5","乛")
		s = s.replace("6",_("StrokeOrder_EngModeFull"))
		s = s.replace("7",_("StrokeOrder_SymModeFull"))
		s = s.replace("%","？")

		return s

	def setCurrentTextboxInFocus(self, widget, textbox):
		# Set the input focus to the given text field
		self.textboxInFocus = textbox
		
	def StrokeClicked(self, StrokeButton, stroke):
		# Triggered once a stroke (1 to 5, and ? ) button is pressed.
		# Build up the stroke sequence string and submit it to queryString() to lookup the candidate characters
		
		if stroke==6 or stroke==7:	# Do not build up stroke sequence if English or Symbol button is pressed
			self.strokesCodeInputted = str(stroke)				
		elif "6" in self.strokesCodeInputted or "7" in self.strokesCodeInputted:
			self.strokesCodeInputted = str(stroke)
		elif stroke==8:
			self.strokesCodeInputted = self.strokesCodeInputted + "%"
		else:
			self.strokesCodeInputted = self.strokesCodeInputted + str(stroke)
		self.strokesInputted.set_text( self.ConvertCodeToChar(self.strokesCodeInputted) )	# Display the inputted strokes
		
		self.queryString(self.strokesCodeInputted)
		
	def CharSelected(self, Selector, column):
		# Triggered once a candidate / English / Numeric / Symbol character is selected from the TouchSelector control.
		# Send the selected text to the text area.
		
		text = Selector.get_current_text()
		if self.textboxInFocus == "textArea":	# If text area is having input focus, insert text to the current cursor position
			buffer = self.textArea.get_buffer()
			buffer.set_text(buffer.get_text(buffer.get_start_iter(), buffer.get_iter_at_mark(buffer.get_insert()), False) + text + buffer.get_text(buffer.get_iter_at_mark(buffer.get_insert()), buffer.get_end_iter(), False))			
			self.textArea.set_buffer(buffer)	
		elif self.textboxInFocus == "sendTo":	# If phone number field is having input focus, insert text to the current cursor position
			buffer = self.sendTo.get_buffer() 
			buffer.set_text(buffer.get_text(buffer.get_start_iter(), buffer.get_iter_at_mark(buffer.get_insert()), False) + text + buffer.get_text(buffer.get_iter_at_mark(buffer.get_insert()), buffer.get_end_iter(), False))
			self.sendTo.set_buffer(buffer)							
		
		self.strokesInputted.set_text("")	# Clear the stroke display area once the text is inserted
		if not "6" in self.strokesCodeInputted and not "7" in self.strokesCodeInputted:	# If any of the stroke 1-5 is pressed, once text is inserted into the text area, clear the stroke sequence variable and associated phrases
			self.strokesCodeInputted = ""
			self.queryString("")			
			self.queryAssoc(text)

	def CopyClicked(self, CopyButton, window):
		# Copy the text area content to the clipboard
		clipboard = gtk.Clipboard()
		buffer = self.textArea.get_buffer()
		selectedText = buffer.get_selection_bounds()
		if selectedText==():	# If some text is selected, copy the selected text to clipboard only
			textToBeCopied = buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter(), False)
		else:	# If no text is selected, copy all the contents in the text area
			textToBeCopied = buffer.get_text(selectedText[0], selectedText[1], False)
		clipboard.set_text(textToBeCopied)
		clipboard.store()
		dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, "「" + textToBeCopied + "」 " + _("StrokeOrder_HasBeenCopied")) 
		response = dialog.run()
		dialog.destroy()	

	def DelClicked(self, LeftButton, window):		
		if self.textboxInFocus == "sendTo":		# Set buffer according to current input focus
			buffer = self.sendTo.get_buffer()
		elif self.textboxInFocus == "textArea":
			buffer = self.textArea.get_buffer()
			
		if len(self.strokesCodeInputted) > 0:	# If strokes sequence is not blank, delete stroke from the sequence first
			self.strokesCodeInputted = self.strokesCodeInputted[0:len(self.strokesCodeInputted)-1]
			self.queryString(self.strokesCodeInputted)			
			self.strokesInputted.set_text( self.ConvertCodeToChar(self.strokesCodeInputted) )
		else:						
			selectedText = buffer.get_selection_bounds()
			if selectedText==():	# If there is no selected text, issue a Backspace keystroke
				offset = buffer.get_iter_at_mark(buffer.get_insert())
				buffer.backspace(offset,True,True)
			else:	# If there is selected text, delete the selected text
				buffer.delete_selection(True,True)

	def refreshCharLeft(self, widget):
		# Recalculates the number of characters left in the current message, and the number of messages to be sent out
		msg = unicode(self.textAreaBuffer.get_text(self.textAreaBuffer.get_start_iter(), self.textAreaBuffer.get_end_iter(), False),"utf-8")
		charactersLeft = ( 70 * ( len(msg) / 70 + 1 ) ) - len(msg)
		msgCount = len(msg) / 70 + 1
		self.charLeft.set_text( str( charactersLeft ) + "(" + str(msgCount) + ")" )
							
	def ClearClicked(self, widget): 
		# Reset everything back to the very beginning
		text = ""
		buffer = self.textArea.get_buffer()
		buffer.set_text(text)
		self.textArea.set_buffer(buffer)
		
		self.strokesCodeInputted = ""
		self.strokesInputted.set_text("")
		
		buffer = self.sendTo.get_buffer()
		buffer.set_text("")
		
		self.queryString("")
				
	def selectContactClicked(self, widget):
		# Pops up the Address Book, select a contact and phone number will be inserted to the phone number text field
		start, end = self.sendToBuffer.get_bounds()
		oldbuffer = self.sendToBuffer.get_text(start, end)
		osso_abook = ctypes.CDLL('libosso-abook-1.0.so.0')
		argv_type = ctypes.c_char_p * len(sys.argv)
		argv = argv_type(*sys.argv)
		argc = ctypes.c_int(len(sys.argv))
		osso_abook.osso_abook_init(ctypes.byref(argc), ctypes.byref(argv),
								   hash(self.osso_ctx))
		c_chooser = osso_abook.osso_abook_contact_chooser_new(None, _("StrokeOrder_SelectContact"))
		chooser = self.capi.pygobject_new(c_chooser)
		hildon.hildon_gtk_window_set_portrait_flags(chooser, hildon.PORTRAIT_MODE_SUPPORT)

		chooser.run()
		chooser.hide()

		contacts = osso_abook.osso_abook_contact_chooser_get_selection(c_chooser)
		glib = ctypes.CDLL('libglib-2.0.so.0')

		def glist(addr):
			class _GList(ctypes.Structure):
				_fields_ = [('data', ctypes.c_void_p),
							('next', ctypes.c_void_p)]
			l = addr
			while l:
				l = _GList.from_address(l)
				yield l.data
				l = l.next

		for i in glist(contacts):
			c_selector = osso_abook.osso_abook_contact_detail_selector_new_for_contact(c_chooser, i, 2) 	

			selector = self.capi.pygobject_new(c_selector)
			hildon.hildon_gtk_window_set_portrait_flags(selector, hildon.PORTRAIT_MODE_SUPPORT)
			selector.run()
			selector.hide()

			c_field = osso_abook.osso_abook_contact_detail_selector_get_selected_field(c_selector)
			get_display_value = osso_abook.osso_abook_contact_field_get_display_value
			get_display_value.restype = ctypes.c_char_p
			finalval = osso_abook.osso_abook_contact_field_get_display_value(c_field)
	#            print oldbuffer
			if oldbuffer == "":
				self.sendToBuffer.set_text(finalval)
			else:
				newbuffer = oldbuffer +";" + finalval
				self.sendToBuffer.set_text(newbuffer)

	def sendSMSPreCheck(self, widget, window):
		# Before sending out SMS, detect long message and break it down into multiple ones.
		start, end = self.textAreaBuffer.get_bounds()
		text = unicode(self.textAreaBuffer.get_text(start,end), "utf-8")
		msglength = len(text)
		for i in range(1, msglength/70+2 ):
			textToBeSent = text[(i*70-70):(i*70)]
			self.sendSMS(widget, window, textToBeSent )
			print "Loop: " + str(i)
			print "Message length: " + str(msglength)
			print "Total no. of messages to be sent: " + str(msglength/70+1)
			print "Text to be sent:\n" + textToBeSent
		os.system("sudo pkill -f rtcom-messaging-ui")
			

	def sendSMS(self, widget, window, text):
		# Send SMS to the specified recipient(s)
		
		start2, end2 = self.sendToBuffer.get_bounds()
		fullnumber = self.sendToBuffer.get_text(start2,end2)
		number = fullnumber.replace("+","").replace(" ","") 		
		if number == "":	# If phone number is not specified...
			  note2 = _("StrokeOrder_Error_NoContact")
			  banner = hildon.hildon_banner_show_information(window,"" , note2)
			  print "error, no number specified!"
		elif text == "":	# If text area is blank...
			  note3 = _("StrokeOrder_Error_BlankMessage")
			  banner = hildon.hildon_banner_show_information(window,"" , note3)
			  print "error, message is empty!"
		else:	# If message is valid....
			confirm = hildon.hildon_note_new_confirmation(window, _("StrokeOrder_Confirm_SendMessage") + "「" + text + "」？")
			response = gtk.Dialog.run(confirm)
			gtk.Dialog.hide(confirm)
			print "response was: " +str(response)

			if response == gtk.RESPONSE_DELETE_EVENT:
				print "sending cancelled"
			elif response == gtk.RESPONSE_OK:
				
				if number.isdigit():                
					note = _("StrokeOrder_SendingSMSTo") + number
					banner = hildon.hildon_banner_show_information(window,"" , note)
					sendSMScmd = "python /opt/StrokeOrder/sendSMS.py " + str(number) + " \"" + text.replace("\"","”").replace("'","’").replace("\\","＼").replace("`","‘") + "\""
					print sendSMScmd
					os.system(sendSMScmd)
				else:	# If there are more than one recipients, loop through the recipient list and send the message to all of them.
					numb = number.split(";")
					i=0
					while i < len(numb):
						note = _("StrokeOrder_SendingSMSTo") + numb[i]
						banner = hildon.hildon_banner_show_information(window,"" , note)
						sendSMScmd = "python /opt/StrokeOrder/sendSMS.py " + str(numb[i]).replace("+","").replace(" ","") + " \"" + text.replace("\"","”").replace("'","’").replace("\\","＼").replace("`","‘") + "\""
						print sendSMScmd
						os.system(sendSMScmd)						
						i = i+1
						time.sleep(5)
	
	def app_preclose(self, widnow, widget):
		# Close database connection before closing the application.
		self.con.close()
		gtk.main_quit(None)
if __name__ == "__main__":
	StrokeOrder()