/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#include "sortfilter.h"

//-----------------------------------------------------------------------------
/**
** Constructor
**
** \param pParent The parent for the widget.
*/
CSortFilter::CSortFilter(QWidget* pParent) : QSortFilterProxyModel(pParent)
{
}

//-----------------------------------------------------------------------------
/**
** Destructor
*/
CSortFilter::~CSortFilter()
{
}

///////////////////////////////////////////////////////////////////////////////
/// OVERRIDES
///////////////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
** Returns true if the item in the row indicated by the given source_row  and
** source_parent should be included in the model; otherwise returns false.
**
** \param source_row The filtered row.
** \param source_parent The row's parent
** \return true if the row is accepted.
*/
bool CSortFilter::filterAcceptsRow(int source_row, const QModelIndex& source_parent) const
{
    if (source_parent.isValid() && !source_parent.parent().isValid())
    {
        return QSortFilterProxyModel::filterAcceptsRow(source_row, source_parent);
    }
    return true;
}

// EOF
