/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef VOLUMEVIEW_H
#define VOLUMEVIEW_H

#include <QtGui>
#include "mainwindow.h"

class CVolumeView : public QWidget
{
    Q_OBJECT

public:
    CVolumeView(QWidget* pParent);
    ~CVolumeView();

    void setColors(QColor back, QColor front, QColor textLight, QColor textDark);
    void setVolume(Volume* pVolume);

    static QString formatSize(quint64 size);

signals:
    void clicked(QString strPath);

protected:
    virtual void paintEvent(QPaintEvent* pEvent);
    virtual void mousePressEvent(QMouseEvent* pEvent);
    virtual void mouseReleaseEvent(QMouseEvent* pEvent);

private:
    QColor m_ColorBack;       ///< The color of unused space
    QColor m_ColorFront;      ///< The color of used space
    QColor m_ColorTextLight;  ///< The color of light text
    QColor m_ColorTextDark;   ///< The color of dark text
    QBrush m_Background;      ///< The background brush
    int m_Angle;              ///< The angle for the usage pie
    Volume* m_pVolume;        ///< The volume information
    bool m_bMouseDown;        ///< True when mouse is clicked down
};

#endif // VOLUMEVIEW_H
