/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>

enum Colors
{
    Color_Red,
    Color_Green,
    Color_Blue,
    Color_Magenta,
    Color_Yellow,
    Color_Cyan,
    Color_White
};

struct Volume
{
    quint64 total;
    quint64 free;
    QString name;
    QString path;
    Colors color;
};

class CMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    CMainWindow(QWidget* pParent = 0);
    ~CMainWindow();

    void initialize();

    static QStringList& getMountPoints() { return c_MountPoints; }
    static QColor getColor(Colors color);
    static Colors getColorForPath(QString strPath);

public slots:
    void onAbout();
    void onScanFolder();
    void onScanApps();
    void onScanVolume(QString strPath);

private:
    static void readVolumes();

    static QList<Volume*> c_Volumes;            ///< The list of all volumes
    static QMap<QString, QString> c_Binds;      ///< The mount binds
    static QStringList c_MountPoints;           ///< The list of all mount paths
};

#endif // MAINWINDOW_H
