/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#include "delegate.h"
#include "scanwindow.h"
#include "volumeview.h"
#include "mainwindow.h"

//-----------------------------------------------------------------------------
/**
** Constructor
**
** \param pParent The parent for the widget.
*/
CDelegate::CDelegate(QWidget* pParent) : QItemDelegate(pParent)
{
}

//-----------------------------------------------------------------------------
/**
** Destructor
*/
CDelegate::~CDelegate()
{
}

///////////////////////////////////////////////////////////////////////////////
/// OVERRIDES
///////////////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
** Paint handler. Draws the usage grid to the window.
**
** \param pPainter The painter.
** \param option The paint options.
** \param index The index of the painted item.
*/
void CDelegate::paint(QPainter* pPainter, const QStyleOptionViewItem& option, const QModelIndex& index) const
{
    QString strText = index.data(Qt::DisplayRole).toString();
    qint64 sizeParent = index.parent().data(MaxSizeRole).toLongLong();
    qint64 sizeTotal = index.data(SizeRole).toLongLong();

    if (option.state & QStyle::State_Selected)
    {
        pPainter->fillRect(option.rect, option.palette.highlight());
    }
    else
    {
        if (index.parent().isValid())
        {
            // Draw the bar
            if (sizeParent > 0)
            {
                QRectF r = option.rect;
                QVariant vntSizes = index.data(SizeMapRole);
                if (vntSizes.canConvert<ColorMap>())
                {
                    ColorMap mapSizes = vntSizes.value<ColorMap>();
                    ColorMap::iterator iter = mapSizes.begin();
                    for ( ; iter != mapSizes.end(); iter++)
                    {
                        qint64 size = iter.value();

                        //qDebug() << iter.key() << size << sizeParent << index.data(Qt::DisplayRole).toString();

                        r.setWidth(option.rect.width() * size / sizeParent);
                        pPainter->fillRect(r, QBrush(CMainWindow::getColor(iter.key())));
                        r.adjust(r.width(), 0, r.width(), 0);
                    }
                }
                else
                {
                    // This is a file so it doesn't contain the size map
                    Colors color = CMainWindow::getColorForPath(index.data(PathRole).toString());

                    r.setWidth(option.rect.width() * sizeTotal / sizeParent);
                    pPainter->fillRect(r, QBrush(CMainWindow::getColor(color)));
                }
            }
        }
    }

    // Draw the size to right edge
    QString strSize = CVolumeView::formatSize(sizeTotal);
    QFontMetrics metrics(option.font);
    QSize s = metrics.size(Qt::TextSingleLine, strSize);
    pPainter->drawText(option.rect, Qt::TextSingleLine | Qt::AlignRight, strSize);

    // Cut the text if it doesn't fit otherwise
    strText = metrics.elidedText(strText, Qt::ElideMiddle, option.rect.width() - s.width());

    // Bold the selected index or the root if nothing is selected
    if (index == m_SelectedIndex || (!m_SelectedIndex.isValid() && !index.parent().isValid()))
    {
        QFont fontBold = option.font;
        fontBold.setBold(true);
        pPainter->setFont(fontBold);
        pPainter->drawText(option.rect, Qt::TextSingleLine, strText);
        pPainter->setFont(option.font);
    }
    else
    {
        pPainter->drawText(option.rect, Qt::TextSingleLine, strText);
    }
}

// EOF
