/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef SCANWINDOW_H
#define SCANWINDOW_H

#include <QtGui>
#include "usagegrid.h"
#include "scanthread.h"
#include "delegate.h"
#include "mainwindow.h"

#define TYPE_FILE   1
#define TYPE_FOLDER 2

#define SizeRole    Qt::UserRole
#define AreaRole    Qt::UserRole + 1
#define TypeRole    Qt::UserRole + 2
#define PathRole    Qt::UserRole + 3
#define SizeMapRole Qt::UserRole + 4
#define MaxSizeRole Qt::UserRole + 5

typedef QMap<Colors, qint64> ColorMap;
Q_DECLARE_METATYPE(ColorMap);

class CScanWindow : public QMainWindow
{
    Q_OBJECT

public:
    CScanWindow(QWidget* pParent = 0);
    ~CScanWindow();

    void initialize(QString strFolder, bool bScanApps);
    void startScan();

public slots:
    void onRescan();
    void onFolderFound(QString strFolder);
    void onFolderScanned();
    void onFileFound(QString strFilename, QString strFilePath, qint64 size);
    void onItemSelectionChanged(const QModelIndex& current, const QModelIndex& previous);
    void onItemDoubleClicked(const QModelIndex& index);
    void onProgressMaximum(int maxValue);
    void onProgressValue(QString strText, int value);

private:
    QString m_strFolder;             ///< The folder to be scanned
    QTreeView* m_pTreeWidget;        ///< Contains the directory tree
    CDelegate* m_pDelegate;          ///< The delegate for the tree view which draws the content
    QStandardItemModel* m_pModel;    ///< The model for the data
    QSortFilterProxyModel* m_pSortModel;  ///< The sort proxy model
    CUsageGrid* m_pUsageGrid;        ///< Displays the disk usage grid
    CScanThread* m_pScanThread;      ///< The thread which reads the folder contents
    QStandardItem* m_pCurrentItem;   ///< The tree item currently scanned
    QStandardItem* m_pSelectedItem;  ///< The tree item currently shown in the usage grid
    QLabel* m_pPathLabel;            ///< Widget to show the full path
    QProgressBar* m_pProgress;       ///< Widget for the progress indicator
    QPushButton* m_pCancelButton;    ///< The cancel button for the progress
    bool m_bScanApps;                ///< This is true when scanning the applications
};

#endif // SCANWINDOW_H
