/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef SCANTHREAD_H
#define SCANTHREAD_H

#include <QtGui>
#include "usagegrid.h"

class CScanThread : public QThread
{
    Q_OBJECT

public:
    CScanThread(QWidget* pParent, QString strFolder);
    ~CScanThread();

    bool isCancelled();

public slots:
    void cancel();

protected:
    virtual void run();

signals:
    void folderFound(QString strFolder);
    void folderScanned();
    void fileFound(QString strFilename, QString strFilePath, qint64 size);

    void progressMaximum(int maxValue);
    void progressValue(QString strText, int value);

private:
    void scanFolder(const QString& strFolder);
    void scanInstallations();
    void readPackageFiles(QString strPackage);

    QString m_strFolder;    ///< The folder to be scanned
    QMutex m_mutex;         ///< Mutex to protect the cancellation
    bool m_bCancelled;      ///< True if the operation has been cancelled
};

#endif // SCANTHREAD_H
