/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#include "delegate.h"
#include "mainwindow.h"

//-----------------------------------------------------------------------------
/**
** Constructor
**
** \param pParent The parent for the widget.
*/
CDelegate::CDelegate(QWidget* pParent) : QItemDelegate(pParent)
{
}

//-----------------------------------------------------------------------------
/**
** Destructor
*/
CDelegate::~CDelegate()
{
}

//-----------------------------------------------------------------------------
/**
**
**
** \param size
*/
QString CDelegate::formatSize(qint64 size) const
{
    if (size > 1000)
    {
        if (size > 1000000)
        {
            if (size > 1000000000)
            {
                return QString("%1 GB").arg(size / 1024.0 / 1024.0 / 1024.0, 0, 'f', 1);
            }
            return QString("%1 MB").arg(size / 1024.0 / 1024.0, 0, 'f', 1);
        }
        return QString("%1 KB").arg(size / 1024.0, 0, 'f', 1);
    }
    return QString("%1 B").arg(size);
}

///////////////////////////////////////////////////////////////////////////////
/// OVERRIDES
///////////////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
** Paint handler. Draws the usage grid to the window.
**
** \param pEvent The paint event.
*/
void CDelegate::paint(QPainter* pPainter, const QStyleOptionViewItem& option, const QModelIndex& index) const
{
    QString strText = index.data(Qt::DisplayRole).toString();
    qint64 sizeParent = index.parent().data(SizeRole).toLongLong();
    qint64 sizeTotal = index.data(SizeRole).toLongLong();

    if (option.state & QStyle::State_Selected)
    {
        pPainter->fillRect(option.rect, option.palette.highlight());
    }
    else
    {
        if (index.parent().isValid())
        {
            // Draw the bar
            if (sizeParent > 0)
            {
                qint64 sizeOpt = index.data(OptSizeRole).toLongLong();
                qint64 sizeOther = sizeTotal - sizeOpt;

                QRect r = option.rect;
                r.setWidth(option.rect.width() * sizeOpt / sizeParent);
                pPainter->fillRect(r, QBrush(QColor(0, 255, 0, 128)));

                r.setX(r.x() + sizeOpt);
                r.setWidth(option.rect.width() * sizeOther / sizeParent);
                pPainter->fillRect(r, QBrush(QColor(255, 0, 0, 128)));
            }
        }
    }

    // Draw the size to right edge
    QString strSize = formatSize(sizeTotal);
    QFontMetrics metrics(option.font);
    QSize s = metrics.size(Qt::TextSingleLine, strSize);
    pPainter->drawText(option.rect, Qt::TextSingleLine | Qt::AlignRight, strSize);

    // Cut the text if it doesn't fit otherwise
    strText = metrics.elidedText(strText, Qt::ElideMiddle, option.rect.width() - s.width());

    // Bold the selected index or the root if nothing is selected
    if (index == m_SelectedIndex || (!m_SelectedIndex.isValid() && !index.parent().isValid()))
    {
        QFont fontBold = option.font;
        fontBold.setBold(true);
        pPainter->setFont(fontBold);
        pPainter->drawText(option.rect, Qt::TextSingleLine, strText);
        pPainter->setFont(option.font);
    }
    else
    {
        pPainter->drawText(option.rect, Qt::TextSingleLine, strText);
    }
}

// EOF
