/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef USAGEGRID_H
#define USAGEGRID_H

#include <QtGui>

class CUsageGrid : public QWidget
{
    Q_OBJECT

public:
    CUsageGrid(QWidget* pParent, QTreeView* pTreeView);
    ~CUsageGrid();

    void clear();
    void initialize(QStandardItem* pRootItem, bool bRecursive);
    void setSelectionRect(QRect r) { m_rectSelection = r; update(); }
    QStandardItem* getRootItem() { return m_pRootItem; }

signals:
    void progressMaximum(int maxValue);
    void progressValue(QString strText, int value);

protected:
    virtual void paintEvent(QPaintEvent* pEvent);
    virtual void mousePressEvent(QMouseEvent* pEvent);

private:
    void createGrid(QStandardItem* pItem, bool bRecursive);
    void drawGrid(QPainter& painter, QStandardItem* pItem, const QRectF& rect, bool bRecursive);
    QStandardItem* pickItem(QStandardItem* pItem, QPoint pos);
    QColor getBaseColor(QString strText, bool bExtensionOnly);

    QTreeView* m_pTreeView;         ///< A pointer to the tree view
    QStandardItem* m_pRootItem;     ///< The currently shown root item
    QPixmap m_pxGrid;               ///< The grid image
    QRect m_rectSelection;          ///< The selected item's rect
    bool m_pRecursive;              ///< True when the leaf nodes are shown. False when just the root is shown.
};

#endif // USAGEGRID_H
