#!/usr/bin/python2.5
# -*- coding: utf-8 -*-

# 
# Copyright (c) 2007-2008 INdT.
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# ============================================================================
# Name        : stopwatch.py
# Author      : Giorgos Logiotatidis
# Version     : 0.1
# Description : Stopwatch and countdown timer from maemo 5
# ============================================================================


import gtk 
import gobject
import hildon
import sys
from time import strftime
from datetime import datetime

from portrait import FremantleRotation

class StopwatchApp(hildon.Program):
    def __init__(self):
        hildon.Program.__init__(self)
        
        self.running = False
        self.startTime = None
        self.stopTime = None
        
        self.stopButton = None
        self.startButton = None
        self.checkpointButton = None
        self.clearButton = None   
        self.cleared = True    
        self.savedTimings = []
      
        gtk.set_application_name("Stopwatch")

        self.rotation = FremantleRotation('Stopwatch', None, '0.1', 0)

        self.window = hildon.StackableWindow()
        self.window.connect("delete_event", self.quit)  
        self.window.get_screen().connect("size-changed", self.drawUI)

        self.add_window(self.window)
       
        # buttons        
        # stop button
        self.stopButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.stopButton.connect("clicked", self.menu_button_clicked, None)
        self.stopButton.set_label("Stop")
        image = gtk.image_new_from_stock(gtk.STOCK_NO, gtk.ICON_SIZE_BUTTON)
        self.stopButton.set_image(image)
        self.stopButton.set_image_position(gtk.POS_LEFT)    
        self.stopButton.set_sensitive(False)
            
        # start button
        self.startButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.startButton.connect("clicked", self.menu_button_clicked, None)        
        self.startButton.set_label("Go")
        image = gtk.image_new_from_stock(gtk.STOCK_YES, gtk.ICON_SIZE_BUTTON)
        self.startButton.set_image(image)
        self.startButton.set_image_position(gtk.POS_LEFT)
        self.startButton.set_sensitive(True)

        # checkList button
        self.checkpointButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.checkpointButton.connect("clicked", self.menu_button_clicked, None)        
        self.checkpointButton.set_label("Checkpoint")
        image = gtk.image_new_from_stock(gtk.STOCK_ADD, gtk.ICON_SIZE_BUTTON)
        self.checkpointButton.set_image(image)
        self.checkpointButton.set_image_position(gtk.POS_LEFT)
        self.checkpointButton.set_sensitive(False)

        # clear button
        self.clearButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.clearButton.connect("clicked", self.menu_button_clicked, None)        
        self.clearButton.set_label("Clear")
        image = gtk.image_new_from_stock(gtk.STOCK_CLEAR, gtk.ICON_SIZE_BUTTON)
        self.clearButton.set_image(image)
        self.clearButton.set_image_position(gtk.POS_LEFT)
        self.clearButton.set_sensitive(False)
        
        
        # create clickable label        
        self.timeLabel = gtk.Label()
        self.clear_time()
        
        self.eventBox = gtk.EventBox()
        self.eventBox.add(self.timeLabel)
        self.eventBox.connect("button-press-event", self.label_clicked, None)
        
        self.drawUI()
        menu = self.create_menu(None)
        self.window.set_app_menu(menu)
        
    def drawUI(self, screen=None):      
        # clear everything
        def clearGtkTree(item):
            if (type(item) is gtk.EventBox) or (type(item) is hildon.GtkButton):
                return
            try:
                for child in item.get_children():            
                    clearGtkTree(child)
                    item.remove(child)
            except AttributeError:
                return  
            
        clearGtkTree(self.window)
            
        if (self.rotation._orientation) == "portrait":
            # buttons vbox
            bvbox = gtk.VBox(True, 0)
            bvbox.add(self.startButton)
            bvbox.add(self.stopButton)
            bvbox.add(self.checkpointButton)
            bvbox.add(self.clearButton)
            
            vbox = gtk.VBox(False, 10)
            vbox.add(self.eventBox)
            vbox.add(bvbox)
            
            self.window.add(vbox)
            
        else:
            # buttons hbox
            bhbox = gtk.HBox(True, 0)
            
            bvbox = gtk.VBox(True, 0)
            bvbox.add(self.startButton)
            bvbox.add(self.checkpointButton)
            bhbox.add(bvbox)
            bvbox = gtk.VBox(True, 0)
            bvbox.add(self.stopButton)
            bvbox.add(self.clearButton)
            bhbox.add(bvbox)
            
            vbox = gtk.VBox(False, 10)
            vbox.add(self.eventBox)
            vbox.add(bhbox)
            
            self.window.add(vbox)
          
        self.update_time()  
        self.window.show_all()
         

    def update_time(self):                      
        if self.running:
            now = datetime.now()
        else:
            now = self.stopTime          
        
        try:
            timeString = str(now - self.startTime)
        except TypeError:
            timeString = "0:00:00.000000"
            
        fontSize = self.get_font_size()
        self.timeLabel.set_markup("<span font_size='%s' font_weight='bold'>%s</span><span font_size=\"%s\" color=\"grey\">%s</span>" % (fontSize[0], timeString[:-7], fontSize[1], timeString[-7:-4]))
        
        if self.running:
            gobject.timeout_add(50, self.update_time)

    def clear_time(self):
        fontSize = self.get_font_size()
        timeString = "0:00:00.000000"
        self.timeLabel.set_markup("<span font_size='%s' font_weight='bold'>%s</span><span font_size=\"%s\" color=\"grey\">%s</span>" % (fontSize[0], timeString[:-7], fontSize[1], timeString[-7:-4]))
        
        self.savedTimings = []
        self.cleared = True
        self.startTime = None
        self.stopTime = None
        
        self.checkpointButton.set_sensitive(False)
        self.clearButton.set_sensitive(False)

    def get_font_size(self):
        if self.rotation._orientation == "portrait":
            return (75000, 35000)
        else:
            return (125000, 50000)
        
              
    def set_checkpoint_button(self):
        self.checkpointButton.set_label("Checkpoint")
        image = gtk.image_new_from_stock(gtk.STOCK_ADD, gtk.ICON_SIZE_BUTTON)
        self.checkpointButton.set_image(image)
        self.checkpointButton.set_image_position(gtk.POS_LEFT)
        self.checkpointButton.set_sensitive(True)

    def set_checkpointlist_button(self):
        self.checkpointButton.set_label("Checkpoint List")
        image = gtk.image_new_from_stock(gtk.STOCK_INFO, gtk.ICON_SIZE_BUTTON)
        self.checkpointButton.set_image(image)
        self.checkpointButton.set_image_position(gtk.POS_LEFT)
        self.checkpointButton.set_sensitive(True)

    def quit(self, *args):
        print "Goodbye world!"
        gtk.main_quit()
        
    def run(self):     
        self.window.show_all()
        gtk.main() 

    def menu_button_clicked(self, button, lbale):        
        label = button.get_label()
        if label == "Go":
            if self.running == False:
                self.running = True
                if self.cleared == True:
                    self.startTime = datetime.now()   
                else:
                    self.startTime = datetime.now() - (self.stopTime - self.startTime)                                  
                
                self.update_time()                
                self.stopButton.set_sensitive(True)
                self.set_checkpoint_button()
                self.clearButton.set_sensitive(False)
                self.startButton.set_sensitive(False)
                self.cleared = False
                self.running = True
            elif self.running == True:
                self.clearButton.set_sensitive(False)
        
        elif label == "Stop":
                self.running = False  
                self.stopTime = datetime.now()
                self.update_time()
                self.clearButton.set_sensitive(True)
                self.startButton.set_sensitive(True)
                self.stopButton.set_sensitive(False)
                self.set_checkpointlist_button()

                
        elif label == "Clear":
            self.clear_time()
            
        elif label == "Checkpoint":
            self.checkpoint()
            
        elif label == "Checkpoint List":
            self.label_clicked()
        
            
        elif label == "Countdown":
            self.stopButton = hildon.TimeButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
            self.stopButton.set_text("Pick time", "")
   

    def checkpoint(self):
        now = datetime.now()
        self.savedTimings.append(now-self.startTime)            
        hildon.hildon_banner_show_information(self.window, "", "Saved time: %s" % str(now-self.startTime)[:-4])
        
    def label_clicked(self, a=None, b=None, c=None):     
        if self.running:    
            self.checkpoint()
        else:
            list = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
            
            counter = 1
            for i in self.savedTimings:
                niter = list.append()
                list.set(niter, 0, "# %d -" % counter, 1, str(i)[:-4])
                counter += 1
            
            win = hildon.StackableWindow()
            win.set_title("Saved Times")  
            vbox = gtk.VBox()
            parea = hildon.PannableArea()
            
            #Define the recipe list treeview with multiple selections, search, etc.
            self.checkpoint_tv = hildon.GtkTreeView(gtk.HILDON_UI_MODE_EDIT)
            selection = self.checkpoint_tv.get_selection()
            self.checkpoint_tv.set_model(list)
    
            parea.add(self.checkpoint_tv)
            # add columns to the tree view
            self.add_columns_to_checkpoint_list(self.checkpoint_tv)
            vbox.pack_start(parea, True, True, 0)
            win.add(vbox)          
            win.show_all()

    def add_columns_to_checkpoint_list(self, treeview):
        model = treeview.get_model()

        # column for ID
        column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=0)
        column.set_visible(True)
        treeview.append_column(column)

        # column for title
        renderer = gtk.CellRendererText()
        renderer.set_property('wrap-mode', gtk.WRAP_WORD)
        renderer.set_property('wrap-width', 780)
        column = gtk.TreeViewColumn('Recipe title', renderer, text=1)
        column.set_sort_column_id(1)
        column.set_property("expand", True)
        treeview.append_column(column)
        
               
    def create_menu(self,label):
        menu = hildon.AppMenu()
                
        button = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, None)
        button.set_label("Stopwatch")
        button.connect("clicked", self.menu_button_clicked, label)
        menu.append(button)
        button.set_mode(False)
        
        button = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, button)
        button.set_label("Countdown")
        button.connect("clicked", self.menu_button_clicked, label)
        menu.append(button)
        button.set_mode(False)
        
        # about button
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        button.set_label("About")
        button.connect("clicked", self.on_about_button_clicked)
        menu.append(button)

        menu.show_all()
        
        return menu
    
    def on_about_button_clicked(self, widget):
        about = gtk.AboutDialog()
        about.set_name("stopwatch")
        about.set_comments("A stopwatch and countdown timer")
        about.set_version("0.1")
        about.set_copyright("Giorgos Logiotatidis")
        about.set_website("https://launchpad.net/maemo-stopwatch")
        about.set_logo_icon_name("stopwatch")
        about.connect("response", lambda x, y: x.destroy())
        about.show()
        



if __name__ == "__main__":  
    app = StopwatchApp() 
    app.run()         
