/****************************************************************************
** EggTimer Widget version 0.2
** Author: Ilkka Salmine <ilkkas@gmail.com>, 2009
**
****************************************************************************/
#include "widget.h"
#include <QPushButton>
#include <QLabel>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPainter>
#include <QPaintEvent>
#include <QTimer>
#include <QSettings>

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>
#include <QtGui/QMessageBox>

#define TIME_FORMAT "h:mm:ss"
#define BIG_STEP_FORWARD     600
#define BIG_STEP_BACKWARDS   -60
#define SMALL_STEP_BACKWARDS -30

//#include <QDebug>

Widget::Widget()
    : QWidget(0, Qt::FramelessWindowHint), timerCookie(0), alarmSeconds(0), error(false)
{

     // Get required atoms
    Atom winTypeAtom = XInternAtom(QX11Info::display(), "_NET_WM_WINDOW_TYPE", false);
    Atom homeAppletAto = XInternAtom(QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", false);
    Atom appletIDAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", false);
    Atom utf8Atom = XInternAtom(QX11Info::display(), "UTF8_STRING", false);
    Atom appletSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", false);

    // Set correct window type
    XChangeProperty(QX11Info::display(), winId(), winTypeAtom, XA_ATOM, 32,
		    PropModeReplace, (unsigned char *) &homeAppletAto, 1);

    // Use application name to fill AppletID
    QByteArray id (QCoreApplication::instance()->applicationName().remove(' ').toUtf8());
    XChangeProperty(QX11Info::display(), winId(), appletIDAtom, utf8Atom, 8,
    	            PropModeReplace, (unsigned char *)id.constData(), id.length());

    // Add setting button. This button is shown when hildon-desktop is in edit mode.
    int settings = 0;
    XChangeProperty(QX11Info::display(), winId(), appletSettingAtom, XA_CARDINAL, 32,
		    PropModeReplace, (unsigned char*)&settings, 1);

     countdownTimer = new QTimer(this);
     connect(countdownTimer, SIGNAL(timeout()), this, SLOT(fireNextTimerEvent()));

    //make layout
    QVBoxLayout *layout= new QVBoxLayout(this);
    QHBoxLayout *timerArea = new QHBoxLayout;
    QHBoxLayout *buttonArea = new QHBoxLayout;

    QLabel *iconLabel = new QLabel(this);
    iconLabel->setPixmap(QPixmap(":images/icon.png"));
    timeLabel = new QLabel(tr("0:00"));
    QFont labelFont = font();
    labelFont.setPointSize(26);
    timeLabel->setFont(labelFont);
    timeLabel->setAlignment(Qt::AlignHCenter);
    QPalette p;
    p.setColor(QPalette::WindowText, Qt::white);
    timeLabel->setPalette(p);
    timerArea->addWidget(iconLabel);
    timerArea->addWidget(timeLabel);

    buttonControls = new QWidget(this);
    startButton = new QPushButton(tr("Start"), this);
    QPushButton *resetButton = new QPushButton(tr("Reset"), buttonControls);
    connect(resetButton, SIGNAL(clicked()), this, SLOT(resetClicked()));
    connect(startButton, SIGNAL(clicked()), this, SLOT(startClicked()));
    buttonArea->setSpacing(0);
    buttonArea->addWidget(startButton);
    buttonArea->addWidget(resetButton);
    buttonArea->setSizeConstraint(QLayout::SetFixedSize);
    buttonControls->setLayout(buttonArea);

    layout->addLayout(timerArea);
    layout->addWidget(buttonControls);
    setLayout(layout);
}

void Widget::resetClicked()
{
    reset();
    error = false;
}


void Widget::updateTimeLabel(int secsToAlarm)
{
    int hours;
    int minutes;
    int seconds = secsToAlarm;
    hours = seconds/3600;
    seconds -= hours*3600;
    minutes = seconds/60;
    seconds -= minutes*60;
    if(hours > 0)
        timeLabel->setText(QString("%1:%2.%3").arg(hours, 2, 10, QChar('0')).arg(minutes, 2, 10, QChar('0')).arg(seconds, 2, 10, QChar('0')));
    else
        timeLabel->setText(QString("%1:%2").arg(minutes, 2, 10, QChar('0')).arg(seconds, 2, 10, QChar('0')));
}

void Widget::startClicked()
{
            QDateTime now = QDateTime::currentDateTime();
            if(!countdownTimer->isActive())
            {
                alarmTime = now;
            	startButton->setText(tr("Stop"));
                countdownTimer->start(500);
            } else {
    		int secsTo = alarmTime.secsTo(now);
		alarmSeconds += secsTo;
            	startButton->setText(tr("Start"));
                countdownTimer->stop();
            } 
}


void Widget::fireNextTimerEvent()
{
    //countdownTimer->setSingleShot(true);
    QDateTime now = QDateTime::currentDateTime();
    //time_t arithmetic is undefined by ISO C but POSIX says its integer seconds, so maybe simple subtraction would suffice here
    int secsTo = alarmTime.secsTo(now);
    updateTimeLabel(secsTo + alarmSeconds);
}

void Widget::reset()
{
    countdownTimer->stop();
    timerCookie = 0;
    alarmSeconds = 0;
    alarmTime.setTime_t(0);
    updateTimeLabel(alarmSeconds);
    startButton->setText(tr("Start"));
    startButton->setEnabled(true);
}

void Widget::paintEvent(QPaintEvent *e)
{
  
    QPainter p(this);
    p.setRenderHint(QPainter::Antialiasing);
    p.setClipRect(e->rect());

    //make sure you clean your widget with a transparent
    //  color before doing any rendering
    //  note the usage of a composition mode Source
    //  it's important!
    p.save();
    p.setCompositionMode(QPainter::CompositionMode_Source);
    p.setOpacity(0.3);
    p.fillRect(rect(), Qt::lightGray);
    p.restore();

}

//Filter show setting requests
bool Widget::x11Event ( XEvent * event )
{
  static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), 
						  "_HILDON_APPLET_SHOW_SETTINGS", false);

  if (event->xclient.message_type == appletShowSettingAtom ) {
          QMessageBox::about(this, tr("About"),
            tr("Simple Timer Widget\nv0.1\nAuthor: Ilkka Salminen <ilkkas@gmail.com>\nApplication icon: http://phoenity.com/icons/aura"));

      return true;
  }
  return false;
}

void Widget::resizeEvent(QResizeEvent *e)
{

}

