//      stopish.h
//
//      Copyright 2010 Michael Cronenworth <mike@cchtml.com>
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.


#ifndef __STOPISH_H__
#define __STOPISH_H__

#include <libosso.h>

#define STOPISH_VERSION_NUM 0.9.3
#define STOPISH_VERSION_STR "0.9.3"

#define STOPISH_MODE_START  0
#define STOPISH_MODE_PAUSE  1
#define STOPISH_MODE_RESUME 2

#define STOPISH_TYPE_STOPWATCH 0
#define STOPISH_TYPE_COUNTDOWN 1

#define STOPISH_PORTRAIT  0
#define STOPISH_LANDSCAPE 1

#define TIMER_PRECISION_HOUR   0
#define TIMER_PRECISION_MINUTE 1

// stopish.c
gint dbus_callback( const gchar *interface, const gchar *method,
	                GArray *arguments, gpointer data, osso_rpc_t *retval );
void stopish_about_cb( GtkButton* button, gpointer data );
int stopish_get_mode( void );
int stopish_get_type( void );
int stopish_get_orientation( void );
void stopish_set_mode( int newMode );
void stopish_set_type( int newType );
gboolean stopish_focus_in_cb( GtkWidget *widget, GdkEventFocus *event,
                               gpointer data );
gboolean stopish_focus_out_cb( GtkWidget *widget, GdkEventFocus *event,
                               gpointer data );

// stopish-countdown.c
void stopish_countdown_new( void );
void stopish_countdown_label_timer_landscape( void );
void stopish_countdown_label_timer_portrait( void );

// stopish-stopwatch.c
GtkWindow *stopish_stopwatch_new( void );
void stopish_stopwatch_reset( void );
void stopish_stopwatch_perf_timer_hour( GtkRadioButton* radio, GtkLabel *label );
void stopish_stopwatch_perf_timer_minute( GtkRadioButton* radio, GtkLabel *label );
void stopish_stopwatch_label_timer_landscape( void );
void stopish_stopwatch_label_timer_portrait( void );

// timer.c
char *stopish_get_time_string( void );
long int stopish_get_time_timer( void );
void stopish_set_time_start( long int time );
void stopish_timer_resume( void );
void stopish_timer_save( void );
long int stopish_current_time( void );
void stopish_timer_set_precision( int setting );
int stopish_timer_get_precision( void );

#endif
