#!/usr/bin/env python2.5
# -*- coding: UTF8 -*-
# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# StocksPy: Application to get stocks data from Yahoo Finance.
# Version 0.1
#

import urllib2
import gtk, gobject
import os
import hildon

#import osso
#osso_c = osso.Context("net.yerga.stockthis", "0.3", False)

import marketdata
import settings


#detect if is ran locally or not
import sys
runningpath = sys.path[0]

if '/usr/share' in runningpath:
    runninglocally = False
else:
    runninglocally = True

HOME = os.path.expanduser("~")

settingsdb, imgdir, configdir, logfile = \
    settings.define_paths(runninglocally, HOME)


fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL
ui_normal = gtk.HILDON_UI_MODE_NORMAL
ui_edit = gtk.HILDON_UI_MODE_EDIT
winprogind = hildon.hildon_gtk_window_set_progress_indicator

gtk.gdk.threads_init()

class StocksPy:

    def __init__(self):
        self.program = hildon.Program()
        self.program.__init__()
        gtk.set_application_name("StockThis")
        self.window = hildon.StackableWindow()
        self.window.set_default_size(800, 480)
        self.program.add_window(self.window)
        self.window.connect("destroy", gtk.main_quit)

        menu = hildon.AppMenu()
        self.window.set_app_menu(menu)
        button = gtk.Button("About")
        button.connect("clicked", self.on_about)
        menu.append(button)
        menu.show_all()

        vbox = gtk.VBox()
        toolbar = self.main_toolbar(False, False)

        parea = hildon.PannableArea()
        tv = hildon.GtkTreeView(ui_normal)
        inmodel = self.__create_model(marketdata.main, marketdata.idmain)
        tv.connect("row-activated", self.show_instrument_view, inmodel,
                    marketdata.localmarkets, marketdata.localids,
                    marketdata.idmain)
        tv.set_model(inmodel)
        self._tv_columns(tv)
        parea.add(tv)

        vbox.pack_start(parea, True, True, 0)
        vbox.pack_start(gtk.HSeparator(), False, False, 5)
        vbox.pack_start(toolbar, False, False, 0)

        self.window.add(vbox)
        self.window.show_all()

    def show_instrument_view(self, widget, path, column, inmodel, names,
        ids, mindex):
        market = inmodel[path][0]
        names = names[mindex.index(market)]
        ids = ids[mindex.index(market)]

        window = hildon.StackableWindow()
        window.set_title("StockThis - " + inmodel[path][1])

        vbox = gtk.VBox()
        toolbar = self.main_toolbar(False, False)

        parea = hildon.PannableArea()
        tv = hildon.GtkTreeView(ui_normal)
        model = self.__create_model(names, ids)
        tv.connect("row-activated", self.show_quotes_view, model, False)
        tv.set_model(model)
        self._tv_columns(tv)
        parea.add(tv)

        vbox.pack_start(parea, True, True, 0)
        vbox.pack_start(gtk.HSeparator(), False, False, 5)
        vbox.pack_start(toolbar, False, False, 0)

        window.add(vbox)
        window.show_all()


    def show_quotes_view(self, widget, path, column, model, portfolio):
        quote = model[path][0], model[path][1]
        print "quote:", quote[0]
        #('EURUSD=X', 'EUR/USD')

        #Currencies and ETFs should show the list now -> view = True
        #Other items show a new list with options
        view = False
        for i in marketdata.localids[(len(marketdata.localids)-2):]:
            for j in i:
                if quote[0] == j:
                    print j
                    view = True

        if not view:
            if quote[0] in marketdata.idindexes:
                self.show_instrument_view(widget, path, column, model,
                                        marketdata.wnamesindexes,
                                        marketdata.widsindexes,
                                        marketdata.idindexes)
                return
            if quote[0] in marketdata.idotmarkets:
                self.show_instrument_view(widget, path, column, model,
                                        marketdata.omnames,
                                        marketdata.omsymbols,
                                        marketdata.idotmarkets)
                return
            if quote[0] in marketdata.ideumarkets:
                self.show_instrument_view(widget, path, column, model,
                                        marketdata.eunames,
                                        marketdata.eusymbols,
                                        marketdata.ideumarkets)
                return
            if quote[0] in marketdata.idusmarkets:
                self.show_instrument_view(widget, path, column, model,
                                        marketdata.usnames,
                                        marketdata.ussymbols,
                                        marketdata.idusmarkets)
                return


        self.stocks_id = quote[0]
        self.stocks_name = quote[1]

        if portfolio:
            self.portfolio_win = hildon.StackableWindow()
            self.portfolio_win.set_title("StockThis - Quotes View - "
                            + self.stocks_name)
        else:
            self.quotes_win = hildon.StackableWindow()
            self.quotes_win.set_title("StockThis - Quotes View - "
                            + self.stocks_name)


        vbox = gtk.VBox()
        toolbar = self.main_toolbar(True, portfolio)


        self.titlelbl = gtk.Label('')
        self.titlelbl.set_markup('<b><big>' + quote[1].replace('&', '') +
                                 '</big></b>')
        color = gtk.gdk.color_parse("#03A5FF")
        self.titlelbl.modify_fg(gtk.STATE_NORMAL, color)

        parea = hildon.PannableArea()

        vbox1 = gtk.VBox()

        hbox = gtk.HBox()
        label = gtk.Label('')
        label.set_markup('<b><big>Price:</big></b>')
        self.lprice = gtk.Label('')
        hbox.pack_start(label, False, False, 20)
        hbox.pack_start(self.lprice, False, False, 245)
        vbox1.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        label = gtk.Label('')
        label.set_markup('<b><big>Change:</big></b>')
        self.lchange = gtk.Label('')
        self.lpercent = gtk.Label('')
        hbox.pack_start(label, False, False, 20)
        hbox.pack_start(self.lchange, False, False, 205)
        hbox.pack_start(self.lpercent, False, False, 0)
        vbox1.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        label = gtk.Label('')
        label.set_markup('<b><big>Volume:</big></b>')
        self.lvolume = gtk.Label('')
        hbox.pack_start(label, False, False, 20)
        hbox.pack_start(self.lvolume, False, False, 207)
        vbox1.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        label = gtk.Label('')
        label.set_markup('<b><big>52 week high:</big></b>')
        self.l52whigh = gtk.Label('')
        hbox.pack_start(label, False, False, 20)
        hbox.pack_start(self.l52whigh, False, False, 110)
        vbox1.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        label = gtk.Label('')
        label.set_markup('<b><big>52 week low:</big></b>')
        self.l52wlow = gtk.Label('')
        hbox.pack_start(label, False, False, 20)
        hbox.pack_start(self.l52wlow, False, False, 125)
        vbox1.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        button1 = hildon.PickerButton(fhsize, horbtn)
        data = ["50", "100", "200", "300", "400", "500", "600", "700", "800",
                "900", "1000"]
        selector = self.create_selector(data, True)
        button1.set_selector(selector)
        button1.set_title("Shares")
        #FIXME: Improve as it's shown you have a component in your portfolio
        shares = self.get_shares_from_symbol()
        button1.set_value(shares)
        hbox.pack_start(button1, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Add to Portfolio")
        button.connect("clicked", self.add_to_portfolio, button1)
        hbox.pack_start(button, True, True, 0)

        hbox1 = gtk.HBox()
        label = gtk.Label('')
        label.set_markup('<b><big>Shares:</big></b>')
        self.shares = gtk.Label(shares)
        hbox1.pack_start(label, False, False, 20)
        hbox1.pack_start(self.shares, False, False, 215)

        hbox2 = gtk.HBox()
        label = gtk.Label('')
        label.set_markup('<b><big>Holdings Value:</big></b>')
        self.holdingsvalue = gtk.Label("")
        hbox2.pack_start(label, False, False, 20)
        hbox2.pack_start(self.holdingsvalue, False, False, 85)

        hbox3 = gtk.HBox()
        label = gtk.Label('')
        label.set_markup("<b><big>Day's Value Change:</big></b>")
        self.dayvaluechange = gtk.Label("")
        hbox3.pack_start(label, False, False, 20)
        hbox3.pack_start(self.dayvaluechange, False, False, 10)

        if not portfolio:
            vbox1.pack_start(hbox, False, False, 0)
        else:
            vbox1.pack_start(hbox1, True, True, 0)
            vbox1.pack_start(hbox2, True, True, 0)
            vbox1.pack_start(hbox3, True, True, 0)

        parea.add_with_viewport(vbox1)

        vbox.pack_start(self.titlelbl, False, False, 0)
        vbox.pack_start(gtk.HSeparator(), False, False, 0)
        vbox.pack_start(parea, True, True, 0)
        vbox.pack_start(gtk.HSeparator(), False, False, 5)
        vbox.pack_start(toolbar, False, False, 0)

        if portfolio:
            self.portfolio_win.add(vbox)
            self.portfolio_win.show_all()
            self.show_data(quote[0], self.portfolio_win, shares)
        else:
            self.quotes_win.add(vbox)
            self.quotes_win.show_all()
            self.show_data(quote[0], self.quotes_win, shares)

    def get_shares_from_symbol(self):
        portfolio_data = settings.load_portfolio(settingsdb)
        shares = "0"
        for item in portfolio_data :
            if self.stocks_id in item:
                shares = item[2]
        return shares

    def add_to_portfolio(self, widget, button):
        shares = button.get_value()
        self.stocks_id
        self.stocks_name

        portfolio = settings.load_portfolio(settingsdb)
        index = "None"
        for item in portfolio:
            if self.stocks_id in item:
                index = portfolio.index(item)

        item = [self.stocks_id, self.stocks_name, shares, '-']

        if index is "None":
            settings.insert_new_item_to_portfolio(settingsdb, item)
        else:
            settings.delete_item_from_portfolio(settingsdb, self.stocks_id)
            settings.insert_new_item_to_portfolio(settingsdb, item)

        self.show_info_banner(widget, "Added to portfolio")


    def create_selector(self, data, entry):
        if entry:
            selector = hildon.TouchSelectorEntry(text=True)
        else:
            selector = hildon.hildon_touch_selector_new_text()
        for i in range(len(data)):
            selector.append_text(data[i])

        return selector

    def show_data(self, quote, win, shares):
        import thread
        winprogind(win, 1)
        thread.start_new_thread(self.get_data, (quote, win, shares))

    def get_data(self, quote, win, shares):
        from ystockquote import ystockquote as yt
        try:
            data = yt.get_all(quote)
        except:
            print 'Failed to get internet data'
            data = {'price': 'N/A', 'change': 'N/A', 'volume':'N/A',
                    '52_week_high': 'N/A', '52_week_low': 'N/A'}
            self.titlelbl.set_markup('<b><big>Failed to get data</big></b>')

        try:
            ch_percent = \
                    100.0 * float(data['change'])/(float(data['price']) - \
                    float(data['change']))
        except ValueError:
            ch_percent = 0.0

        self.lprice.set_label(data['price'])
        self.lchange.set_label(data['change'])
        self.lpercent.set_label('%6.2f %%' % ch_percent)

        if '-' in data['change']:
            color = gtk.gdk.color_parse("#FF0000")
        else:
            color = gtk.gdk.color_parse("#16EB78")

        self.lpercent.modify_fg(gtk.STATE_NORMAL, color)
        self.lchange.modify_fg(gtk.STATE_NORMAL, color)

        self.lvolume.set_label(data['volume'])
        self.l52whigh.set_label(data['52_week_high'])
        self.l52wlow.set_label(data['52_week_low'])

        try:
            daychange = float(shares)*float(data['change'])
        except ValueError:
            daychange = 'N/A'
        try:
            holdvalue = float(shares)*float(data['price'])
        except ValueError:
            holdvalue = 'N/A'

        self.dayvaluechange.set_label(str(daychange))
        self.holdingsvalue.set_label(str(holdvalue))

        winprogind(win, 0)

    def refresh_stock_data(self, widget, portfolio):
        if portfolio:
            shares = self.get_shares_from_symbol()
            win = self.portfolio_win
        else:
            shares = "0"
            win = self.quotes_win

        self.show_data(self.stocks_id, self.quotes_win, shares)

    def show_graph_view(self, widget):
        win = hildon.StackableWindow()
        win.set_title("StockThis - Graph View - " + self.stocks_name)

        vbox = gtk.VBox()
        toolbar = self.main_toolbar(False, True)

        self.graphs_title = gtk.Label(self.stocks_name)
        color = gtk.gdk.color_parse("#03A5FF")
        self.graphs_title.modify_fg(gtk.STATE_NORMAL, color)

        parea = hildon.PannableArea()

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('1d')
        button.connect("clicked", self.show_graph, '1d', win)
        hbox.pack_start(button)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('5d')
        button.connect("clicked", self.show_graph, '5d', win)
        hbox.pack_start(button)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('3m')
        button.connect("clicked", self.show_graph, '3m', win)
        hbox.pack_start(button)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('6m')
        button.connect("clicked", self.show_graph, '6m', win)
        hbox.pack_start(button)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('1y')
        button.connect("clicked", self.show_graph, '1y', win)
        hbox.pack_start(button)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('2y')
        button.connect("clicked", self.show_graph, '2y', win)
        hbox.pack_start(button)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('5y')
        button.connect("clicked", self.show_graph, '5y', win)
        hbox.pack_start(button)

        button = hildon.Button(fhsize, horbtn)
        button.set_label('Max')
        button.connect("clicked", self.show_graph, 'max', win)
        hbox.pack_start(button)

        vbox1 = gtk.VBox()
        vbox1.pack_start(hbox, False, False, 0)

        self.graph = gtk.Image()
        vbox1.pack_start(self.graph, True, True, 0)

        parea.add_with_viewport(vbox1)

        vbox.pack_start(self.graphs_title, False, False, 0)
        vbox.pack_start(gtk.HSeparator(), False, False, 0)
        vbox.pack_start(parea, True, True, 0)
        vbox.pack_start(gtk.HSeparator(), False, False, 5)
        vbox.pack_start(toolbar, False, False, 0)

        win.add(vbox)
        win.show_all()

        self.show_graph(None, '1d', win)

    def show_graph(self, widget, option, win):
        import thread
        winprogind(win, 1)
        thread.start_new_thread(self.get_graph_data, (option, win))

    def get_graph_data(self, option, win):
        kind = self.stocks_id
        if option == '1d':
            url = 'http://uk.ichart.yahoo.com/b?s=%s' % kind
        elif option == '5d':
            url = 'http://uk.ichart.yahoo.com/w?s=%s' % kind
        elif option == '3m':
            url = 'http://chart.finance.yahoo.com/c/3m/s/%s' % kind.lower()
        elif option == '6m':
            url = 'http://chart.finance.yahoo.com/c/6m/s/%s' % kind.lower()
        elif option == '1y':
            url = 'http://chart.finance.yahoo.com/c/1y/s/%s' % kind.lower()
        elif option == '2y':
            url = 'http://chart.finance.yahoo.com/c/2y/s/%s' % kind.lower()
        elif option == '5y':
            url = 'http://chart.finance.yahoo.com/c/5y/s/%s' % kind.lower()
        elif option == 'max':
            url = 'http://chart.finance.yahoo.com/c/my/s/%s' % kind.lower()

        try:
            myimg = urllib2.urlopen(url)
            imgdata = myimg.read()

            pbl = gtk.gdk.PixbufLoader()
            pbl.write(imgdata)

            pbuf = pbl.get_pixbuf()
            pbl.close()
            self.graph.set_from_pixbuf(pbuf)
            winprogind(win, 0)
        except:
            winprogind(win, 0)
            self.graphs_title.set_label('Failed to get data')
            self.graph.destroy()

    def _tv_columns(self, treeview):
        column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=1)
        treeview.append_column(column)

    def __create_model(self, names, ids):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
        for item in range(len(names)):
            iter = lstore.append()
            lstore.set(iter, 0, ids[item], 1, names[item])
        return lstore

    def main_toolbar(self, quotesview, portfolio):
        toolbar = gtk.HBox()
        toolbar.set_homogeneous(True)

        portfolio_btn = hildon.Button(fhsize, horbtn)
        portfolio_btn.set_title("Portfolio")
        portfolio_btn.connect("clicked", self.show_portfolio_view)

        graph_btn = hildon.Button(fhsize, horbtn)
        graph_btn.set_title("Graph")
        graph_btn.connect("clicked", self.show_graph_view)

        refresh_btn = hildon.Button(fhsize, horbtn)
        refresh_btn.set_title("Refresh")
        refresh_btn.connect("clicked", self.refresh_stock_data, portfolio)

        if not portfolio:
            toolbar.pack_start(portfolio_btn)
        if quotesview:
            toolbar.pack_start(graph_btn)
            toolbar.pack_start(refresh_btn)

        toolbar.show_all()

        return toolbar

    def show_portfolio_view(self, widget):
        data = settings.load_portfolio(settingsdb)

        win = hildon.StackableWindow()
        win.set_title("StockThis - Portfolio")

        vbox = gtk.VBox()

        parea = hildon.PannableArea()
        tv = hildon.GtkTreeView(ui_normal)
        tv.set_headers_visible(True)
        self.portfolio_model = self._create_portfolio_model(data)
        tv.connect("row-activated", self.show_quotes_view, self.portfolio_model, True)
        tv.set_model(self.portfolio_model)
        self._tv_portfolio_columns(tv)
        parea.add(tv)

        hbox = gtk.HBox()
        button = hildon.Button(fhsize, horbtn)
        button.set_title("Refresh All")
        button.connect("clicked", self.refresh_portfolio, tv, win)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Remove")
        button.connect("clicked", self.remove_item)
        hbox.pack_start(button, True, True, 0)

        vbox.pack_start(parea, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)
        win.add(vbox)
        win.show_all()

    def remove_item(self, widget):
        win = hildon.StackableWindow()
        win.fullscreen()
        toolbar = hildon.EditToolbar("Choose items to delete", "Delete")
        win.set_edit_toolbar(toolbar)

        vbox = gtk.VBox()
        parea = hildon.PannableArea()
        tv = hildon.GtkTreeView(ui_edit)
        selection = tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)
        tv.set_model(self.portfolio_model)
        self._tv_remove_portfolio_columns(tv)
        parea.add(tv)

        toolbar.connect("button-clicked", self.delete_from_portfolio, win, tv,
                        selection)
        toolbar.connect_object("arrow-clicked", gtk.Window.destroy, win)

        vbox.pack_start(parea, True, True, 0)
        win.add(vbox)
        win.show_all()

    def delete_from_portfolio(self, widget, win, tv, selection):
        if not self.is_treeview_selected(tv):
            return

        conf = self.show_confirmation(win, "Delete items?")

        if conf:
            selmodel, selected = selection.get_selected_rows()
            iters = [selmodel.get_iter(path) for path in selected]
            for i in iters:
                symbol = selmodel.get_value(i, 0)
                settings.delete_item_from_portfolio(settingsdb, symbol)
                selmodel.remove(i)

    def _tv_remove_portfolio_columns(self, treeview):
        column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=1)
        column.set_property("expand", True)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Shares', gtk.CellRendererText(), text=2)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Price', gtk.CellRendererText(), text=3)
        column.set_visible(False)
        treeview.append_column(column)

    def refresh_portfolio(self, widget, tv, win):
        data = settings.load_portfolio(settingsdb)
        import thread
        winprogind(win, 1)
        thread.start_new_thread(self._do_refresh_portfolio, (data, tv, win))

    def _do_refresh_portfolio(self, data, tv, win):
        for item in data:
            item[3] = self.get_price(item[0])

        self.portfolio_model = self._create_portfolio_model(data)
        tv.set_model(self.portfolio_model)
        winprogind(win, 0)

    def get_price(self, symbol):
        from ystockquote import ystockquote as yt
        price = yt.get_price(symbol)

        return price

    def _create_portfolio_model(self, data):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING,
                                gobject.TYPE_STRING, gobject.TYPE_STRING)
        for item in data:
            iter = lstore.append()
            lstore.set(iter, 0, item[0], 1, item[1], 2, item[2], 3, item[3])
        return lstore

    def _tv_portfolio_columns(self, treeview):
        column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=1)
        column.set_property("expand", True)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Shares', gtk.CellRendererText(), text=2)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Price', gtk.CellRendererText(), text=3)
        treeview.append_column(column)

    def show_confirmation(self, window, msg):
        dialog = hildon.hildon_note_new_confirmation(window, msg)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_OK:
            dialog.destroy()
            return True

        dialog.destroy()
        return False

    def show_info_banner(self, widget, msg):
        hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

    def is_treeview_selected(self, treeview):
        selection = treeview.get_selection()
        if selection.count_selected_rows() == 0:
            self.show_info_banner(treeview, 'No selected item')
            return False
        else:
            return True

    def on_about(self, widget):
        dialog = gtk.AboutDialog()
        dialog.set_name("StockThis")
        dialog.set_version("0.3")
        dialog.set_copyright("Copyright © 2009")
        dialog.set_website("http://stockthis.garage.maemo.org")
        dialog.set_authors(["Daniel Martin Yerga <dyerga@gmail.com>"])
        logo = gtk.gdk.pixbuf_new_from_file(imgdir + "stockthis.png")
        dialog.set_logo(logo)
        dialog.set_license("This program is released under the GNU\nGeneral Public License. Please visit \nhttp://www.gnu.org/copyleft/gpl.html\nfor details.")
        dialog.set_artists(["Logo by Daniel Martin Yerga"])
        dialog.run()
        dialog.destroy()

if __name__ == "__main__":
    stockspy = StocksPy()
    gtk.gdk.threads_enter()
    gtk.main()
    gtk.gdk.threads_leave()
