#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

# files to install
inst_desktop = ['stockthis.desktop']
inst_py = ['stockthis.py', 'marketdata.py']
pixmaps = ['pixmaps/loading.gif', 'pixmaps/stockthis.png']
#inst_dbus = ['stockthis.service']
inst_icon = ['stockthis.png']
inst_icon_sca = ['pixmaps/stockthis.png']

data_files = [
  ('share/applications/hildon', inst_desktop),
  ('share/stockthis',   inst_py),
  ('share/stockthis/pixmaps',   pixmaps),
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca),
#  ('share/dbus-1/services',   inst_dbus),
]

setup(
  name         = 'stockthis',
  version      = '0.2',
  description  = 'Stocks application',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'https://garage.maemo.org/projects/stockthis',
  data_files   = data_files
)
