import QtQuick 1.0

Rectangle {
    id: container
    x: 2
    width: parent.width - 2*x
    height: pfoMode ? 250 : 400
    focus: true
    radius: 5
    border.color: "#3577B9" //"orange"
    border.width: 2
    //color: "#F1F1F1"

    property int listFontSize: 28
    property int fontSize1: listFontSize - 2
    property color textInputBg: "#E2EFFC" //"#C2DEFA"
    property color breakBg: "#D5D5D5"
    property bool pfoMode: false
    property int refHeight: parent.height

    property alias myPfoName: pfoNameIn.text
    property alias myPfoDesc: pfoDescIn.text

    property alias myName: symbolIn.text
    property alias myExg: exchangeIn.text

    property alias myShare: shareIn.text
    property alias myCost: costIn.text
    property alias myStop: stopIn.text

    property bool myIsYahoo: false

    signal save
    signal cancel

    Grid {
        id: pfoGrid
        x: 20; y: 20;
        spacing: 20
        columns: 2
        width: parent.width
        visible: pfoMode

        Text {
            text: "Name"
            font.pixelSize: fontSize1
        }

        Rectangle {
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: pfoNameIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            text: "Description"
            font.pixelSize: fontSize1
        }

        Rectangle {
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: pfoDescIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            font.pixelSize: listFontSize
            text: "Yahoo quote"
        }

        Rectangle {
            x: 2
            width: fontSize1 + 4
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"
            smooth: true

            Rectangle {
                x: 4; y: 4;
                width: parent.height - 2*x
                height: parent.height - 2*y
                radius: 5
                smooth: true
                visible: container.myIsYahoo
                color: "#7DBFFF"
            }

            MouseArea {
                anchors.fill: parent
                onClicked: { container.myIsYahoo = !container.myIsYahoo; }
            }
        }

        TextButton {
            text: "Save"
            onClicked: { container.save(); }
        }

        TextButton {
            text: "Cancel"
            onClicked: { container.cancel(); }
        }
    }

    Grid {
        id: posGrid
        x: 20; y: 20;
        spacing: 20
        columns: 2
        width: parent.width
        visible: !pfoMode

        Text {
            id: symbol
            text: "Symbol"
            font.pixelSize: fontSize1
        }

        Rectangle {
            id: symbolInRect
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: symbolIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.capitalization: Font.AllUppercase
                font.pixelSize: fontSize1
            }
        }

        Text {
            id: exchange
            text: "Exchange"
            font.pixelSize: fontSize1
            color: (myIsYahoo) ? "#E8E8E8" : "black"
        }

        Rectangle {
            id: exchangeInRect
            width: parent.width/2
            height: fontSize1 + 4

            color: (myIsYahoo) ? "#F7F5F5" : textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: exchangeIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.capitalization: Font.AllUppercase
                font.pixelSize: fontSize1
                readOnly: myIsYahoo
            }
        }

        Text {
            id: share
            text: "Share"
            font.pixelSize: fontSize1
        }

        Rectangle {
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: shareIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            id: cost
            text: "Cost"
            font.pixelSize: fontSize1
        }

        Rectangle {
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: costIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            id: stop
            text: "Stop"
            font.pixelSize: fontSize1
        }

        Rectangle {
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: stopIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            id: pfoView
            font.pixelSize: listFontSize
            color: "#E8E8E8"
            text: "Yahoo quote"
        }
        Rectangle {
            id: yahooBG
            x: 2
            width: fontSize1 + 4
            height: fontSize1 + 4

            color: "#F7F5F5"
            radius: 5
            border.width: 1
            border.color: "#aaa"
            smooth: true

            Rectangle {
                id: yahooSelBG
                x: 4; y: 4;
                width: parent.height - 2*x
                height: parent.height - 2*y
                radius: 5
                smooth: true
                visible: container.myIsYahoo
                color: "#DADADA"
            }

            //MouseArea {
            //    id: yahooMouseArea
            //    anchors.fill: parent
            //    onClicked: { container.myIsYahoo = !container.myIsYahoo; }
            //}
        }

        TextButton {
            id: saveButton
            text: "Save"
            onClicked: { container.save(); }
        }

        TextButton {
            id: cancelButton
            text: "Cancel"
            onClicked: { container.cancel(); }
        }
    }

    states: [
        State {
            name: "hidden"
            PropertyChanges { target: container; y: refHeight }
        },
        State {
            name: "shown"
            PropertyChanges { target: container; y: refHeight - container.height }
        }
    ]

    transitions: Transition {
        SequentialAnimation {
            PropertyAnimation {
                target: container
                properties: "y"
                duration: 300
                easing.type: "OutQuad"
            }
        }
    }
}

