import QtQuick 1.0

Item {
    id: container
    width: parent.width
    height: parent.height

    property color bgColor: "white"
    property color barColor: "#68C8FF"
    property int duration : 300
    property real progress: 0

    Rectangle {
        id: border

        anchors.fill: parent
        color: bgColor
        border.color: barColor
        border.width: 4
        radius: 10

        // Bar
        Rectangle {
            id: filler
            //anchors.centerIn: parent
            anchors { left: parent.left; leftMargin: 10; verticalCenter: parent.verticalCenter }
            height: parent.height - 16
            width: (container.width - 20) * container.progress;

            color: barColor
            radius: border.radius;
        }
    }

    states: State {
        name: "hideContainer"
        when: (container.progress==1)

        PropertyChanges { target: container; opacity: 0 }
    }

    Behavior on opacity { NumberAnimation { duration: duration } }
}
