#include "filehandler.h"

FileHandler::FileHandler(QObject *parent) :
    QObject(parent)
{
    //cfgDir = "/home/user/.stockona/";
}

void FileHandler::debugPfo() {
    for (int i=0; i<pfoModel.pfoName.length(); i++) {
        qDebug() << i << "="
                 << pfoModel.pfoName[i].toString() << ":"
                 << pfoModel.pfoDesc[i].toString() << ":"
                 << pfoModel.pfoIsYahoo[i].toBool() ; //<< ":"
                 //<< pfoModel.pfoNum[i].toInt();
    }
}

// Overloaded function to eliminate appendPfo()
Q_INVOKABLE int FileHandler::storePfo(QString name, QString desc, bool isYahoo)
{
    qDebug() << "C_Info: storePfo() " << name << " " << desc << " " << isYahoo;
    pfoModel.pfoName.append(name);
    pfoModel.pfoDesc.append(desc);
    pfoModel.pfoIsYahoo.append(isYahoo);

    QFile f( "/home/user/.stockona/portfolio.cfg" );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        qDebug() << "Failed to open for write.";

        return -1;
    }

    QTextStream ts( &f );

    if (!pfoModel.pfoName.isEmpty()) {
        for (int i=0; i < pfoModel.pfoName.count(); i++) {
            ts << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool() << endl;
            qDebug() << "C_Info: " << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool();
        }
    }

    f.close();

    return 0;
}

Q_INVOKABLE int FileHandler::storePfoAll()
{
    qDebug() << "C_Info: storePfoAll()";

    QFile f( "/home/user/.stockona/portfolio.cfg" );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        qDebug() << "Failed to open for write.";

        return -1;
    }

    QTextStream ts( &f );

    if (!pfoModel.pfoName.isEmpty()) {
        for (int i=0; i < pfoModel.pfoName.count(); i++) {
            ts << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool() << endl;
            qDebug() << "C_Info: " << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool();
        }
    }

    f.close();

    return 0;
}

Q_INVOKABLE int FileHandler::loadPfo()
{
    QDir dir("/home/user/.stockona/");
    if (!dir.exists()) {
        dir.mkpath("/home/user/.stockona/");
    }

    qDebug() << "C_Info: loadPfo --->";

    QFile f( "/home/user/.stockona/portfolio.cfg" );

    pfoModel.pfoName.clear();
    pfoModel.pfoDesc.clear();
    pfoModel.pfoIsYahoo.clear();

    if( !f.exists() )
    {
        qDebug() << "C_Info: Local portfolio does not exist.";

        return -1;
    }

    if( !f.open( QIODevice::ReadOnly ) )
    {
        qDebug() << "C_Info: Failed to open for read.";

        return -1;
    }

    QTextStream ts( &f );

    QStringList strList;
    //QStringList::const_iterator constIterator;

    while ( !ts.atEnd() ) {
        strList = ts.readLine().split(":");

        if (strList.length()==3) {
            //for (constIterator = strList.constBegin(); constIterator != strList.constEnd(); ++constIterator) {
            //qDebug() << (*constIterator).toLocal8Bit().constData();
            //if (constIterator==strList.constBegin())
            //    pfoName.append( (*constIterator).toLocal8Bit().constData() );
            //else
            //    pfoNum.append( (*constIterator).toLocal8Bit().constData() );
            for (int i=0; i<strList.length(); i++) {
                //qDebug() << "C_Info: " << strList[i].toLocal8Bit().constData();
                if (i==0)
                    pfoModel.pfoName.append( strList[i].toLocal8Bit().constData() );
                else if (i==1)
                    pfoModel.pfoDesc.append( strList[i].toLocal8Bit().constData() );
                else
                    pfoModel.pfoIsYahoo.append( strList[i].toLocal8Bit().constData() );
            }
        }
        else {
            // Fix format
            //f.remove();
            qDebug() << "C_Info: Error in loading local portfolio.";

            return -1;
        }
    }

    f.close();

    for (int i=0; i<pfoModel.pfoName.length(); i++) {
        loadPosNum(i);
    }

    debugPfo();

    return 0;
}

Q_INVOKABLE void FileHandler::setPfo(int idx, QString name, QString desc, bool isYahoo) {
    qDebug() << "C_Info: Append: " << name << " " << desc << " " << isYahoo << "to" << idx;
    pfoModel.pfoName.replace(idx, name);
    pfoModel.pfoDesc.replace(idx, desc);
    pfoModel.pfoIsYahoo.replace(idx, isYahoo);
}

Q_INVOKABLE void FileHandler::removePfo(int idx) {
    qDebug() << "C_Info: Remove portfolio entry " << idx;
    pfoModel.pfoName.removeAt(idx);
    pfoModel.pfoDesc.removeAt(idx);
    pfoModel.pfoIsYahoo.removeAt(idx);
    pfoModel.pfoNum.removeAt(idx);
}

void FileHandler::updatePfoNum(int idx, int num) {
    if (idx < pfoModel.pfoNum.length())
        pfoModel.pfoNum[idx] = num;
    else
        pfoModel.pfoNum.append(num);
}

Q_INVOKABLE int FileHandler::deletePfo()
{
    QFile f( "portfolio.cfg" );

    if( !f.exists() )
    {
        qDebug() << "Local portfolio does not exist.";

        return -1;
    }

    f.remove();
    qDebug() << "Delete local portfolio.";

    f.close();

    return 0;
}

/*
  Position
*/

int FileHandler::loadPosNum(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");

    //qDebug() << "C_Info: loadPos ---> " << filename;

    QFile f( filename );

    if( !f.exists() )
    {
        qDebug() << "C_Info: Position " << filename << " does not exist.";
        updatePfoNum(idx, 0);
        return -1;
    }

    if( !f.open( QIODevice::ReadOnly ) )
    {
        qDebug() << "C_Info: Failed to open position " << filename << " for read.";
        updatePfoNum(idx, 0);
        return -1;
    }

    QTextStream ts( &f );

    QStringList strList;

    int lineCount = 0;

    while ( !ts.atEnd() ) {
        strList = ts.readLine().split(":");
        lineCount++;
    }

    f.close();

    updatePfoNum(idx, lineCount);

    return 0;
}

Q_INVOKABLE int FileHandler::loadPos(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");

    qDebug() << "C_Info: loadPos ---> " << filename;

    QFile f( filename );

    posSymbol.clear();
    posExg.clear();
    posShare.clear();
    posCost.clear();
    posStop.clear();

    if( !f.exists() )
    {
        qDebug() << "C_Info: Position " << filename << " does not exist.";
        // Set pfo's num to 0
        updatePfoNum(idx, 0);

        return -1;
    }

    if( !f.open( QIODevice::ReadOnly ) )
    {
        qDebug() << "C_Info: Failed to open position " << filename << " for read.";
        // Set pfo's num to 0
        updatePfoNum(idx, 0);

        return -1;
    }

    QTextStream ts( &f );

    QStringList strList;

    while ( !ts.atEnd() ) {
        strList = ts.readLine().split(":");

        if (strList.length()==6) {
            for (int i=0; i<strList.length(); i++) {
                //qDebug() << "C_Info: " << strList[i].toLocal8Bit().constData();
                if (i==0)
                    posSymbol.append( strList[i].toLocal8Bit().constData() );
                else if (i==1)
                    posExg.append( strList[i].toLocal8Bit().constData() );
                else if (i==2)
                    posShare.append( strList[i].toLocal8Bit().constData() );
                else if (i==3)
                    posCost.append( strList[i].toLocal8Bit().constData() );
                else if (i==4)
                    posStop.append( strList[i].toLocal8Bit().constData() );
            }
        }
        else {
            // Fix format
            //f.remove();
            qDebug() << "C_Info: Error in loading local position.";

            return -1;
        }
    }

    debugPos();

    f.close();

    updatePfoNum(idx, posSymbol.length());

    return 0;
}

// Overloaded storePos
Q_INVOKABLE int FileHandler::storePos(int idx, QString symbol, QString exchange, int share, int cost, int stop)
{
    qDebug() << "C_Info: storePos() " << symbol << " " << exchange << " " << share << " " << cost << " " << stop;

    posSymbol.append(symbol);
    posExg.append(exchange);
    posShare.append(share);
    posCost.append(cost);
    posStop.append(stop);

    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");
    qDebug() << "C_Info: storePos() into " << filename;

    QFile f( filename );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        qDebug() << "Failed to open " << filename << " for write.";

        return -1;
    }

    QTextStream ts( &f );

    if (!posSymbol.isEmpty()) {
        for (int i=0; i < posSymbol.count(); i++) {
            ts << posSymbol[i].toString() << ":"
               << posExg[i].toString() << ":"
               << posShare[i].toInt() << ":"
               << posCost[i].toInt() << ":"
               << posStop[i].toInt() << ":"
               << "0" << endl;
        }
    }

    f.close();

    if (pfoModel.pfoNum.length()>0 && idx < pfoModel.pfoNum.length()) {
        pfoModel.pfoNum[idx] = posSymbol.length();
    }

    return 0;
}

Q_INVOKABLE int FileHandler::storePosAll(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");
    qDebug() << "C_Info: storePosAll() into " << filename;

    QFile f( filename );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        qDebug() << "Failed to open " << filename << " for write.";

        return -1;
    }

    //debugPos();

    QTextStream ts( &f );

    if (!posSymbol.isEmpty()) {
        for (int i=0; i < posSymbol.count(); i++) {
            ts << posSymbol[i].toString() << ":"
               << posExg[i].toString() << ":"
               << posShare[i].toInt() << ":"
               << posCost[i].toInt() <<  ":"
               << posStop[i].toInt() << ":"
               << "0" << endl;
        }
    }

    f.close();

    if (pfoModel.pfoNum.length()>0 && idx < pfoModel.pfoNum.length()) {
        pfoModel.pfoNum[idx] = posSymbol.length();
    }

    return 0;
}

Q_INVOKABLE void FileHandler::setPos(int idx, QString symbol, QString exchange, int share, int cost, int stop)
{
    qDebug() << "C_Info: Append: " << symbol << " " << exchange << " " << share << " " << cost << " " << stop;
    posSymbol.replace(idx, symbol);
    posExg.replace(idx, share);
    posShare.replace(idx, exchange);
    posCost.replace(idx, cost);
    posStop.replace(idx, stop);
}

Q_INVOKABLE void FileHandler::removePos(int idx)
{
    qDebug() << "C_Info: Remove pos entry " << idx;
    posSymbol.removeAt(idx);
    posExg.removeAt(idx);
    posShare.removeAt(idx);
    posCost.removeAt(idx);
    posStop.removeAt(idx);
}

Q_INVOKABLE void FileHandler::removePosFile(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");
    QFile::remove(filename);
}

void FileHandler::debugPos() {
    for (int i=0; i<posSymbol.count(); i++) {
        qDebug() << i << "="
                 << posSymbol[i].toString() << ":"
                 << posExg[i].toString() << ":"
                 << posShare[i].toInt() << ":"
                 << posCost[i].toInt() << ":"
                 << posStop[i].toInt();
    }
}
